/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import kinugasa.object.Model;
import kinugasa.util.TimeCounter;

/**
 * Kinugasa : ChoiceEffect : I\郁bZ[WEChÉA
 * IĂ郉xɓKpGtFNg̃ASY`܂.
 * <br>
 * ̃fNX͑IuݑI𒆂ł邱ƁvvC[ɎGtFNg񋟂܂B<br>
 * `Iȕ@ƂĂ̓nCCg\@܂B̃NXł1̃Xy[X
 * Cӂ̐FŃnCCgvZbg񋟂܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2012/11/23_21:56:07.<br>
 * @author Dra0211<br>
 * <br>
 */
public abstract class ChoiceEffect extends Model {

	private static final long serialVersionUID = -3642532507764357135L;

	/**
	 * eLXgxlabelɑI𒆂ł邱ƂGtFNg`悵܂.
	 * ̃GtFNg̓x̕`ɌĂ΂_ɒӂĂB<br>
	 * ʏ̕sȐFɂ㏑̓x̃eLXgB܂B<br>
	 *
	 * @param g     ރOtBbNXReLXgM܂B<br>
	 * @param label I𒆂̃xM܂B<br>
	 */
	public abstract void draw(Graphics2D g, TextLabel label);

	@Override
	public ChoiceEffect clone() {
		return (ChoiceEffect) super.clone();
	}

	/**
	 * I𒆃x̐擪1Cӂ̐FŃnCCg郂f쐬ĕԂ܂.
	 *
	 * @param color@nCCgFw肵܂Bʏ͔ȐF𑗐M܂B<br>
	 *
	 * @return w肵F̑IGtFNg쐬ĕԂ܂B<br>
	 */
	public static ChoiceEffect craeteSingleCharChoiceEffect(Color color) {
		return new SingleCharEffect(color);
	}

	/**
	 * I𒆃x̐擪1Cӂ̐FŃnCCg郂f쐬ĕԂ܂.
	 *
	 * @param color@    nCCgFw肵܂Bʏ͔ȐF𑗐M܂B<br>
	 * @param blinkRate _ŊԊuw肵܂BisReachingtrueԂƂ̂݃GtFNg`悳܂B<br>
	 *
	 * @return w肵FƓ_ŊԊȗIGtFNg쐬ĕԂ܂B<br>
	 */
	public static ChoiceEffect craeteSingleCharChoiceEffect(Color color, TimeCounter blinkRate) {
		return new SingleCharEffect(color, blinkRate);
	}

	/**
	 * Kinugasa : ChoiceEffect.SingleCharEffect : 1ɃnCCgGtFNgIGtFNg̎ł.
	 * <br>
	 * ̃f̓nCCg̓_ŊԊu܂B<br>
	 * <br>
	 *
	 * @author dra0211 ( <a href="mailto:d0211@live.jp">d0211@live.jp</a>&nbsp;).<br>
	 * @version 1.0.0 - 2012/11/23_21:56:07.<br>
	 * <br>
	 */
	private static final class SingleCharEffect extends ChoiceEffect {

		private static final long serialVersionUID = -3270758183562208632L;

		/**
		 * Vf쐬܂.
		 * ̃RXgN^ł͓_ł͂AɃnCCgLɂȂ܂B<br>
		 *
		 * @param color nCCg̐Fw肵܂B<br>
		 */
		SingleCharEffect(Color color) {
			this.color = color;
			blinkTime = TimeCounter.TRUE;
		}

		/**
		 * Vf쐬܂.
		 *
		 * @param color     nCCg̐Fw肵܂B<br>
		 * @param blinkTime _ŊԊuw肵܂B<br>
		 */
		SingleCharEffect(Color color, TimeCounter blinkTime) {
			this.blinkTime = blinkTime;
			this.color = color;
		}
		/** _ŊԊu\^CJE^ł. */
		private TimeCounter blinkTime;
		/** nCCg̐Fł. */
		private Color color;

		@Override
		public void draw(Graphics2D g, TextLabel label) {
			if (!blinkTime.isReaching()) {
				return;
			}
			g.setColor(color);
			float x = label.getX() - 3;
			float y = label.getY() + 3;
			float w = label.getLabelModel().getFontSize() + 3;
			float h = label.getLabelModel().getFontSize();
			g.fillRect((int) x, (int) y, (int) w, (int) h);
		}

		@Override
		public ChoiceEffect clone() {
			SingleCharEffect cf = (SingleCharEffect) super.clone();
			cf.blinkTime = this.blinkTime.clone();
			return cf;
		}
	};
}
