/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import kinugasa.util.TimeCounter;

/**
 * Kinugasa : ConfirmMessageWindow : vC[2̑I^ĉ񓚂𓾂A
 * ȈՓIȑIbZ[WEChE̊gł.
 * <br>
 * ̃bZ[WEChE̎́Au₢킹bZ[WEChEvĂт܂B<br>
 * ̃bZ[WEChEɂyes̏ꍇ̑Inȍꍇ̑I^邱Ƃł܂B<br>
 * ꂼ֋XIyesAnoƂOtĂ܂ÃbZ[WłĂ\܂B<br>
 * ╶ёI̕\`̓X[p[NXɏ]܂B܂A╶͉s"\n"A
 * I1ŝ݂łB<br>
 * <br>
 * ꂼ̑Iɂ͌₷邽߂ɐ擪ɃXy[Xt^ꂽԂŃx܂B<br>
 * ̃NX̃IvVƂĕ\镶擾郁\bhł́ÃXy[XꂽԂ
 * Ԃ܂B<br>
 * āAx擾Ɩ₢킹bZ[WEChẼCX^X擾IvVɕ\
 * ͈قȂ܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2012/11/23_21:28:36.<br>
 * @author Dra0211<br>
 * <br>
 */
public class ConfirmMessageWindow extends SelectableMessageWindow {

	private static final long serialVersionUID = -8448581906646818648L;

	/**
	 * ₢킹p2bZ[WEChE쐬܂.
	 * <br>
	 * ₢킹͕sł\\łBIvV1słȂ΂Ȃ܂B<br>
	 *
	 * @param x      EChEXWw肵܂B<br>
	 * @param y      EChEYWw肵܂B<br>
	 * @param width  EChE̕w肵܂B<br>
	 * @param height EChE̍w肵܂B<br>
	 * @param wm     EChE̕\fw肵܂B<Br>
	 * @param lm     EChẼxɓKp郉xfw肵܂B<br>
	 * @param tc     xɓKp^CJE^w肵܂Bۂ̓N[gp܂B<br>
	 * @param text   ╶łBs"\n"𗘗pł܂B<br>
	 * @param yes    I\ȃIvV1ڂłB̃IvV̓ftHgőIĂ܂B<br>
	 * @param no     I\ȃIvV2ڂłB̃IvVyes̉ɕ\܂B<br>
	 * @param ce     IGtFNgw肵܂Bnulle܂B<br>
	 *
	 * @throws NullPointerException eLXgnullłꍇɓ܂B<br>
	 */
	public ConfirmMessageWindow(float x, float y, float width, float height,
			MessageWindowModel wm, LabelModel lm, TimeCounter tc, String text,
			String yes, String no, ChoiceEffect ce)
			throws NullPointerException {
		super(x, y, width, height, wm, lm, tc, text + "\n" + "   " + yes + "\n" + "   " + no, 0, 0, 1, ce);
		this.yesMessage = yes;
		this.noMessage = no;
		String message = text + "\n" + "   " + yes + "\n" + "   " + no;
		String[] texts = message.split(MessageWindow.getSeparator());
		for (int i = 0; i < texts.length; i++) {
			if (texts[i].replaceAll(" ", "").equals(yes)) {
				setMinIndex(i);
				setMaxIndex(i + 1);
				select(i);
			}
		}
	}
	/** 1ڂ̃IvV̕ł. */
	private String yesMessage;
	/** 2ڂ̃IvV̕ł. */
	private String noMessage;

	/**
	 * ̖₢킹bZ[WEChE1ڂ̃IvVƂĕ\镶擾܂.
	 *
	 * @return 1ڂ̃IvVƂĕ\镶Ԃ܂B<br>
	 */
	public String getYesMessage() {
		return yesMessage;
	}

	/**
	 * ̖₢킹bZ[WEChE2ڂ̃IvVƂĕ\镶擾܂.
	 *
	 * @return 2ڂ̃IvVƂĕ\镶Ԃ܂B<br>
	 */
	public String getNoMessage() {
		return noMessage;
	}

	/**
	 * ݑI𒆂̑I1ڂ̃IvVł邩𒲂ׂ܂.
	 *
	 * @return yesIĂꍇtrueAnoIĂꍇfalseԂ܂B<br>
	 */
	public boolean isYesOption() {
		return getSelectedLabel().getText().replaceAll(" ", "").equals(yesMessage);
	}

	@Override
	public ConfirmMessageWindow clone() {
		return (ConfirmMessageWindow) super.clone();
	}
}
