/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kinugasa.util.FrameTimeCounter;
import kinugasa.util.TimeCounter;

/**
 * Kinugasa : InputMessageWindow : 1ȏ̕Zbg當Rɍ\zł̓EChEł.
 * <br>
 * ̓bZ[WEChE͎w肳ꂽ܂ł̕Aw肳ꂽZbg1Rɓ͂ł
 * EChE̎łB<br>
 * EChE͂ꂽ1s̃xƂĕ\\łB<br>
 * <br>
 * ̃EChEɂ0sȏ́u╶vA1śu͊mFxvA́uZbgvсA
 * gpꍇɂ́uR}hxv\܂B<br>
 * <br>
 * ╶Ƃ̓vC[ɉ͂Ă炢̂w郉x̂ƂłB̃x̓X[p[NX̋@\gp
 * 쐬A`悳܂B̃x͕s\邱Ƃł̂ŁAeLXg"\n"gp邱Ƃ
 * s邱Ƃł܂B<br>
 * <br>
 * ͊mFxƂ͓͂m肵A^Cɕ\郉xłB̃xɂ
 * ftHg"Q"ő啶\ĂA擾ۂɂ͂"Q"""ɒu܂B<br>
 * āA͕ƂđSp̃A_[XRA"Q"gp邱Ƃ͂ł܂B<br>
 * <br>
 * ZbgƂ͓͉\ȕ̃ZbgłBCharSetNXgpĒ`܂B<br>
 * ZbǵAʏA쐫悭邽߂ɂ̃Xy[X" "ZbgɊ܂܂邱Ƃ܂B<br>
 * āAZbg͕̕KdĂ͂ȂȂƂ[͂܂B<br>
 * Zbg̓tHg񋟂镶Rɒ`\łBƂΊ⑼̕łĂ
 * ̓tH[쐬邱Ƃł܂B<br>
 * <br>
 * ̃EChEɂ̓x̃vZbgƂăR}hƂx\z@\Ă܂B<br>
 * ̃x́A͂m肵LZĖ߂鏈𔻒肷邽߂̂̂ŁAgpꍇ
 * Zbg̉ɕ\܂B<br>
 * <br>
 * <br>
 * ̃EChE̎ł́AƎ̃xzuASYp邽߁AX[p[NXɐݒ肳郉x
 * u╶vłBȊÔׂẴx͂̃NXɓƎɊi[܂B<br>
 * <br>
 * ̃EChÉAʏ2ȏ\邱Ƃ͂Ȃƍl̂ŁA
 * N[jO̓V[Rs[ƂȂ܂BׂẴx͂̎QƂRs[܂B<br>
 * <br>
 * <Br>
 * ̓bZ[WEChÉA͂ꂽ}ʒu߂̃Lbg܂B<br>
 * Lbg͒PF̋`Ƃē͊mFx̎ɕ}ʒuɕ`悳܂B<br>
 * ő̕܂œ͂Ăꍇ̓Lbg͕\܂B<br>
 * Lbg̐F̓ftHgł͓ߓx50%̔ݒ肳Ă܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2012/11/25_14:13:24.<br>
 * @author Dra0211<br>
 * <br>
 */
public class InputMessageWindow extends MessageWindow {

	private static final long serialVersionUID = -3348163241388833782L;
	/** R}hpx"OK"`郉x̕ł. */
	public static String COMMAND_OK = "";
	/** R}hpx"Cancel"`郉x̕ł. */
	public static String COMMAND_CANCEL = "߂";

	/**
	 * V̓bZ[WEChE쐬܂.
	 *
	 * @param x EChEXWw肵܂B<br>
	 * @param y EChEYWw肵܂B<br>
	 * @param width EChE̕w肵܂B<br>
	 * @param height EChE̍w肵܂B<br>
	 * @param windowModel bZ[WEChẼfw肵܂B<br>
	 * @param messageLabelModel ╶Ɠ͊mFx̃fw肵܂B<br>
	 * @param choicesLabelModel IƃR}hx̃fw肵܂B<br>
	 * @param message ╶łBs"\n"gpĕsɂł܂B<br>
	 * @param choiceEffect ȊIGtFNgw肵܂B<br>
	 * @param maxLength ͉\ȍő̕w肵܂B<br>
	 * @param useCommandLabels R}hxgpꍇtrueAgpȂꍇfalse𑗐M܂B<br>
	 * @param charSet gp镶Zbg1ȏ㑗M܂B<br>
	 *
	 * @throws IllegalArgumentException charSetmessagenull̏ꍇɓ܂B<br>
	 * @throws NullPointerException Zbg0ł邩Aő̕0łꍇɓ܂B<br>
	 */
	public InputMessageWindow(
			float x, float y, float width, float height,
			MessageWindowModel windowModel, LabelModel messageLabelModel,
			LabelModel choicesLabelModel, String message,
			ChoiceEffect choiceEffect, int maxLength, boolean useCommandLabels,
			CharSet... charSet)
			throws IllegalArgumentException, NullPointerException {
		super(x, y, width, height, windowModel, messageLabelModel, message);
		if (charSet == null) {
			throw new NullPointerException("! > InputMessageWindow : ctor : charSet is null : message=[" + message + "]");
		}
		if (message == null) {
			throw new NullPointerException("! > InputMessageWindow : ctor : message is null : message=[" + message + "]");
		}
		if (charSet.length == 0) {
			throw new IllegalArgumentException("! > InputMessageWindow : ctor : charSet.length == 0 : message=[" + message + "]");
		}
		if (maxLength <= 0) {
			throw new IllegalArgumentException("! > InputMessageWindow : ctor maxLength <= 0 : maxLength=[" + maxLength + "]");
		}
		this.choiceEffect = choiceEffect;
		this.selectedIndexX = this.selectedIndexY = 0;
		this.caretIndex = 0;
		this.choicesLabelModel = choicesLabelModel;
		this.maxLength = maxLength;
		this.charSets = charSet;
		this.caretBlinkRate = new FrameTimeCounter(20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
		initLabels(useCommandLabels);
		this.caretY = inputValueLabel.getY();
		this.caretX = inputValueLabel.getX();
	}

	/**
	 * ╶A͊mFAI̊exĔzu܂.
	 *
	 * @param useCommand R}hxgpꍇtrue𑗐M܂B<br>
	 */
	private void initLabels(boolean useCommand) {
		float charSize = choicesLabelModel.getFontSize() + 2;
		float x = labels[labels.length - 1].getX() + 8;
		float y = labels[labels.length - 1].getY() + charSize * 2;
		String defaultText = "";
		for (int i = 0; i < maxLength; i++) {
			defaultText += "Q";
		}
		this.inputValueLabel = new TextLabel(x, y, defaultText, labels[0].getLabelModel());
		y += charSize * 2;

		List<TextLabel[]> csChoiceLabels = new ArrayList<TextLabel[]>(512);
		int maxWidth = 0;
		for (CharSet cs : charSets) {
			for (TextLabel[] l : cs.parse(x, y, choicesLabelModel)) {
				csChoiceLabels.add(l);
				if (maxWidth < l.length) {
					maxWidth = l.length;
				}
			}
			y += charSize * cs.rowNum() + charSize;
		}
		choiceLabels = new TextLabel[csChoiceLabels.size() + (useCommand ? 1 : 0)][];
		for (int i = 0, size = csChoiceLabels.size(); i < size; i++) {
			TextLabel[] line = csChoiceLabels.get(i);
			choiceLabels[i] = new TextLabel[line.length];
			System.arraycopy(line, 0, choiceLabels[i], 0, line.length);
		}
		if (useCommand) {
			initCommandLabels();
		}
	}

	/**
	 * R}hxgpꍇɁAWȂǂ̏s\bhł.
	 * R}hx͑I̔zɂǉ܂BR}hx̔zƑI̔zɊ܂܂
	 * R}hx̃CX^X͓łB<br>
	 * ̃\bhinitLabelsR[܂B<br>
	 */
	private void initCommandLabels() {
		choiceLabels[choiceLabels.length - 1] = new TextLabel[2];
		TextLabel mostUnder = choiceLabels[choiceLabels.length - 2][0];
		assert mostUnder != null : "[V]Ȃ̃vO͊ԈĂ mostUnder == null";
		float x = mostUnder.getX();
		float y = mostUnder.getY();
		y += mostUnder.getLabelModel().getFontSize() + 2;
		commandLabels = new TextLabel[]{
			new TextLabel(x, y, COMMAND_OK, choicesLabelModel),
			new TextLabel(x + choicesLabelModel.getFontSize() * 2 + 12, y, COMMAND_CANCEL, choicesLabelModel),};
		System.arraycopy(commandLabels, 0, choiceLabels[choiceLabels.length - 1], 0, commandLabels.length);
	}

	/**
	 * ̃EChEgpĂ镶Zbg̒當c܂܂镶Zbg܂.
	 *
	 * @param c 镶w肵܂B<br>
	 *
	 * @return cŏɔꂽZbgԂ܂B<br>
	 *
	 * @throws AssertionError ܂܂ĂȂꍇɓ܂Bʏ̎gp@ł̗͂O邱Ƃ͂܂B<br>
	 */
	private CharSet searchCharSet(char c) throws AssertionError {
		for (CharSet cs : charSets) {
			if (cs.contains(Character.toString(c))) {
				return cs;
			}
		}
		throw new AssertionError("! > InputMessageWindow : character not found :" + c);
	}
	/** I̔zł. R}hx܂݂܂. */
	private TextLabel[][] choiceLabels;
	/** ͉\ȍő啶ł. */
	private int maxLength;
	/** Ĩfł. */
	private LabelModel choicesLabelModel;
	/** gp镶Zbgł. */
	private CharSet[] charSets;
	/** Zbg̑Ixł. */
	private ChoiceEffect choiceEffect;
	/** I𒆃xXWł. */
	private int selectedIndexX;
	/** I𒆃xYWł. */
	private int selectedIndexY;
	/** ͊mFxł. */
	private TextLabel inputValueLabel;
	/** Lbg\͊mFxɑ΂镶CfbNXł. */
	private int caretIndex;
	/** Lbg̓_ŊԊuł. */
	private TimeCounter caretBlinkRate;
	/** Lbg`悷XWł. */
	private float caretX;
	/** Lbg`悷YWł. */
	private float caretY;
	/** Lbg̐Fł. */
	private Color caretColor = new Color(255, 255, 255, 128);
	/** R}hx̔zł. */
	private TextLabel[] commandLabels;

	@Override
	public void draw(Graphics2D g) {
		super.draw(g);
		inputValueLabel.draw(g);
		for (TextLabel[] line : choiceLabels) {
			for (TextLabel label : line) {
				label.draw(g);
			}
		}
		if (choiceEffect != null) {
			choiceEffect.draw(g, getSelectedLabel());
		}
		if (caretBlinkRate.isReaching() && !isMaxInput()) {
			drawCaret(g);
		}
		if (commandLabels != null) {
			for (TextLabel label : commandLabels) {
				label.draw(g);
			}
		}
	}

	/**
	 * Lbg`悵܂.
	 *
	 * @param g ރOtBbNXReLXg𑗐M܂B<br>
	 */
	private void drawCaret(Graphics2D g) {
		g.setColor(caretColor);
		float size = inputValueLabel.getLabelModel().getFontSize();
		g.fillRect((int) caretX, (int) caretY, (int) size / 2, (int) size);
	}

	/**
	 * R}hxI𒆂ł邩𒲂ׂ܂.
	 *
	 * @return R}hxgpĂA肩LZ̃R}hIĂꍇtrueԂ܂B<br>
	 */
	public boolean isCommandSelect() {
		return isOkSelected() | isCancelSelected();
	}

	/**
	 * R}hI𒆂ł邩𒲂ׂ܂.
	 *
	 * @return R}hxgpĂAIĂ郉x胉xłꍇtrueԂ܂B<br>
	 */
	public boolean isOkSelected() {
		if (commandLabels == null) {
			return false;
		}
		for (TextLabel label : commandLabels) {
			if (getSelectedLabel().equals(label) && label.getText().equals(COMMAND_OK)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * LZR}hI𒆂ł邩𒲂ׂ܂.
	 *
	 * @return R}hxgpĂAIĂ郉xLZxłꍇtrueԂ܂B<br>
	 */
	public boolean isCancelSelected() {
		for (TextLabel label : commandLabels) {
			if (getSelectedLabel().equals(label) && label.getText().equals(COMMAND_CANCEL)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * I𒆂͂̕A1ǉ܂.
	 * ͂ő啶łꍇ͉s܂B<br>
	 *
	 * @return ͂m肵Ă镶Ԃ܂B̌Ăяo܂łɓ͂ꂽ
	 * ÂŁǍĂяoɂĐVǉꂽ܂݂܂B<br>
	 */
	public String enter() {
		if (isCommandSelect()) {
			return getSelectedLabel().getText();
		}
		if (isMaxInput()) {
			return inputValueLabel.getText().replaceAll("Q", "");
		}
		char[] inputData = inputValueLabel.getText().toCharArray();
		inputData[caretIndex] = getSelectedLabel().getText().charAt(0);
		caretX += searchCharSet(inputData[caretIndex]).
				convertSize(inputValueLabel.getLabelModel().getFontSize());
		if (inputValueLabel.getLabelModel().getFont().isBold()) {
			caretX += 1;
		}
		inputValueLabel.setText(String.valueOf(inputData));
		caretIndex++;
		return inputValueLabel.getText().replaceAll("Q", "");
	}

	/**
	 * O̓͂LZA1폜܂.
	 * ͂0łꍇ͉s܂B<br>
	 */
	public void backSpace() {
		if (isNotYetInput()) {
			return;
		}
		caretIndex--;
		char[] inputData = inputValueLabel.getText().toCharArray();
		caretX -= searchCharSet(inputData[caretIndex]).
				convertSize(inputValueLabel.getLabelModel().getFontSize());
		if (inputValueLabel.getLabelModel().getFont().isBold()) {
			caretX -= 1;
		}
		inputData[caretIndex] = 'Q';
		inputValueLabel.setText(String.valueOf(inputData));
	}

	/**
	 * ͂m肵AEChE܂.
	 * ̃\bhĂяoƃEChE̐ԂƉԂfalseɂA
	 * getInputTextԂ܂B<br>
	 *
	 * @return ͂ꂽԂ܂B<br>
	 */
	public String ok() {
		setExist(false);
		setVisible(false);
		return getInputText();
	}

	/**
	 * ͂LZAEChE܂.
	 * ̃\bhĂяoƓ͊mFx̃eLXg(ő啶"Q")ɂȂA
	 * EChE̐ԂƉԂfalseɐݒ肵܂B<br>
	 */
	public void cancel() {
		String text = "";
		for (int i = 0; i < maxLength; i++) {
			text += "Q";
		}
		inputValueLabel.setText(text);
		setExist(false);
		setVisible(false);
	}

	/**
	 * vC[ɂ錻݂̓͒lő̕ł邩܂.
	 *
	 * @return vC[̓͂ő̕łꍇtrueAłȂꍇfalseԂ܂B<br>
	 */
	public boolean isMaxInput() {
		return caretIndex == maxLength;
	}

	/**
	 * vC[ɂ錻݂̓͒l0ł邩܂.
	 *
	 * @return vC[͂ĂȂꍇtrueA1ȏ͂ĂꍇfalseԂ܂B<br>
	 */
	public boolean isNotYetInput() {
		return caretIndex == 0;
	}

	/**
	 * IɈړ܂.
	 * ɑIȂꍇ(ł̑Ȉꍇ)͈ړ܂B<br>
	 */
	public void toLeft() {
		selectedIndexX--;
		clamp();
	}

	/**
	 * IEɈړ܂.
	 * EɑIȂꍇ(łȆȈꍇ)͈ړ܂B<br>
	 */
	public void toRight() {
		selectedIndexX++;
		clamp();
	}

	/**
	 * IɈړ܂.
	 * ɑIȂꍇ(ł̑Ȉꍇ)͈ړ܂B<br>
	 */
	public void toDown() {
		selectedIndexY++;
		clamp();
	}

	/**
	 * IɈړ܂.
	 * ɑIȂꍇ(ł̑Ȉꍇ)͈ړ܂B<br>
	 */
	public void toUp() {
		selectedIndexY--;
		clamp();
	}

	/**
	 * I𒆃xCfbNXL͈͓ɐ؂l߂܂.
	 */
	private void clamp() {
		if (selectedIndexY < 0) {
			selectedIndexY = 0;
		} else if (selectedIndexY > choiceLabels.length - 1) {
			selectedIndexY = choiceLabels.length - 1;
		}
		if (selectedIndexX < 0) {
			selectedIndexX = 0;
		} else if (selectedIndexX > choiceLabels[selectedIndexY].length - 1) {
			selectedIndexX = choiceLabels[selectedIndexY].length - 1;
		}
	}

	/**
	 * Lbg̓_ŊԊuݒ肵܂.
	 *
	 * @param cursorBlink VLbg̓_ŊԊuw肵܂B<br>
	 */
	public void setCaretBlinkRate(TimeCounter cursorBlink) {
		this.caretBlinkRate = cursorBlink;
	}

	/**
	 * Lbg̓_ŊԊu擾܂.
	 *
	 * @return Lbg̓_MԊuɎgpĂ^CJE^Ԃ܂B<br>
	 */
	public TimeCounter getCaretBlinkRate() {
		return caretBlinkRate;
	}

	/**
	 * Lbg̐F擾܂.
	 *
	 * @return ̃EChẼLbg̐F擾܂BftHgł͓ߓx50%̔łB<br>
	 */
	public Color getCaretColor() {
		return caretColor;
	}

	/**
	 * Lbg̐FύX܂.
	 *
	 * @param caretColor VLbg̐Fݒ肵܂B<br>
	 */
	public void setCaretColor(Color caretColor) {
		this.caretColor = caretColor;
	}

	/**
	 * ͉\ȍő̕擾܂.
	 *
	 * @return vC[̃EChEɓ͂ł镶̍őlԂ܂B<br>
	 */
	public int getMaxLength() {
		return maxLength;
	}

	/**
	 * ݑIĂ郉xԂ܂B
	 *
	 * @return ݑIĂ郉x̃N[Ԃ܂B<br>
	 */
	public TextLabel getSelectedLabel() {
		return choiceLabels[selectedIndexY][selectedIndexX].clone();
	}

	/**
	 * I𒆂̃x̃eLXg擾܂.
	 *
	 * @return I𒆂̃x̃eLXgԂ܂BgetSelectedLabel().getText()ƓʂłB<br>
	 */
	public String getSelectedLabelText() {
		return getSelectedLabel().getText();
	}

	/**
	 * I𒆃xỸCfbNX擾܂.
	 *
	 * @return IGtFNgKp郉xX̃CfbNXԂ܂B<br>
	 */
	public int getSelectedIndexX() {
		return selectedIndexX;
	}

	/**
	 * I𒆃xX̃CfbNXݒ肵܂.
	 *
	 * @param selectedIndexX IGtFNgKp郉xX̃CfbNX𑗐M܂B<br>
	 */
	public void setSelectedIndexX(int selectedIndexX) {
		this.selectedIndexX = selectedIndexX;
	}

	/**
	 * I𒆃xỸCfbNX擾܂.
	 *
	 * @return IGtFNgKp郉xỸCfbNXԂ܂B<br>
	 */
	public int getSelectedIndexY() {
		return selectedIndexY;
	}

	/**
	 * I𒆃xỸCfbNXݒ肵܂.
	 *
	 * @param selectedIndexY IGtFNgKp郉xỸCfbNX𑗐M܂B<br>
	 */
	public void setSelectedIndexY(int selectedIndexY) {
		this.selectedIndexY = selectedIndexY;
	}

	/**
	 * ̃EChEɕ\ĂSĂ̕Zbg擾܂.
	 * ̃\bh͎QƂ߂܂B߂lɑ΂鑀̓EChEɉe^܂B<br>
	 *
	 * @return ̃EChEgp̑SĂ̕ZbgԂ܂B<br>
	 */
	public CharSet[] getCharSets() {
		return charSets;
	}

	/**
	 * IƂĕ\Ă邷ׂẴxXgƂĎ擾܂.
	 * ̃\bh̖߂lɂ͑쐫̂߂ɊmۂĂXy[X" "̃x
	 * R}hx܂܂܂B<br>
	 * ̃\bh͎QƂ߂܂B߂lɑ΂鑀͂̃EChȆIxɉe܂B<br>
	 *
	 * @return SĂ̑IXgƂĕԂ܂B<br>
	 */
	public List<TextLabel> getChoiceLabelsList() {
		List<TextLabel> result = new ArrayList<TextLabel>();
		for (TextLabel[] line : choiceLabels) {
			result.addAll(Arrays.asList(line));
		}
		return result;
	}

	/**
	 * IƂĕ\Ă邷ׂẴx̔zu2zƂĎ擾܂.
	 * ̃\bh̖߂lɂ͑쐫̂߂ɊmۂĂXy[X" "̃x
	 * R}hx܂܂܂B<br>
	 * ̃\bh͎QƂ߂܂B߂lɑ΂鑀͂̃EChȆIxɉe܂B<br>
	 *
	 * @return SĂ̑I2zƂĕԂ܂B<br>
	 */
	public TextLabel[][] getChoiceLabels() {
		return choiceLabels;
	}

	/**
	 * IƂĕ\Ă郉x̃f擾܂.
	 *
	 * @return Ix̃fԂ܂B<br>
	 */
	public LabelModel getChoicesLabelModel() {
		return choicesLabelModel;
	}

	/**
	 * ̃EChE̕Zbgɑ΂ĎgpĂIGtFNg擾܂.
	 *
	 * @return ݂̑IGtFNgԂ܂Bݒ肳ĂȂꍇnullԂ܂B<br>
	 */
	public ChoiceEffect getChoiceEffect() {
		return choiceEffect;
	}

	/**
	 * ̃EChE̕Zbgɑ΂ĎgpĂIGtFNgύX܂.
	 *
	 * @param choiceEffect VIGtFNgw肵܂B\Ȃꍇnullgpł܂B<br>
	 */
	public void setChoiceEffect(ChoiceEffect choiceEffect) {
		this.choiceEffect = choiceEffect;
	}

	/**
	 * vC[͂eLXg\邽߂ɎgpĂ郉x擾܂.
	 * ̃x̓vC[ɓ͉\ȕ`邽߂ɖ͕"Q"
	 * ɒuĂ܂B<br>
	 * ȓ͂ꂽ擾ɂgetInputTextgp܂B<br>
	 *
	 * @return vC[͂eLXg\Ă郉x擾܂BN[Ԃ܂B<bR>
	 */
	public TextLabel getInputValueLabel() {
		return inputValueLabel.clone();
	}

	/**
	 * vC[ɂē͂ꂽ擾܂.
	 * ̃\bhł́Aۂɕ\Ă郉x̃eLXg
	 * "Q"""ɒuĕԂ܂B<br>
	 * "Q"܂߂ۂɕ\Ă镶擾ɂgetInputValueLabel
	 * gp܂B<br>
	 *
	 * @return vC[ɂē͂ꂽ擾܂B<br>
	 */
	public String getInputText() {
		return inputValueLabel.getText().replaceAll("Q", "");
	}

	/**
	 * ̃EChEɐݒ肳Ă邷ׂĂ̕ZbgpxXg[ɔs܂.
	 * ̃\bh̓fobOpłB<br>
	 *
	 * @param stream sXg[w肵܂B<br>
	 */
	public void printAll(PrintStream stream) {
		System.out.println("> InputMessageWindow : printAll : ");
		for (TextLabel[] l : choiceLabels) {
			for (TextLabel t : l) {
				System.out.print(t.getText() + ", ");
			}
			stream.println();
		}
		System.out.println("> InputMessageWindow : printAll : --------------------");
	}

	@Override
	public InputMessageWindow clone() {
		InputMessageWindow result = (InputMessageWindow) super.clone();
		return result;
	}

	@Override
	public String toString() {
		return "InputMessageWindow{" + "choiceLabels=" + choiceLabels
				+ ", maxLength=" + maxLength + ", choicesLabelModel="
				+ choicesLabelModel + ", charSets=" + charSets
				+ ", choiceEffect=" + choiceEffect + ", selectedIndexX="
				+ selectedIndexX + ", selectedIndexY=" + selectedIndexY
				+ ", inputValueLabel=" + inputValueLabel + ", caretIndex="
				+ caretIndex + ", caretBlinkRate=" + caretBlinkRate
				+ ", caretX=" + caretX + ", caretY=" + caretY
				+ ", caretColor=" + caretColor + ", commandLabels="
				+ commandLabels + '}';
	}
}