/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import kinugasa.object.Model;

/**
 * kinugasa : LabelModel : x̃eLXg`悷郂fł.
 * <br>
 * x̕\CfbNX̍XVƂ̌͂̃f̕`惁\bh
 * sKv܂B<br>
 * 
 * @version 1.0.0 - 2012/07/16_14:22:53.<br>
 * @version 2.0.0 - 2012/11/26_::.<br>
 * @author Dra0211<br>
 * <br>
 * 
 */
public abstract class LabelModel extends Model {

	/** W̃tHgł. ύXȂꍇMONOSPACE, PLAIN, 16pt̃tHgݒ肳Ă܂. */
	private static Font DEFALUT_FONT = new Font(Font.MONOSPACED, Font.PLAIN, 16);
	/** W̃tHgJ[ł. ύXȂꍇColor.ORANGEݒ肳Ă܂. */
	private static Color DEFULT_COLOR = Color.ORANGE;
	private static final long serialVersionUID = 3188375963284932612L;

	/**
	 * ftHgRXgN^gpăxf쐬ۂɐݒ肳
	 * tHg擾܂.
	 * 
	 * @return W̃tHg.<Br>
	 */
	public static Font getDefaultFont() {
		return DEFALUT_FONT;
	}

	/**
	 * ftHgRXgN^gpăxf쐬ۂɐݒ肳
	 * tHgݒ肵܂.
	 * 
	 * @param font W̃tHg.<Br>
	 */
	public static void setDefaultFont(Font font) {
		LabelModel.DEFALUT_FONT = font;
	}

	/**
	 * ftHgRXgN^gpăxf쐬ۂɐݒ肳
	 * tHgJ[擾܂.
	 * 
	 * @return W̃tHgJ[.<Br>
	 */
	public static Color getDefaultColor() {
		return DEFULT_COLOR;
	}

	/**
	 * ftHgRXgN^gpăxf쐬ۂɐݒ肳
	 * tHgJ[擾܂.
	 * 
	 * @param color W̃tHgJ[.<Br>
	 */
	public static void setDefaultColor(Color color) {
		LabelModel.DEFULT_COLOR = color;
	}
	//
	/** ̃fŎgptHg. */
	private Font font;
	/** tHgɐݒ肷F. */
	private Color color;

	/**
	 * Vxf\z܂.
	 * ̃RXgN^ł́Axf̃NXtB[hłW̃tHg
	 * tHgJ[ݒ肳܂.<br>
	 */
	public LabelModel() {
		super();
		font = DEFALUT_FONT;
		color = DEFULT_COLOR;
	}

	/**
	 * Vxf\z܂.
	 * 
	 * @param f tHg.<br>
	 * @param c tHg̐F.<br>
	 */
	public LabelModel(Font f, Color c) {
		super();
		this.font = f;
		this.color = c;
	}

	/**
	 * x̃eLXg`悵܂.
	 * ʏ́AsetPropertygpătHgуtHgJ[
	 * KpAxgetVisibleTextgpĎ擾
	 * x̍Wɕ`悵܂B<br>
	 * <br>
	 * ̃\bhŃx̉Ԃ␶Ԃ]Kv͂܂B<br>
	 * 
	 * @param g ރOtBbNXReLXgB<br>
	 * @param l \郉xM܂B<br>
	 */
	public abstract void drawText(Graphics2D g, TextLabel l);

	/**
	 * OtBbNXReLXgɂ̃xfɐݒ肳ĂtHg
	 * уtHgJ[ݒ肵܂.
	 * 
	 * @param g ݒ肷OtBbNXReLXg.<br>
	 */
	protected final void setProperty(Graphics2D g) {
		g.setColor(color);
		g.setFont(font);
	}

	/**
	 * ̃f̃tHgJ[擾܂.
	 * 
	 * @return tHg̐F.<Br>
	 */
	public final Color getColor() {
		return color;
	}

	/**
	 * tHg̐Fݒ肵܂.
	 * 
	 * @param color tHg̐F.<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 */
	public final LabelModel setColor(Color color) {
		this.color = color;
		return this;
	}

	/**
	 * tHg̃TCY擾܂.
	 * 
	 * @return tHg̃TCY.<br>
	 */
	public final float getFontSize() {
		return font.getSize2D();
	}

	/**
	 * tHg̃TCYݒ肵܂.
	 * 
	 * @param size tHg̃TCY.<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 */
	public final LabelModel setFontSize(float size) {
		font = font.deriveFont(size);
		return this;
	}

	/**
	 * ̃f̃tHg擾܂.
	 * 
	 * @return tHg.<br>
	 */
	public final Font getFont() {
		return font;
	}

	/**
	 * ̃f̃tHg擾܂.
	 * 
	 * @param font tHg.<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 */
	public final LabelModel setFont(Font font) {
		this.font = font;
		return this;
	}

	@Override
	public LabelModel clone() {
		return (LabelModel) super.clone();
	}
	/** x̍WɃx̉eLXg\,W̎ł. */
	public static final LabelModel STANDARD = new LabelModel() {
		private static final long serialVersionUID = -6879469600761885933L;

		@Override
		public void drawText(Graphics2D g, TextLabel l) {
			setProperty(g);
			g.drawString(l.getVisibleText(), (int) l.getX(), (int) l.getY() + getFontSize());
			if (l.getTimeCounter().isReaching() && !l.isAllTextVisible()) {
				l.nextChar();
			}
		}
	};
}
