/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import kinugasa.contents.sound.Sound;
import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;
import kinugasa.object.Sprite;
import kinugasa.util.TimeCounter;

/**
 * kinugasa : MessageWindow : ̃eLXgx\邽߂̃R|[lgł.
 * <br>
 * 
 * <br>
 * bZ[WEChE͐p̕`ASYɂĕ(0ȏ́jxK؂Ȉʒuɕ`悵܂.<br>
 * EChÊׂẴx͐ݒ肳Ă^CJE^ɂ1s\邱Ƃł܂.<br>
 * <br>
 * EChẼCX^X͕\镪Kvł.<br>ʏ́AbZ[W\邽߂̃EChEpӂA
 * ̃eLXguĕ\܂.<br>
 * <br>
 * EChẼTCYEChEɊ܂܂(܂ނƂłjx͔̐Cӂł.̒l
 * ߂܂.EChË̗悩os̃x̓EChE̊Oɕ\܂B<br>
 * <br>
 * EChE͈́uACRvSpriteCX^XƂĎƂł܂.<br>
 * ACRisAllTextViibletrueԂƂ
 * ̃NXŎIɕ`悳܂.EChEfɂăACRɓK؂ȃp[^
 * ݒ肳ĂꍇɌ܂.<br>
 * EChEɃACRݒ肷ƁAfinitIcon\bhIɌĂяo܂.<br>
 * ACR̕\ԂύXꍇ́AI[o[Chł܂.<br>
 * <Br>
 * x̎ۂ̕`ʒu̓EChEfɂČ߂܂.<Br>
 * <Br>
 * <Br>
 * EChEɕ\eLXǵAPStringCX^X\z邱Ƃł܂.<br>
 * es͂̃NXseparatortB[hɂĕꂽ񂪎gp܂.<br>
 * separator̓ftHgł"\n"ݒ肳Ă܂.<br>
 * A"\n"̓t@Cǂݍ߂Ȃ߁At@Cǂݍ񂾃f[^ƂɃEChE\zꍇ
 * ugp邩AZp[^ύXĂ.<br>
 * ̃NX̃N[jOł̓x̔zN[܂(V[Rs[).<br>
 * <br>
 *
 * @version 1.0.0 - 2012/07/16_15:36:35.<br>
 * @author Dra0211<br>
 */
public class MessageWindow extends BasicSprite {

	/**
	 * PStringCX^X烁bZ[W\zꍇɁAs؂镶ł.
	 * ftHgł"\n"ɐݒ肳Ă܂.
	 */
	private static String separator = "\n";
	private static final long serialVersionUID = 8737215838540638322L;

	/**
	 * ؂蕶擾܂.
	 * ̒l̓ftHgł"\n"Ԃ܂.<br>
	 * 
	 * @return x\zɎgpZp[^.<br>
	 */
	public static String getSeparator() {
		return separator;
	}

	/**
	 * ؂蕶ݒ肵܂.
	 * 
	 * @param separator x\zɎgpZp[^.<br>
	 */
	public static void setSeparator(String separator) {
		MessageWindow.separator = separator;
	}
	/** EChEǗ郉x. */
	protected TextLabel[] labels;
	/** EChE̕`ASY. */
	private MessageWindowModel windowModel;
	/** eLXgACR. */
	private Sprite icon;

	/**
	 * eLXgxw肵āAVbZ[WEChE\z܂.
	 * ̃RXgN^ł́Axɐݒ肳Ăp[^(ʓIɂ́j炵܂.<br>
	 * AEChEfɂ
	 * x̍WȂǂ̏ݒ肪s_ɒӂĂ.<br>
	 * ̃RXgN^́A̃xꂼʂ
	 * xf^CJE^gpĂۂɁA
	 * ݒgpăbZ[WEChE\ۂɎgp܂.<br>
	 * 
	 * @param x      EChEXW.<Br>
	 * @param y      EChEYW.<Br>
	 * @param width  EChE̕.<Br>
	 * @param height EChE̍.<br>
	 * @param wm     EChẼf.<br>
	 * @param label  x̎.<Br>
	 *
	 * @throws NullPointerException xnull̏ꍇɓ.
	 *                                 ̃EChE\ɂ͋̕""Ƃɋ̃x쐬Kv܂.<Br>
	 */
	public MessageWindow(float x, float y, float width, float height,
			MessageWindowModel wm, TextLabel... label)
			throws NullPointerException {
		super(x, y, width, height);
		if (label == null) {
			throw new NullPointerException("! > MessageWindow : LABEL == null !");
		}
		this.windowModel = wm;
		setLabels(labels);
	}

	/**
	 * StringCX^XseparatorŕgpēKȃx\zA
	 * bZ[WEChEɐݒ肵܂.
	 * 
	 * ̃RXgN^Őݒ肳ꂽx̉CfbNXɂ͕IDX=̒ݒ肳܂.<ve>
	 * āAEChÊׂẴeLXg
	 * ŏ\Ă܂.<br>
	 * 
	 * @param x      EChEXW.<Br>
	 * @param y      EChEYW.<Br>
	 * @param width  EChE̕.<Br>
	 * @param height EChE̍.<br>
	 * @param wm     EChẼf.<br>
	 * @param lm     xɓKp郉xf.<br>
	 * @param text   EChEɐݒ肷镶.separatorɂĕ.<br>
	 *
	 * @throws NullPointerException xnull̏ꍇɓ.
	 *                                 ̃EChE\ɂ͋̕""Ƃɋ̃x쐬Kv܂.<Br>
	 */
	public MessageWindow(float x, float y, float width, float height,
			MessageWindowModel wm, LabelModel lm, String text) throws NullPointerException {
		super(x, y, width, height);
		if (text == null) {
			throw new NullPointerException("! > MessageWindow : TEXT == null !");
		}
		this.windowModel = wm;
		setText(text, lm);
	}

	/**
	 * StringCX^XseparatorŕgpēKȃx\zA
	 * bZ[WEChEɐݒ肵܂.
	 * 
	 * ̃RXgN^Őݒ肳ꂽx̉CfbNX0ɐݒ肳܂.<br>
	 * āAEChÊׂẴeLXg
	 * w肵^CJE^gpĈꕶ\邱Ƃł܂.<br>
	 * 
	 * @param x      EChEXW.<Br>
	 * @param y      EChEYW.<Br>
	 * @param width  EChE̕.<Br>
	 * @param height EChE̍.<br>
	 * @param wm     EChẼf.<br>
	 * @param lm     xɓKp郉xf.<br>
	 * @param tc     SẴxɓKp^CJE^.ۂɂ͂̃CX^X̃N[gp.<br>
	 * @param text   EChEɐݒ肷镶.separatorɂĕ.<br>
	 *
	 * @throws NullPointerException xnull̏ꍇɓ.
	 *                                 ̃EChE\ɂ͋̕""Ƃɋ̃x쐬Kv܂.<Br>
	 */
	public MessageWindow(float x, float y, float width, float height,
			MessageWindowModel wm, LabelModel lm, TimeCounter tc, String text) throws NullPointerException {
		super(x, y, width, height);
		if (text == null) {
			throw new NullPointerException("! > MessageWindow : TEXT == null !");
		}
		this.windowModel = wm;
		setText(text, tc, lm);
	}

	/**
	 * bZ[WEChE`悵܂.
	 * `ł́A܂AEChỂԂ̔肪s܂.<br>
	 * ɃEChEfɂăEChẺnуx`悳܂.<br>
	 * ŌɃACRݒ肳Ăꍇ̓ACR`悵܂.<br>
	 * 
	 * @param g ރOtBbNXReLXg.<Br>
	 */
	@Override
	public void draw(Graphics2D g) {
		if (!isVisible() || !isExist()) {
			return;
		}
		windowModel.drawWindow(g, this);
		if (icon != null && isAllTextVisible()) {
			icon.draw(g);
		}
	}

	/**
	 * EChẼeLXgXV܂.
	 * 
	 * ̃\bhł́ÃEChEɃx݂ꍇɂ́Ãx̃fgp
	 * VeLXg쐬܂.<br>
	 * x݂ȂꍇɂSTANDARD_MODELgp܂.<br>
	 * <br>
	 * ̃\bhsetText(String, TimeCounter, LabelModel)gp܂B<br>
	 * 
	 * @param text ݒ肷镶.separatorɂĕ.<br>
	 * @param tc   SẴxɐݒ肷^CJE^̃}X^.ۂɂ̓N[gp.<br>
	 */
	public void setText(String text, TimeCounter tc) {
		setText(text, tc, (labels != null && labels.length != 0)
				? labels[0].getLabelModel() : LabelModel.STANDARD);
	}

	/**
	 * EChẼeLXgXV܂.
	 * 
	 * ̃\bhł́AVx̃^CJE^ɂTRUE_MODELIDXɂ͕̒ݒ肳܂.<br>
	 * āÃ\bhŐVݒ肷ƁÃeLXg͍ŏ炷ׂĂ\Ă܂.<br>
	 * 
	 * @param text ݒ肷镶.separatorɂĕ.<br>
	 * @param lm   Vxɐݒ肷郂f.<br>
	 */
	public void setText(String text, LabelModel lm) {
		String[] msg = text.split(separator);
		Sound sound = null;
		if (labels != null) {
			for (TextLabel label : labels) {
				if (label.getSound() != null) {
					sound = label.getSound();
					break;
				}
			}
		}
		labels = new TextLabel[msg.length];
		for (int i = 0; i < labels.length; i++) {
			labels[i] = new TextLabel(0, 0, msg[i], lm);
		}
		windowModel.initLabels(this);
		if (sound != null) {
			setSound(sound);
		}
	}

	/**
	 * EChẼeLXgXV܂.
	 * 
	 * ̃\bhł́AVx̉IDXɂ0ݒ肳܂.<br>
	 * āÃ\bhŐVݒ肷ƁA^CJE^tcуflmgp
	 * ꕶeLXg\邱Ƃł܂.<br>
	 * 
	 * @param text ݒ肷镶.separatorɂĕ.<br>
	 * @param tc   SẴxɐݒ肷^CJE^̃}X^.ۂɂ̓N[gp.<br>
	 * @param lm   Vxɐݒ肷郂f.<br>
	 */
	public void setText(String text, TimeCounter tc, LabelModel lm) {
		String[] msg = text.split(separator);
		Sound sound = null;
		if (labels != null) {
			for (TextLabel label : labels) {
				if (label.getSound() != null) {
					sound = label.getSound();
					break;
				}
			}
		}
		labels = new TextLabel[msg.length];
		for (int i = 0; i < labels.length; i++) {
			labels[i] = new TextLabel(0, 0, msg[i], 0, tc.clone(), lm);
		}
		windowModel.initLabels(this);
		if (sound != null) {
			setSound(sound);
		}
	}

	/**
	 * ݕ\̃xƓݒsetText(String, TimeCounter, LabelModel)ĂяoȈՃ\bhł.
	 *
	 * @param text ɕ\eLXgw肵܂B<br>
	 */
	public void setText(String text) {
		LabelModel model = labels != null && labels.length > 1 ? labels[0].getLabelModel() : LabelModel.STANDARD;
		TimeCounter tc = labels != null && labels.length > 1 ? labels[0].getTimeCounter() : TimeCounter.TRUE;
		tc = tc.clone();
		tc.reset();
		setText(text, tc, model);
	}

	/**
	 * Vxݒ肵Ȁݒs܂.
	 * ݒ̓EChEfɂčs܂.<br>
	 * 
	 * @param labels Vx̃CX^X.<br>
	 */
	public final void setLabels(TextLabel[] labels) {
		this.labels = labels;
		windowModel.initLabels(this);
	}

	/**
	 * ̃EChEɊ܂܂邷ׂẴx擾܂.
	 * ̃\bhŎ擾xɍsꂽ́AEChEɔf܂.<Br>
	 * 
	 * @return ̃EChEɊ܂܂郉x.<br>
	 */
	public TextLabel[] getLabels() {
		return labels;
	}

	/**
	 * ̃EChE̎w肵CfbNXx擾܂.
	 * 
	 * @param idx CfbNX.ʏ0x[X̍sԍƂȂ.<Br>
	 *
	 * @return w肵CfbNX̃x.<br>
	 *
	 * @throws ArrayIndexOutOfBoundsException sȗvf̏ꍇɓ.<br>
	 */
	public TextLabel getLabel(int idx) throws ArrayIndexOutOfBoundsException {
		return labels[idx];
	}

	/**
	 * EChẼfύX܂.
	 * EChẼfύXƁAACRуx̏ݒ肪s܂.<br>
	 * 
	 * @param windowModel Vf.<br>
	 */
	public void setWindowModel(MessageWindowModel windowModel) {
		this.windowModel = windowModel;
		windowModel.initIcon(this);
		windowModel.initLabels(this);
	}

	/**
	 * ̃EChEgpĂ郂f擾܂.
	 * 
	 * @return EChẼf.<br>
	 */
	public MessageWindowModel getWindowModel() {
		return windowModel;
	}

	/**
	 * ̃EChEɊ܂܂SẴxisAllVisibletrueԂǂ𒲂ׂ܂.
	 * ̃\bh́ueLXgύX̃^C~OvɎgpł܂.<br>
	 * 
	 * @return SẴxׂ̂Ă̕\ĂꍇtrueԂ.<Br>
	 */
	public boolean isAllTextVisible() {
		boolean result = true;
		for (int i = 0; i < labels.length; i++) {
			result &= labels[i].isAllTextVisible();
		}
		return result;
	}

	/**
	 * ̃EChEueLXg\vłāu\ĂȂvꍇɑSĂ̕\܂.
	 * ̃\bh͈ꕶ\̃eLXgvC[̑ɂĂׂĕ\邽߂Ɏgp܂.<Br>
	 * 
	 * @return ̃\bh̑ɂĂׂĂ̕\ꂽꍇtrueԂ.<br>
	 */
	public boolean skip() {
		if (!isAllTextVisible()) {
			allText();
			return true;
		}
		return false;
	}

	/**
	 * EChÊׂẴxallCharR[܂.
	 */
	public void allText() {
		for (int i = 0; i < labels.length; i++) {
			labels[i].allChar();
		}
	}

	/**
	 * ̃EChEɐݒ肳ĂACR擾܂.
	 * 
	 * @return ̃EChEɐݒ肳ĂACR.ݒ肳ĂȂꍇnullԂ.<br>
	 */
	public Sprite getIcon() {
		return icon;
	}

	/**
	 * ̃EChEɐVACRݒ肵܂.
	 * ACRݒ肷ƃEChEfinitIcon\bhR[܂.<br>
	 * ̃\bh̓EChẼCX^XƓɎgpł悤ɂȂĂ܂.<br>
	 * 
	 * @param icon ݒ肷ACR.<br>
	 *
	 * @return ̃EChẼCX^XԂ.<br>
	 */
	public MessageWindow setIcon(Sprite icon) {
		this.icon = icon;
		windowModel.initIcon(this);
		return this;
	}

	@Override
	public MessageWindow clone() {
		MessageWindow w = (MessageWindow) super.clone();
		w.windowModel = this.windowModel.clone();
		w.icon = this.icon.clone();
		return w;
	}

	/**
	 * ̃bZ[WEChEׂẴxɃTEhݒ肵܂.
	 *
	 * @param a 1\邽тɂ̃TEht@CĐ܂B<br>
	 */
	public void setSound(Sound a) {
		for (TextLabel l : labels) {
			l.setSound(a);
		}
	}

	@Override
	public void move() {
		super.move();
		for (TextLabel label : labels) {
			label.move();
		}
	}

	@Override
	public void move(MovingModel m) {
		super.move(m);
		for (TextLabel label : labels) {
			label.move(m);
		}
	}

	@Override
	public boolean move(Point2D.Float p, Shape s) {
		boolean result = super.move(p, s);
		for (TextLabel label : labels) {
			result &= label.move(p, s);
		}
		return result;
	}

	@Override
	public boolean move(float xValue, float yValue, Shape s) {
		boolean result = super.move(xValue, yValue, s);
		for (TextLabel label : labels) {
			result &= label.move(xValue, yValue, s);
		}
		return result;
	}
}
