/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import kinugasa.object.Model;
import kinugasa.object.Sprite;

/**
 * kinugasa : MessageWindowModel : bZ[WEChȄݒ肨щnƃx̕`sfł.
 * <br>
 * ̃f̓ŃJE^gpꍇ͏\ӂĂ.̂悤ȃfgpꍇ
 * ɐVCX^XgpĂ.<Br>
 * 
 * @version 1.0.0 - 2012/07/16_18:07:10.<br>
 * @version 2.0.0 - 2012/11/26_::.<br>
 * @author Dra0211<br>
 * <br>
 */
public abstract class MessageWindowModel extends Model {

	private static final long serialVersionUID = -3101131626178958221L;

	/**
	 * Vf\z܂.
	 */
	public MessageWindowModel() {
		super();
	}

	/**
	 * bZ[WEChEуeLXg`悵܂.
	 * 
	 * @param g OtBbNXReLXg.<Br>
	 * @param w bZ[WEChE.<Br>
	 */
	public abstract void drawWindow(Graphics2D g, MessageWindow w);

	/**
	 * bZ[WEChEw̎ׂẴxɓK؂ȍWݒ肵܂.
	 * ̃\bh̓EChEɐVeLXgݒ肳ꂽSẴ^C~OŃR[܂.<br>
	 * 
	 * @param w EChE.0ȏ̃x.x̏Ԃ͎ɂقȂ.<br>
	 */
	public abstract void initLabels(MessageWindow w);

	/**
	 * ʏ̃ASYpđSẴxEChE̍Wɕׂ܂.
	 *
	 * @param w       EChE̎𑗐M܂B<br<
	 * @param xBlank  X̃EChE̍W烉x̔zuʒu܂ł̃Mbvw肵܂B<br>
	 * @param yBlank  ỸEChE̍W烉x̔zuʒu܂ł̃Mbvw肵܂B<br>
	 * @param lineGap sԂw肵܂B<br>
	 */
	protected final void lineUpText(MessageWindow w, float xBlank, float yBlank, float lineGap) {
		TextLabel[] tl = w.getLabels();
		float x = w.getX() + xBlank;
		float y = w.getY() + yBlank;
		for (int i = 0; i < tl.length; i++) {
			tl[i].setLocation(x, y);
			y += tl[i].getLabelModel().getFontSize() + lineGap;
		}
	}

	/**
	 * w肳ꂽeLXgxׂĕ`悵Ax̕\CfbNXXV܂.
	 *
	 * @param g  ރOtBbNXReLXg𑗐M܂B<br>
	 * @param tl `悷郉x̔z𑗐M܂B<br>
	 */
	protected final void drawText(Graphics2D g, TextLabel... tl) {
		int line = 0;
		for (int i = 0; i < tl.length; i++) {
			if (!tl[i].isAllTextVisible()) {
				line = i;
				break;
			}
			line++;
		}
		for (int i = 0; i < tl.length && i <= line; i++) {
			if (!tl[i].isAllTextVisible() && tl[i].getTimeCounter().isReaching()) {
				tl[i].nextChar();
			}
			tl[i].draw(g);
		}
	}

	/**
	 * eLXgACRɓK؂Ȉʒuݒ肵܂.
	 * ̃\bhAEChEɐVACRݒ肳ꂽ^C~OŃR[܂.<br>
	 * ̃\bhł̓EChEiconnullł\܂.<br>
	 * 
	 * @param w EChE.<br>
	 */
	public abstract void initIcon(MessageWindow w);

	@Override
	public MessageWindowModel clone() {
		return (MessageWindowModel) super.clone();
	}
	/**
	 * DQ5ۂbZ[WEChE̎ł.
	 */
	public static final MessageWindowModel DQ5_STYLE_WINDOW_MODEL = new SimpleWindowModel(Color.BLACK, Color.WHITE, new Color(140, 140, 140), new Color(32, 32, 32));
	/**
	 * FF3ۂbZ[WEChE̎ł.
	 */
	public static final MessageWindowModel FF3_STYLE_WINDOW_MODEL = new SimpleWindowModel(Color.BLACK, new Color(255, 255, 255), new Color(140, 140, 140), new Color(16, 32, 172));
}