/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.awt.Graphics2D;
import kinugasa.util.TimeCounter;

/**
 * Kinugasa : SelectableMessageWindow : 1ȏ̑IeI΂邱Ƃł郁bZ[WEChE̊gNXł.
 * <br>
 * IbZ[WEChE1̎╶0ȏ̑I܂B<br>
 * ╶͉s"\n"𗘗p\łBI͉sł܂B<br>
 * I𒆂̑IwɂCHoiceEffectNXgp܂B<br>
 * ChoiceEffect̓bZ[WEChẼx̑I𒆃CfbNX̗vfɓKp܂B<br>
 * IꂽI͑ĨeLXg⃉xz̃CfbNX擾邱Ƃ
 * ʂ邱Ƃł܂B<br>
 * <br>
 * ̃bZ[WEChE͑IGtFNgnull̏ꍇ́AIGtFNg\܂B<br>
 * āAÎȂʂ̃bZ[WłĂ\\łB<br>
 * 𗘗pāArőI^bCxg̑IbZ[WEChEgp
 * 쐬邱ƂŁAEChE؂ւɑICxg𔭐邱Ƃł܂B<br>
 * <br>
 * ̃EChE̎ł́AׂẴx\܂őIGtFNg`悳܂B<br>
 * ͈ꕔ̃\bhɂIꂽl擾ɉe܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2012/11/23_21:19:46.<br>
 * @author Dra0211<br>
 * <br>
 */
public class SelectableMessageWindow extends MessageWindow {

	private static final long serialVersionUID = 1982543255115530212L;

	/**
	 * VIbZ[WEChE쐬܂.
	 * CfbNX͔z̃CfbNXłBʏ́A╶0ԖڂƂȂAl1Aŏ1Aő
	 * I̐ɂȂ܂B<br>
	 * AĨCfbNX͎╶̍s̉e󂯂܂B╶2sꍇ͏l2ƂȂ܂B<br>
	 * ̃RXgN^ł̓x̕\xԂ0ɐݒ肳܂BāAׂẴxŏ\܂B<br>
	 *
	 * @param x            EChEXWw肵܂B<br>
	 * @param y            EChEYWw肵܂B<br>
	 * @param width        EChE̕w肵܂B<br>
	 * @param height       EChE̍w肵܂B<br>
	 * @param wm           EChE̕\fw肵܂B<Br>
	 * @param lm           EChẼxɓKp郉xfw肵܂B<br>
	 * @param text         ╶łBs"\n"𗘗pł܂B<br>
	 * @param initialIdx   ŏɑIĂĨCfbNXw肵܂B<br>
	 * @param minIdx       I\ȃCfbNX̍ŏlw肵܂B<br>
	 * @param maxIdx       I\ȃCfbNX̍ŏlw肵܂B<br>
	 * @param choiceEffect IGtFNgw肵܂Bnulle܂B<br>
	 *
	 * @throws NullPointerException     eLXgnullłꍇɓ܂B<br>
	 * @throws IllegalArgumentException minIdx &gt; maxIdx̂Ƃɓ܂B<br>
	 */
	public SelectableMessageWindow(float x, float y, float width, float height,
			MessageWindowModel wm, LabelModel lm, String text,
			int initialIdx, int minIdx, int maxIdx, ChoiceEffect choiceEffect)
			throws NullPointerException, IllegalArgumentException {
		super(x, y, width, height, wm, lm, text);
		if (minIdx > maxIdx) {
			throw new IllegalArgumentException("! > SelectableMessageWindow : minIdx > maxIdx : min=[" + minIdx + "] max=[" + maxIdx + "]");
		}
		this.selectedIndex = initialIdx;
		this.minIndex = minIdx;
		this.maxIndex = maxIdx;
		this.choiceEffect = choiceEffect;
		select(selectedIndex);
	}

	/**
	 * VIbZ[WEChE쐬܂.
	 * CfbNX͔z̃CfbNXłBʏ́A╶0ԖڂƂȂAl1Aŏ1Aő
	 * I̐ɂȂ܂B<br>
	 * AĨCfbNX͎╶̍s̉e󂯂܂B╶2sꍇ͏l2ƂȂ܂B<br>
	 *
	 * @param x            EChEXWw肵܂B<br>
	 * @param y            EChEYWw肵܂B<br>
	 * @param width        EChE̕w肵܂B<br>
	 * @param height       EChE̍w肵܂B<br>
	 * @param wm           EChE̕\fw肵܂B<Br>
	 * @param lm           EChẼxɓKp郉xfw肵܂B<br>
	 * @param tc           xɓKp^CJE^w肵܂Bۂ̓N[gp܂B<br>
	 * @param text         ╶łBs"\n"𗘗pł܂B<br>
	 * @param initialIdx   ŏɑIĂĨCfbNXw肵܂B<br>
	 * @param minIdx       I\ȃCfbNX̍ŏlw肵܂B<br>
	 * @param maxIdx       I\ȃCfbNX̍ŏlw肵܂B<br>
	 * @param choiceEffect IGtFNgw肵܂Bnulle܂B<br>
	 *
	 * @throws NullPointerException     eLXgnullłꍇɓ܂B<br>
	 * @throws IllegalArgumentException minIdx &gt; maxIdx̂Ƃɓ܂B<br>
	 */
	public SelectableMessageWindow(float x, float y, float width, float height,
			MessageWindowModel wm, LabelModel lm, TimeCounter tc, String text,
			int initialIdx, int minIdx, int maxIdx, ChoiceEffect choiceEffect)
			throws NullPointerException, IllegalArgumentException {
		super(x, y, width, height, wm, lm, tc, text);
		if (minIdx > maxIdx) {
			throw new IllegalArgumentException("! > SelectableMessageWindow : minIdx > maxIdx : min=[" + minIdx + "] max=[" + maxIdx + "]");
		}
		this.selectedIndex = initialIdx;
		this.minIndex = minIdx;
		this.maxIndex = maxIdx;
		this.choiceEffect = choiceEffect;
		select(selectedIndex);
	}
	/** ̑IbZ[WEChEgpIGtFNgł. */
	private ChoiceEffect choiceEffect;
	/** ݑI𒆂̃x̃CfbNXł. */
	private int selectedIndex = 0;
	/** I\ȍŏ̃CfbNXł. */
	private int minIndex;
	/** I\ȍő̃CfbNXł. */
	private int maxIndex;

	/**
	 * I\ȍŏ̃CfbNX擾܂.
	 *
	 * @return I\ȍŏ̃CfbNXԂ܂B<br>
	 */
	public int getMinIndex() {
		return minIndex;
	}

	/**
	 * I\ȍŏ̃CfbNXݒ肵܂.
	 *
	 * @param minIndex I\ȍŏ̃CfbNXԂ܂B<br>
	 */
	public void setMinIndex(int minIndex) {
		this.minIndex = minIndex;
	}

	/**
	 * I\ȍő̃CfbNX擾܂.
	 *
	 * @return I\ȍő̃CfbNXԂ܂B<br>
	 */
	public int getMaxIndex() {
		return maxIndex;
	}

	/**
	 * I\ȍő̃CfbNXݒ肵܂.
	 *
	 * @param maxIndex I\ȍő̃CfbNXԂ܂B<br>
	 */
	public void setMaxIndex(int maxIndex) {
		this.maxIndex = maxIndex;
	}

	/**
	 * ̑IbZ[WEChEɐVIGtFNgݒ肵܂.
	 *
	 * @param choiceEffect IGtFNg̎𑗐M܂Bnulle܂B<br>
	 */
	public void setChoiceEffect(ChoiceEffect choiceEffect) {
		this.choiceEffect = choiceEffect;
	}

	/**
	 * ̑IbZ[WEChEɐݒ肳ĂGtFNg擾܂.
	 *
	 * @return ݒ肳ĂIGtFNg̎Ԃ܂Bݒ肳ĂȂꍇ
	 *            nullݒ肳Ăꍇ́AnullԂ܂B<br>
	 */
	public ChoiceEffect getChoiceEffect() {
		return choiceEffect;
	}

	/**
	 * I𒆂̑I1̑Iւƈڂ܂.
	 * ̃\bh͌ݑIĂIŌ(ő̃CfbNX)Iłꍇ
	 * s܂B<br>
	 */
	public void nextChoice() {
		selectedIndex++;
		clamp();
	}

	/**
	 * I𒆂̑I1̑Iւƈڂ܂.
	 * ̃\bh͌ݑIĂIŌ(ő̃CfbNX)Iłꍇ
	 * ŏ(ŏ̃CfbNX)II܂B<br>
	 */
	public void nextChoiceLoop() {
		if (selectedIndex == maxIndex) {
			selectedIndex = minIndex;
		} else {
			nextChoice();
		}
	}

	/**
	 * I𒆂̑I1ȎIւƈڂ܂.
	 * ̃\bh͌ݑIĂIŏ(ŏ̃CfbNX)Iłꍇ
	 * s܂B<br>
	 */
	public void prevChoice() {
		selectedIndex--;
		clamp();
	}

	/**
	 * I𒆂̑I1ȎIւƈڂ܂.
	 * ̃\bh͌ݑIĂIŏ(ŏ̃CfbNX)Iłꍇ
	 * Ō(ő̃CfbNX)II܂B<br>
	 */
	public void prevChoiceLoop() {
		if (selectedIndex == minIndex) {
			selectedIndex = maxIndex;
		} else {
			prevChoice();
		}
	}

	/**
	 * CfbNX̑IIԂɂ܂.
	 *
	 * @param idx ICfbNX𑗐M܂B<br>
	 *
	 * @throws IllegalArgumentException idx &gt;= labels.length || minIndex &gt; idx || maxIndex &lt; idx̂Ƃɓ܂B<br>
	 */
	public final void select(int idx) throws IllegalArgumentException {
		if (idx >= labels.length || minIndex > idx || maxIndex < idx) {
			throw new IllegalArgumentException("! > SelectableMessageWindow : select :  idx >= labels.length || minIndex > idx || maxIndex < idx : idx=["
					+ idx + "] labelsLength=[" + labels.length + "] min=[" + minIndex + "] max=[" + maxIndex + "]");
		}
		this.selectedIndex = idx;
		clamp();
	}

	/**
	 * CfbNXL͈͓ɐ؂l߂܂.
	 */
	protected final void clamp() {
		if (selectedIndex > maxIndex || selectedIndex > labels.length - 1) {
			selectedIndex = maxIndex;
		} else if (selectedIndex < minIndex || selectedIndex < 0) {
			selectedIndex = minIndex;
		}
	}

	/**
	 * ݑIĂ郉x擾܂.
	 *
	 * @return I𒆂̃xԂ܂BSẴx\ĂȂꍇ(!isAllTextVisible()̂Ƃ)
	 *            nullԂ܂B<br>
	 */
	public TextLabel getSelectedLabel() {
		if (!isAllTextVisible()) {
			return null;
		}
		return labels[selectedIndex];
	}
	/** SẴx\ĂȂ߂ɁAIĂȂԂ\CfbNX̒萔ł. */
	public static final int NOT_YET_SELECTED = -1;

	/**
	 * ݑIĂ郉x̃CfbNX擾܂.
	 *
	 * @return I𒆂̃x̃CfbNXԂ܂BSẴx\ĂȂꍇ(!isAllTextVisible()̂Ƃ)
	 *            NOT_YET_SELECTEDԂ܂B<br>
	 */
	public int getSelectedIndex() {
		if (!isAllTextVisible()) {
			return NOT_YET_SELECTED;
		}
		return selectedIndex;
	}

	@Override
	public void draw(Graphics2D g) {
		super.draw(g);
		if (isAllTextVisible() && choiceEffect != null) {
			choiceEffect.draw(g, getSelectedLabel());
		}
	}

	@Override
	public SelectableMessageWindow clone() {
		SelectableMessageWindow result = (SelectableMessageWindow) super.clone();
		result.choiceEffect = this.choiceEffect.clone();
		return result;
	}
}
