/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

/**
 * Kinugasa : SimpleBorderLabelModel : .
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/03/10_1:55:56<br>
 * @author Dra0211<br>
 */
public class SimpleBorderLabelModel extends SimpleLabelModel {

	private static final long serialVersionUID = -5777129069829712979L;
	private float borderSize;
	private Color borderColor;

	public SimpleBorderLabelModel(float borderSize, Color borderColor, Font f, Color c) {
		super(f, c);
		this.borderSize = borderSize;
		this.borderColor = borderColor;
	}

	public Color getBorderColor() {
		return borderColor;
	}

	public float getBorderSize() {
		return borderSize;
	}

	public void setBorderColor(Color borderColor) {
		this.borderColor = borderColor;
	}

	public void setBorderSize(float borderSize) {
		this.borderSize = borderSize;
	}

	@Override
	public void drawText(Graphics2D g, TextLabel l) {
		g.setFont(getFont());
		String text = l.getVisibleText();
		float x = l.getX();
		float y = l.getY();
		g.setColor(borderColor);
		g.drawString(text, (int) x + borderSize, (int) y + getFontSize() + borderSize);
		g.drawString(text, (int) x - borderSize, (int) y + getFontSize() - borderSize);
		g.drawString(text, (int) x + borderSize, (int) y + getFontSize() - borderSize);
		g.drawString(text, (int) x - borderSize, (int) y + getFontSize() + borderSize);
		g.setColor(getColor());
		g.drawString(text, (int) x, (int) y + getFontSize());
		if (l.getTimeCounter().isReaching() && !l.isAllTextVisible()) {
			l.nextChar();
		}
	}
}
