/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import kinugasa.object.Sprite;

/**
 * Kinugasa : SimpleClearWindowModel : .
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/19_22:41:27<br>
 * @author Dra0211<br>
 */
public class SimpleClearWindowModel extends MessageWindowModel {

	private static final long serialVersionUID = -2662571804611406032L;

	/**
	 * VEChEf쐬܂.
	 *
	 * @param borderColor {[_̐F𑗐M܂B<br>
	 * @param innerColor@ GA̐F𑗐M܂B<br>
	 * @param strokeWidth {[_̕w肵܂B<br>
	 */
	public SimpleClearWindowModel(Color borderColor, Color innerColor, float strokeWidth) {
		this.borderColor = borderColor;
		this.innerColor = innerColor;
		stroke = new BasicStroke(strokeWidth);
	}
	/** {[__O邽߂̃Xg[Nł. */
	private Stroke stroke;
	/** {[_̐Fł. */
	private Color borderColor;
	/** GA̐Fł. */
	private Color innerColor;

	@Override
	public void drawWindow(Graphics2D g, MessageWindow w) {
		g.setColor(innerColor);
		g.fillRoundRect((int) w.getX(), (int) w.getY(), (int) w.getWidth(), (int) w.getHeight(), 6, 6);
		g.setColor(borderColor);
		g.setStroke(stroke);
		g.drawRoundRect((int) w.getX(), (int) w.getY(), (int) w.getWidth(), (int) w.getHeight(), 6, 6);
		drawText(g, w.getLabels());
	}
	/** X̃xzuʒũMbvł. */
	private final int X_BLANK = 6;
	/** ỸxzuʒũMbvł. */
	private final int Y_BLANK = 6;
	/** sԂł. */
	private final int LINE_GAP = 3;

	@Override
	public void initLabels(MessageWindow w) {
		lineUpText(w, X_BLANK, Y_BLANK, LINE_GAP);
	}

	@Override
	public void initIcon(MessageWindow w) {
		Sprite icon = w.getIcon();
		if (icon == null) {
			return;
		}
		icon.setVisible(true);
		icon.setExist(true);
		float x = w.getX() + w.getWidth() / 2 - icon.getWidth();
		float y = w.getY() + w.getHeight() - icon.getHeight() - icon.getHeight() / 2;
		icon.setLocation(x, y);
	}
}