/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import kinugasa.object.Sprite;

/**
 * Kinugasa : SimpleWindowModel : .
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/19_22:42:05<br>
 * @author Dra0211<br>
 */
public class SimpleWindowModel extends MessageWindowModel {

	private static final long serialVersionUID = -5369806996238641648L;

	/**
	 * VEChEf쐬܂.
	 *
	 * @param BORDER_1 ԊÕ{[_̐Fw肵܂B<br>
	 * @param BORDER_2 Ԃ̃{[_̐Fw肵܂B<br>
	 * @param BORDER_3 ̃{[_̐Fw肵܂B<br>
	 * @param INNER    GA̐Fw肵܂B<br>
	 */
	public SimpleWindowModel(Color BORDER_1, Color BORDER_2, Color BORDER_3, Color INNER) {
		this.BORDER_1 = BORDER_1;
		this.BORDER_2 = BORDER_2;
		this.BORDER_3 = BORDER_3;
		this.INNER = INNER;
	}
	/** ԊÕ{[_̐Fł. */
	private final Color BORDER_1;
	/** Ԃ̃{[_̐Fł. */
	private final Color BORDER_2;
	/** ̃{[_̐Fł. */
	private final Color BORDER_3;
	/** GA̐Fł. */
	private final Color INNER;
	/** {[_̕ł. */
	private final int BORDER_WIDTH = 1;

	@Override
	public void drawWindow(Graphics2D g, MessageWindow w) {
		g.setColor(BORDER_1);
		g.fillRoundRect((int) w.getX(), (int) w.getY(), (int) w.getWidth(), (int) w.getHeight(), 6, 6);
		g.setColor(BORDER_3);
		g.fillRoundRect((int) w.getX() + BORDER_WIDTH, (int) w.getY() + BORDER_WIDTH,
				(int) w.getWidth() - BORDER_WIDTH * 2, (int) w.getHeight() - BORDER_WIDTH * 2, 6, 6);
		g.setColor(BORDER_2);
		g.fillRoundRect((int) w.getX() + BORDER_WIDTH * 2, (int) w.getY() + BORDER_WIDTH * 2,
				(int) w.getWidth() - BORDER_WIDTH * 4, (int) w.getHeight() - BORDER_WIDTH * 4, 6, 6);
		g.setColor(BORDER_3);
		g.fillRoundRect((int) w.getX() + BORDER_WIDTH * 3, (int) w.getY() + BORDER_WIDTH * 3,
				(int) w.getWidth() - BORDER_WIDTH * 6, (int) w.getHeight() - BORDER_WIDTH * 6, 6, 6);
		g.setColor(INNER);
		g.fillRoundRect((int) w.getX() + BORDER_WIDTH * 4, (int) w.getY() + BORDER_WIDTH * 4,
				(int) w.getWidth() - BORDER_WIDTH * 8, (int) w.getHeight() - BORDER_WIDTH * 8, 6, 6);
		drawText(g, w.getLabels());
	}
	/** X̃xzuʒũMbvł. */
	private final int X_BLANK = 6;
	/** ỸxzuʒũMbvł. */
	private final int Y_BLANK = 6;
	/** sԂł. */
	private final int LINE_GAP = 3;

	@Override
	public void initLabels(MessageWindow w) {
		lineUpText(w, X_BLANK, Y_BLANK, LINE_GAP);
	}

	@Override
	public void initIcon(MessageWindow w) {
		Sprite icon = w.getIcon();
		if (icon == null) {
			return;
		}
		icon.setVisible(true);
		icon.setExist(true);
		float x = w.getX() + w.getWidth() / 2 - icon.getWidth();
		float y = w.getY() + w.getHeight() - icon.getHeight() - icon.getHeight() / 2;
		icon.setLocation(x, y);
	}
}