/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.ui;

import java.awt.Graphics2D;
import kinugasa.contents.sound.Sound;
import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;
import kinugasa.object.VectorF;
import kinugasa.util.TimeCounter;

/**
 * kinugasa : TextLabel : s̃eLXg\XvCg̎ł.
 * <br>
 * 
 * <br>
 * x͂Ps̃eLXgƃ^CJE^ۗLĂAeLXg̍ŏPԂɕ\邱Ƃł܂.<br>
 * <br>
 * \͕\̓xɐݒ肳Ă^CJE^𗘗pĔ肳Aݒ肳ĂxԌoߌɕ\P
 * ǉ܂.<Br>
 * 
 * x̕≺n̕`LabelModelōs܂.<br>
 * <br>
 *
 * @version 1.0.0 - 2012/07/16_14:11:53.<br>
 * @author Dra0211<br>
 */
public class TextLabel extends BasicSprite {

	private static final long serialVersionUID = 5968313475051994644L;
	/** xɕ\eLXg. */
	private StringBuilder text;
	/** \镶. */
	private int idx;
	/** \xp̃JE^. */
	private TimeCounter timeCounter;
	/** \f. */
	private LabelModel labelModel;
	/** 1\邽тɍĐłTEht@Cł. */
	private Sound sound = null;

	/**
	 * Vx쐬܂.
	 * ̃RXgN^ł́AׂĂ̕\܂(idx==text.length())<br>
	 * ܂Ax̃TCY1,1ɂȂ܂.<br>
	 * ̑XvCg̃vpeB̓XvCg̃ftHglKp܂.<br>
	 * 
	 * @param x XW.<br>
	 * @param y YW.<br>
	 * @param text \eLXg.<Br>
	 * @param lm \f.<br>
	 */
	public TextLabel(float x, float y,
			String text, LabelModel lm) {
		super(x, y, 1, 1);
		this.text = new StringBuilder(text);
		this.idx = text.length();
		this.timeCounter = TimeCounter.TRUE;
		this.labelModel = lm;
		int w = (int) ((lm.getFont().getSize() * 0.66f + 4) * text.length());
		int h = lm.getFont().getSize() + 2;
		setSize(w, h);
	}

	/**
	 * Vx쐬܂.
	 * ̃RXgN^ł́AׂĂ̕\܂(idx==text.length())<br>
	 * ܂Ax̃TCY1,1ɂȂ܂.<br>
	 * ̑XvCg̃vpeB̓XvCg̃ftHglKp܂.<br>
	 * 
	 * @param x XW.<br>
	 * @param y YW.<br>
	 * @param text \eLXg.<Br>
	 * @param tc ^CJE^.gpȂꍇTimeCounter.FALSE_MODELw肷.TimeCounter.TRUE_MODELő
	 * `惂fiPt[ɂPǉjƂȂAȏ̑x͂Pt[ɂQȏ̃eLXg
	 * pLabelModel`Kv.<br>
	 * @param lm \f.<br>
	 */
	public TextLabel(float x, float y,
			String text, TimeCounter tc, LabelModel lm) {
		super(x, y, 1, 1);
		this.text = new StringBuilder(text);
		this.idx = text.length();
		this.timeCounter = tc;
		this.labelModel = lm;
		int w = (int) ((lm.getFont().getSize() * 0.66f + 4) * text.length());
		int h = lm.getFont().getSize() + 2;
		setSize(w, h);

	}

	/**
	 * Vx쐬܂.
	 * x̃TCY1,1ɂȂ܂.<br>
	 * ̑XvCg̃vpeB̓XvCg̃ftHglKp܂.<br>
	 * 
	 * @param x XW.<br>
	 * @param y YW.<br>
	 * @param text \eLXg.<Br>
	 * @param idx \镶.<br>
	 * @param tc ^CJE^.gpȂꍇTimeCounter.FALSE_MODELw肷.TimeCounter.TRUE_MODELő
	 * `惂fiPt[ɂPǉjƂȂAȏ̑x͂Pt[ɂQȏ̃eLXg
	 * pLabelModel`Kv.<br>
	 * @param lm \f.<br>
	 */
	public TextLabel(float x, float y,
			String text, int idx, TimeCounter tc, LabelModel lm) {
		super(x, y, 1, 1);
		this.text = new StringBuilder(text);
		this.idx = idx;
		this.timeCounter = tc;
		this.labelModel = lm;
		int w = (int) ((lm.getFont().getSize() * 0.66f + 4) * text.length());
		int h = lm.getFont().getSize() + 2;
		setSize(w, h);

	}

	/**
	 * Vx쐬܂.
	 * 
	 * @param x XW.<br>
	 * @param y YW.<br>
	 * @param w .<br>
	 * @param h .<br>
	 * @param vector
	 * @param text \eLXg.<Br>
	 * @param movingModel ړf.<br>
	 * @param tc ^CJE^.gpȂꍇTimeCounter.FALSE_MODELw肷.TimeCounter.TRUE_MODELő
	 * `惂fiPt[ɂPǉjƂȂAȏ̑x͂Pt[ɂQȏ̃eLXg
	 * pLabelModel`Kv.<br>
	 * @param lm \f.<br>
	 */
	public TextLabel(float x, float y, float w, float h,
			VectorF vector, MovingModel movingModel,
			String text, TimeCounter tc, LabelModel lm) {
		super(x, y, w, h, vector, movingModel);
		this.text = new StringBuilder(text);
		this.idx = text.length();
		this.timeCounter = tc;
		this.labelModel = lm;
	}

	/**
	 * Vx쐬܂.
	 * 
	 * @param x XW.<br>
	 * @param y YW.<br>
	 * @param w .<br>
	 * @param h .<br>
	 * @param vector
	 * @param text \eLXg.<Br>
	 * @param idx \镶.<br>
	 * @param movingModel ړf.<br>
	 * @param tc ^CJE^.gpȂꍇTimeCounter.FALSE_MODELw肷.TimeCounter.TRUE_MODELő
	 * `惂fiPt[ɂPǉjƂȂAȏ̑x͂Pt[ɂQȏ̃eLXg
	 * pLabelModel`Kv.<br>
	 * @param lm \f.<br>
	 */
	public TextLabel(float x, float y, float w, float h,
			VectorF vector, MovingModel movingModel,
			String text, int idx, TimeCounter tc, LabelModel lm) {
		super(x, y, w, h, vector, movingModel);
		this.text = new StringBuilder(text);
		this.idx = idx;
		this.timeCounter = tc;
		this.labelModel = lm;
	}

	/**
	 * x`悵܂.
	 * ۂ̕`̓xfs܂.<br>
	 * 
	 * @param g ރOtBbNXReLXg.<br>
	 */
	@Override
	public void draw(Graphics2D g) {
		if (!isVisible() || !isExist()) {
			return;
		}
		labelModel.drawText(g, this);
	}

	public void draw(Graphics2D g, LabelModel model) {
		if (!isVisible() || !isExist()) {
			return;
		}
		model.drawText(g, this);
	}

	/**
	 * x̃eLXgXV܂.
	 * 
	 * @param text VeLXg.<br>
	 */
	public void setText(String text) {
		setText(text, true);
	}

	public void setText(String text, boolean allout) {
		this.text.replace(0, this.text.length(), text);
		if (idx > text.length()) {
			idx = text.length();
		}
		if (allout) {
			allChar();
		}
	}

	/**
	 * ̃x̃eLXgStringƂĎ擾܂.
	 * ̃\bh͐VStringԂ܂.<br>
	 * 
	 * @return x̃eLXg.<br>
	 */
	public String getText() {
		return text.toString();
	}

	/**
	 * ̃x̃eLXg̎Ԃ܂.
	 * ̃\bh͎QƂԂ܂.<br>
	 * 
	 * @return x̃eLXg.<br>
	 */
	public StringBuilder getStringBuilder() {
		return text;
	}

	/**
	 * ̃x̃eLXg̕\̕擾܂.
	 * SẴxfł́AʏÃ\bhgp擾\ׂł.<br.
	 * 
	 * @return \̕.̃xɐݒ肳Ă镶0idx܂ł̕.<Br>
	 */
	public String getVisibleText() {
		return text.substring(0, idx);
	}

	/**
	 * \ԂɎgp^CJE^ݒ肵܂.
	 * 
	 * @param timeCounter JE^.<br>
	 */
	public void setTimeCounter(TimeCounter timeCounter) {
		this.timeCounter = timeCounter;
	}

	/**
	 * \ԂɎgp^CJE^擾܂.
	 * 
	 * @return timeCounter JE^.<br>
	 */
	public TimeCounter getTimeCounter() {
		return timeCounter;
	}

	/**
	 * xfݒ肵܂.
	 * 
	 * @param labelModel xf.<br>
	 */
	public void setLabelModel(LabelModel labelModel) {
		this.labelModel = labelModel;
	}

	/**
	 * xf擾܂.
	 * 
	 * @return xf.<br>
	 */
	public LabelModel getLabelModel() {
		return labelModel;
	}

	/**
	 * ̃xSĂ̕\Ă邩𒲂ׂ܂.
	 * 
	 * @return SĂ̕񂪉ĂꍇtrueԂ.<br>
	 */
	public boolean isAllTextVisible() {
		return idx == text.length();
	}

	/**
	 * \̈g債A̕܂.
	 * eLXgׂĕ\Ăꍇ͉s܂.<br>
	 */
	public void nextChar() {
		if (text.charAt(idx) != ' ' && text.charAt(idx) != '@') {
			if (sound != null) {
				if (!sound.isLoaded()) {
					sound.load();
				}
				sound.again();
			}
		}
		idx = isAllTextVisible() ? text.length() : idx + 1;
	}

	/**
	 * \̈kAO̕܂ł܂.
	 * eLXg\ĂȂꍇ͉s܂.<br>
	 */
	public void prevChar() {
		idx = idx == 0 ? 0 : idx - 1;
	}

	/**
	 * SĂ̕܂.
	 */
	public void allChar() {
		idx = text.length();
	}

	/**
	 * SĂ̕sɂ܂.
	 */
	public void resetIdx() {
		idx = 0;
	}

	/**
	 * 1\邽тɍĐTEhݒ肵܂.
	 * TEhnulle܂B<br>
	 *
	 * @param sound TEht@C𑗐M܂B<br>
	 */
	public void setSound(Sound sound) {
		this.sound = sound;
	}

	/**
	 * 1\邽тɍĐTEh擾܂.
	 * TEhnulle܂Bݒ肳ĂȂꍇnullԂ܂B<br>
	 *
	 * @return ̃xɐݒ肳ĂTEht@CԂ܂Bݒ肳ĂȂꍇnullԂ܂B<br>
	 */
	public Sound getSound() {
		return sound;
	}

	@Override
	public TextLabel clone() {
		TextLabel tl = (TextLabel) super.clone();
		tl.text = new StringBuilder(text);
		tl.timeCounter = this.timeCounter.clone();
		tl.labelModel = this.labelModel.clone();
		return tl;
	}
}
