/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.util;

import java.util.Arrays;
import kinugasa.util.annotations.CallSuper;
import kinugasa.util.annotations.CallTiming;
import kinugasa.util.annotations.CastReturnValue;
import kinugasa.util.annotations.VirtualMethod;

/**
 * Kinugasa : FrameTimeCounter : ́AĂяo񐔃x[X̑ҋ@ԂԂɕ]TimeCounter̎ł.
 * <br>
 * ̃NX́ATimeCounter̊{̎łBƂ΁ASTGɂˌԊu̐ȂǂɎgp܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/11_18:35:20<br>
 * @author Dra0211<br>
 */
public class FrameTimeCounter extends TimeCounter {

	private static final long serialVersionUID = 8128288858943550667L;
	/** ݂̃CfbNX̑҂Ԃ̃JE^ł.
	 * ̒lۂɌvZ܂B */
	private int timeCount;
	/** JE^lł. */
	private int speed;
	/** JڂCfbNX̃fł. */
	private ArrayIndexModel index;
	/** ŏɐݒ肳ĂԂ̃CfbNX̃fł. */
	private ArrayIndexModel initialIndex;
	/** ҂Ԃi[zł. */
	private int[] waitTime;
	/** sł邩𔻒肷tOł. */
	private boolean running;

	/**
	 * ҂Ԃw肵āAVJE^쐬܂.
	 * ̃RXgN^ł́Ax1ACfbNX͒ʏ̃V[PVȃCfbNXݒ肳܂B<br>
	 *
	 * @param waitTime ҋ@Ԃw肵܂B0w肷ƁAtrueԂfA1w肷ƁA2ڂ̌Ăяo݂
	 * trueԂf쐬܂Bw肵Ȃꍇ́A0ɂȂ܂B<br>
	 */
	public FrameTimeCounter(int... waitTime) {
		this(1, (waitTime.length == 0 ? new int[]{0} : waitTime));
	}

	/**
	 * xƑ҂Ԃw肵āAVJE^쐬܂.
	 * ̃RXgN^ł́ACfbNX͒ʏ̃V[PVȃCfbNXݒ肳܂B<br>
	 *
	 * @param speed ҂Ԃɑ΂Jڑxw肵܂BƂ΁A2w肷Ƒ҂Ԃ猟̂т2A
	 * 0ȉɂȂꍇɁuԐ؂vƔ肳܂B<br>
	 * @param waitTime ҋ@Ԃw肵܂B0w肷ƁAtrueԂfA1w肷ƁA2ڂ̌Ăяo݂
	 * trueԂf쐬܂Bw肵Ȃꍇ́A0ɂȂ܂B<br>
	 */
	public FrameTimeCounter(int speed, int[] waitTime) {
		this(speed, new SequentialIndex(), waitTime);
	}

	/**
	 * CfbNXfƑ҂Ԃw肵āAVJE^쐬܂.
	 * ̃RXgN^ł́Ax1ݒ肳܂B<br>
	 *
	 * @param index ҂Ԃ̔zɑ΂CfbNX̑Jڃfw肵܂B<br>
	 * @param waitTime ҋ@Ԃw肵܂B0w肷ƁAtrueԂfA1w肷ƁA2ڂ̌Ăяo݂
	 * trueԂf쐬܂Bw肵Ȃꍇ́A0ɂȂ܂B<br>
	 */
	public FrameTimeCounter(ArrayIndexModel index, int... waitTime) {
		this(1, index, waitTime);
	}

	/**
	 * xACfbNXfA҂Ԃw肵ĐVJE^쐬܂.
	 *
	 * @param speed ҂Ԃɑ΂Jڑxw肵܂BƂ΁A2w肷Ƒ҂Ԃ猟̂т2A
	 * 0ȉɂȂꍇɁuԐ؂vƔ肳܂B<br>
	 * @param index ҂Ԃ̔zɑ΂CfbNX̑Jڃfw肵܂B<br>
	 * @param waitTime ҋ@Ԃw肵܂B0w肷ƁAtrueԂfA1w肷ƁA2ڂ̌Ăяo݂
	 * trueԂf쐬܂Bw肵Ȃꍇ́A0ɂȂ܂B<br>
	 */
	public FrameTimeCounter(int speed, ArrayIndexModel index, int... waitTime) {
		if (waitTime.length == 0) {
			waitTime = new int[]{0};
		}
		this.speed = speed;
		this.index = index;
		this.waitTime = waitTime;
		this.timeCount = waitTime[index.index(waitTime.length)];
		this.initialIndex = index.clone();
	}

	@Override
	@CallSuper(CallTiming.ANY)
	@CastReturnValue
	@VirtualMethod
	public FrameTimeCounter clone() {
		FrameTimeCounter result = (FrameTimeCounter) super.clone();
		result.index = this.index.clone();
		result.waitTime = this.waitTime.clone();
		return result;
	}

	@Override
	public boolean isReaching() {
		running = true;
		timeCount -= speed;
		if (timeCount < 0) {
			timeCount = waitTime[index.index(waitTime.length)];
			return true;
		}
		return false;
	}

	public void initCount() {
		timeCount = waitTime[index.getIndex()];
	}

	public void setIndex(ArrayIndexModel index) {
		this.index = index;
		initCount();
	}

	public void setIndex(int index) {
		timeCount = waitTime[index];
	}

	public ArrayIndexModel getIndex() {
		return index;
	}

	public void setSpeed(int speed) {
		this.speed = speed;
	}

	public int getSpeed() {
		return speed;
	}

	public int getTimeCount() {
		return timeCount;
	}

	public void setTimeCount(int timeCount) {
		this.timeCount = timeCount;
	}

	public int[] getWaitTime() {
		return waitTime;
	}

	public void setWaitTime(int... waitTime) {
		this.waitTime = waitTime;
	}

	@Override
	public boolean isEnded() {
		return false;
	}

	@Override
	public boolean isRunning() {
		return running;
	}

	@Override
	public void reset() {
		index = initialIndex.clone();
	}

	@Override
	public int hashCode() {
		int hash = 3;
		hash = 67 * hash + this.timeCount;
		hash = 67 * hash + this.speed;
		hash = 67 * hash + (this.index != null ? this.index.hashCode() : 0);
		hash = 67 * hash + Arrays.hashCode(this.waitTime);
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final FrameTimeCounter other = (FrameTimeCounter) obj;
		if (this.timeCount != other.timeCount) {
			return false;
		}
		if (this.speed != other.speed) {
			return false;
		}
		if (this.index != other.index && (this.index == null || !this.index.equals(other.index))) {
			return false;
		}
		if (!Arrays.equals(this.waitTime, other.waitTime)) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return "FrameTimeCounter{" + "timeCount=" + timeCount + ", speed=" + speed + ", index=" + index + ", waitTime=" + Arrays.toString(waitTime) + '}';
	}
}
