/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.util;

/**
 * Kinugasa : OnlyFirstTimeCounter : ŏ̌w肳ꂽlԂAȍ~
 * ŏ̌Ƃ͋t̒lԂ^CJE^̎ł.
 * <br>
 * resetR[ƁAuŏ̌ĂяovȌԂɖ߂Ƃo܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/02/20_22:16:22<br>
 * @author Dra0211<br>
 */
public class OnlyFirstTimeCounter extends TimeCounter {

	private static final long serialVersionUID = -1074690399355994082L;
	/** ŏɕԂlł. */
	private boolean firstValue;
	/** ŏ̌Ăяom邽߂̃tOł. */
	private boolean running = false;

	/**
	 * ŏɕԂlw肵A^CJE^쐬܂.
	 * @param firstValue ŏɕԂlł.2ڂ̌ĂяóAreset܂!firstValueԂ܂B<br>
	 */
	public OnlyFirstTimeCounter(boolean firstValue) {
		this.firstValue = firstValue;
	}

	@Override
	public boolean isReaching() {
		if (running) {
			return !firstValue;
		}
		running = true;
		return firstValue;
	}

	@Override
	public boolean isEnded() {
		return false;
	}

	@Override
	public boolean isRunning() {
		return running;
	}

	@Override
	public void reset() {
		running = false;
	}

	@Override
	public OnlyFirstTimeCounter clone() {
		return (OnlyFirstTimeCounter) super.clone();
	}

	@Override
	public String toString() {
		return "OnlyFirstTimeCounter{" + "firstValue=" + firstValue + ", running=" + running + '}';
	}
}
