/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.util;

/**
 * Kinugasa : SequentialIndex : z̗vfɁAԂɃANZX{IȃCfbNX̃JE^ł.
 * <br>
 * CfbNX́AA~̐؂ւ\łB[v邩ǂIł܂B<br>
 * index\bhĂяo邽тɁACfbNX̒lJEg܂B<br>
 * <br>
 * ̎́AŃJE^̒lێ邽߁A1̔zvfɑ΂āA1
 * CfbNXfKvłB<br>
 *
 * @version 1.0.0 - 2013/01/12_17:12:36<br>
 * @author Dra0211<br>
 */
public class SequentialIndex extends ArrayIndexModel {

	private static final long serialVersionUID = -5792984578642711312L;
	/** ݂̃CfbNXł. */
	private int index;
	/** CfbNX[v邩ǂ̃tOł. */
	private boolean loop;
	/** CfbNX{̕ɐi߂邩ǂ̃tOł. */
	private boolean toPlus;

	/**
	 * 0X^[gAEփ[vCfbNXf쐬܂.
	 */
	public SequentialIndex() {
		this(0, true, true);
	}

	/**
	 * w肳ꂽCfbNXX^[gAEփ[vCfbNXf쐬܂.
	 *
	 * @param index CfbNX̏lw肵܂B<br>
	 */
	public SequentialIndex(int index) {
		this(index, true, true);
	}

	/**
	 * 0X^[gAE֐iރCfbNXf쐬܂.
	 *
	 * @param loop truew肷ƁACfbNXz̍Ō̗vfQƂƂ
	 * ̎QƂł0Ԗڂɖ߂܂B<br>falseł́AŌ̎QƂŃCfbNX̍XV~܂܂B<br>
	 */
	public SequentialIndex(boolean loop) {
		this(0, loop, true);
	}

	/**
	 * 0X^[gAw肳ꂽ֐iރCfbNXf쐬܂.
	 *
	 * @param loop truew肷ƁACfbNXz̍Ō̗vfQƂƂ
	 * ̎QƂł0Ԗڂɖ߂܂B<br>falseł́AŌ̎QƂŃCfbNX̍XV~܂܂B<br>
	 * @param toPlus truew肷ƁACfbNX+̕֐i݂܂B<br>falseł-̕֐i݂܂B<br>
	 */
	public SequentialIndex(boolean loop, boolean toPlus) {
		this(0, loop, toPlus);
	}

	/**
	 * w肳ꂽCfbNXX^[gAEփ[vCfbNXf쐬܂.
	 *
	 * @param index CfbNX̏lw肵܂B<br>
	 * @param loop truew肷ƁACfbNXz̍Ō̗vfQƂƂ
	 * ̎QƂł0Ԗڂɖ߂܂B<br>falseł́AŌ̎QƂŃCfbNX̍XV~܂܂B<br>
	 */
	public SequentialIndex(int index, boolean loop) {
		this(index, loop, true);
	}

	/**
	 * w肳ꂽCfbNXX^[gCfbNXf쐬܂.
	 *
	 * @param index CfbNX̏lw肵܂B<br>
	 * @param loop truew肷ƁACfbNXz̍Ō̗vfQƂƂ
	 * ̎QƂł0Ԗڂɖ߂܂B<br>falseł́AŌ̎QƂŃCfbNX̍XV~܂܂B<br>
	 * @param toPlus truew肷ƁACfbNX+̕֐i݂܂B<br>falseł-̕֐i݂܂B<br>
	 */
	public SequentialIndex(int index, boolean loop, boolean toPlus) {
		this.index = index;
		this.loop = loop;
		this.toPlus = toPlus;
	}

	@Override
	public int index(int arrayLength) {
		//*/
		if (toPlus) {
			if (index >= arrayLength - 1) {
				if (!loop) {
					return arrayLength - 1;
				}
				index = 0;
			}
			return index++;
		} else {
			if (index == -1) {
				if (!loop) {
					return 0;
				}
				index = arrayLength - 1;
			}
			return index--;
		}
		//*/
	}

	/**
	 * CfbNX̌ݒlݒ肵܂.
	 *
	 * @param index JE^̒lw肵܂B<br>
	 */
	public void setIndex(int index) {
		this.index = index;
	}

	@Override
	public int getIndex() {
		return index;
	}

	/**
	 * [vݒύX܂.
	 *
	 * @param loop truew肷ƁACfbNXz̍Ō̗vfQƂƂ
	 * ̎QƂł0Ԗڂɖ߂܂B<br>falseł́AŌ̎QƂŃCfbNX̍XV~܂܂B<br>
	 */
	public void setLoop(boolean loop) {
		this.loop = loop;
	}

	/**
	 * ̃CfbNXf[v邩𒲂ׂ܂.
	 *
	 * @return [vݒł́AtrueԂ܂B<br>
	 */
	public boolean isLoop() {
		return loop;
	}

	/**
	 * CfbNX̐iޕύX܂.
	 *
	 * @param toPlus truew肷ƁACfbNX+̕֐i݂܂B<br>falseł-̕֐i݂܂B<br>
	 */
	public void setToPlus(boolean toPlus) {
		this.toPlus = toPlus;
	}

	/**
	 * ̃CfbNXf̃CfbNX̐iޕ𒲂ׂ܂.
	 *
	 * @return trueł́ACfbNX+̕֐i݂܂B<br>
	 */
	public boolean isToPlus() {
		return toPlus;
	}

	@Override
	public ArrayIndexModel clone() {
		return super.clone();
	}

	@Override
	public int hashCode() {
		int hash = 7;
		hash = 71 * hash + this.index;
		hash = 71 * hash + (this.loop ? 1 : 0);
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final SequentialIndex other = (SequentialIndex) obj;
		if (this.index != other.index) {
			return false;
		}
		if (this.loop != other.loop) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return "SequentialIndex{" + "index=" + index + ", loop=" + loop + ", toPlus=" + toPlus + '}';
	}
}