/*
 * Copyright (c) 2004
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/time.h>
#include <sys/param.h>

#include "kircd.h"

unsigned char *configfile = "kircd.conf";
static char version[]= VERSION;

char buff[SBUFLEN+1];
char lbuff[LBUFLEN+1];

int get_addr(struct addrinfo h, const char *host,
	     const char *port, int flag)
{
	struct addrinfo *res, *res0;
	int i,s;
	i = s = 0;

	if (flag == SERVER) {
		i = getaddrinfo(NULL, port, &h, &res0);
	} else {
		i = getaddrinfo(host, port, &h, &res0);
	}

	if (i) {
		printf("error: %s\n", gai_strerror(i));
		return (-1);
	}

	if (flag == SERVER) {
		if (res0->ai_next) {
			printf("multiple addr\n");
			return (-1);
		}
		s = socket(res0->ai_family, res0->ai_socktype,
 			   res0->ai_protocol);
		if (s < 0)
			return (-1);
		if (bind(s, res0->ai_addr, res0->ai_addrlen) < 0)
			return (-1);
	} else {
		for (res=res0; res; res = res->ai_next) {
			s = socket(res->ai_family, res->ai_socktype,
			   	   res->ai_protocol); 
			if (connect(s, res->ai_addr, res->ai_addrlen) < 0) {
				close(s);
				continue;
			}
			break;
		}
	}
	freeaddrinfo(res0);

	return s;
}

int main(int argc, char *argv[])
{
	struct addrinfo h;
	struct config *cf;
	GThread *t1, *t2, *t3;
	int s1, s2;
	struct tparam th;

	/* initialize structure */
	cf = (struct config *)malloc(sizeof(struct config));
	if (cf == NULL)
		printf("error: cannot malloc struct config\n");

	/* read configuration file */
	if (readconf(configfile, cf))
		printf("error: Configration\n");

	/* make socket for IRC client (IPv4/v6) */
	memset(&h, 0, sizeof(h));
	h.ai_family = PF_UNSPEC;
	h.ai_socktype = SOCK_STREAM;
	s1 = get_addr(h, cf->hostname, cf->server_port, CLIENT);
	if (s1 < 0) {
		printf("error: faild to make socket for IRC client\n");
		exit(1);
	}

	/* make socket for HTTP server (IPv4 only) */
	memset(&h, 0, sizeof(h));
	h.ai_family = AF_INET;
	h.ai_socktype = SOCK_STREAM;
	h.ai_flags = AI_PASSIVE;
	s2 = get_addr(h, NULL, cf->client_port, SERVER);
	if (s2 < 0) {
		printf("error: faild to make socket for HTTP server\n");
		exit(1);
	}
	listen(s2, 1);

	/* make thread for IRC client */
	th.socket_number = s1;
	th.s_read = 0;
	th.s_count = 0;
	th.s_empty = 1; /* recv buffer is empty */
	th.t_empty = 1;	/* trans buffer is empty */
	th.s_lock = 0;
	th.s_buff = buff; 
	th.l_buff = lbuff; 

	/* copy config option */
	th.max_line = cf->max_line;
	th.line_reverse = cf->line_reverse;
	strcpy(th.real_nickname, cf->nickname);

	/* copy auth info */
	strcpy(th.auth_user, cf->auth_user);
	strcpy(th.auth_pass, cf->auth_pass);

	/* initialize gthread */
	g_thread_init(NULL);

	t1 = g_thread_create(watch, (gpointer *)&th, TRUE, NULL);
	t2 = g_thread_create(lineget, (gpointer *)&th, TRUE, NULL);

	init(s1, cf);

	/* make thread for HTTP server */
	th.server_socket = s2;
	t3 = g_thread_create(httpd, (gpointer *)&th, TRUE, NULL);

	/* final */
	g_thread_join(t1);
	g_thread_join(t2);
	g_thread_join(t3);

	close(s2);
	close(s1);

	return (0);
}

void init(int s, struct config *cf)
{
	char p[40];

	strcpy(p, "PASS ");
	strcat(p, cf->password);
	strcat(p, "\r\n");
	send_msg(s, p);

	strcpy(p, "USER ");
	strcat(p, cf->username);
	strcat(p, " \"\" \"\" \"\"\r\n");
	send_msg(s, p);

	strcpy(p, "NICK ");
	strcat(p, cf->nickname);
	strcat(p, "\r\n");
	send_msg(s, p);
}

gpointer
watch(gpointer param)
{
	struct tparam *th;
	struct timeval timeout;
	fd_set *fdset;
	int s, n;
	char *sbuf;

	th = (struct tparam *)param;
	timeout.tv_sec = 0;
	timeout.tv_usec = 100000; /* 100ms */
	s = th->socket_number;
	sbuf = th->s_buff;

	fdset = (fd_set *)calloc(howmany(s+1, NFDBITS),
		sizeof(fd_mask));
	if (fdset == NULL) {
		free(fdset);
		exit (1);
	}

	do {
		FD_SET(s,fdset);

		if (th->s_count >= th->s_read) {
			th->s_empty = 1; 
			th->s_lock = 1;
		}

		/* send data */
		if (!th->t_empty) {
			for (n = 0; n <= th->ch_count; n++) {
				if (th->postdata[n][0] != '\0')
#ifdef DEBUG
				printf("send: %s\n",th->postdata[n]);
#endif
				/* SEND DATA */
				send_msg(s, th->postdata[n]);
				strcpy(th->l_buff, th->postdata[n]);
				keitai_start(th);
				memset(th->l_buff, 0, sizeof(th->l_buff));
			}
			th->t_empty = 1; /* set empty flag */
		}

		/* recieve data */
		if (th->s_empty) {
			bzero(sbuf, SBUFLEN);
			th->s_count = 0;
			th->s_read = 0;

			select(s+1,fdset, NULL, NULL, &timeout);

			if (FD_ISSET(s,fdset)) {
				th->s_read = read(s, sbuf, SBUFLEN);
				th->s_empty = 0;
				th->s_lock = 0;
			}
		}
		usleep(100000);
	} while (1);
}

gpointer
lineget(gpointer param)
{
	struct tparam *th;
	int lcount = 0;
	th = (struct tparam *)param;

	printf("keitairc ver %s\n", version);

	do {
		if (th->s_empty || th->s_lock) {
			sleep(1);
			goto loop_end;
		}

		lcount = 0;
		while (th->s_count < th->s_read) {
			if ((th->s_buff[th->s_count + 1] == 0x0a) ||
			    (th->s_buff[th->s_count] == 0x0d)) {
				th->l_buff[lcount] = '\0';
				th->s_count = th->s_count + 2;
				break;
			} else {
				th->l_buff[lcount] = th->s_buff[th->s_count];
				th->s_count++;
				lcount++;
			}
		} /* while */

		/* bit empty flag */
		if (th->s_count >= th->s_read)
			th->s_empty = 1; 
#ifdef DEBUG
		printf("(s_count %d/s_read %d/lcount %d)\n%s\n---------\n",
			th->s_count, th->s_read, lcount, th->l_buff);
		printf("s_empty=%d, s_lock=%d\n", th->s_empty, th->s_lock);
		printf("s_read=%d, s_count=%d\n", th->s_read, th->s_count);
#endif
		keitai_start(th);

		/* buffer clear */
		bzero(lbuff, SBUFLEN);
loop_end:
	;;
	} while (1);
}
