/* $Id: keitai.c,v 1.5 2004/12/05 07:31:31 ichiro Exp $ */
/*
 * Copyright (c) 2004
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/param.h>

#include "kircd.h"

int
keitai_start(struct tparam *th)
{
	char a1[40], a2[40], a3[40], a4[IRC_MAX];
	char *s;

	/* skip NOTICE/PING messages */
	if ((s = strstr(th->l_buff, "NOTICE")) ||
		(s = strstr(th->l_buff, "PING")))
			return (0);
#ifdef DEBUG
		printf("%s\r\n", th->l_buff);
#endif
	/* catch NICK name */
	if ((s = strstr(th->l_buff, "NICK"))) {
		sscanf(th->l_buff, ":%*s NICK :%[^,]", a3);
		strcpy(th->real_nickname, a3);
	}

	/* detect JOIN channel */
	if ((s = strstr(th->l_buff, "JOIN"))) {
		sscanf(th->l_buff, ":%s JOIN :%[^,]", a1, a3);
		if (a3[0] != '#') { /* for madoka4.2 */
			sscanf(th->l_buff, ":%s JOIN %[^,]", a1, a3);
#ifdef DEBUG
			printf("JOIN: madoka hack\n");
#endif
		}
		join_recv(th, a3);
	}

	if ((s = strstr(th->l_buff, "PART"))) {
		strcpy(a3, s + 5);
		sscanf(th->l_buff, ":%s PART %s :%*[^,]", a1, a3);
		if (strcmp(th->real_nickname, a1) == 0)
			part_recv(th, a3);
 	}

	/* catch PRIVMSGs */
	if ((s = strstr(th->l_buff, "PRIVMSG"))) {
		priv_recv(th);
	}

	/* catch QUIT */
	if ((s = strstr(th->l_buff, "QUIT"))) {
		printf("QUIT:%s\n", th->l_buff);
	}

	/* detect TOPIC */
	if ((s = strstr(th->l_buff, "332"))) {
		if ((sscanf(th->l_buff, ":%s 332 %*s %s :%[^\n]",
			a1, a2, a4)) == 3) {
			topic_recv(th, "332", a2, a4);
		}
	} else if ((s = strstr(th->l_buff, "TOPIC"))) {
		if ((sscanf(th->l_buff, ":%[^!]!%*s TOPIC %s :%[^\n]",
			a1, a2, a4)) == 3) {
			topic_recv(th, a1, a2, a4);
		}
	}

	/* MODE */
	if ((s = strstr(th->l_buff, "MODE"))) {
		printf("MODE:%s\n", th->l_buff);
	}

	return (0);
}

int priv_recv(struct tparam *th)
{
	time_t t = time(NULL);
	struct tm* tm;
	char id[40];
	char channel[C_NAME], channel2[C_NAME];
	char message[IRC_MAX];
	char message2[IRC_MAX + 256]; /* include &lt,&gt charactor */

	int n = 0;
	int ch_number = 255; /* 255 means "not found" */
	tm = localtime(&t);

	/* zero clear */
	memset(channel,  0, sizeof(channel));
	memset(channel2, 0, sizeof(channel2));
	memset(message,  0, sizeof(message));
	memset(message2, 0, sizeof(message2));

	/* get PRIVMSG */
	n = sscanf(th->l_buff, ":%[^!]!%*s PRIVMSG %s :%[^\n]",
			id, channel, message);
	if (n < 3) { /* for madoka4.2 */
		n = sscanf(th->l_buff, ":%s PRIVMSG %s :%[^\n]",
			id, channel, message);
	}

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

	/* message; '<','>' ---> '&lt;','&gt;' */
        ltgt_encode(message2, message);


#ifdef DEBUG 
	printf("%s | <%s> %s\n", channel2, id, message2);
#endif

	for (n = 0; n <= th->ch_count; n++) {
		if (strstr(th->name[n], channel2)) {
					/* message to channel */
			ch_number = n;
			break;
		} else if (strstr(th->name[n], id)) { 
					/* message from another person */
			ch_number = n;
			break;
		}
	}
	/* can not found out channel, maybe conversation
	   with another person ? */
	if (ch_number == 255) {
		if (strstr(th->real_nickname, channel2)) {
			printf("private session with %s\n", id);
			ch_number = join_recv(th, id);
			printf("make new channel with another person\n");
		} else {
			printf("channel not found\n");
			return (1);
		}
	} 

	/* check history count and roll up */
	if (th->history_count[ch_number] == th->max_line) {
		for (n = 0; n <= th->max_line; n++) {
			strcpy(th->data[ch_number][n],
			       th->data[ch_number][n + 1]);
			memset(th->data[ch_number][n + 1], 0,
			       sizeof(th->data[ch_number][n + 1]));
		}
		th->history_count[ch_number]--;
		if (th->read_count[ch_number] > 0)
			th->read_count[ch_number]--;
	}

	/* add message with time into historical buffer */
	if (strstr(th->real_nickname, id)) /* own messages */
		sprintf(th->
			data[ch_number][th->history_count[ch_number]],
			"%02d:%02d %s<  %s<br>",
			tm->tm_hour, tm->tm_min,id, message2);
	else
		sprintf(th->
			data[ch_number][th->history_count[ch_number]],
			"%02d:%02d %s> %s<br>",
			tm->tm_hour, tm->tm_min,id, message2);
	th->history_count[ch_number]++;

#ifdef DEBUG
	printf("%d: %s | %s\n", (th->history_count[ch_number] - 1), channel2,
		th->data[ch_number][th->history_count[ch_number] - 1]);
#endif

	return (0);
}

int topic_recv(struct tparam *th, char *user, char *channel, char *topic)
{
	int n = 0;
	char buf[IRC_MAX];
	char channel2[C_NAME];

	memset(buf, 0, sizeof(buf));
	memset(channel2, 0, sizeof(channel2));

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

#ifdef DEBUG
	printf("TOPIC:user=%s, channel=%s, topic=%s, len=%d\n",
		user, channel2, topic, len);
#endif
	/* '<','>' ---> '&lt;','&gt;' */
	ltgt_encode(buf, topic);

	for (n = 0; n <= th->ch_count; n++) {
		if (strstr(th->name[n], channel2))
			sprintf(th->topic[n], " %s", buf);
	}

	return (0);
}

int part_recv(struct tparam *th, char *channel)
{
	int i, j, match = 255;
	char channel2[C_NAME];

	memset(channel2, 0, sizeof(channel2));

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

#ifdef DEBUG
	printf("part channel=%s\n", channel2);
	printf("last ch number=%d\n", th->ch_count);
#endif

	 /* search exist channel */
	for (i = 0; i <= th->ch_count; i++) {
		if (strcmp(th->name[i], channel2) == 0) {
			match = i;
			break;
		}
	}

	if (match > th->ch_count)
		return (0);

	if (match == th->ch_count) {
		memset(th->name[match], 0, sizeof(th->name[match]));
		memset(th->topic[match], 0, sizeof(th->topic[match]));
		memset(th->data[match], 0, sizeof(th->data[match]));
		th->history_count[match] = 0;
		th->read_count[match] = 0;
	} else {
	    for (i = match; i < th->ch_count; i++) {
		memset(th->name[i], 0, sizeof(th->name[i]));
		memset(th->topic[i], 0, sizeof(th->topic[i]));
		memset(th->data[i], 0, sizeof(th->data[i]));

		strcpy(th->name[i], th->name[i + 1]);
		strcpy(th->topic[i], th->topic[i + 1]);

		for (j = 0; j < th->history_count[i + 1]; j++) {
			strcpy(th->data[i][j], th->data[i + 1][j]);
		}
		th->history_count[i] = th->history_count[i + 1];
		th->read_count[i] = th->read_count[i + 1];
	    }
	    memset(th->name[th->ch_count], 0,
		   sizeof(th->name[th->ch_count]));
	    memset(th->topic[th->ch_count], 0,
		   sizeof(th->topic[th->ch_count]));
	    memset(th->data[th->ch_count], 0,
		   sizeof(th->data[match]));
	    th->history_count[th->ch_count] = 0;
	    th->read_count[th->ch_count] = 0;
	}
	th->ch_count--;

	return (0);
}

int join_recv(struct tparam *th, char *channel)
{
	int i, n = 0;
	char channel2[C_NAME];

	memset(channel2, 0, sizeof(channel2));

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

	/* search exist channel */
	for (i = 0; i <= th->ch_count; i++) {
		if (strcmp(th->name[i], channel2) == 0)
			return (0);
	}

	/* make new channel */
	while (th->name[n][0] != '\0')
		n++;
	if (n > th->ch_count)
		th->ch_count = n; /* largest channel number */

	strcpy(th->name[n], channel2);

#ifdef DEBUG
	printf("%s\r\n", th->l_buff);
	printf("join channel name(%d) = %s\n", n, th->name[n]);
#endif

	return (n);
}
