"""KittyWalk bookmark editor

This script was contributed by
http://pc2.2ch.net/test/read.cgi/tech/1036892546/868
"""


from Tkinter import * 
import fileinput, os 
import tkMessageBox 
 
BOOKPATH = '~/.kittywalk/bookmark' 


class App(Frame): 
 
    def __init__(self, master=None): 
        Frame.__init__(self, master) 
        self.pack() 
        self.master.title('KittyWalk Bookmark Editor') 
        self.createWidget() 
 
    def createWidget(self): 
        mfm = Frame(self) 
        mfm.pack() 
         
        scrollbar = Scrollbar(mfm, orient=VERTICAL) 
        self.listbox = Listbox(mfm, width=50, yscrollcommand=scrollbar.set) 
        scrollbar.config(command=self.listbox.yview) 
        scrollbar.pack(side=RIGHT, fill=Y) 
 

        self.infile = os.path.expanduser(BOOKPATH) 
        for item in fileinput.input(self.infile): 
            self.listbox.insert(END, item) 
        self.listbox.pack() 
 
        fm = Frame(self) 
        fm.pack(pady=3) 
         
        btnUp = Button(fm, text='Up', command=self.up) 
        btnUp.pack(side=LEFT) 
        btnDown = Button(fm, text='Down', command=self.down) 
        btnDown.pack(side=LEFT) 
 
        btnDel = Button(fm, text='Delete', command=self.delete) 
        btnDel.pack(side=LEFT, padx=10) 
 
        btnSave = Button(fm, text='Save', command=self.save) 
        btnSave.pack(side=LEFT) 
 
        btnQuit = Button(self, text='Quit', command=self.quit) 
        btnQuit.pack(side=RIGHT, padx=3, pady=3) 
 
    def delete(self): 
        if self.listbox.curselection(): 
            self.listbox.delete(self.getitemno()) 

    def up(self): 
        if self.listbox.curselection(): 
            itemno = self.getitemno() 
            if itemno == 0: 
                return 
            item = self.listbox.get(itemno) 
            self.listbox.delete(itemno) 
            self.listbox.insert(itemno-1, item) 
            self.listbox.select_set(itemno-1) 
            self.listbox.see(itemno-1) 
 
    def down(self): 
        if self.listbox.curselection(): 
            itemno = self.getitemno() 
            size = self.listbox.size() 
            if itemno == size-1: 
                return 
            item = self.listbox.get(itemno) 
            self.listbox.delete(itemno) 
            self.listbox.insert(itemno+1, item) 
            self.listbox.select_set(itemno+1) 
            self.listbox.see(itemno+1) 
 
    def save(self): 
        os.rename(self.infile, self.infile+'.bak') 
        f = file(self.infile, 'w') 
        for x in range(self.listbox.size()): 
            str = self.listbox.get(x) 
            f.write(str.encode('utf-8')) 
        f.close() 
        tkMessageBox.showinfo(message='The bookmark was saved.') 
 

    def getitemno(self): 
        return int(self.listbox.curselection()[0]) 
     
 
if __name__ == '__main__': 
    if os.path.isfile(os.path.expanduser(BOOKPATH)): 
        app = App() 
        app.mainloop() 
    else: 
        print 'bookmark not found at', BOOKPATH
 
# eof 