#include <linux/config.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/notifier.h>
#include <linux/kmemprof.h>

MODULE_LICENSE("GPL");

static int kmemprof_plug (struct notifier_block * self, unsigned long val,
			void * arg)
{
	return NOTIFY_STOP_MASK | NOTIFY_OK;
}

static struct notifier_block plug_nb = {
	.notifier_call = &kmemprof_plug,
	.priority = 100
};

static int __init mymodule_init(void)
{
	kmemprof_notifier_chain_register(&plug_nb);

	return 0;
}

static void __exit mymodule_exit(void)
{
	kmemprof_notifier_chain_unregister(&plug_nb);
}

module_init(mymodule_init);
module_exit(mymodule_exit);

