/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"
knh_connptr_t * knh_Connection_open__mysql(Ctx *ctx, knh_bytes_t url, char *uname, char *upwd);
knh_ResultSet* knh_Connection_query__mysql(Ctx *ctx, knh_connptr_t *conn, char *sql);
void knh_Connection_close__mysql(Ctx *ctx, knh_connptr_t *conn);

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

	
/* ======================================================================== */

static knh_connptr_t * knh_Connection_open__nop(Ctx *ctx, knh_bytes_t url, char *uname, char *upwd);
static ResultSet* knh_Connection_query__nop(Ctx *ctx, knh_connptr_t *ptr, char *sql);
static void knh_Connection_close__nop(Ctx *ctx, knh_connptr_t *ptr);

/* ======================================================================== */
/* [structs] */

void knh_Connection_struct_init(Ctx *ctx, knh_Connection *b, int init, Object *cs)
{
	b->conn = NULL;
	KNH_INITv(b->urn, TS_EMPTY);
	b->api.fopen  = knh_Connection_open__nop;
	b->api.fquery = knh_Connection_query__nop;
	b->api.fclose = knh_Connection_close__nop;
}

/* ------------------------------------------------------------------------ */

#define _knh_Connection_struct_copy    NULL

/* ------------------------------------------------------------------------ */

#define _knh_Connection_struct_compare  NULL

/* ------------------------------------------------------------------------ */

void knh_Connection_struct_traverse(Ctx *ctx, knh_Connection *b, f_traverse gc)
{
	gc(ctx, b->urn);
	if(IS_SWEEP(gc) && b->conn != NULL) {
		b->api.fclose(ctx, b->conn);
		b->conn = NULL;
	}
}

/* ======================================================================== */
/* [constructors] */

void knh_Connection_init(Ctx *ctx, Connection *o, knh_bytes_t urn)
{
	knh_index_t idx = knh_bytes_index(urn, ':');
	if(idx == -1) {
		idx = urn.len;
	}
	
	knh_bytes_t dname = knh_bytes_first(urn, idx);
	if(ISB(dname, "ubiql")) {
		DP(o)->api.fopen = knh_Connection_open__ubiql;
		DP(o)->api.fquery = knh_Connection_query__ubiql;
		DP(o)->api.fclose = knh_Connection_close__ubiql;
	}
	else if(ISB(dname, "test")) {
		DP(o)->api.fopen = knh_Connection_open__test;
		DP(o)->api.fquery = knh_Connection_query__test;
		DP(o)->api.fclose = knh_Connection_close__test;
	}
	else {
		DP(o)->api.fopen = (f_connptr_open)knh_system_loadDriverFunc(ctx, dname,   "knh_Connection_open", knh_Connection_open__nop);
		DP(o)->api.fquery = (f_connptr_query)knh_system_loadDriverFunc(ctx, dname, "knh_Connection_query", knh_Connection_query__nop);
		DP(o)->api.fclose = (f_connptr_close)knh_system_loadDriverFunc(ctx, dname, "knh_Connection_close", knh_Connection_close__nop);
	}
	
	DP(o)->conn = DP(o)->api.fopen(ctx, urn, NULL, NULL);
	if(DP(o)->conn == NULL) {
		DP(o)->api.fquery = knh_Connection_query__nop;
		DP(o)->api.fclose = knh_Connection_close__nop;
	}
}

/* ------------------------------------------------------------------------ */

Connection* new_Connection(Ctx *ctx, String *urn)
{
	knh_Connection_t *o = (Connection*)new_Object__RAW(ctx, FLAG_Connection, CLASS_Connection, sizeof(knh_Connection));
	knh_Connection_struct_init(ctx, DP(o), 0, NULL);
	KNH_SETv(ctx, DP(o)->urn, urn);
	knh_Connection_init(ctx, o, knh_String_tobytes(urn));
	return o;
}

/* ======================================================================== */
/* [nop] */

/* ------------------------------------------------------------------------ */
/* @method void Connection.close() */

void knh_Connection_close(Ctx *ctx, Connection *o)
{
	DP(o)->api.fclose(ctx, DP(o)->conn);
	DP(o)->api.fquery = knh_Connection_query__nop;
	DP(o)->api.fclose = knh_Connection_close__nop;
	DP(o)->conn = NULL;
}

/* ======================================================================== */
/* [nop] */

static
knh_connptr_t *knh_Connection_open__nop(Ctx *ctx, knh_bytes_t url, char *uname, char *upwd)
{
	return NULL;
}

/* ------------------------------------------------------------------------ */

static
ResultSet* knh_Connection_query__nop(Ctx *ctx, knh_connptr_t *ptr, char *sql)
{
	return (ResultSet*)KNH_NULL;
}	

/* ------------------------------------------------------------------------ */

static
void knh_Connection_close__nop(Ctx *ctx, knh_connptr_t *ptr)
{

}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
