/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method Any Context.getProperty(String! key) */

Object* knh_Context_getProperty(Ctx *ctx, Context *b, knh_bytes_t key)
{
	Object *v = knh_DictMap_get__b(ctx, b->props, key);	
	if(IS_NULL(v)) {
		return knh_System_getProperty(ctx, knh_rootSystem, key);
	}
	return v;
}

/* ------------------------------------------------------------------------ */
/* @method void Context.setProperty(String! key, Any value) */

void knh_Context_setProperty(Ctx *ctx, Context *b, String *key, Any *value)
{
	knh_DictMap_set(ctx, b->props, key, value);	
}

/* ------------------------------------------------------------------------ */
/* @method void Context.setEncoding(String enc) */

void knh_Context_setEncoding(Ctx *ctx, knh_Context_t *o, String *enc)
{
	if(IS_NULL(enc)) {
		enc = knh_constEncoding;
	}
	KNH_SETv(ctx, o->enc, enc);
	if(knh_bytes_strcasecmp(knh_String_tobytes(enc), STEXT(KONOHA_ENCODING))==0) {
		KNH_SETv(ctx, DP(o->in)->bconv, KNH_NULL);
		KNH_SETv(ctx, DP(o->out)->bconv, KNH_NULL);
		KNH_SETv(ctx, DP(o->err)->bconv, KNH_NULL);
	}
	else {
		BytesConv *bin = new_BytesConv__in(ctx, knh_String_tochar(enc));
		BytesConv *bout = new_BytesConv__out(ctx, knh_String_tochar(enc));
		if(IS_NULL(bin) || IS_NULL(bout)) {
			KNH_WARNING(ctx, "unsupported character encoding: %s", knh_String_tochar(enc));
		}
		KNH_SETv(ctx, DP(o->in)->bconv, bin);
		KNH_SETv(ctx, DP(o->out)->bconv, bout);
		KNH_SETv(ctx, DP(o->err)->bconv, bout);
	}
}

///* ------------------------------------------------------------------------ */
//
//void knhctx_setEncoding(Ctx *ctx, String *enc)
//{
//	TODO();
//}
//
///* ------------------------------------------------------------------------ */
//
//String* knhctx_getEncoding(Ctx *ctx)
//{
//	TODO();
//}
//
///* ------------------------------------------------------------------------ */
///* @method String! Context.getLanguage() */
//
//void knh_Context_setLanguage(Ctx *ctx, Context *o)
//{
//	TODO();
//}
//
///* ------------------------------------------------------------------------ */
///* @ method void Context.setLanguage(String! lang) */
//
//void knh_Context_setLanguage(Ctx *ctx, Context *o, String *lang)
//{
//	TODO();
//}
//
///* ------------------------------------------------------------------------ */
///* @ method String! Context.getLanguage() */
//
//String *knh_Context_getLanguage(Ctx *ctx, Context *o)
//{
//	TODO();
//}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [movabletext] */

/* @method void Context.%dump(OutputStream w, Any m) */

void knh_Context__dump(Ctx *ctx, Context *b, OutputStream *w, Any *m)
{
//	knh_int_t i = 0;
//	for(i = b->ebp - b->stack; i >= 0; i--) {
//		knh_printf(ctx, w, "[%d]\t%o\n", i, b->stack[i]);
//	}	
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
