/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

INLINE
static Int *new_Int__NNctx(Ctx *ctx, knh_int_t value)
{
	if(KNH_TINT_MIN <= value && value <= KNH_TINT_MAX) {
		return knh_tInt[value - KNH_TINT_MIN];
	}
	else {
		knh_Int_t* n = (knh_Int_t*)new_PObject__NNctx(ctx, FLAG_Int, CLASS_Int, CLASS_Int);
		n->value = value;
		return n;
	}
}

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.opAdd:2(Int! v) */

METHOD knh__Int_opAdd__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value + (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.opNeg() */

METHOD knh__Int_opNg(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, -((sfp[0].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.opSub:2(Int! n) */

METHOD knh__Int_opSub__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value - (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.opMul:2(Int! n) */

METHOD knh__Int_opMul__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value * (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.opDiv:2(Int! n) */

METHOD knh__Int_opDiv__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value / (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC] Int! Int.opAdd(Int! v) */

METHOD knh__Int_opAdd(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_vargc_t ac = knh_sfp_argc(ctx, sfp);
	knh_int_t i, n = (sfp[0].i)->value;
	for(i = 1; i < ac; i++) {
		n += (sfp[i].i)->value;
	}
	METHOD_RETURN(ctx, sfp, new_Int__NNctx(ctx, n));
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC] Int! Int.opSub(Int! n) */

METHOD knh__Int_opSub(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_vargc_t ac = knh_sfp_argc(ctx, sfp);
	knh_int_t i, n = (sfp[0].i)->value;
	for(i = 1; i < ac; i++) {
		n -= (sfp[i].i)->value;
	}
	METHOD_RETURN(ctx, sfp, new_Int__NNctx(ctx, n));
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC] Int! Int.opMul(Int! n) */

METHOD knh__Int_opMul(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_vargc_t ac = knh_sfp_argc(ctx, sfp);
	knh_int_t i, n = (sfp[0].i)->value;
	for(i = 1; i < ac; i++) {
		n *= (sfp[i].i)->value;
	}
	METHOD_RETURN(ctx, sfp, new_Int__NNctx(ctx, n));
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC] Int! Int.opDiv(Int! n) */

METHOD knh__Int_opDiv(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_vargc_t ac = knh_sfp_argc(ctx, sfp);
	knh_int_t i, n = (sfp[0].i)->value;
	for(i = 1; i < ac; i++) {
		n /= (sfp[i].i)->value;
	}
	METHOD_RETURN(ctx, sfp, new_Int__NNctx(ctx, n));
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.opMod(Int! n) */

METHOD knh__Int_opMod(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value % (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Int.opEq(Int! value) */

METHOD knh__Int_opEq(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value == (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Int.opNeq(Int! value) */

METHOD knh__Int_opNeq(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value != (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Int.opLt(Int! value) */

METHOD knh__Int_opLt(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value < (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Int.opLte(Int! value) */

METHOD knh__Int_opLte(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value <= (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Int.opGt(Int! value) */

METHOD knh__Int_opGt(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value > (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Int.opGte(Int! value) */

METHOD knh__Int_opGte(Ctx *ctx, knh_sfp_t *sfp)
{
	if((sfp[0].i)->value >= (sfp[1].i)->value) {
		METHOD_RETURN(ctx, sfp, KNH_TRUE);
	}
	else {
		METHOD_RETURN(ctx, sfp, KNH_FALSE);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.opLogicalAnd(Int! v) */

METHOD knh__Int_opLogicalAnd(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value & (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */

/* @method[STATIC] Int! Int.opLogicalOr(Int! v) */

METHOD knh__Int_opLogicalOr(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value | (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.opLogicalXor(Int! n) */

METHOD knh__Int_opLogicalXor(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value ^ (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.opLogicalNot() */

METHOD knh__Int_opLogicalNot(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ~((sfp[0].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */

/* @method[STATIC] Int! Int.opLShift(Int! n) */

METHOD knh__Int_opLShift(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value << (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */

/* @method[STATIC] Int! Int.opRShift(Int! n) */

METHOD knh__Int_opRShift(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value >> (sfp[1].i)->value));
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.opNext() */

METHOD knh__Int_opNext(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value)+1);
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */

/* @method[STATIC] Int! Int.opPrev() */

METHOD knh__Int_opPrev(Ctx *ctx, knh_sfp_t *sfp)
{
	Int *n = new_Int__NNctx(ctx, ((sfp[0].i)->value)-1);
	METHOD_RETURN(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* @method[NULLBASE|STATIC] Int! Int.abs() */

METHOD knh__Int_abs(Ctx *ctx, knh_sfp_t *sfp)
{
	if(IS_NULL(sfp[0].o)) {
		METHOD_RETURN(ctx, sfp, knh_tInt[0-KNH_TINT_MIN]);
	}
	else {
		knh_int_t n = (sfp[0].i)->value;
		if(n >= 0) {
			METHOD_RETURN(ctx, sfp, knh_tInt[0-KNH_TINT_MIN]);
		}
		else {
			METHOD_RETURN(ctx, sfp, new_Int__NNctx(ctx, -n));
		}
	}
}

/* ------------------------------------------------------------------------ */
/* @method Int! Int.random(Int n) */

METHOD knh__Int_random(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_int_t n = knh_rand();
	if(IS_NOTNULL(sfp[1].o)) {
		knh_int_t max = knh_abs((sfp[1].i)->value);
		if(max > 0) {
			METHOD_RETURN(ctx, sfp, new_Int__NNctx(ctx, n % max));
		}
	}
	METHOD_RETURN(ctx, sfp, new_Int__NNctx(ctx, n % KNH_UINT_MAX));
}

/* ======================================================================== */
/* [mapping] */

/* ------------------------------------------------------------------------ */
/* @map String Int @Static @Final */

Int* knh_String_Int(Ctx *ctx, String *o, Mapper *mpr)
{
	return new_IntX__b(ctx, CLASS_Int, knh_String_tobytes(o));
}

/* ------------------------------------------------------------------------ */
/* @map Int String! @Static @Final */

String* knh_Int_String(Ctx *ctx, Int *o, Mapper *mpr)
{
	char buf[KNH_INTUNIT_BUFSIZ];
	knh_format_Int(buf, sizeof(buf), o);
	return new_String(ctx, B(buf), NULL);
}

/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void Int.%s(OutputStream w, Any m) */

void knh_Int__s(Ctx *ctx, Int *b, OutputStream *w, Any *m)
{
	knh_write__i(ctx, w, b->value);
}

/* ------------------------------------------------------------------------ */
/* @method void Int.%x(OutputStream w, Any m) */

void knh_Int__x(Ctx *ctx, Int *b, OutputStream *w, Any *m)
{
	knh_write__x(ctx, w, b->value);
}

/* ------------------------------------------------------------------------ */
/* @method void Int.%bits(OutputStream w=new, Any m) */

void knh_Int__bits(Ctx *ctx, Int *b, OutputStream *w, Any *m)
{
	knh_uint_t i, flag = 1 << ((sizeof(knh_int_t) * 8)- 1);
	for(i = 0; i < (sizeof(knh_int_t) * 8); i++) {
		if(i > 0 && i % 8 == 0) {
			knh_putc(ctx, w, ' ');
		}
		if((flag & b->value) == flag) {
			knh_putc(ctx, w, '1');
		}else{
			knh_putc(ctx, w, '0');
		}
		flag >>= 1;
	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
