/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
/* [globals] */
//
//GLOBAL MapMap *tglobalMapMapNULL = NULL;
//
///* ------------------------------------------------------------------------ */
//
//MapMap* knh_MapMap_NULL()
//{
//	if(tglobalMapMapNULL == NULL) {
//		tglobalMapMapNULL = new_MapMap(NULL, 0, CLASS_Object, CLASS_Object, knh_MapMap_fmap__Null, KNH_NULL);
//		KNH_TSTATICOBJ(tglobalMapMapNULL);
//	}
//	return tglobalMapMapNULL;
//}

/* ======================================================================== */
/* [structs] */

void
knh_Mapper_struct_init(Ctx *ctx, knh_Mapper *b, int init, Object *cs)
{
	b->size = 0;
	b->flag = 0;
	b->scid = CLASS_Object;
	b->tcid = CLASS_Object;
	b->fmap = NULL;
	KNH_INITv(b->mapdata, KNH_NULL);
}

/* ------------------------------------------------------------------------ */

void
knh_Mapper_struct_copy(Ctx *ctx, knh_Mapper *b, knh_Mapper *b2)
{
	b2->fmap = b->fmap;
	KNH_INITv(b2->mapdata, b->mapdata);
}

/* ------------------------------------------------------------------------ */

void
knh_Mapper_struct_traverse(Ctx *ctx, knh_Mapper *b, f_traverse gc)
{
	gc(ctx, b->mapdata);
}

/* ======================================================================== */
/* [constructors] */

Mapper* new_Mapper(Ctx *ctx, knh_flag_t flag, knh_class_t scid, knh_class_t tcid, f_mapper fmap, Object *mapdata)
{
	knh_Mapper_t* o = 
		(Mapper*)new_Object__RAW(ctx, FLAG_Mapper, CLASS_Mapper, sizeof(knh_Mapper));
	knh_Mapper_struct_init(ctx, DP(o), 0, NULL);
	DP(o)->size = 0;
	DP(o)->flag = flag;
	DP(o)->scid = scid;
	DP(o)->tcid = tcid;
	if(fmap == NULL) {
		DP(o)->fmap = knh_tmapper_findfunc(ctx, mapdata, scid, tcid);
		KNH_ASSERT(fmap != NULL);
	}else {
		DP(o)->fmap = fmap;
	}
	KNH_SETv(ctx, DP(o)->mapdata, mapdata);
	o->fmap_1 = DP(o)->fmap;
	return o;
}


/* ======================================================================== */
/* [methods] */

INLINE
Object *knh_Mapper_execMap(Ctx *ctx, Mapper *o, Object *sub)
{
	KNH_ASSERT(IS_Mapper(o));
	return o->fmap_1(ctx, sub, o);
}

/* ======================================================================== */
/* [movabletext] */
/* @method void Mapper.%repr(OutputStream w, Any m) */

void knh_Mapper__repr(Ctx *ctx, Mapper *o, OutputStream *w, Any *m)
{
	knh_write__type(ctx, w, DP(o)->scid);
	if(knh_Mapper_isTotal(o)) {
		knh_write(ctx, w, STEXT("==>"));
	}else{
		knh_write(ctx, w, STEXT("-->"));
	}
	knh_write__type(ctx, w, DP(o)->tcid);
	knh_putc(ctx, w, ':');
	knh_write__i(ctx, w, DP(o)->flag);
}

/* ------------------------------------------------------------------------ */


#ifdef __cplusplus
}
#endif
