/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif


/* ------------------------------------------------------------------------ */

INLINE
Float* new_Float(Ctx *ctx, knh_float_t value)
{
	Float *b = (Float*)new_PObject__NNctx(ctx, FLAG_Float, CLASS_Float, CLASS_Float);
	b->value = value;
	return b;
}
	
/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Float! Number.opAdd:2(Number! v) */

METHOD knh__Number_opAdd__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Float *v = new_Float(ctx, knh_Number_tofloat(sfp[0].o) + knh_Number_tofloat(sfp[1].o));
	METHOD_RETURN(ctx, sfp, v);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Float! Number.opSub:2(Number! v) */

METHOD knh__Number_opSub__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Float *v = new_Float(ctx, knh_Number_tofloat(sfp[0].o) - knh_Number_tofloat(sfp[1].o));
	METHOD_RETURN(ctx, sfp, v);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Float! Number.opMul:2(Number! v) */

METHOD knh__Number_opMul__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Float *v = new_Float(ctx, knh_Number_tofloat(sfp[0].o) * knh_Number_tofloat(sfp[1].o));
	METHOD_RETURN(ctx, sfp, v);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Float! Number.opDiv:2(Number! v) */

METHOD knh__Number_opDiv__2(Ctx *ctx, knh_sfp_t *sfp)
{
	Float *v = new_Float(ctx, knh_Number_tofloat(sfp[0].o) / knh_Number_tofloat(sfp[1].o));
	METHOD_RETURN(ctx, sfp, v);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC] Float! Number.opAdd(Number! v) */

METHOD knh__Number_opAdd(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_vargc_t ac = knh_sfp_argc(ctx, sfp + 1);
	knh_int_t i;
	knh_float_t n = knh_Number_tofloat(sfp[0].o);
	for(i =0; i < ac; i++) {
		n += knh_Number_tofloat(sfp[i].o);
	}
	METHOD_RETURN(ctx, sfp, new_Float(ctx, n));
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC] Float! Number.opSub(Number! v) */

METHOD knh__Number_opSub(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_vargc_t ac = knh_sfp_argc(ctx, sfp + 1);
	knh_int_t i;
	knh_float_t n = knh_Number_tofloat(sfp[0].o);
	for(i =0; i < ac; i++) {
		n -= knh_Number_tofloat(sfp[i].o);
	}
	METHOD_RETURN(ctx, sfp, new_Float(ctx, n));
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC] Float! Number.opMul(Number! v) */

METHOD knh__Number_opMul(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_vargc_t ac = knh_sfp_argc(ctx, sfp + 1);
	knh_int_t i;
	knh_float_t n = knh_Number_tofloat(sfp[0].o);
	for(i =0; i < ac; i++) {
		n -= knh_Number_tofloat(sfp[i].o);
	}
	METHOD_RETURN(ctx, sfp, new_Float(ctx, n));
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|STATIC] Float! Number.opDiv(Number! v) */

METHOD knh__Number_opDiv(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_vargc_t ac = knh_sfp_argc(ctx, sfp + 1);
	knh_int_t i;
	knh_float_t n = knh_Number_tofloat(sfp[0].o);
	for(i =0; i < ac; i++) {
		n -= knh_Number_tofloat(sfp[i].o);
	}
	METHOD_RETURN(ctx, sfp, new_Float(ctx, n));
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Number.opEq(Number! v) */

METHOD knh__Number_opEq(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Number_tofloat(sfp[0].o) == knh_Number_tofloat(sfp[1].o));
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Number.opNeq(Number! v) */

METHOD knh__Number_opNeq(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Number_tofloat(sfp[0].o) != knh_Number_tofloat(sfp[1].o));
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Number.opLt(Number! v) */

METHOD knh__Number_opLt(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Number_tofloat(sfp[0].o) < knh_Number_tofloat(sfp[1].o));
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Number.opLte(Number! v) */

METHOD knh__Number_opLte(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Number_tofloat(sfp[0].o) <= knh_Number_tofloat(sfp[1].o));
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Number.opGt(Number! v) */

METHOD knh__Number_opGt(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Number_tofloat(sfp[0].o) > knh_Number_tofloat(sfp[1].o));
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Boolean! Number.opGte(Number! v) */

METHOD knh__Number_opGte(Ctx *ctx, knh_sfp_t *sfp)
{
	METHOD_RETURN_BOOLEAN(ctx, sfp, knh_Number_tofloat(sfp[0].o) >= knh_Number_tofloat(sfp[1].o));
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
