/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

#define KONOHA_ENCODING__UTF8

/* ------------------------------------------------------------------------ */

knh_bool_t knh_bytes_checkENCODING(knh_bytes_t s)
{
#ifdef KONOHA_ENCODING__UTF8
	TODO();
#endif
	return 1; /* if KONOHA_ENCODING is not set */
}

/* ------------------------------------------------------------------------ */

size_t knh_bytes_mlen(knh_bytes_t s) {
#ifdef KONOHA_ENCODING__UTF8
	size_t i, len = 0, ulen = 0;
	for (i = 0; i < s.len; i++) {
		if ((s.buf[i] & 0xC0) != 0x80)
			ulen++;
		else if ((s.buf[i] & 0x80) == 0)
			len++;
	}
	return ulen + len;
#endif
	TODO();
	return s.len; /* if KONOHA_ENCODING is not set */
}

/* ======================================================================== */

knh_bytes_t knh_bytes_mofflen(knh_bytes_t m, size_t moff, size_t mlen)
{
#ifdef KONOHA_ENCODING__UTF8
	size_t i, s = m.len, len = 0, ulen = 0;
	size_t bytes = 0;
	for (i = 0; i < m.len; i++) {
		if ((m.buf[i] & 0xC0) != 0x80) ulen++;
		else if ((m.buf[i] & 0x80) == 0) len++;
		
		if (ulen + len == moff+1) {
			s = i;
			break;
		}
	}
	if (!(s < m.len)) {
		m.buf = (knh_uchar_t*)"";
		m.len = 0;
		return m;
	}
	if ((m.buf[i] & 0xF0) == 0xE0) {
		bytes = 3;
	}else if ((m.buf[i] & 128) == 0) {
		bytes = 1;
	} else {
		switch (m.buf[i] & 0xF0){
		case 0xC0:
			bytes = 2;
			break;
		case 0xF0:
			bytes = 4;
			break;
		default:
			switch (m.buf[i] & 0xF) {
				case 0x8:
					bytes = 5;
					break;
				case 0xC:
					bytes = 6;
					break;
				default:
					bytes = -1;
			}
		}
	}
	m.buf = m.buf + s;
	m.len = bytes;
	return m;
#endif
	TODO();
	return knh_bytes_offlen(m, moff, mlen); /* if KONOHA_ENCODING is not set */
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
