/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Tuple2! Tuple2.new(Any1 first, Any2 second) */

METHOD knh__Tuple_new(Ctx *ctx, knh_sfp_t *sfp)
{
	Tuple2 *t = (Tuple2*)sfp[0].o;
	KNH_SETv(ctx, t->first, sfp[1].o);
	KNH_SETv(ctx, t->second, sfp[2].o);
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */
/* ======================================================================== */
/* [methods] */

/* ------------------------------------------------------------------------ */
/* @method Int! Tuple2.getSize() */

METHOD knh__Tuple2_getSize(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(KNH_TINT_MIN < 2 && 2 < KNH_TINT_MAX);
	METHOD_RETURN(ctx, sfp, knh_tInt[2 - KNH_TINT_MIN]);
}

/* ------------------------------------------------------------------------ */
/* @method Any Tuple2.get:fast(Int! index) */

Object *knh_Tuple2_get__fast(Tuple2 *b, knh_int_t index)
{
	return KNH_FIELDn(b, index);
}

///* ------------------------------------------------------------------------ */
///* @method Any Tuple2.get(Int! index) */
//
//Object *knh_Tuple2_get(Tuple2 *b, knh_int_t index)
//{
//	return KNH_FIELDn(b, knh_array_index(index, 2));
//}

/* ======================================================================== */
/* [mappings] */



/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void Tuple2.%dump(OutputStream w, Any m) */

void knh_Tuple2__dump(Ctx *ctx, Tuple2 *b, OutputStream *w, Any *m)
{
//	knh_fputc(ctx, w, '(');
//	size_t c;
//	for(c = 0; c < knh_Tuple2_size(b); c++) {
//		if(c > 0) {
//			knh_print_delim(ctx, w);
//		}
//		knh_Object__dump(ctx, KNH_FIELDn(b, c), w, lv+1);
//		c++;
//	}
//	knh_fputc(ctx, w, ')');
}


/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
/* [mapping] */

/* ------------------------------------------------------------------------ */
///* @map Array Tuple2! */

//Object* knh_Array_Tuple2(Ctx *ctx, Object *self, Mapper *map)
//{
//	Array *b = (Array*)self;
//	knh_class_t cid = knh_int_min(knh_Array_size(b), CLASS_Prototype - 1);
//	if(cid == 0) return KNH_NULL;
//	Tuple2 *t = (Tuple2*)knh_Object_malloc(ctx, cid);
//	size_t i;
//	for(i = 0; i < cid; i++) {
//		KNH_INITv(t->v[i], knh_Array_n(b,i));
//	}
//	return t;
//}

///* ======================================================================== */
///* [iterators] */
//
//Object*
//knh_Tuple2_next(Ctx *ctx, Iterator *it)
//{
//	Tuple2 *b = (Tuple2*)knh_Iterator_source(it);
//	size_t pos ;
//	for(pos = knh_Iterator_pos(it); pos < knh_Tuple2_size(b); pos++) {
//		if(IS_NOTNULL(KNH_FIELDn(b, pos))) {
//			knh_Iterator_setpos(it,pos+1);
//			return KNH_FIELDn(b, pos);
//		}
//	}		
//	knh_Iterator_setpos(it,pos+1);
//	return KNH_NULL;
//}
//
///* ------------------------------------------------------------------------ */
//
///* @Map Tuple2 Iterator! */
//
//
//Object* knh_Tuple2_Iterator(Ctx *ctx, Object *self, Mapper *map)
//{
//	return new_Iterator(ctx, CLASS_Any, self, knh_Tuple2_next);	
//}


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
