/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

	
/* ------------------------------------------------------------------------ */
/* [Term] */

/* ------------------------------------------------------------------------ */

knh_type_t knh_Term_type(Term *tm)
{
	if(IS_Token(tm)) {
		return DP((Token*)tm)->type;
	}
	else {
		KNH_ASSERT(IS_Stmt(tm));
		return DP((Stmt*)tm)->type;
	}
}

/* ------------------------------------------------------------------------ */

Token *knh_Term_firstToken(Term *tm)
{
	if(IS_Token(tm)) {
		return (Token*)tm;
	}
	else {
		Stmt *stmt = (Stmt*)tm;
		KNH_ASSERT(IS_Stmt(stmt));
		KNH_ASSERT(DP(stmt)->size > 0);
		return knh_Term_firstToken(DP(stmt)->terms[0]);
	}
}

/* ------------------------------------------------------------------------ */

int knh_Term_isASIS(Term *tm)
{
	if(IS_Token(tm)) {
		return (DP((Token*)tm)->tt == TT_ASIS);
	}
	return 0;
}

/* ------------------------------------------------------------------------ */

int knh_Term_isCONST(Term *tm)
{
	if(IS_Token(tm)) {
		return (DP((Token*)tm)->tt == TT_CONST);
	}
	return 0;
}

/* ------------------------------------------------------------------------ */

Object *knh_Term_constValue(Ctx *ctx, Term *tm, knh_class_t reqc)
{
	Token *tk = (Token*)tm;
	if(IS_Token(tm) && DP(tk)->tt == TT_CONST) {
		if(reqc == CLASS_Any) {
			return DP(tk)->data;
		}
		else {
			Object *v = knh_Object_opAs(ctx, DP(tk)->data, reqc);
			if(IS_NULL(v) && IS_NOTNULL(DP(tk)->data)) {
				DEBUG3("Imcomatible const value %s := %s", CLASSN(reqc), CLASSN(knh_Object_cid(DP(tk)->data)));
			}
			knh_Token_setCONST(ctx, tk, v);
			return v;
		}
	}
	return KNH_NULL;
}

/* ------------------------------------------------------------------------ */

Object *knh_Term_constValueNULL(Ctx *ctx, Term *tm, knh_class_t reqc)
{
	Token *tk = (Token*)tm;
	if(IS_Token(tm) && DP(tk)->tt == TT_CONST) {
		Object *v = knh_Object_opAs(ctx, DP(tk)->data, reqc);
		if(IS_NULL(v) && IS_NOTNULL(DP(tk)->data)) {
			DEBUG3("Imcomatible const value %s := %s", CLASSN(reqc), CLASSN(knh_Object_cid(DP(tk)->data)));
		}
		knh_Token_setCONST(ctx, tk, v);
		return v;
	}
	return NULL;
}

/* ------------------------------------------------------------------------ */
/* [ERR] */

int knh_Term_isERR(Term *tm)
{
	if(IS_Token(tm)) {
		return (DP((Token*)tm)->tt == TT_ERR);
	}
	else {
		return (DP((Stmt*)tm)->stt == STT_ERR);
	}
}

/* ------------------------------------------------------------------------ */

void knh_Token_setERR(Ctx *ctx, Token *tk, String *msg)
{
	DEBUG3("switching .. %s to TT_ERR", knh_token_tochar(DP(tk)->tt));
	DP(tk)->tt = TT_ERR;
	KNH_SETv(ctx, DP(tk)->data, msg);
	knh_Token_setTyped(tk, 1);
	DP(tk)->type = CLASS_Any;
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
