/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHA_MESSAGE__H
#define KONOHA_MESSAGE__H

#include<konoha/konoha_t.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
#define KONOHA_LANG                     "en"
#define KONOHA_LANG__en                 0
#define KONOHA_LANG__ja                 1
#define KONOHA_LANG__debug              2
#define KONOHA_LANG_MAXSIZ              3

/* ------------------------------------------------------------------------ */
#define KMSG_NAME                       0
#define KMSG_ERRATA                     1
#define KMSG_ETIME                      2
#define KMSG_TYPEINF                    3
#define KMSG_ESYNTAX                    4
#define KMSG_EFORGET_PARENTHESIS        5
#define KMSG_EMISMATCH                  6
#define KMSG_WUNCLOSED                  7
#define KMSG_WASCII                     8
#define KMSG_WEOF                       9
#define KMSG_WSEMICOLON                 10
#define KMSG_IGSTMT                     11
#define KMSG_ETOKEN                     12
#define KMSG_ELENGTH                    13
#define KMSG_WCLASSN                    14
#define KMSG_WCONSTN                    15
#define KMSG_WCMETHODN                  16
#define KMSG_WNAME                      17
#define KMSG_WIGNORED                   18
#define KMSG_TEXPTN                     19
#define KMSG_TNSNAME                    20
#define KMSG_TCURN                      21
#define KMSG_TNSCLASSN                  22
#define KMSG_TTYPEN                     23
#define KMSG_TMETHODN                   24
#define KMSG_TCLASSTN                   25
#define KMSG_TSTR                       26
#define KMSG_TVARN                      27
#define KMSG_TCLASSN                    28
#define KMSG_TARGS                      29
#define KMSG_TNAME                      30
#define KMSG_TCMETHODN                  31
#define KMSG_TMT                        32
#define KMSG_TANY                       33
#define KMSG_TSTMT1                     34
#define KMSG_TPEXPR                     35
#define KMSG_TCATCHPARAM                36
#define KMSG_ELVALUE                    37
#define KMSG_NOTHERECONST               38
#define KMSG_NOTHERECLASSCONST          39
#define KMSG_NNCONST                    40
#define KMSG_DUPCONST                   41
#define KMSG_ENEXTPREV                  42
#define KMSG_EEMPTYEXPR                 43
#define KMSG_ETRINARY                   44
#define KMSG_EPSTMT3                    45
#define KMSG_WLET                       46
#define KMSG_WEMPTYPEXPR                47
#define KMSG_WEMPTYARGS                 48
#define KMSG_WTRUEFALSE                 49
#define KMSG_UUOPTION                   50
#define KMSG_UCONSTN                    51
#define KMSG_UVARN                      52
#define KMSG_USYSTEMVARN                53
#define KMSG_UCLASSN                    54
#define KMSG_UTAG                       55
#define KMSG_UTYPEN                     56
#define KMSG_UMETHODN                   57
#define KMSG_UFUNCN                     58
#define KMSG_ULABEL                     59
#define KMSG_UOP                        60
#define KMSG_UNEW                       61
#define KMSG_UMAP                       62
#define KMSG_INTOVERFLOW                63
#define KMSG_FLOATOVERFLOW              64
#define KMSG_INT64OVERFLOW              65
#define KMSG_ETOOFEWPARAMS              66
#define KMSG_WTOOMANYPARAMS             67
#define KMSG_EOP2                       68
#define KMSG_EOPCMP                     69
#define KMSG_EVOIDPARAM                 70
#define KMSG_ENULLPARAM                 71
#define KMSG_WNULLPARAM                 72
#define KMSG_ETYPEPARAM                 73
#define KMSG_EVOIDRETURN                74
#define KMSG_ENULLRETURN                75
#define KMSG_WNULLRETURN                76
#define KMSG_ETYPERETURN                77
#define KMSG_EVOIDLET                   78
#define KMSG_ENULLLET                   79
#define KMSG_WNULLLET                   80
#define KMSG_ETYPELET                   81
#define KMSG_WDUPFUNCNAME               82
#define KMSG_USCLASSFUNC                83
#define KMSG_USNNTYPE                   84
#define KMSG_IGNNTYPE                   85
#define KMSG_EEXTENDS                   86
#define KMSG_EIMPLEMENTS                87
#define KMSG_DIFFDECL                   88
#define KMSG_DIFFCLASSN                 89
#define KMSG_DIFFNEWTYPE                90
#define KMSG_DIFFRTYPE                  91
#define KMSG_DIFFPSIZE                  92
#define KMSG_DIFFPTYPE                  93
#define KMSG_DIFFPNAME                  94
#define KMSG_TOOMANYVARS                95
#define KMSG_EOUTERLOOP                 96
#define KMSG_IGFIELDVALUE               97
#define KMSG_IGSCRIPTNAME               98
#define KMSG_IGFIELDNAME                99
#define KMSG_NORETURN                   100
#define KMSG_NORETURNVALUE              101
#define KMSG_IGRETURN                   102
#define KMSG_AHISTORIC                  103
#define KMSG_AOVERRIDE                  104
#define KMSG_EOVERRIDE                  105
#define KMSG_TOABSTRACT                 106
#define KMSG_MAXSIZ                     107

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
int knh_system_langid(char *lang);
int knh_system_setLang(char *lang);
int knh_message_type(int e);
char *knh_message_text(int e);
char *knh_message_tochar(int e);

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHA_MESSAGE__H*/
