/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHA_NAME__H
#define KONOHA_NAME__H

#include<konoha/konoha_config.h>
#include<konoha/konoha_t.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* [flag] */

/* ------------------------------------------------------------------------ */
/* Object */
#define KNH_FLAG_OF_RELEASE             KNH_FLAG0

#define knh_Object_isRelease(o)  \
	(((o)->h.flag & KNH_FLAG_OF_RELEASE) == KNH_FLAG_OF_RELEASE)

#define knh_Object_isDebug(o)   \
	(((o)->h.flag & KNH_FLAG_OF_RELEASE) != KNH_FLAG_OF_RELEASE)
#define KNH_FLAG_OF_IMMUTABLE           KNH_FLAG1

#define knh_Object_isImmutable(o)  \
	(((o)->h.flag & KNH_FLAG_OF_IMMUTABLE) == KNH_FLAG_OF_IMMUTABLE)
#define KNH_FLAG_OF_CYCLIC              KNH_FLAG2

#define knh_Object_isCyclic(o)  \
	(((o)->h.flag & KNH_FLAG_OF_CYCLIC) == KNH_FLAG_OF_CYCLIC)

#define knh_Object_setCyclic(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OF_CYCLIC; else (o)->h.flag &= ~(KNH_FLAG_OF_CYCLIC);

#define KNH_FLAG_OF_METADATA            KNH_FLAG3

#define knh_Object_hasMetaData(o)  \
	(((o)->h.flag & KNH_FLAG_OF_METADATA) == KNH_FLAG_OF_METADATA)

#define knh_Object_setMetaData(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OF_METADATA; else (o)->h.flag &= ~(KNH_FLAG_OF_METADATA);

#define KNH_FLAG_OF_SYNCHRONIZED        KNH_FLAG4

#define knh_Object_isSynchronized(o)  \
	(((o)->h.flag & KNH_FLAG_OF_SYNCHRONIZED) == KNH_FLAG_OF_SYNCHRONIZED)
#define KNH_FLAG_OF_MODIFIED            KNH_FLAG5

#define knh_Object_isModified(o)  \
	(((o)->h.flag & KNH_FLAG_OF_MODIFIED) == KNH_FLAG_OF_MODIFIED)

#define knh_Object_setModified(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OF_MODIFIED; else (o)->h.flag &= ~(KNH_FLAG_OF_MODIFIED);

#define KNH_FLAG_OF_GCMARKED            KNH_FLAG6

#define knh_Object_isGCMarked(o)  \
	(((o)->h.flag & KNH_FLAG_OF_GCMARKED) == KNH_FLAG_OF_GCMARKED)

#define knh_Object_setGCMarked(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OF_GCMARKED; else (o)->h.flag &= ~(KNH_FLAG_OF_GCMARKED);

#define KNH_FLAG_OF_FORMATTED           KNH_FLAG7

#define knh_Object_isFormatted(o)  \
	(((o)->h.flag & KNH_FLAG_OF_FORMATTED) == KNH_FLAG_OF_FORMATTED)

#define knh_Object_setFormatted(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OF_FORMATTED; else (o)->h.flag &= ~(KNH_FLAG_OF_FORMATTED);

#define KNH_FLAG_OF_LOCAL4              KNH_FLAG8

#define knh_Object_isLocal4(o)  \
	(((o)->h.flag & KNH_FLAG_OF_LOCAL4) == KNH_FLAG_OF_LOCAL4)

#define knh_Object_setLocal4(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OF_LOCAL4; else (o)->h.flag &= ~(KNH_FLAG_OF_LOCAL4);

#define KNH_FLAG_OF_LOCAL3              KNH_FLAG9

#define knh_Object_isLocal3(o)  \
	(((o)->h.flag & KNH_FLAG_OF_LOCAL3) == KNH_FLAG_OF_LOCAL3)

#define knh_Object_setLocal3(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OF_LOCAL3; else (o)->h.flag &= ~(KNH_FLAG_OF_LOCAL3);

#define KNH_FLAG_OF_LOCAL2              KNH_FLAG10

#define knh_Object_isLocal2(o)  \
	(((o)->h.flag & KNH_FLAG_OF_LOCAL2) == KNH_FLAG_OF_LOCAL2)

#define knh_Object_setLocal2(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OF_LOCAL2; else (o)->h.flag &= ~(KNH_FLAG_OF_LOCAL2);

#define KNH_FLAG_OF_LOCAL1              KNH_FLAG11

#define knh_Object_isLocal1(o)  \
	(((o)->h.flag & KNH_FLAG_OF_LOCAL1) == KNH_FLAG_OF_LOCAL1)

#define knh_Object_setLocal1(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OF_LOCAL1; else (o)->h.flag &= ~(KNH_FLAG_OF_LOCAL1);


/* ------------------------------------------------------------------------ */
/* Nue */
#define KNH_FLAG_NUE_GCHOOK             KNH_FLAG_OF_LOCAL1

#define knh_Nue_isGCHook(o)  \
	(((o)->h.flag & KNH_FLAG_NUE_GCHOOK) == KNH_FLAG_NUE_GCHOOK)

#define knh_Nue_setGCHook(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_NUE_GCHOOK; else (o)->h.flag &= ~(KNH_FLAG_NUE_GCHOOK);


/* ------------------------------------------------------------------------ */
/* String */
#define KNH_FLAG_STRING_TEXTSGM         KNH_FLAG_OF_LOCAL1

#define knh_String_isTextSgm(o)  \
	(((o)->h.flag & KNH_FLAG_STRING_TEXTSGM) == KNH_FLAG_STRING_TEXTSGM)

#define knh_String_setTextSgm(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_STRING_TEXTSGM; else (o)->h.flag &= ~(KNH_FLAG_STRING_TEXTSGM);

#define KNH_FLAG_STRING_ASCII           KNH_FLAG_OF_LOCAL2

#define knh_String_isASCII(o)  \
	(((o)->h.flag & KNH_FLAG_STRING_ASCII) == KNH_FLAG_STRING_ASCII)

#define knh_String_setASCII(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_STRING_ASCII; else (o)->h.flag &= ~(KNH_FLAG_STRING_ASCII);


/* ------------------------------------------------------------------------ */
/* Bytes */
#define KNH_FLAG_BYTES_STACKBUFFER      KNH_FLAG_OF_LOCAL1

#define knh_Bytes_isStackBuffer(o)  \
	(((o)->h.flag & KNH_FLAG_BYTES_STACKBUFFER) == KNH_FLAG_BYTES_STACKBUFFER)

#define knh_Bytes_setStackBuffer(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_BYTES_STACKBUFFER; else (o)->h.flag &= ~(KNH_FLAG_BYTES_STACKBUFFER);


/* ------------------------------------------------------------------------ */
/* Class */
#define KNH_FLAG_CF_RELEASE             KNH_FLAG0

#define knh_class_isRelease(o)  \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_RELEASE) == KNH_FLAG_CF_RELEASE)

#define knh_class_isDebug(o)   \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_RELEASE) != KNH_FLAG_CF_RELEASE)
#define KNH_FLAG_CF_IMMUTABLE           KNH_FLAG1

#define knh_class_isImmutable(o)  \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_IMMUTABLE) == KNH_FLAG_CF_IMMUTABLE)
#define KNH_FLAG_CF_CYCLIC              KNH_FLAG2

#define knh_class_isCyclic(o)  \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_CYCLIC) == KNH_FLAG_CF_CYCLIC)

#define knh_class_setCyclic(o,b)  \
	if(b) knh_tClass[(o)].cflag |= KNH_FLAG_CF_CYCLIC; else knh_tClass[(o)].cflag &= ~(KNH_FLAG_CF_CYCLIC);

#define KNH_FLAG_CF_METAEXTENSIBLE      KNH_FLAG3

#define knh_class_isMetaExtensible(o)  \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_METAEXTENSIBLE) == KNH_FLAG_CF_METAEXTENSIBLE)
#define KNH_FLAG_CF_PRIVATE             KNH_FLAG4

#define knh_class_isPrivate(o)  \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_PRIVATE) == KNH_FLAG_CF_PRIVATE)

#define knh_class_isPublic(o)   \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_PRIVATE) != KNH_FLAG_CF_PRIVATE)
#define KNH_FLAG_CF_FINAL               KNH_FLAG5

#define knh_class_isFinal(o)  \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_FINAL) == KNH_FLAG_CF_FINAL)
#define KNH_FLAG_CF_STRICT              KNH_FLAG6

#define knh_class_isStrict(o)  \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_STRICT) == KNH_FLAG_CF_STRICT)
#define KNH_FLAG_CF_SYSTEM              KNH_FLAG7

#define knh_class_isSystem(o)  \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_SYSTEM) == KNH_FLAG_CF_SYSTEM)
#define KNH_FLAG_CF_NULLOBJECT          KNH_FLAG8

#define knh_class_isNullObject(o)  \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_NULLOBJECT) == KNH_FLAG_CF_NULLOBJECT)
#define KNH_FLAG_CF_INTERFACE           KNH_FLAG9

#define knh_class_isInterface(o)  \
	((knh_tClass[(o)].cflag & KNH_FLAG_CF_INTERFACE) == KNH_FLAG_CF_INTERFACE)

/* ------------------------------------------------------------------------ */
/* ClassStruct */
#define KNH_FLAG_CFF_HIDDEN             KNH_FLAG0

#define knh_ClassStruct_isHidden(o,n)  \
	((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_HIDDEN) == KNH_FLAG_CFF_HIDDEN)

#define knh_ClassStruct_setHidden(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_HIDDEN; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_HIDDEN);

#define KNH_FLAG_CFF_AUTONAME           KNH_FLAG1

#define knh_ClassStruct_isAutoName(o,n)  \
	((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_AUTONAME) == KNH_FLAG_CFF_AUTONAME)

#define knh_ClassStruct_setAutoName(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_AUTONAME; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_AUTONAME);

#define KNH_FLAG_CFF_SAFEVALUE          KNH_FLAG2

#define knh_ClassStruct_isSafeValue(o,n)  \
	((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_SAFEVALUE) == KNH_FLAG_CFF_SAFEVALUE)

#define knh_ClassStruct_setSafeValue(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_SAFEVALUE; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_SAFEVALUE);

#define KNH_FLAG_CFF_PROTECTED          KNH_FLAG3

#define knh_ClassStruct_isProtected(o,n)  \
	((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_PROTECTED) == KNH_FLAG_CFF_PROTECTED)

#define knh_ClassStruct_setProtected(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_PROTECTED; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_PROTECTED);

#define KNH_FLAG_CFF_GETTER             KNH_FLAG4

#define knh_ClassStruct_isGetter(o,n)  \
	((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_GETTER) == KNH_FLAG_CFF_GETTER)

#define knh_ClassStruct_setGetter(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_GETTER; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_GETTER);

#define KNH_FLAG_CFF_SETTER             KNH_FLAG5

#define knh_ClassStruct_isSetter(o,n)  \
	((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_SETTER) == KNH_FLAG_CFF_SETTER)

#define knh_ClassStruct_setSetter(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_SETTER; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_SETTER);

#define KNH_FLAG_CFF_KEY                KNH_FLAG6

#define knh_ClassStruct_isKey(o,n)  \
	((((ClassStruct)o)->fields[n].flag & KNH_FLAG_CFF_KEY) == KNH_FLAG_CFF_KEY)

#define knh_ClassStruct_setKey(o,n,b)  \
	if(b) ((ClassStruct)o)->fields[n].flag |= KNH_FLAG_CFF_KEY; else ((ClassStruct)o)->fields[n].flag &= ~(KNH_FLAG_CFF_KEY);


/* ------------------------------------------------------------------------ */
/* Method */
#define KNH_FLAG_MF_PUBLIC              KNH_FLAG0

#define knh_Method_isPublic(o)  \
	((DP((Method*)o)->flag & KNH_FLAG_MF_PUBLIC) == KNH_FLAG_MF_PUBLIC)

#define knh_Method_isPrivate(o)   \
	((DP((Method*)o)->flag & KNH_FLAG_MF_PUBLIC) != KNH_FLAG_MF_PUBLIC)

#define knh_Method_setPublic(o,b)  \
	if(b) DP((Method*)o)->flag |= KNH_FLAG_MF_PUBLIC; else DP((Method*)o)->flag &= ~(KNH_FLAG_MF_PUBLIC);


#define knh_Method_setPrivate(o,b)  \
	if(b) DP((Method*)o)->flag &= ~(KNH_FLAG_MF_PUBLIC); else DP((Method*)o)->flag |= KNH_FLAG_MF_PUBLIC;

#define KNH_FLAG_MF_VIRTUAL             KNH_FLAG1

#define knh_Method_isVirtual(o)  \
	((DP((Method*)o)->flag & KNH_FLAG_MF_VIRTUAL) == KNH_FLAG_MF_VIRTUAL)

#define knh_Method_isFinal(o)   \
	((DP((Method*)o)->flag & KNH_FLAG_MF_VIRTUAL) != KNH_FLAG_MF_VIRTUAL)

#define knh_Method_setVirtual(o,b)  \
	if(b) DP((Method*)o)->flag |= KNH_FLAG_MF_VIRTUAL; else DP((Method*)o)->flag &= ~(KNH_FLAG_MF_VIRTUAL);


#define knh_Method_setFinal(o,b)  \
	if(b) DP((Method*)o)->flag &= ~(KNH_FLAG_MF_VIRTUAL); else DP((Method*)o)->flag |= KNH_FLAG_MF_VIRTUAL;

#define KNH_FLAG_MF_STATIC              KNH_FLAG2

#define knh_Method_isStatic(o)  \
	((DP((Method*)o)->flag & KNH_FLAG_MF_STATIC) == KNH_FLAG_MF_STATIC)
#define KNH_FLAG_MF_CLASS               KNH_FLAG3

#define knh_Method_isClass(o)  \
	((DP((Method*)o)->flag & KNH_FLAG_MF_CLASS) == KNH_FLAG_MF_CLASS)
#define KNH_FLAG_MF_NULLBASE            KNH_FLAG4

#define knh_Method_isNullBase(o)  \
	((DP((Method*)o)->flag & KNH_FLAG_MF_NULLBASE) == KNH_FLAG_MF_NULLBASE)
#define KNH_FLAG_MF_VARARGS             KNH_FLAG5

#define knh_Method_isVarArgs(o)  \
	((DP((Method*)o)->flag & KNH_FLAG_MF_VARARGS) == KNH_FLAG_MF_VARARGS)

#define knh_Method_setVarArgs(o,b)  \
	if(b) DP((Method*)o)->flag |= KNH_FLAG_MF_VARARGS; else DP((Method*)o)->flag &= ~(KNH_FLAG_MF_VARARGS);

#define KNH_FLAG_MF_SMART               KNH_FLAG6

#define knh_Method_isSmart(o)  \
	((DP((Method*)o)->flag & KNH_FLAG_MF_SMART) == KNH_FLAG_MF_SMART)
#define KNH_FLAG_MF_ASPECT              KNH_FLAG7

#define knh_Method_isAspect(o)  \
	((DP((Method*)o)->flag & KNH_FLAG_MF_ASPECT) == KNH_FLAG_MF_ASPECT)

#define knh_Method_setAspect(o,b)  \
	if(b) DP((Method*)o)->flag |= KNH_FLAG_MF_ASPECT; else DP((Method*)o)->flag &= ~(KNH_FLAG_MF_ASPECT);

#define KNH_FLAG_MF_OBJECTCODE          KNH_FLAG8

#define knh_Method_isObjectCode(o)  \
	((DP((Method*)o)->flag & KNH_FLAG_MF_OBJECTCODE) == KNH_FLAG_MF_OBJECTCODE)

#define knh_Method_setObjectCode(o,b)  \
	if(b) DP((Method*)o)->flag |= KNH_FLAG_MF_OBJECTCODE; else DP((Method*)o)->flag &= ~(KNH_FLAG_MF_OBJECTCODE);

#define KNH_FLAG_MF_GENERATED           KNH_FLAG9

#define knh_Method_isGenerated(o)  \
	((DP((Method*)o)->flag & KNH_FLAG_MF_GENERATED) == KNH_FLAG_MF_GENERATED)

#define knh_Method_setGenerated(o,b)  \
	if(b) DP((Method*)o)->flag |= KNH_FLAG_MF_GENERATED; else DP((Method*)o)->flag &= ~(KNH_FLAG_MF_GENERATED);


/* ------------------------------------------------------------------------ */
/* Mapper */
#define KNH_FLAG_MMF_INTERFACE          KNH_FLAG0

#define knh_Mapper_isInterface(o)  \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_INTERFACE) == KNH_FLAG_MMF_INTERFACE)

#define knh_Mapper_setInterface(o,b)  \
	if(b) DP((Mapper*)o)->flag |= KNH_FLAG_MMF_INTERFACE; else DP((Mapper*)o)->flag &= ~(KNH_FLAG_MMF_INTERFACE);

#define KNH_FLAG_MMF_SIGNIFICANT        KNH_FLAG1

#define knh_Mapper_isSignificant(o)  \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_SIGNIFICANT) == KNH_FLAG_MMF_SIGNIFICANT)

#define knh_Mapper_setSignificant(o,b)  \
	if(b) DP((Mapper*)o)->flag |= KNH_FLAG_MMF_SIGNIFICANT; else DP((Mapper*)o)->flag &= ~(KNH_FLAG_MMF_SIGNIFICANT);

#define KNH_FLAG_MMF_FINAL              KNH_FLAG2

#define knh_Mapper_isFinal(o)  \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_FINAL) == KNH_FLAG_MMF_FINAL)
#define KNH_FLAG_MMF_SYNONYM            KNH_FLAG3

#define knh_Mapper_isSynonym(o)  \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_SYNONYM) == KNH_FLAG_MMF_SYNONYM)

#define knh_Mapper_setSynonym(o,b)  \
	if(b) DP((Mapper*)o)->flag |= KNH_FLAG_MMF_SYNONYM; else DP((Mapper*)o)->flag &= ~(KNH_FLAG_MMF_SYNONYM);

#define KNH_FLAG_MMF_LOSSLESS           KNH_FLAG4

#define knh_Mapper_isLossLess(o)  \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_LOSSLESS) == KNH_FLAG_MMF_LOSSLESS)

#define knh_Mapper_setLossLess(o,b)  \
	if(b) DP((Mapper*)o)->flag |= KNH_FLAG_MMF_LOSSLESS; else DP((Mapper*)o)->flag &= ~(KNH_FLAG_MMF_LOSSLESS);

#define KNH_FLAG_MMF_TOTAL              KNH_FLAG5

#define knh_Mapper_isTotal(o)  \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_TOTAL) == KNH_FLAG_MMF_TOTAL)

#define knh_Mapper_isPartial(o)   \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_TOTAL) != KNH_FLAG_MMF_TOTAL)

#define knh_Mapper_setTotal(o,b)  \
	if(b) DP((Mapper*)o)->flag |= KNH_FLAG_MMF_TOTAL; else DP((Mapper*)o)->flag &= ~(KNH_FLAG_MMF_TOTAL);


#define knh_Mapper_setPartial(o,b)  \
	if(b) DP((Mapper*)o)->flag &= ~(KNH_FLAG_MMF_TOTAL); else DP((Mapper*)o)->flag |= KNH_FLAG_MMF_TOTAL;

#define KNH_FLAG_MMF_STATIC             KNH_FLAG6

#define knh_Mapper_isStatic(o)  \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_STATIC) == KNH_FLAG_MMF_STATIC)

#define knh_Mapper_isTemporal(o)   \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_STATIC) != KNH_FLAG_MMF_STATIC)

#define knh_Mapper_setStatic(o,b)  \
	if(b) DP((Mapper*)o)->flag |= KNH_FLAG_MMF_STATIC; else DP((Mapper*)o)->flag &= ~(KNH_FLAG_MMF_STATIC);


#define knh_Mapper_setTemporal(o,b)  \
	if(b) DP((Mapper*)o)->flag &= ~(KNH_FLAG_MMF_STATIC); else DP((Mapper*)o)->flag |= KNH_FLAG_MMF_STATIC;

#define KNH_FLAG_MMF_LOCAL              KNH_FLAG7

#define knh_Mapper_isLocal(o)  \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_LOCAL) == KNH_FLAG_MMF_LOCAL)

#define knh_Mapper_setLocal(o,b)  \
	if(b) DP((Mapper*)o)->flag |= KNH_FLAG_MMF_LOCAL; else DP((Mapper*)o)->flag &= ~(KNH_FLAG_MMF_LOCAL);

#define KNH_FLAG_MMF_DERIVED            KNH_FLAG8

#define knh_Mapper_isDerived(o)  \
	((DP((Mapper*)o)->flag & KNH_FLAG_MMF_DERIVED) == KNH_FLAG_MMF_DERIVED)

#define knh_Mapper_setDerived(o,b)  \
	if(b) DP((Mapper*)o)->flag |= KNH_FLAG_MMF_DERIVED; else DP((Mapper*)o)->flag &= ~(KNH_FLAG_MMF_DERIVED);


/* ------------------------------------------------------------------------ */
/* ClassMap */
#define KNH_FLAG_CM_SORTED              KNH_FLAG_OF_LOCAL1

#define knh_ClassMap_isSorted(o)  \
	(((o)->h.flag & KNH_FLAG_CM_SORTED) == KNH_FLAG_CM_SORTED)

#define knh_ClassMap_setSorted(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_CM_SORTED; else (o)->h.flag &= ~(KNH_FLAG_CM_SORTED);


/* ------------------------------------------------------------------------ */
/* IntUnit */
#define KNH_FLAG_UF_UNSIGNED            KNH_FLAG0

#define knh_IntUnit_isUnsigned(o)  \
	((DP((IntUnit*)o)->spec.flag & KNH_FLAG_UF_UNSIGNED) == KNH_FLAG_UF_UNSIGNED)

/* ------------------------------------------------------------------------ */
/* OutputStream */
#define KNH_FLAG_OUT_BOL                KNH_FLAG_OF_LOCAL1

#define knh_OutputStream_isBOL(o)  \
	(((o)->h.flag & KNH_FLAG_OUT_BOL) == KNH_FLAG_OUT_BOL)

#define knh_OutputStream_setBOL(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OUT_BOL; else (o)->h.flag &= ~(KNH_FLAG_OUT_BOL);

#define KNH_FLAG_OUT_AUTOFLUSH          KNH_FLAG_OF_LOCAL2

#define knh_OutputStream_isAutoFlush(o)  \
	(((o)->h.flag & KNH_FLAG_OUT_AUTOFLUSH) == KNH_FLAG_OUT_AUTOFLUSH)

#define knh_OutputStream_setAutoFlush(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_OUT_AUTOFLUSH; else (o)->h.flag &= ~(KNH_FLAG_OUT_AUTOFLUSH);


/* ------------------------------------------------------------------------ */
/* Exception */
#define KNH_FLAG_EF_FATAL               KNH_FLAG0

#define knh_Exception_isFatal(o)  \
	((DP((Exception*)o)->flag & KNH_FLAG_EF_FATAL) == KNH_FLAG_EF_FATAL)
#define KNH_FLAG_EF_LOGGING             KNH_FLAG1

#define knh_Exception_isLogging(o)  \
	((DP((Exception*)o)->flag & KNH_FLAG_EF_LOGGING) == KNH_FLAG_EF_LOGGING)
#define KNH_FLAG_EF_GENERATED           KNH_FLAG2

#define knh_Exception_isGenerated(o)  \
	((DP((Exception*)o)->flag & KNH_FLAG_EF_GENERATED) == KNH_FLAG_EF_GENERATED)
#define KNH_FLAG_EF_CAUGHT              KNH_FLAG3

#define knh_Exception_isCaught(o)  \
	((DP((Exception*)o)->flag & KNH_FLAG_EF_CAUGHT) == KNH_FLAG_EF_CAUGHT)

#define knh_Exception_setCaught(o,b)  \
	if(b) DP((Exception*)o)->flag |= KNH_FLAG_EF_CAUGHT; else DP((Exception*)o)->flag &= ~(KNH_FLAG_EF_CAUGHT);


/* ------------------------------------------------------------------------ */
/* ExceptionHandler */
#define KNH_FLAG_EHF_CATCHING           KNH_FLAG_OF_LOCAL1

#define knh_ExceptionHandler_isCatching(o)  \
	(((o)->h.flag & KNH_FLAG_EHF_CATCHING) == KNH_FLAG_EHF_CATCHING)

#define knh_ExceptionHandler_setCatching(o,b)  \
	if(b) (o)->h.flag |= KNH_FLAG_EHF_CATCHING; else (o)->h.flag &= ~(KNH_FLAG_EHF_CATCHING);


/* ------------------------------------------------------------------------ */
/* Context */
#define KNH_FLAG_CTX_VERBOSE            KNH_FLAG0

#define knh_Context_isVerbose(o)  \
	((((Context*)o)->flag & KNH_FLAG_CTX_VERBOSE) == KNH_FLAG_CTX_VERBOSE)

#define knh_Context_setVerbose(o,b)  \
	if(b) ((Context*)o)->flag |= KNH_FLAG_CTX_VERBOSE; else ((Context*)o)->flag &= ~(KNH_FLAG_CTX_VERBOSE);


/* ------------------------------------------------------------------------ */
/* Token */
#define KNH_FLAG_TKF_TAILWILDCARD       KNH_FLAG0

#define knh_Token_isTailWildCard(o)  \
	((DP(o)->flag & KNH_FLAG_TKF_TAILWILDCARD) == KNH_FLAG_TKF_TAILWILDCARD)

#define knh_Token_setTailWildCard(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_TKF_TAILWILDCARD; else DP(o)->flag &= ~(KNH_FLAG_TKF_TAILWILDCARD);

#define KNH_FLAG_TKF_TOPDOT             KNH_FLAG1

#define knh_Token_isTopDot(o)  \
	((DP(o)->flag & KNH_FLAG_TKF_TOPDOT) == KNH_FLAG_TKF_TOPDOT)

#define knh_Token_setTopDot(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_TKF_TOPDOT; else DP(o)->flag &= ~(KNH_FLAG_TKF_TOPDOT);

#define KNH_FLAG_TKF_GETTER             KNH_FLAG2

#define knh_Token_isGetter(o)  \
	((DP(o)->flag & KNH_FLAG_TKF_GETTER) == KNH_FLAG_TKF_GETTER)

#define knh_Token_setGetter(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_TKF_GETTER; else DP(o)->flag &= ~(KNH_FLAG_TKF_GETTER);

#define KNH_FLAG_TKF_SETTER             KNH_FLAG3

#define knh_Token_isSetter(o)  \
	((DP(o)->flag & KNH_FLAG_TKF_SETTER) == KNH_FLAG_TKF_SETTER)

#define knh_Token_setSetter(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_TKF_SETTER; else DP(o)->flag &= ~(KNH_FLAG_TKF_SETTER);

#define KNH_FLAG_TKF_GENERATED          KNH_FLAG4

#define knh_Token_isGenerated(o)  \
	((DP(o)->flag & KNH_FLAG_TKF_GENERATED) == KNH_FLAG_TKF_GENERATED)

#define knh_Token_setGenerated(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_TKF_GENERATED; else DP(o)->flag &= ~(KNH_FLAG_TKF_GENERATED);

#define KNH_FLAG_TKF_EXCEPTIONTYPE      KNH_FLAG5

#define knh_Token_isExceptionType(o)  \
	((DP(o)->flag & KNH_FLAG_TKF_EXCEPTIONTYPE) == KNH_FLAG_TKF_EXCEPTIONTYPE)

#define knh_Token_setExceptionType(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_TKF_EXCEPTIONTYPE; else DP(o)->flag &= ~(KNH_FLAG_TKF_EXCEPTIONTYPE);

#define KNH_FLAG_TKF_NOTNULLTYPE        KNH_FLAG6

#define knh_Token_isNotNullType(o)  \
	((DP(o)->flag & KNH_FLAG_TKF_NOTNULLTYPE) == KNH_FLAG_TKF_NOTNULLTYPE)

#define knh_Token_setNotNullType(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_TKF_NOTNULLTYPE; else DP(o)->flag &= ~(KNH_FLAG_TKF_NOTNULLTYPE);

#define KNH_FLAG_TKF_ITERATORTYPE       KNH_FLAG7

#define knh_Token_isIteratorType(o)  \
	((DP(o)->flag & KNH_FLAG_TKF_ITERATORTYPE) == KNH_FLAG_TKF_ITERATORTYPE)

#define knh_Token_setIteratorType(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_TKF_ITERATORTYPE; else DP(o)->flag &= ~(KNH_FLAG_TKF_ITERATORTYPE);

#define KNH_FLAG_TKF_ARRAYTYPE          KNH_FLAG8

#define knh_Token_isArrayType(o)  \
	((DP(o)->flag & KNH_FLAG_TKF_ARRAYTYPE) == KNH_FLAG_TKF_ARRAYTYPE)

#define knh_Token_setArrayType(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_TKF_ARRAYTYPE; else DP(o)->flag &= ~(KNH_FLAG_TKF_ARRAYTYPE);

#define KNH_FLAG_TKF_TYPED              KNH_FLAG9

#define knh_Token_isTyped(o)  \
	((DP(o)->flag & KNH_FLAG_TKF_TYPED) == KNH_FLAG_TKF_TYPED)

#define knh_Token_setTyped(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_TKF_TYPED; else DP(o)->flag &= ~(KNH_FLAG_TKF_TYPED);


/* ------------------------------------------------------------------------ */
/* Stmt */
#define KNH_FLAG_STMTF_ADPOSITION       KNH_FLAG0

#define knh_Stmt_isAdposition(o)  \
	((DP(o)->flag & KNH_FLAG_STMTF_ADPOSITION) == KNH_FLAG_STMTF_ADPOSITION)

#define knh_Stmt_setAdposition(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_STMTF_ADPOSITION; else DP(o)->flag &= ~(KNH_FLAG_STMTF_ADPOSITION);

#define KNH_FLAG_STMTF_NONNEWLINE       KNH_FLAG1

#define knh_Stmt_isNonNewLine(o)  \
	((DP(o)->flag & KNH_FLAG_STMTF_NONNEWLINE) == KNH_FLAG_STMTF_NONNEWLINE)

#define knh_Stmt_setNonNewLine(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_STMTF_NONNEWLINE; else DP(o)->flag &= ~(KNH_FLAG_STMTF_NONNEWLINE);

#define KNH_FLAG_STMTF_VISIBLE          KNH_FLAG2

#define knh_Stmt_isVisible(o)  \
	((DP(o)->flag & KNH_FLAG_STMTF_VISIBLE) == KNH_FLAG_STMTF_VISIBLE)

#define knh_Stmt_setVisible(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_STMTF_VISIBLE; else DP(o)->flag &= ~(KNH_FLAG_STMTF_VISIBLE);

#define KNH_FLAG_STMTF_TYPED            KNH_FLAG3

#define knh_Stmt_isTyped(o)  \
	((DP(o)->flag & KNH_FLAG_STMTF_TYPED) == KNH_FLAG_STMTF_TYPED)

#define knh_Stmt_setTyped(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_STMTF_TYPED; else DP(o)->flag &= ~(KNH_FLAG_STMTF_TYPED);


/* ------------------------------------------------------------------------ */
/* Compiler */
#define KNH_FLAG_CPF_SYNTAXERROR        KNH_FLAG0

#define knh_Compiler_isSyntaxError(o)  \
	((DP(o)->flag & KNH_FLAG_CPF_SYNTAXERROR) == KNH_FLAG_CPF_SYNTAXERROR)

#define knh_Compiler_setSyntaxError(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_CPF_SYNTAXERROR; else DP(o)->flag &= ~(KNH_FLAG_CPF_SYNTAXERROR);

#define KNH_FLAG_CPF_STOPPED            KNH_FLAG1

#define knh_Compiler_isStopped(o)  \
	((DP(o)->flag & KNH_FLAG_CPF_STOPPED) == KNH_FLAG_CPF_STOPPED)

#define knh_Compiler_setStopped(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_CPF_STOPPED; else DP(o)->flag &= ~(KNH_FLAG_CPF_STOPPED);

#define KNH_FLAG_CPF_CANCELLED          KNH_FLAG2

#define knh_Compiler_isCancelled(o)  \
	((DP(o)->flag & KNH_FLAG_CPF_CANCELLED) == KNH_FLAG_CPF_CANCELLED)

#define knh_Compiler_setCancelled(o,b)  \
	if(b) DP(o)->flag |= KNH_FLAG_CPF_CANCELLED; else DP(o)->flag &= ~(KNH_FLAG_CPF_CANCELLED);


/* ======================================================================== */
/* [class] */

/* ------------------------------------------------------------------------ */
/* konoha */

/* ------------------------------------------------------------------------ */
/* Object */
#define STRUCT_Object           ((knh_struct_t)0)
#define CLASS_Object            ((knh_class_t)0)
#define IS_bObject(o)           ((o)->h.bcid == CLASS_Object)
#ifndef Object
#define Object                  knh_Object_t
#endif
#define IS_Object(o)            ((o)->h.cid == CLASS_Object)
#define ASSERT_Object(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_Object))
#define ACLASS_Object           knh_class_Array(ctx, CLASS_Object)
#define ICLASS_Object           knh_class_Iterator(ctx, CLASS_Object)
#define TYPE_Object             CLASS_Object
#define NNTYPE_Object           TYPE_TONNTYPE(CLASS_Object)
#define ATYPE_Object            knh_class_Array(ctx, CLASS_Object)
#define ITYPE_Object            knh_class_Iterator(ctx, CLASS_Object)
#define CLASS_pObject           CLASS_PMZ(CLASS_Object)
#define TYPE_pObject            TYPE_PMZ(CLASS_Object)
#define NNTYPE_pObject          TYPE_TONNTYPE(CLASS_pObject)
#define CFLAG_Object            ((knh_flag_t)KNH_FLAG_CF_CYCLIC)
#define FLAG_Object             KNH_FLAG_CF2OF(CFLAG_Object)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Any */
#define STRUCT_Any              ((knh_struct_t)1)
#define CLASS_Any               ((knh_class_t)1)
#define IS_bAny(o)              ((o)->h.bcid == CLASS_Any)
#ifndef Any
#define Any                     knh_Any_t
#endif
#define IS_Any(o)               ((o)->h.cid == CLASS_Any)
#define ASSERT_Any(o)           DEBUG_ASSERT(((o)->h.cid == CLASS_Any))
#define ACLASS_Any              knh_class_Array(ctx, CLASS_Any)
#define ICLASS_Any              knh_class_Iterator(ctx, CLASS_Any)
#define TYPE_Any                CLASS_Any
#define NNTYPE_Any              TYPE_TONNTYPE(CLASS_Any)
#define ATYPE_Any               knh_class_Array(ctx, CLASS_Any)
#define ITYPE_Any               knh_class_Iterator(ctx, CLASS_Any)
#define CLASS_pAny              CLASS_PMZ(CLASS_Any)
#define TYPE_pAny               TYPE_PMZ(CLASS_Any)
#define NNTYPE_pAny             TYPE_TONNTYPE(CLASS_pAny)
#define CFLAG_Any               ((knh_flag_t)KNH_FLAG_CF_CYCLIC)
#define FLAG_Any                KNH_FLAG_CF2OF(CFLAG_Any)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* This */
#define STRUCT_This             ((knh_struct_t)2)
#define CLASS_This              ((knh_class_t)2)
#define IS_bThis(o)             ((o)->h.bcid == CLASS_This)
#ifndef This
#define This                    knh_This_t
#endif
#define IS_This(o)              ((o)->h.cid == CLASS_This)
#define ASSERT_This(o)          DEBUG_ASSERT(((o)->h.cid == CLASS_This))
#define ACLASS_This             knh_class_Array(ctx, CLASS_This)
#define ICLASS_This             knh_class_Iterator(ctx, CLASS_This)
#define TYPE_This               CLASS_This
#define NNTYPE_This             TYPE_TONNTYPE(CLASS_This)
#define ATYPE_This              knh_class_Array(ctx, CLASS_This)
#define ITYPE_This              knh_class_Iterator(ctx, CLASS_This)
#define CLASS_pThis             CLASS_PMZ(CLASS_This)
#define TYPE_pThis              TYPE_PMZ(CLASS_This)
#define NNTYPE_pThis            TYPE_TONNTYPE(CLASS_pThis)
#define CFLAG_This              ((knh_flag_t)0)
#define FLAG_This               KNH_FLAG_CF2OF(CFLAG_This)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Any1 */
#define STRUCT_Any1             ((knh_struct_t)3)
#define CLASS_Any1              ((knh_class_t)3)
#define IS_bAny1(o)             ((o)->h.bcid == CLASS_Any1)
#ifndef Any1
#define Any1                    knh_Any1_t
#endif
#define IS_Any1(o)              ((o)->h.cid == CLASS_Any1)
#define ASSERT_Any1(o)          DEBUG_ASSERT(((o)->h.cid == CLASS_Any1))
#define ACLASS_Any1             knh_class_Array(ctx, CLASS_Any1)
#define ICLASS_Any1             knh_class_Iterator(ctx, CLASS_Any1)
#define TYPE_Any1               CLASS_Any1
#define NNTYPE_Any1             TYPE_TONNTYPE(CLASS_Any1)
#define ATYPE_Any1              knh_class_Array(ctx, CLASS_Any1)
#define ITYPE_Any1              knh_class_Iterator(ctx, CLASS_Any1)
#define CLASS_pAny1             CLASS_PMZ(CLASS_Any1)
#define TYPE_pAny1              TYPE_PMZ(CLASS_Any1)
#define NNTYPE_pAny1            TYPE_TONNTYPE(CLASS_pAny1)
#define CFLAG_Any1              ((knh_flag_t)0)
#define FLAG_Any1               KNH_FLAG_CF2OF(CFLAG_Any1)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Any2 */
#define STRUCT_Any2             ((knh_struct_t)4)
#define CLASS_Any2              ((knh_class_t)4)
#define IS_bAny2(o)             ((o)->h.bcid == CLASS_Any2)
#ifndef Any2
#define Any2                    knh_Any2_t
#endif
#define IS_Any2(o)              ((o)->h.cid == CLASS_Any2)
#define ASSERT_Any2(o)          DEBUG_ASSERT(((o)->h.cid == CLASS_Any2))
#define ACLASS_Any2             knh_class_Array(ctx, CLASS_Any2)
#define ICLASS_Any2             knh_class_Iterator(ctx, CLASS_Any2)
#define TYPE_Any2               CLASS_Any2
#define NNTYPE_Any2             TYPE_TONNTYPE(CLASS_Any2)
#define ATYPE_Any2              knh_class_Array(ctx, CLASS_Any2)
#define ITYPE_Any2              knh_class_Iterator(ctx, CLASS_Any2)
#define CLASS_pAny2             CLASS_PMZ(CLASS_Any2)
#define TYPE_pAny2              TYPE_PMZ(CLASS_Any2)
#define NNTYPE_pAny2            TYPE_TONNTYPE(CLASS_pAny2)
#define CFLAG_Any2              ((knh_flag_t)0)
#define FLAG_Any2               KNH_FLAG_CF2OF(CFLAG_Any2)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Nue */
#define STRUCT_Nue              ((knh_struct_t)5)
#define CLASS_Nue               ((knh_class_t)5)
#define IS_bNue(o)              ((o)->h.bcid == CLASS_Nue)
#ifndef Nue
#define Nue                     knh_Nue_t
#endif
#define IS_Nue(o)               ((o)->h.cid == CLASS_Nue)
#define ASSERT_Nue(o)           DEBUG_ASSERT(((o)->h.cid == CLASS_Nue))
#define ACLASS_Nue              knh_class_Array(ctx, CLASS_Nue)
#define ICLASS_Nue              knh_class_Iterator(ctx, CLASS_Nue)
#define TYPE_Nue                CLASS_Nue
#define NNTYPE_Nue              TYPE_TONNTYPE(CLASS_Nue)
#define ATYPE_Nue               knh_class_Array(ctx, CLASS_Nue)
#define ITYPE_Nue               knh_class_Iterator(ctx, CLASS_Nue)
#define CLASS_pNue              CLASS_PMZ(CLASS_Nue)
#define TYPE_pNue               TYPE_PMZ(CLASS_Nue)
#define NNTYPE_pNue             TYPE_TONNTYPE(CLASS_pNue)
#define CFLAG_Nue               ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_Nue                KNH_FLAG_CF2OF(CFLAG_Nue)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Boolean */
#define STRUCT_Boolean          ((knh_struct_t)6)
#define CLASS_Boolean           ((knh_class_t)6)
#define IS_bBoolean(o)          ((o)->h.bcid == CLASS_Boolean)
#ifndef Boolean
#define Boolean                 knh_Boolean_t
#endif
#define IS_Boolean(o)           ((o)->h.cid == CLASS_Boolean)
#define ASSERT_Boolean(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_Boolean))
#define ACLASS_Boolean          knh_class_Array(ctx, CLASS_Boolean)
#define ICLASS_Boolean          knh_class_Iterator(ctx, CLASS_Boolean)
#define TYPE_Boolean            CLASS_Boolean
#define NNTYPE_Boolean          TYPE_TONNTYPE(CLASS_Boolean)
#define ATYPE_Boolean           knh_class_Array(ctx, CLASS_Boolean)
#define ITYPE_Boolean           knh_class_Iterator(ctx, CLASS_Boolean)
#define CLASS_pBoolean          CLASS_PMZ(CLASS_Boolean)
#define TYPE_pBoolean           TYPE_PMZ(CLASS_Boolean)
#define NNTYPE_pBoolean         TYPE_TONNTYPE(CLASS_pBoolean)
#define CFLAG_Boolean           ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_Boolean            KNH_FLAG_CF2OF(CFLAG_Boolean)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Number */
#define STRUCT_Number           ((knh_struct_t)7)
#define CLASS_Number            ((knh_class_t)7)
#define IS_bNumber(o)           ((o)->h.bcid == CLASS_Number)
#ifndef Number
#define Number                  knh_Number_t
#endif
#define IS_Number(o)            ((o)->h.cid == CLASS_Number)
#define ASSERT_Number(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_Number))
#define ACLASS_Number           knh_class_Array(ctx, CLASS_Number)
#define ICLASS_Number           knh_class_Iterator(ctx, CLASS_Number)
#define TYPE_Number             CLASS_Number
#define NNTYPE_Number           TYPE_TONNTYPE(CLASS_Number)
#define ATYPE_Number            knh_class_Array(ctx, CLASS_Number)
#define ITYPE_Number            knh_class_Iterator(ctx, CLASS_Number)
#define CLASS_pNumber           CLASS_PMZ(CLASS_Number)
#define TYPE_pNumber            TYPE_PMZ(CLASS_Number)
#define NNTYPE_pNumber          TYPE_TONNTYPE(CLASS_pNumber)
#define CFLAG_Number            ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_Number             KNH_FLAG_CF2OF(CFLAG_Number)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Int */
#define STRUCT_Int              ((knh_struct_t)8)
#define CLASS_Int               ((knh_class_t)8)
#define IS_bInt(o)              ((o)->h.bcid == CLASS_Int)
#ifndef Int
#define Int                     knh_Int_t
#endif
#define IS_Int(o)               ((o)->h.cid == CLASS_Int)
#define ASSERT_Int(o)           DEBUG_ASSERT(((o)->h.cid == CLASS_Int))
#define ACLASS_Int              knh_class_Array(ctx, CLASS_Int)
#define ICLASS_Int              knh_class_Iterator(ctx, CLASS_Int)
#define TYPE_Int                CLASS_Int
#define NNTYPE_Int              TYPE_TONNTYPE(CLASS_Int)
#define ATYPE_Int               knh_class_Array(ctx, CLASS_Int)
#define ITYPE_Int               knh_class_Iterator(ctx, CLASS_Int)
#define CLASS_pInt              CLASS_PMZ(CLASS_Int)
#define TYPE_pInt               TYPE_PMZ(CLASS_Int)
#define NNTYPE_pInt             TYPE_TONNTYPE(CLASS_pInt)
#define CFLAG_Int               ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_Int                KNH_FLAG_CF2OF(CFLAG_Int)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* IntX */
#define STRUCT_IntX             ((knh_struct_t)9)
#define CLASS_IntX              ((knh_class_t)9)
#define IS_bIntX(o)             ((o)->h.bcid == CLASS_IntX)
#ifndef IntX
#define IntX                    knh_IntX_t
#endif
#define IS_IntX(o)              ((o)->h.cid == CLASS_IntX)
#define ASSERT_IntX(o)          DEBUG_ASSERT(((o)->h.cid == CLASS_IntX))
#define ACLASS_IntX             knh_class_Array(ctx, CLASS_IntX)
#define ICLASS_IntX             knh_class_Iterator(ctx, CLASS_IntX)
#define TYPE_IntX               CLASS_IntX
#define NNTYPE_IntX             TYPE_TONNTYPE(CLASS_IntX)
#define ATYPE_IntX              knh_class_Array(ctx, CLASS_IntX)
#define ITYPE_IntX              knh_class_Iterator(ctx, CLASS_IntX)
#define CLASS_pIntX             CLASS_PMZ(CLASS_IntX)
#define TYPE_pIntX              TYPE_PMZ(CLASS_IntX)
#define NNTYPE_pIntX            TYPE_TONNTYPE(CLASS_pIntX)
#define CFLAG_IntX              ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_IntX               KNH_FLAG_CF2OF(CFLAG_IntX)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Int64 */
#define STRUCT_Int64            ((knh_struct_t)10)
#define CLASS_Int64             ((knh_class_t)10)
#define IS_bInt64(o)            ((o)->h.bcid == CLASS_Int64)
#ifndef Int64
#define Int64                   knh_Int64_t
#endif
#define IS_Int64(o)             ((o)->h.cid == CLASS_Int64)
#define ASSERT_Int64(o)         DEBUG_ASSERT(((o)->h.cid == CLASS_Int64))
#define ACLASS_Int64            knh_class_Array(ctx, CLASS_Int64)
#define ICLASS_Int64            knh_class_Iterator(ctx, CLASS_Int64)
#define TYPE_Int64              CLASS_Int64
#define NNTYPE_Int64            TYPE_TONNTYPE(CLASS_Int64)
#define ATYPE_Int64             knh_class_Array(ctx, CLASS_Int64)
#define ITYPE_Int64             knh_class_Iterator(ctx, CLASS_Int64)
#define CLASS_pInt64            CLASS_PMZ(CLASS_Int64)
#define TYPE_pInt64             TYPE_PMZ(CLASS_Int64)
#define NNTYPE_pInt64           TYPE_TONNTYPE(CLASS_pInt64)
#define CFLAG_Int64             ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_Int64              KNH_FLAG_CF2OF(CFLAG_Int64)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Int64X */
#define STRUCT_Int64X           ((knh_struct_t)11)
#define CLASS_Int64X            ((knh_class_t)11)
#define IS_bInt64X(o)           ((o)->h.bcid == CLASS_Int64X)
#ifndef Int64X
#define Int64X                  knh_Int64X_t
#endif
#define IS_Int64X(o)            ((o)->h.cid == CLASS_Int64X)
#define ASSERT_Int64X(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_Int64X))
#define ACLASS_Int64X           knh_class_Array(ctx, CLASS_Int64X)
#define ICLASS_Int64X           knh_class_Iterator(ctx, CLASS_Int64X)
#define TYPE_Int64X             CLASS_Int64X
#define NNTYPE_Int64X           TYPE_TONNTYPE(CLASS_Int64X)
#define ATYPE_Int64X            knh_class_Array(ctx, CLASS_Int64X)
#define ITYPE_Int64X            knh_class_Iterator(ctx, CLASS_Int64X)
#define CLASS_pInt64X           CLASS_PMZ(CLASS_Int64X)
#define TYPE_pInt64X            TYPE_PMZ(CLASS_Int64X)
#define NNTYPE_pInt64X          TYPE_TONNTYPE(CLASS_pInt64X)
#define CFLAG_Int64X            ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_Int64X             KNH_FLAG_CF2OF(CFLAG_Int64X)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Float */
#define STRUCT_Float            ((knh_struct_t)12)
#define CLASS_Float             ((knh_class_t)12)
#define IS_bFloat(o)            ((o)->h.bcid == CLASS_Float)
#ifndef Float
#define Float                   knh_Float_t
#endif
#define IS_Float(o)             ((o)->h.cid == CLASS_Float)
#define ASSERT_Float(o)         DEBUG_ASSERT(((o)->h.cid == CLASS_Float))
#define ACLASS_Float            knh_class_Array(ctx, CLASS_Float)
#define ICLASS_Float            knh_class_Iterator(ctx, CLASS_Float)
#define TYPE_Float              CLASS_Float
#define NNTYPE_Float            TYPE_TONNTYPE(CLASS_Float)
#define ATYPE_Float             knh_class_Array(ctx, CLASS_Float)
#define ITYPE_Float             knh_class_Iterator(ctx, CLASS_Float)
#define CLASS_pFloat            CLASS_PMZ(CLASS_Float)
#define TYPE_pFloat             TYPE_PMZ(CLASS_Float)
#define NNTYPE_pFloat           TYPE_TONNTYPE(CLASS_pFloat)
#define CFLAG_Float             ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_Float              KNH_FLAG_CF2OF(CFLAG_Float)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* FloatX */
#define STRUCT_FloatX           ((knh_struct_t)13)
#define CLASS_FloatX            ((knh_class_t)13)
#define IS_bFloatX(o)           ((o)->h.bcid == CLASS_FloatX)
#ifndef FloatX
#define FloatX                  knh_FloatX_t
#endif
#define IS_FloatX(o)            ((o)->h.cid == CLASS_FloatX)
#define ASSERT_FloatX(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_FloatX))
#define ACLASS_FloatX           knh_class_Array(ctx, CLASS_FloatX)
#define ICLASS_FloatX           knh_class_Iterator(ctx, CLASS_FloatX)
#define TYPE_FloatX             CLASS_FloatX
#define NNTYPE_FloatX           TYPE_TONNTYPE(CLASS_FloatX)
#define ATYPE_FloatX            knh_class_Array(ctx, CLASS_FloatX)
#define ITYPE_FloatX            knh_class_Iterator(ctx, CLASS_FloatX)
#define CLASS_pFloatX           CLASS_PMZ(CLASS_FloatX)
#define TYPE_pFloatX            TYPE_PMZ(CLASS_FloatX)
#define NNTYPE_pFloatX          TYPE_TONNTYPE(CLASS_pFloatX)
#define CFLAG_FloatX            ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_FloatX             KNH_FLAG_CF2OF(CFLAG_FloatX)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* String */
#define STRUCT_String           ((knh_struct_t)14)
#define CLASS_String            ((knh_class_t)14)
#define IS_bString(o)           ((o)->h.bcid == CLASS_String)
#ifndef String
#define String                  knh_String_t
#endif
#define IS_String(o)            ((o)->h.cid == CLASS_String)
#define ASSERT_String(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_String))
#define ACLASS_String           knh_class_Array(ctx, CLASS_String)
#define ICLASS_String           knh_class_Iterator(ctx, CLASS_String)
#define TYPE_String             CLASS_String
#define NNTYPE_String           TYPE_TONNTYPE(CLASS_String)
#define ATYPE_String            knh_class_Array(ctx, CLASS_String)
#define ITYPE_String            knh_class_Iterator(ctx, CLASS_String)
#define CLASS_pString           CLASS_PMZ(CLASS_String)
#define TYPE_pString            TYPE_PMZ(CLASS_String)
#define NNTYPE_pString          TYPE_TONNTYPE(CLASS_pString)
#define CFLAG_String            ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_String             KNH_FLAG_CF2OF(CFLAG_String)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* StringX */
#define STRUCT_StringX          ((knh_struct_t)15)
#define CLASS_StringX           ((knh_class_t)15)
#define IS_bStringX(o)          ((o)->h.bcid == CLASS_StringX)
#ifndef StringX
#define StringX                 knh_StringX_t
#endif
#define IS_StringX(o)           ((o)->h.cid == CLASS_StringX)
#define ASSERT_StringX(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_StringX))
#define ACLASS_StringX          knh_class_Array(ctx, CLASS_StringX)
#define ICLASS_StringX          knh_class_Iterator(ctx, CLASS_StringX)
#define TYPE_StringX            CLASS_StringX
#define NNTYPE_StringX          TYPE_TONNTYPE(CLASS_StringX)
#define ATYPE_StringX           knh_class_Array(ctx, CLASS_StringX)
#define ITYPE_StringX           knh_class_Iterator(ctx, CLASS_StringX)
#define CLASS_pStringX          CLASS_PMZ(CLASS_StringX)
#define TYPE_pStringX           TYPE_PMZ(CLASS_StringX)
#define NNTYPE_pStringX         TYPE_TONNTYPE(CLASS_pStringX)
#define CFLAG_StringX           ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_StringX            KNH_FLAG_CF2OF(CFLAG_StringX)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Bytes */
#define STRUCT_Bytes            ((knh_struct_t)16)
#define CLASS_Bytes             ((knh_class_t)16)
#define IS_bBytes(o)            ((o)->h.bcid == CLASS_Bytes)
#ifndef Bytes
#define Bytes                   knh_Bytes_t
#endif
#define IS_Bytes(o)             ((o)->h.cid == CLASS_Bytes)
#define ASSERT_Bytes(o)         DEBUG_ASSERT(((o)->h.cid == CLASS_Bytes))
#define ACLASS_Bytes            knh_class_Array(ctx, CLASS_Bytes)
#define ICLASS_Bytes            knh_class_Iterator(ctx, CLASS_Bytes)
#define TYPE_Bytes              CLASS_Bytes
#define NNTYPE_Bytes            TYPE_TONNTYPE(CLASS_Bytes)
#define ATYPE_Bytes             knh_class_Array(ctx, CLASS_Bytes)
#define ITYPE_Bytes             knh_class_Iterator(ctx, CLASS_Bytes)
#define CLASS_pBytes            CLASS_PMZ(CLASS_Bytes)
#define TYPE_pBytes             TYPE_PMZ(CLASS_Bytes)
#define NNTYPE_pBytes           TYPE_TONNTYPE(CLASS_pBytes)
#define CFLAG_Bytes             ((knh_flag_t)0)
#define FLAG_Bytes              KNH_FLAG_CF2OF(CFLAG_Bytes)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Tuple2 */
#define STRUCT_Tuple2           ((knh_struct_t)17)
#define CLASS_Tuple2            ((knh_class_t)17)
#define IS_bTuple2(o)           ((o)->h.bcid == CLASS_Tuple2)
#ifndef Tuple2
#define Tuple2                  knh_Tuple2_t
#endif
#define IS_Tuple2(o)            ((o)->h.cid == CLASS_Tuple2)
#define ASSERT_Tuple2(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_Tuple2))
#define ACLASS_Tuple2           knh_class_Array(ctx, CLASS_Tuple2)
#define ICLASS_Tuple2           knh_class_Iterator(ctx, CLASS_Tuple2)
#define TYPE_Tuple2             CLASS_Tuple2
#define NNTYPE_Tuple2           TYPE_TONNTYPE(CLASS_Tuple2)
#define ATYPE_Tuple2            knh_class_Array(ctx, CLASS_Tuple2)
#define ITYPE_Tuple2            knh_class_Iterator(ctx, CLASS_Tuple2)
#define CLASS_pTuple2           CLASS_PMZ(CLASS_Tuple2)
#define TYPE_pTuple2            TYPE_PMZ(CLASS_Tuple2)
#define NNTYPE_pTuple2          TYPE_TONNTYPE(CLASS_pTuple2)
#define CFLAG_Tuple2            ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_Tuple2             KNH_FLAG_CF2OF(CFLAG_Tuple2)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Range */
#define STRUCT_Range            ((knh_struct_t)18)
#define CLASS_Range             ((knh_class_t)18)
#define IS_bRange(o)            ((o)->h.bcid == CLASS_Range)
#ifndef Range
#define Range                   knh_Range_t
#endif
#define IS_Range(o)             ((o)->h.cid == CLASS_Range)
#define ASSERT_Range(o)         DEBUG_ASSERT(((o)->h.cid == CLASS_Range))
#define ACLASS_Range            knh_class_Array(ctx, CLASS_Range)
#define ICLASS_Range            knh_class_Iterator(ctx, CLASS_Range)
#define TYPE_Range              CLASS_Range
#define NNTYPE_Range            TYPE_TONNTYPE(CLASS_Range)
#define ATYPE_Range             knh_class_Array(ctx, CLASS_Range)
#define ITYPE_Range             knh_class_Iterator(ctx, CLASS_Range)
#define CLASS_pRange            CLASS_PMZ(CLASS_Range)
#define TYPE_pRange             TYPE_PMZ(CLASS_Range)
#define NNTYPE_pRange           TYPE_TONNTYPE(CLASS_pRange)
#define CFLAG_Range             ((knh_flag_t)KNH_FLAG_CF_IMMUTABLE)
#define FLAG_Range              KNH_FLAG_CF2OF(CFLAG_Range)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Array */
#define STRUCT_Array            ((knh_struct_t)19)
#define CLASS_Array             ((knh_class_t)19)
#define IS_bArray(o)            ((o)->h.bcid == CLASS_Array)
#ifndef Array
#define Array                   knh_Array_t
#endif
#define IS_Array(o)             ((o)->h.cid == CLASS_Array)
#define ASSERT_Array(o)         DEBUG_ASSERT(((o)->h.cid == CLASS_Array))
#define ACLASS_Array            knh_class_Array(ctx, CLASS_Array)
#define ICLASS_Array            knh_class_Iterator(ctx, CLASS_Array)
#define TYPE_Array              CLASS_Array
#define NNTYPE_Array            TYPE_TONNTYPE(CLASS_Array)
#define ATYPE_Array             knh_class_Array(ctx, CLASS_Array)
#define ITYPE_Array             knh_class_Iterator(ctx, CLASS_Array)
#define CLASS_pArray            CLASS_PMZ(CLASS_Array)
#define TYPE_pArray             TYPE_PMZ(CLASS_Array)
#define NNTYPE_pArray           TYPE_TONNTYPE(CLASS_pArray)
#define CFLAG_Array             ((knh_flag_t)KNH_FLAG_CF_CYCLIC)
#define FLAG_Array              KNH_FLAG_CF2OF(CFLAG_Array)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* DictMap2 */
#define STRUCT_DictMap2         ((knh_struct_t)20)
#define CLASS_DictMap2          ((knh_class_t)20)
#define IS_bDictMap2(o)         ((o)->h.bcid == CLASS_DictMap2)
#ifndef DictMap2
#define DictMap2                knh_DictMap2_t
#endif
#define IS_DictMap2(o)          ((o)->h.cid == CLASS_DictMap2)
#define ASSERT_DictMap2(o)      DEBUG_ASSERT(((o)->h.cid == CLASS_DictMap2))
#define ACLASS_DictMap2         knh_class_Array(ctx, CLASS_DictMap2)
#define ICLASS_DictMap2         knh_class_Iterator(ctx, CLASS_DictMap2)
#define TYPE_DictMap2           CLASS_DictMap2
#define NNTYPE_DictMap2         TYPE_TONNTYPE(CLASS_DictMap2)
#define ATYPE_DictMap2          knh_class_Array(ctx, CLASS_DictMap2)
#define ITYPE_DictMap2          knh_class_Iterator(ctx, CLASS_DictMap2)
#define CLASS_pDictMap2         CLASS_PMZ(CLASS_DictMap2)
#define TYPE_pDictMap2          TYPE_PMZ(CLASS_DictMap2)
#define NNTYPE_pDictMap2        TYPE_TONNTYPE(CLASS_pDictMap2)
#define CFLAG_DictMap2          ((knh_flag_t)KNH_FLAG_CF_CYCLIC)
#define FLAG_DictMap2           KNH_FLAG_CF2OF(CFLAG_DictMap2)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* DictSet2 */
#define STRUCT_DictSet2         ((knh_struct_t)21)
#define CLASS_DictSet2          ((knh_class_t)21)
#define IS_bDictSet2(o)         ((o)->h.bcid == CLASS_DictSet2)
#ifndef DictSet2
#define DictSet2                knh_DictSet2_t
#endif
#define IS_DictSet2(o)          ((o)->h.cid == CLASS_DictSet2)
#define ASSERT_DictSet2(o)      DEBUG_ASSERT(((o)->h.cid == CLASS_DictSet2))
#define ACLASS_DictSet2         knh_class_Array(ctx, CLASS_DictSet2)
#define ICLASS_DictSet2         knh_class_Iterator(ctx, CLASS_DictSet2)
#define TYPE_DictSet2           CLASS_DictSet2
#define NNTYPE_DictSet2         TYPE_TONNTYPE(CLASS_DictSet2)
#define ATYPE_DictSet2          knh_class_Array(ctx, CLASS_DictSet2)
#define ITYPE_DictSet2          knh_class_Iterator(ctx, CLASS_DictSet2)
#define CLASS_pDictSet2         CLASS_PMZ(CLASS_DictSet2)
#define TYPE_pDictSet2          TYPE_PMZ(CLASS_DictSet2)
#define NNTYPE_pDictSet2        TYPE_TONNTYPE(CLASS_pDictSet2)
#define CFLAG_DictSet2          ((knh_flag_t)KNH_FLAG_CF_CYCLIC)
#define FLAG_DictSet2           KNH_FLAG_CF2OF(CFLAG_DictSet2)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* DictMap */
#define STRUCT_DictMap          ((knh_struct_t)22)
#define CLASS_DictMap           ((knh_class_t)22)
#define IS_bDictMap(o)          ((o)->h.bcid == CLASS_DictMap)
#ifndef DictMap
#define DictMap                 knh_DictMap_t
#endif
#define IS_DictMap(o)           ((o)->h.cid == CLASS_DictMap)
#define ASSERT_DictMap(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_DictMap))
#define ACLASS_DictMap          knh_class_Array(ctx, CLASS_DictMap)
#define ICLASS_DictMap          knh_class_Iterator(ctx, CLASS_DictMap)
#define TYPE_DictMap            CLASS_DictMap
#define NNTYPE_DictMap          TYPE_TONNTYPE(CLASS_DictMap)
#define ATYPE_DictMap           knh_class_Array(ctx, CLASS_DictMap)
#define ITYPE_DictMap           knh_class_Iterator(ctx, CLASS_DictMap)
#define CLASS_pDictMap          CLASS_PMZ(CLASS_DictMap)
#define TYPE_pDictMap           TYPE_PMZ(CLASS_DictMap)
#define NNTYPE_pDictMap         TYPE_TONNTYPE(CLASS_pDictMap)
#define CFLAG_DictMap           ((knh_flag_t)0)
#define FLAG_DictMap            KNH_FLAG_CF2OF(CFLAG_DictMap)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* DictSet */
#define STRUCT_DictSet          ((knh_struct_t)23)
#define CLASS_DictSet           ((knh_class_t)23)
#define IS_bDictSet(o)          ((o)->h.bcid == CLASS_DictSet)
#ifndef DictSet
#define DictSet                 knh_DictSet_t
#endif
#define IS_DictSet(o)           ((o)->h.cid == CLASS_DictSet)
#define ASSERT_DictSet(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_DictSet))
#define ACLASS_DictSet          knh_class_Array(ctx, CLASS_DictSet)
#define ICLASS_DictSet          knh_class_Iterator(ctx, CLASS_DictSet)
#define TYPE_DictSet            CLASS_DictSet
#define NNTYPE_DictSet          TYPE_TONNTYPE(CLASS_DictSet)
#define ATYPE_DictSet           knh_class_Array(ctx, CLASS_DictSet)
#define ITYPE_DictSet           knh_class_Iterator(ctx, CLASS_DictSet)
#define CLASS_pDictSet          CLASS_PMZ(CLASS_DictSet)
#define TYPE_pDictSet           TYPE_PMZ(CLASS_DictSet)
#define NNTYPE_pDictSet         TYPE_TONNTYPE(CLASS_pDictSet)
#define CFLAG_DictSet           ((knh_flag_t)0)
#define FLAG_DictSet            KNH_FLAG_CF2OF(CFLAG_DictSet)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* HashMap */
#define STRUCT_HashMap          ((knh_struct_t)24)
#define CLASS_HashMap           ((knh_class_t)24)
#define IS_bHashMap(o)          ((o)->h.bcid == CLASS_HashMap)
#ifndef HashMap
#define HashMap                 knh_HashMap_t
#endif
#define IS_HashMap(o)           ((o)->h.cid == CLASS_HashMap)
#define ASSERT_HashMap(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_HashMap))
#define ACLASS_HashMap          knh_class_Array(ctx, CLASS_HashMap)
#define ICLASS_HashMap          knh_class_Iterator(ctx, CLASS_HashMap)
#define TYPE_HashMap            CLASS_HashMap
#define NNTYPE_HashMap          TYPE_TONNTYPE(CLASS_HashMap)
#define ATYPE_HashMap           knh_class_Array(ctx, CLASS_HashMap)
#define ITYPE_HashMap           knh_class_Iterator(ctx, CLASS_HashMap)
#define CLASS_pHashMap          CLASS_PMZ(CLASS_HashMap)
#define TYPE_pHashMap           TYPE_PMZ(CLASS_HashMap)
#define NNTYPE_pHashMap         TYPE_TONNTYPE(CLASS_pHashMap)
#define CFLAG_HashMap           ((knh_flag_t)0)
#define FLAG_HashMap            KNH_FLAG_CF2OF(CFLAG_HashMap)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* HashSet */
#define STRUCT_HashSet          ((knh_struct_t)25)
#define CLASS_HashSet           ((knh_class_t)25)
#define IS_bHashSet(o)          ((o)->h.bcid == CLASS_HashSet)
#ifndef HashSet
#define HashSet                 knh_HashSet_t
#endif
#define IS_HashSet(o)           ((o)->h.cid == CLASS_HashSet)
#define ASSERT_HashSet(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_HashSet))
#define ACLASS_HashSet          knh_class_Array(ctx, CLASS_HashSet)
#define ICLASS_HashSet          knh_class_Iterator(ctx, CLASS_HashSet)
#define TYPE_HashSet            CLASS_HashSet
#define NNTYPE_HashSet          TYPE_TONNTYPE(CLASS_HashSet)
#define ATYPE_HashSet           knh_class_Array(ctx, CLASS_HashSet)
#define ITYPE_HashSet           knh_class_Iterator(ctx, CLASS_HashSet)
#define CLASS_pHashSet          CLASS_PMZ(CLASS_HashSet)
#define TYPE_pHashSet           TYPE_PMZ(CLASS_HashSet)
#define NNTYPE_pHashSet         TYPE_TONNTYPE(CLASS_pHashSet)
#define CFLAG_HashSet           ((knh_flag_t)0)
#define FLAG_HashSet            KNH_FLAG_CF2OF(CFLAG_HashSet)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Iterator */
#define STRUCT_Iterator         ((knh_struct_t)26)
#define CLASS_Iterator          ((knh_class_t)26)
#define IS_bIterator(o)         ((o)->h.bcid == CLASS_Iterator)
#ifndef Iterator
#define Iterator                knh_Iterator_t
#endif
#define IS_Iterator(o)          ((o)->h.cid == CLASS_Iterator)
#define ASSERT_Iterator(o)      DEBUG_ASSERT(((o)->h.cid == CLASS_Iterator))
#define ACLASS_Iterator         knh_class_Array(ctx, CLASS_Iterator)
#define ICLASS_Iterator         knh_class_Iterator(ctx, CLASS_Iterator)
#define TYPE_Iterator           CLASS_Iterator
#define NNTYPE_Iterator         TYPE_TONNTYPE(CLASS_Iterator)
#define ATYPE_Iterator          knh_class_Array(ctx, CLASS_Iterator)
#define ITYPE_Iterator          knh_class_Iterator(ctx, CLASS_Iterator)
#define CLASS_pIterator         CLASS_PMZ(CLASS_Iterator)
#define TYPE_pIterator          TYPE_PMZ(CLASS_Iterator)
#define NNTYPE_pIterator        TYPE_TONNTYPE(CLASS_pIterator)
#define CFLAG_Iterator          ((knh_flag_t)0)
#define FLAG_Iterator           KNH_FLAG_CF2OF(CFLAG_Iterator)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* DictIdx */
#define STRUCT_DictIdx          ((knh_struct_t)27)
#define CLASS_DictIdx           ((knh_class_t)27)
#define IS_bDictIdx(o)          ((o)->h.bcid == CLASS_DictIdx)
#ifndef DictIdx
#define DictIdx                 knh_DictIdx_t
#endif
#define IS_DictIdx(o)           ((o)->h.cid == CLASS_DictIdx)
#define ASSERT_DictIdx(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_DictIdx))
#define ACLASS_DictIdx          knh_class_Array(ctx, CLASS_DictIdx)
#define ICLASS_DictIdx          knh_class_Iterator(ctx, CLASS_DictIdx)
#define TYPE_DictIdx            CLASS_DictIdx
#define NNTYPE_DictIdx          TYPE_TONNTYPE(CLASS_DictIdx)
#define ATYPE_DictIdx           knh_class_Array(ctx, CLASS_DictIdx)
#define ITYPE_DictIdx           knh_class_Iterator(ctx, CLASS_DictIdx)
#define CLASS_pDictIdx          CLASS_PMZ(CLASS_DictIdx)
#define TYPE_pDictIdx           TYPE_PMZ(CLASS_DictIdx)
#define NNTYPE_pDictIdx         TYPE_TONNTYPE(CLASS_pDictIdx)
#define CFLAG_DictIdx           ((knh_flag_t)0)
#define FLAG_DictIdx            KNH_FLAG_CF2OF(CFLAG_DictIdx)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Class */
#define STRUCT_Class            ((knh_struct_t)28)
#define CLASS_Class             ((knh_class_t)28)
#define IS_bClass(o)            ((o)->h.bcid == CLASS_Class)
#ifndef Class
#define Class                   knh_Class_t
#endif
#define IS_Class(o)             ((o)->h.cid == CLASS_Class)
#define ASSERT_Class(o)         DEBUG_ASSERT(((o)->h.cid == CLASS_Class))
#define ACLASS_Class            knh_class_Array(ctx, CLASS_Class)
#define ICLASS_Class            knh_class_Iterator(ctx, CLASS_Class)
#define TYPE_Class              CLASS_Class
#define NNTYPE_Class            TYPE_TONNTYPE(CLASS_Class)
#define ATYPE_Class             knh_class_Array(ctx, CLASS_Class)
#define ITYPE_Class             knh_class_Iterator(ctx, CLASS_Class)
#define CLASS_pClass            CLASS_PMZ(CLASS_Class)
#define TYPE_pClass             TYPE_PMZ(CLASS_Class)
#define NNTYPE_pClass           TYPE_TONNTYPE(CLASS_pClass)
#define CFLAG_Class             ((knh_flag_t)0)
#define FLAG_Class              KNH_FLAG_CF2OF(CFLAG_Class)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* ClassStruct */
#define STRUCT_ClassStruct      ((knh_struct_t)29)
#define CLASS_ClassStruct       ((knh_class_t)29)
#define IS_bClassStruct(o)      ((o)->h.bcid == CLASS_ClassStruct)
#ifndef ClassStruct
#define ClassStruct             knh_ClassStruct_t
#endif
#define IS_ClassStruct(o)       ((o)->h.cid == CLASS_ClassStruct)
#define ASSERT_ClassStruct(o)   DEBUG_ASSERT(((o)->h.cid == CLASS_ClassStruct))
#define ACLASS_ClassStruct      knh_class_Array(ctx, CLASS_ClassStruct)
#define ICLASS_ClassStruct      knh_class_Iterator(ctx, CLASS_ClassStruct)
#define TYPE_ClassStruct        CLASS_ClassStruct
#define NNTYPE_ClassStruct      TYPE_TONNTYPE(CLASS_ClassStruct)
#define ATYPE_ClassStruct       knh_class_Array(ctx, CLASS_ClassStruct)
#define ITYPE_ClassStruct       knh_class_Iterator(ctx, CLASS_ClassStruct)
#define CLASS_pClassStruct      CLASS_PMZ(CLASS_ClassStruct)
#define TYPE_pClassStruct       TYPE_PMZ(CLASS_ClassStruct)
#define NNTYPE_pClassStruct     TYPE_TONNTYPE(CLASS_pClassStruct)
#define CFLAG_ClassStruct       ((knh_flag_t)KNH_FLAG_CF_PRIVATE)
#define FLAG_ClassStruct        KNH_FLAG_CF2OF(CFLAG_ClassStruct)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* MethodField */
#define STRUCT_MethodField      ((knh_struct_t)30)
#define CLASS_MethodField       ((knh_class_t)30)
#define IS_bMethodField(o)      ((o)->h.bcid == CLASS_MethodField)
#ifndef MethodField
#define MethodField             knh_MethodField_t
#endif
#define IS_MethodField(o)       ((o)->h.cid == CLASS_MethodField)
#define ASSERT_MethodField(o)   DEBUG_ASSERT(((o)->h.cid == CLASS_MethodField))
#define ACLASS_MethodField      knh_class_Array(ctx, CLASS_MethodField)
#define ICLASS_MethodField      knh_class_Iterator(ctx, CLASS_MethodField)
#define TYPE_MethodField        CLASS_MethodField
#define NNTYPE_MethodField      TYPE_TONNTYPE(CLASS_MethodField)
#define ATYPE_MethodField       knh_class_Array(ctx, CLASS_MethodField)
#define ITYPE_MethodField       knh_class_Iterator(ctx, CLASS_MethodField)
#define CLASS_pMethodField      CLASS_PMZ(CLASS_MethodField)
#define TYPE_pMethodField       TYPE_PMZ(CLASS_MethodField)
#define NNTYPE_pMethodField     TYPE_TONNTYPE(CLASS_pMethodField)
#define CFLAG_MethodField       ((knh_flag_t)0)
#define FLAG_MethodField        KNH_FLAG_CF2OF(CFLAG_MethodField)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Method */
#define STRUCT_Method           ((knh_struct_t)31)
#define CLASS_Method            ((knh_class_t)31)
#define IS_bMethod(o)           ((o)->h.bcid == CLASS_Method)
#ifndef Method
#define Method                  knh_Method_t
#endif
#define IS_Method(o)            ((o)->h.cid == CLASS_Method)
#define ASSERT_Method(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_Method))
#define ACLASS_Method           knh_class_Array(ctx, CLASS_Method)
#define ICLASS_Method           knh_class_Iterator(ctx, CLASS_Method)
#define TYPE_Method             CLASS_Method
#define NNTYPE_Method           TYPE_TONNTYPE(CLASS_Method)
#define ATYPE_Method            knh_class_Array(ctx, CLASS_Method)
#define ITYPE_Method            knh_class_Iterator(ctx, CLASS_Method)
#define CLASS_pMethod           CLASS_PMZ(CLASS_Method)
#define TYPE_pMethod            TYPE_PMZ(CLASS_Method)
#define NNTYPE_pMethod          TYPE_TONNTYPE(CLASS_pMethod)
#define CFLAG_Method            ((knh_flag_t)0)
#define FLAG_Method             KNH_FLAG_CF2OF(CFLAG_Method)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Mapper */
#define STRUCT_Mapper           ((knh_struct_t)32)
#define CLASS_Mapper            ((knh_class_t)32)
#define IS_bMapper(o)           ((o)->h.bcid == CLASS_Mapper)
#ifndef Mapper
#define Mapper                  knh_Mapper_t
#endif
#define IS_Mapper(o)            ((o)->h.cid == CLASS_Mapper)
#define ASSERT_Mapper(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_Mapper))
#define ACLASS_Mapper           knh_class_Array(ctx, CLASS_Mapper)
#define ICLASS_Mapper           knh_class_Iterator(ctx, CLASS_Mapper)
#define TYPE_Mapper             CLASS_Mapper
#define NNTYPE_Mapper           TYPE_TONNTYPE(CLASS_Mapper)
#define ATYPE_Mapper            knh_class_Array(ctx, CLASS_Mapper)
#define ITYPE_Mapper            knh_class_Iterator(ctx, CLASS_Mapper)
#define CLASS_pMapper           CLASS_PMZ(CLASS_Mapper)
#define TYPE_pMapper            TYPE_PMZ(CLASS_Mapper)
#define NNTYPE_pMapper          TYPE_TONNTYPE(CLASS_pMapper)
#define CFLAG_Mapper            ((knh_flag_t)0)
#define FLAG_Mapper             KNH_FLAG_CF2OF(CFLAG_Mapper)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* ClassMap */
#define STRUCT_ClassMap         ((knh_struct_t)33)
#define CLASS_ClassMap          ((knh_class_t)33)
#define IS_bClassMap(o)         ((o)->h.bcid == CLASS_ClassMap)
#ifndef ClassMap
#define ClassMap                knh_ClassMap_t
#endif
#define IS_ClassMap(o)          ((o)->h.cid == CLASS_ClassMap)
#define ASSERT_ClassMap(o)      DEBUG_ASSERT(((o)->h.cid == CLASS_ClassMap))
#define ACLASS_ClassMap         knh_class_Array(ctx, CLASS_ClassMap)
#define ICLASS_ClassMap         knh_class_Iterator(ctx, CLASS_ClassMap)
#define TYPE_ClassMap           CLASS_ClassMap
#define NNTYPE_ClassMap         TYPE_TONNTYPE(CLASS_ClassMap)
#define ATYPE_ClassMap          knh_class_Array(ctx, CLASS_ClassMap)
#define ITYPE_ClassMap          knh_class_Iterator(ctx, CLASS_ClassMap)
#define CLASS_pClassMap         CLASS_PMZ(CLASS_ClassMap)
#define TYPE_pClassMap          TYPE_PMZ(CLASS_ClassMap)
#define NNTYPE_pClassMap        TYPE_TONNTYPE(CLASS_pClassMap)
#define CFLAG_ClassMap          ((knh_flag_t)0)
#define FLAG_ClassMap           KNH_FLAG_CF2OF(CFLAG_ClassMap)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* AffineConv */
#define STRUCT_AffineConv       ((knh_struct_t)34)
#define CLASS_AffineConv        ((knh_class_t)34)
#define IS_bAffineConv(o)       ((o)->h.bcid == CLASS_AffineConv)
#ifndef AffineConv
#define AffineConv              knh_AffineConv_t
#endif
#define IS_AffineConv(o)        ((o)->h.cid == CLASS_AffineConv)
#define ASSERT_AffineConv(o)    DEBUG_ASSERT(((o)->h.cid == CLASS_AffineConv))
#define ACLASS_AffineConv       knh_class_Array(ctx, CLASS_AffineConv)
#define ICLASS_AffineConv       knh_class_Iterator(ctx, CLASS_AffineConv)
#define TYPE_AffineConv         CLASS_AffineConv
#define NNTYPE_AffineConv       TYPE_TONNTYPE(CLASS_AffineConv)
#define ATYPE_AffineConv        knh_class_Array(ctx, CLASS_AffineConv)
#define ITYPE_AffineConv        knh_class_Iterator(ctx, CLASS_AffineConv)
#define CLASS_pAffineConv       CLASS_PMZ(CLASS_AffineConv)
#define TYPE_pAffineConv        TYPE_PMZ(CLASS_AffineConv)
#define NNTYPE_pAffineConv      TYPE_TONNTYPE(CLASS_pAffineConv)
#define CFLAG_AffineConv        ((knh_flag_t)0)
#define FLAG_AffineConv         KNH_FLAG_CF2OF(CFLAG_AffineConv)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* IntUnit */
#define STRUCT_IntUnit          ((knh_struct_t)35)
#define CLASS_IntUnit           ((knh_class_t)35)
#define IS_bIntUnit(o)          ((o)->h.bcid == CLASS_IntUnit)
#ifndef IntUnit
#define IntUnit                 knh_IntUnit_t
#endif
#define IS_IntUnit(o)           ((o)->h.cid == CLASS_IntUnit)
#define ASSERT_IntUnit(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_IntUnit))
#define ACLASS_IntUnit          knh_class_Array(ctx, CLASS_IntUnit)
#define ICLASS_IntUnit          knh_class_Iterator(ctx, CLASS_IntUnit)
#define TYPE_IntUnit            CLASS_IntUnit
#define NNTYPE_IntUnit          TYPE_TONNTYPE(CLASS_IntUnit)
#define ATYPE_IntUnit           knh_class_Array(ctx, CLASS_IntUnit)
#define ITYPE_IntUnit           knh_class_Iterator(ctx, CLASS_IntUnit)
#define CLASS_pIntUnit          CLASS_PMZ(CLASS_IntUnit)
#define TYPE_pIntUnit           TYPE_PMZ(CLASS_IntUnit)
#define NNTYPE_pIntUnit         TYPE_TONNTYPE(CLASS_pIntUnit)
#define CFLAG_IntUnit           ((knh_flag_t)0)
#define FLAG_IntUnit            KNH_FLAG_CF2OF(CFLAG_IntUnit)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* FloatUnit */
#define STRUCT_FloatUnit        ((knh_struct_t)36)
#define CLASS_FloatUnit         ((knh_class_t)36)
#define IS_bFloatUnit(o)        ((o)->h.bcid == CLASS_FloatUnit)
#ifndef FloatUnit
#define FloatUnit               knh_FloatUnit_t
#endif
#define IS_FloatUnit(o)         ((o)->h.cid == CLASS_FloatUnit)
#define ASSERT_FloatUnit(o)     DEBUG_ASSERT(((o)->h.cid == CLASS_FloatUnit))
#define ACLASS_FloatUnit        knh_class_Array(ctx, CLASS_FloatUnit)
#define ICLASS_FloatUnit        knh_class_Iterator(ctx, CLASS_FloatUnit)
#define TYPE_FloatUnit          CLASS_FloatUnit
#define NNTYPE_FloatUnit        TYPE_TONNTYPE(CLASS_FloatUnit)
#define ATYPE_FloatUnit         knh_class_Array(ctx, CLASS_FloatUnit)
#define ITYPE_FloatUnit         knh_class_Iterator(ctx, CLASS_FloatUnit)
#define CLASS_pFloatUnit        CLASS_PMZ(CLASS_FloatUnit)
#define TYPE_pFloatUnit         TYPE_PMZ(CLASS_FloatUnit)
#define NNTYPE_pFloatUnit       TYPE_TONNTYPE(CLASS_pFloatUnit)
#define CFLAG_FloatUnit         ((knh_flag_t)0)
#define FLAG_FloatUnit          KNH_FLAG_CF2OF(CFLAG_FloatUnit)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* BytesConv */
#define STRUCT_BytesConv        ((knh_struct_t)37)
#define CLASS_BytesConv         ((knh_class_t)37)
#define IS_bBytesConv(o)        ((o)->h.bcid == CLASS_BytesConv)
#ifndef BytesConv
#define BytesConv               knh_BytesConv_t
#endif
#define IS_BytesConv(o)         ((o)->h.cid == CLASS_BytesConv)
#define ASSERT_BytesConv(o)     DEBUG_ASSERT(((o)->h.cid == CLASS_BytesConv))
#define ACLASS_BytesConv        knh_class_Array(ctx, CLASS_BytesConv)
#define ICLASS_BytesConv        knh_class_Iterator(ctx, CLASS_BytesConv)
#define TYPE_BytesConv          CLASS_BytesConv
#define NNTYPE_BytesConv        TYPE_TONNTYPE(CLASS_BytesConv)
#define ATYPE_BytesConv         knh_class_Array(ctx, CLASS_BytesConv)
#define ITYPE_BytesConv         knh_class_Iterator(ctx, CLASS_BytesConv)
#define CLASS_pBytesConv        CLASS_PMZ(CLASS_BytesConv)
#define TYPE_pBytesConv         TYPE_PMZ(CLASS_BytesConv)
#define NNTYPE_pBytesConv       TYPE_TONNTYPE(CLASS_pBytesConv)
#define CFLAG_BytesConv         ((knh_flag_t)0)
#define FLAG_BytesConv          KNH_FLAG_CF2OF(CFLAG_BytesConv)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* StringUnit */
#define STRUCT_StringUnit       ((knh_struct_t)38)
#define CLASS_StringUnit        ((knh_class_t)38)
#define IS_bStringUnit(o)       ((o)->h.bcid == CLASS_StringUnit)
#ifndef StringUnit
#define StringUnit              knh_StringUnit_t
#endif
#define IS_StringUnit(o)        ((o)->h.cid == CLASS_StringUnit)
#define ASSERT_StringUnit(o)    DEBUG_ASSERT(((o)->h.cid == CLASS_StringUnit))
#define ACLASS_StringUnit       knh_class_Array(ctx, CLASS_StringUnit)
#define ICLASS_StringUnit       knh_class_Iterator(ctx, CLASS_StringUnit)
#define TYPE_StringUnit         CLASS_StringUnit
#define NNTYPE_StringUnit       TYPE_TONNTYPE(CLASS_StringUnit)
#define ATYPE_StringUnit        knh_class_Array(ctx, CLASS_StringUnit)
#define ITYPE_StringUnit        knh_class_Iterator(ctx, CLASS_StringUnit)
#define CLASS_pStringUnit       CLASS_PMZ(CLASS_StringUnit)
#define TYPE_pStringUnit        TYPE_PMZ(CLASS_StringUnit)
#define NNTYPE_pStringUnit      TYPE_TONNTYPE(CLASS_pStringUnit)
#define CFLAG_StringUnit        ((knh_flag_t)0)
#define FLAG_StringUnit         KNH_FLAG_CF2OF(CFLAG_StringUnit)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* InputStream */
#define STRUCT_InputStream      ((knh_struct_t)39)
#define CLASS_InputStream       ((knh_class_t)39)
#define IS_bInputStream(o)      ((o)->h.bcid == CLASS_InputStream)
#ifndef InputStream
#define InputStream             knh_InputStream_t
#endif
#define IS_InputStream(o)       ((o)->h.cid == CLASS_InputStream)
#define ASSERT_InputStream(o)   DEBUG_ASSERT(((o)->h.cid == CLASS_InputStream))
#define ACLASS_InputStream      knh_class_Array(ctx, CLASS_InputStream)
#define ICLASS_InputStream      knh_class_Iterator(ctx, CLASS_InputStream)
#define TYPE_InputStream        CLASS_InputStream
#define NNTYPE_InputStream      TYPE_TONNTYPE(CLASS_InputStream)
#define ATYPE_InputStream       knh_class_Array(ctx, CLASS_InputStream)
#define ITYPE_InputStream       knh_class_Iterator(ctx, CLASS_InputStream)
#define CLASS_pInputStream      CLASS_PMZ(CLASS_InputStream)
#define TYPE_pInputStream       TYPE_PMZ(CLASS_InputStream)
#define NNTYPE_pInputStream     TYPE_TONNTYPE(CLASS_pInputStream)
#define CFLAG_InputStream       ((knh_flag_t)0)
#define FLAG_InputStream        KNH_FLAG_CF2OF(CFLAG_InputStream)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* OutputStream */
#define STRUCT_OutputStream     ((knh_struct_t)40)
#define CLASS_OutputStream      ((knh_class_t)40)
#define IS_bOutputStream(o)     ((o)->h.bcid == CLASS_OutputStream)
#ifndef OutputStream
#define OutputStream            knh_OutputStream_t
#endif
#define IS_OutputStream(o)      ((o)->h.cid == CLASS_OutputStream)
#define ASSERT_OutputStream(o)  DEBUG_ASSERT(((o)->h.cid == CLASS_OutputStream))
#define ACLASS_OutputStream     knh_class_Array(ctx, CLASS_OutputStream)
#define ICLASS_OutputStream     knh_class_Iterator(ctx, CLASS_OutputStream)
#define TYPE_OutputStream       CLASS_OutputStream
#define NNTYPE_OutputStream     TYPE_TONNTYPE(CLASS_OutputStream)
#define ATYPE_OutputStream      knh_class_Array(ctx, CLASS_OutputStream)
#define ITYPE_OutputStream      knh_class_Iterator(ctx, CLASS_OutputStream)
#define CLASS_pOutputStream     CLASS_PMZ(CLASS_OutputStream)
#define TYPE_pOutputStream      TYPE_PMZ(CLASS_OutputStream)
#define NNTYPE_pOutputStream    TYPE_TONNTYPE(CLASS_pOutputStream)
#define CFLAG_OutputStream      ((knh_flag_t)0)
#define FLAG_OutputStream       KNH_FLAG_CF2OF(CFLAG_OutputStream)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* ResultSet */
#define STRUCT_ResultSet        ((knh_struct_t)41)
#define CLASS_ResultSet         ((knh_class_t)41)
#define IS_bResultSet(o)        ((o)->h.bcid == CLASS_ResultSet)
#ifndef ResultSet
#define ResultSet               knh_ResultSet_t
#endif
#define IS_ResultSet(o)         ((o)->h.cid == CLASS_ResultSet)
#define ASSERT_ResultSet(o)     DEBUG_ASSERT(((o)->h.cid == CLASS_ResultSet))
#define ACLASS_ResultSet        knh_class_Array(ctx, CLASS_ResultSet)
#define ICLASS_ResultSet        knh_class_Iterator(ctx, CLASS_ResultSet)
#define TYPE_ResultSet          CLASS_ResultSet
#define NNTYPE_ResultSet        TYPE_TONNTYPE(CLASS_ResultSet)
#define ATYPE_ResultSet         knh_class_Array(ctx, CLASS_ResultSet)
#define ITYPE_ResultSet         knh_class_Iterator(ctx, CLASS_ResultSet)
#define CLASS_pResultSet        CLASS_PMZ(CLASS_ResultSet)
#define TYPE_pResultSet         TYPE_PMZ(CLASS_ResultSet)
#define NNTYPE_pResultSet       TYPE_TONNTYPE(CLASS_pResultSet)
#define CFLAG_ResultSet         ((knh_flag_t)0)
#define FLAG_ResultSet          KNH_FLAG_CF2OF(CFLAG_ResultSet)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Connection */
#define STRUCT_Connection       ((knh_struct_t)42)
#define CLASS_Connection        ((knh_class_t)42)
#define IS_bConnection(o)       ((o)->h.bcid == CLASS_Connection)
#ifndef Connection
#define Connection              knh_Connection_t
#endif
#define IS_Connection(o)        ((o)->h.cid == CLASS_Connection)
#define ASSERT_Connection(o)    DEBUG_ASSERT(((o)->h.cid == CLASS_Connection))
#define ACLASS_Connection       knh_class_Array(ctx, CLASS_Connection)
#define ICLASS_Connection       knh_class_Iterator(ctx, CLASS_Connection)
#define TYPE_Connection         CLASS_Connection
#define NNTYPE_Connection       TYPE_TONNTYPE(CLASS_Connection)
#define ATYPE_Connection        knh_class_Array(ctx, CLASS_Connection)
#define ITYPE_Connection        knh_class_Iterator(ctx, CLASS_Connection)
#define CLASS_pConnection       CLASS_PMZ(CLASS_Connection)
#define TYPE_pConnection        TYPE_PMZ(CLASS_Connection)
#define NNTYPE_pConnection      TYPE_TONNTYPE(CLASS_pConnection)
#define CFLAG_Connection        ((knh_flag_t)0)
#define FLAG_Connection         KNH_FLAG_CF2OF(CFLAG_Connection)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Exception */
#define STRUCT_Exception        ((knh_struct_t)43)
#define CLASS_Exception         ((knh_class_t)43)
#define IS_bException(o)        ((o)->h.bcid == CLASS_Exception)
#ifndef Exception
#define Exception               knh_Exception_t
#endif
#define IS_Exception(o)         ((o)->h.cid == CLASS_Exception)
#define ASSERT_Exception(o)     DEBUG_ASSERT(((o)->h.cid == CLASS_Exception))
#define ACLASS_Exception        knh_class_Array(ctx, CLASS_Exception)
#define ICLASS_Exception        knh_class_Iterator(ctx, CLASS_Exception)
#define TYPE_Exception          CLASS_Exception
#define NNTYPE_Exception        TYPE_TONNTYPE(CLASS_Exception)
#define ATYPE_Exception         knh_class_Array(ctx, CLASS_Exception)
#define ITYPE_Exception         knh_class_Iterator(ctx, CLASS_Exception)
#define CLASS_pException        CLASS_PMZ(CLASS_Exception)
#define TYPE_pException         TYPE_PMZ(CLASS_Exception)
#define NNTYPE_pException       TYPE_TONNTYPE(CLASS_pException)
#define CFLAG_Exception         ((knh_flag_t)0)
#define FLAG_Exception          KNH_FLAG_CF2OF(CFLAG_Exception)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* ExceptionHandler */
#define STRUCT_ExceptionHandler ((knh_struct_t)44)
#define CLASS_ExceptionHandler  ((knh_class_t)44)
#define IS_bExceptionHandler(o) ((o)->h.bcid == CLASS_ExceptionHandler)
#ifndef ExceptionHandler
#define ExceptionHandler        knh_ExceptionHandler_t
#endif
#define IS_ExceptionHandler(o)  ((o)->h.cid == CLASS_ExceptionHandler)
#define ASSERT_ExceptionHandler(o) DEBUG_ASSERT(((o)->h.cid == CLASS_ExceptionHandler))
#define ACLASS_ExceptionHandler knh_class_Array(ctx, CLASS_ExceptionHandler)
#define ICLASS_ExceptionHandler knh_class_Iterator(ctx, CLASS_ExceptionHandler)
#define TYPE_ExceptionHandler   CLASS_ExceptionHandler
#define NNTYPE_ExceptionHandler TYPE_TONNTYPE(CLASS_ExceptionHandler)
#define ATYPE_ExceptionHandler  knh_class_Array(ctx, CLASS_ExceptionHandler)
#define ITYPE_ExceptionHandler  knh_class_Iterator(ctx, CLASS_ExceptionHandler)
#define CLASS_pExceptionHandler CLASS_PMZ(CLASS_ExceptionHandler)
#define TYPE_pExceptionHandler  TYPE_PMZ(CLASS_ExceptionHandler)
#define NNTYPE_pExceptionHandler TYPE_TONNTYPE(CLASS_pExceptionHandler)
#define CFLAG_ExceptionHandler  ((knh_flag_t)KNH_FLAG_CF_PRIVATE)
#define FLAG_ExceptionHandler   KNH_FLAG_CF2OF(CFLAG_ExceptionHandler)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Script */
#define STRUCT_Script           ((knh_struct_t)45)
#define CLASS_Script            ((knh_class_t)45)
#define IS_bScript(o)           ((o)->h.bcid == CLASS_Script)
#ifndef Script
#define Script                  knh_Script_t
#endif
#define IS_Script(o)            ((o)->h.cid == CLASS_Script)
#define ASSERT_Script(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_Script))
#define ACLASS_Script           knh_class_Array(ctx, CLASS_Script)
#define ICLASS_Script           knh_class_Iterator(ctx, CLASS_Script)
#define TYPE_Script             CLASS_Script
#define NNTYPE_Script           TYPE_TONNTYPE(CLASS_Script)
#define ATYPE_Script            knh_class_Array(ctx, CLASS_Script)
#define ITYPE_Script            knh_class_Iterator(ctx, CLASS_Script)
#define CLASS_pScript           CLASS_PMZ(CLASS_Script)
#define TYPE_pScript            TYPE_PMZ(CLASS_Script)
#define NNTYPE_pScript          TYPE_TONNTYPE(CLASS_pScript)
#define CFLAG_Script            ((knh_flag_t)0)
#define FLAG_Script             KNH_FLAG_CF2OF(CFLAG_Script)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* NameSpace */
#define STRUCT_NameSpace        BSIZE_TOSID(sizeof(knh_NameSpace)/sizeof(Object*))
#define CLASS_NameSpace         ((knh_class_t)KNH_TSTRUCT_SIZE+0)
#ifndef NameSpace
#define NameSpace               knh_NameSpace_t
#endif
#define IS_NameSpace(o)         ((o)->h.cid == CLASS_NameSpace)
#define ASSERT_NameSpace(o)     DEBUG_ASSERT(((o)->h.cid == CLASS_NameSpace))
#define ACLASS_NameSpace        knh_class_Array(ctx, CLASS_NameSpace)
#define ICLASS_NameSpace        knh_class_Iterator(ctx, CLASS_NameSpace)
#define TYPE_NameSpace          CLASS_NameSpace
#define NNTYPE_NameSpace        TYPE_TONNTYPE(CLASS_NameSpace)
#define ATYPE_NameSpace         knh_class_Array(ctx, CLASS_NameSpace)
#define ITYPE_NameSpace         knh_class_Iterator(ctx, CLASS_NameSpace)
#define CLASS_pNameSpace        CLASS_PMZ(CLASS_NameSpace)
#define TYPE_pNameSpace         TYPE_PMZ(CLASS_NameSpace)
#define NNTYPE_pNameSpace       TYPE_TONNTYPE(CLASS_pNameSpace)
#define CFLAG_NameSpace         ((knh_flag_t)KNH_FLAG_CF_PRIVATE)
#define FLAG_NameSpace          KNH_FLAG_CF2OF(CFLAG_NameSpace)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* System */
#define STRUCT_System           BSIZE_TOSID(sizeof(knh_System)/sizeof(Object*))
#define CLASS_System            ((knh_class_t)KNH_TSTRUCT_SIZE+1)
#ifndef System
#define System                  knh_System_t
#endif
#define IS_System(o)            ((o)->h.cid == CLASS_System)
#define ASSERT_System(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_System))
#define ACLASS_System           knh_class_Array(ctx, CLASS_System)
#define ICLASS_System           knh_class_Iterator(ctx, CLASS_System)
#define TYPE_System             CLASS_System
#define NNTYPE_System           TYPE_TONNTYPE(CLASS_System)
#define ATYPE_System            knh_class_Array(ctx, CLASS_System)
#define ITYPE_System            knh_class_Iterator(ctx, CLASS_System)
#define CLASS_pSystem           CLASS_PMZ(CLASS_System)
#define TYPE_pSystem            TYPE_PMZ(CLASS_System)
#define NNTYPE_pSystem          TYPE_TONNTYPE(CLASS_pSystem)
#define CFLAG_System            ((knh_flag_t)0)
#define FLAG_System             KNH_FLAG_CF2OF(CFLAG_System)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Runtime */
#define STRUCT_Runtime          ((knh_struct_t)46)
#define CLASS_Runtime           ((knh_class_t)46)
#define IS_bRuntime(o)          ((o)->h.bcid == CLASS_Runtime)
#ifndef Runtime
#define Runtime                 knh_Runtime_t
#endif
#define IS_Runtime(o)           ((o)->h.cid == CLASS_Runtime)
#define ASSERT_Runtime(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_Runtime))
#define ACLASS_Runtime          knh_class_Array(ctx, CLASS_Runtime)
#define ICLASS_Runtime          knh_class_Iterator(ctx, CLASS_Runtime)
#define TYPE_Runtime            CLASS_Runtime
#define NNTYPE_Runtime          TYPE_TONNTYPE(CLASS_Runtime)
#define ATYPE_Runtime           knh_class_Array(ctx, CLASS_Runtime)
#define ITYPE_Runtime           knh_class_Iterator(ctx, CLASS_Runtime)
#define CLASS_pRuntime          CLASS_PMZ(CLASS_Runtime)
#define TYPE_pRuntime           TYPE_PMZ(CLASS_Runtime)
#define NNTYPE_pRuntime         TYPE_TONNTYPE(CLASS_pRuntime)
#define CFLAG_Runtime           ((knh_flag_t)0)
#define FLAG_Runtime            KNH_FLAG_CF2OF(CFLAG_Runtime)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Context */
#define STRUCT_Context          ((knh_struct_t)47)
#define CLASS_Context           ((knh_class_t)47)
#define IS_bContext(o)          ((o)->h.bcid == CLASS_Context)
#ifndef Context
#define Context                 knh_Context_t
#endif
#define IS_Context(o)           ((o)->h.cid == CLASS_Context)
#define ASSERT_Context(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_Context))
#define ACLASS_Context          knh_class_Array(ctx, CLASS_Context)
#define ICLASS_Context          knh_class_Iterator(ctx, CLASS_Context)
#define TYPE_Context            CLASS_Context
#define NNTYPE_Context          TYPE_TONNTYPE(CLASS_Context)
#define ATYPE_Context           knh_class_Array(ctx, CLASS_Context)
#define ITYPE_Context           knh_class_Iterator(ctx, CLASS_Context)
#define CLASS_pContext          CLASS_PMZ(CLASS_Context)
#define TYPE_pContext           TYPE_PMZ(CLASS_Context)
#define NNTYPE_pContext         TYPE_TONNTYPE(CLASS_pContext)
#define CFLAG_Context           ((knh_flag_t)0)
#define FLAG_Context            KNH_FLAG_CF2OF(CFLAG_Context)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* konohac */

/* ------------------------------------------------------------------------ */
/* Token */
#define STRUCT_Token            ((knh_struct_t)48)
#define CLASS_Token             ((knh_class_t)48)
#define IS_bToken(o)            ((o)->h.bcid == CLASS_Token)
#ifndef Token
#define Token                   knh_Token_t
#endif
#define IS_Token(o)             ((o)->h.cid == CLASS_Token)
#define ASSERT_Token(o)         DEBUG_ASSERT(((o)->h.cid == CLASS_Token))
#define ACLASS_Token            knh_class_Array(ctx, CLASS_Token)
#define ICLASS_Token            knh_class_Iterator(ctx, CLASS_Token)
#define TYPE_Token              CLASS_Token
#define NNTYPE_Token            TYPE_TONNTYPE(CLASS_Token)
#define ATYPE_Token             knh_class_Array(ctx, CLASS_Token)
#define ITYPE_Token             knh_class_Iterator(ctx, CLASS_Token)
#define CLASS_pToken            CLASS_PMZ(CLASS_Token)
#define TYPE_pToken             TYPE_PMZ(CLASS_Token)
#define NNTYPE_pToken           TYPE_TONNTYPE(CLASS_pToken)
#define CFLAG_Token             ((knh_flag_t)0)
#define FLAG_Token              KNH_FLAG_CF2OF(CFLAG_Token)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Stmt */
#define STRUCT_Stmt             ((knh_struct_t)49)
#define CLASS_Stmt              ((knh_class_t)49)
#define IS_bStmt(o)             ((o)->h.bcid == CLASS_Stmt)
#ifndef Stmt
#define Stmt                    knh_Stmt_t
#endif
#define IS_Stmt(o)              ((o)->h.cid == CLASS_Stmt)
#define ASSERT_Stmt(o)          DEBUG_ASSERT(((o)->h.cid == CLASS_Stmt))
#define ACLASS_Stmt             knh_class_Array(ctx, CLASS_Stmt)
#define ICLASS_Stmt             knh_class_Iterator(ctx, CLASS_Stmt)
#define TYPE_Stmt               CLASS_Stmt
#define NNTYPE_Stmt             TYPE_TONNTYPE(CLASS_Stmt)
#define ATYPE_Stmt              knh_class_Array(ctx, CLASS_Stmt)
#define ITYPE_Stmt              knh_class_Iterator(ctx, CLASS_Stmt)
#define CLASS_pStmt             CLASS_PMZ(CLASS_Stmt)
#define TYPE_pStmt              TYPE_PMZ(CLASS_Stmt)
#define NNTYPE_pStmt            TYPE_TONNTYPE(CLASS_pStmt)
#define CFLAG_Stmt              ((knh_flag_t)0)
#define FLAG_Stmt               KNH_FLAG_CF2OF(CFLAG_Stmt)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Compiler */
#define STRUCT_Compiler         ((knh_struct_t)50)
#define CLASS_Compiler          ((knh_class_t)50)
#define IS_bCompiler(o)         ((o)->h.bcid == CLASS_Compiler)
#ifndef Compiler
#define Compiler                knh_Compiler_t
#endif
#define IS_Compiler(o)          ((o)->h.cid == CLASS_Compiler)
#define ASSERT_Compiler(o)      DEBUG_ASSERT(((o)->h.cid == CLASS_Compiler))
#define ACLASS_Compiler         knh_class_Array(ctx, CLASS_Compiler)
#define ICLASS_Compiler         knh_class_Iterator(ctx, CLASS_Compiler)
#define TYPE_Compiler           CLASS_Compiler
#define NNTYPE_Compiler         TYPE_TONNTYPE(CLASS_Compiler)
#define ATYPE_Compiler          knh_class_Array(ctx, CLASS_Compiler)
#define ITYPE_Compiler          knh_class_Iterator(ctx, CLASS_Compiler)
#define CLASS_pCompiler         CLASS_PMZ(CLASS_Compiler)
#define TYPE_pCompiler          TYPE_PMZ(CLASS_Compiler)
#define NNTYPE_pCompiler        TYPE_TONNTYPE(CLASS_pCompiler)
#define CFLAG_Compiler          ((knh_flag_t)0)
#define FLAG_Compiler           KNH_FLAG_CF2OF(CFLAG_Compiler)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* VirtualMachineCode */
#define STRUCT_VirtualMachineCode ((knh_struct_t)51)
#define CLASS_VirtualMachineCode ((knh_class_t)51)
#define IS_bVirtualMachineCode(o) ((o)->h.bcid == CLASS_VirtualMachineCode)
#ifndef VirtualMachineCode
#define VirtualMachineCode      knh_VirtualMachineCode_t
#endif
#define IS_VirtualMachineCode(o) ((o)->h.cid == CLASS_VirtualMachineCode)
#define ASSERT_VirtualMachineCode(o) DEBUG_ASSERT(((o)->h.cid == CLASS_VirtualMachineCode))
#define ACLASS_VirtualMachineCode knh_class_Array(ctx, CLASS_VirtualMachineCode)
#define ICLASS_VirtualMachineCode knh_class_Iterator(ctx, CLASS_VirtualMachineCode)
#define TYPE_VirtualMachineCode CLASS_VirtualMachineCode
#define NNTYPE_VirtualMachineCode TYPE_TONNTYPE(CLASS_VirtualMachineCode)
#define ATYPE_VirtualMachineCode knh_class_Array(ctx, CLASS_VirtualMachineCode)
#define ITYPE_VirtualMachineCode knh_class_Iterator(ctx, CLASS_VirtualMachineCode)
#define CLASS_pVirtualMachineCode CLASS_PMZ(CLASS_VirtualMachineCode)
#define TYPE_pVirtualMachineCode TYPE_PMZ(CLASS_VirtualMachineCode)
#define NNTYPE_pVirtualMachineCode TYPE_TONNTYPE(CLASS_pVirtualMachineCode)
#define CFLAG_VirtualMachineCode ((knh_flag_t)0)
#define FLAG_VirtualMachineCode KNH_FLAG_CF2OF(CFLAG_VirtualMachineCode)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* naruto */

/* ------------------------------------------------------------------------ */
/* Counter */
#define STRUCT_Counter          ((knh_struct_t)52)
#define CLASS_Counter           ((knh_class_t)52)
#define IS_bCounter(o)          ((o)->h.bcid == CLASS_Counter)
#ifndef Counter
#define Counter                 knh_Counter_t
#endif
#define IS_Counter(o)           ((o)->h.cid == CLASS_Counter)
#define ASSERT_Counter(o)       DEBUG_ASSERT(((o)->h.cid == CLASS_Counter))
#define ACLASS_Counter          knh_class_Array(ctx, CLASS_Counter)
#define ICLASS_Counter          knh_class_Iterator(ctx, CLASS_Counter)
#define TYPE_Counter            CLASS_Counter
#define NNTYPE_Counter          TYPE_TONNTYPE(CLASS_Counter)
#define ATYPE_Counter           knh_class_Array(ctx, CLASS_Counter)
#define ITYPE_Counter           knh_class_Iterator(ctx, CLASS_Counter)
#define CLASS_pCounter          CLASS_PMZ(CLASS_Counter)
#define TYPE_pCounter           TYPE_PMZ(CLASS_Counter)
#define NNTYPE_pCounter         TYPE_TONNTYPE(CLASS_pCounter)
#define CFLAG_Counter           ((knh_flag_t)0)
#define FLAG_Counter            KNH_FLAG_CF2OF(CFLAG_Counter)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Amazon */
#define STRUCT_Amazon           ((knh_struct_t)53)
#define CLASS_Amazon            ((knh_class_t)53)
#define IS_bAmazon(o)           ((o)->h.bcid == CLASS_Amazon)
#ifndef Amazon
#define Amazon                  knh_Amazon_t
#endif
#define IS_Amazon(o)            ((o)->h.cid == CLASS_Amazon)
#define ASSERT_Amazon(o)        DEBUG_ASSERT(((o)->h.cid == CLASS_Amazon))
#define ACLASS_Amazon           knh_class_Array(ctx, CLASS_Amazon)
#define ICLASS_Amazon           knh_class_Iterator(ctx, CLASS_Amazon)
#define TYPE_Amazon             CLASS_Amazon
#define NNTYPE_Amazon           TYPE_TONNTYPE(CLASS_Amazon)
#define ATYPE_Amazon            knh_class_Array(ctx, CLASS_Amazon)
#define ITYPE_Amazon            knh_class_Iterator(ctx, CLASS_Amazon)
#define CLASS_pAmazon           CLASS_PMZ(CLASS_Amazon)
#define TYPE_pAmazon            TYPE_PMZ(CLASS_Amazon)
#define NNTYPE_pAmazon          TYPE_TONNTYPE(CLASS_pAmazon)
#define CFLAG_Amazon            ((knh_flag_t)0)
#define FLAG_Amazon             KNH_FLAG_CF2OF(CFLAG_Amazon)

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* +math */

/* ------------------------------------------------------------------------ */
/* +mysql */

/* ======================================================================== */
/* [tString] */
#define TSN_EMPTY               0
#define TS_EMPTY                        knh_tString[TSN_EMPTY]
#define TSN_TAB                 1
#define TS_TAB                          knh_tString[TSN_TAB]
#define TSN_LF                  2
#define TS_LF                           knh_tString[TSN_LF]
#define TSN_SPC                 3
#define TS_SPC                          knh_tString[TSN_SPC]
#define TSN_EOL                 4
#define TS_EOL                          knh_tString[TSN_EOL]
#define TSN_BEGIN               5
#define TS_BEGIN                        knh_tString[TSN_BEGIN]
#define TSN_END                 6
#define TS_END                          knh_tString[TSN_END]
#define TSN_void                7
#define TS_void                         knh_tString[TSN_void]
#define TSN_true                8
#define TS_true                         knh_tString[TSN_true]
#define TSN_false               9
#define TS_false                        knh_tString[TSN_false]
#define TSN_null                10
#define TS_null                         knh_tString[TSN_null]
#define TSN_main                11
#define TS_main                         knh_tString[TSN_main]
#define TSN_ENCODING            12
#define TS_ENCODING                     knh_tString[TSN_ENCODING]
#define TSN_DEVNULL             13
#define TS_DEVNULL                      knh_tString[TSN_DEVNULL]
#define TSN_DEVSTDIN            14
#define TS_DEVSTDIN                     knh_tString[TSN_DEVSTDIN]
#define TSN_DEVSTDERR           15
#define TS_DEVSTDERR                    knh_tString[TSN_DEVSTDERR]
#define TSN_DEVSTDOUT           16
#define TS_DEVSTDOUT                    knh_tString[TSN_DEVSTDOUT]
#define TSN_ATlabel             17
#define TS_ATlabel                      knh_tString[TSN_ATlabel]
#define TSN_TYPEERR             18
#define TS_TYPEERR                      knh_tString[TSN_TYPEERR]
#define TSN_NULLERR             19
#define TS_NULLERR                      knh_tString[TSN_NULLERR]
#define TSN_SYNTAXERR           20
#define TS_SYNTAXERR                    knh_tString[TSN_SYNTAXERR]
#define KNH_TSTRING_SIZE        21

/* ======================================================================== */
/* [field] */
#define FIELDN_                         ((knh_fieldn_t)0)
#define METHODN_                        ((knh_methodn_t)0)
#define METHODN__                       ((knh_methodn_t)0|KNH_FLAG_MN_MOVTEXT)
#define METHODN_get                     ((knh_methodn_t)0|KNH_FLAG_MN_GETTER)
#define METHODN_set                     ((knh_methodn_t)0|KNH_FLAG_MN_SETTER)
#define FIELDN___fast                   ((knh_fieldn_t)1)
#define METHODN___fast                  ((knh_methodn_t)1)
#define METHODN____fast                 ((knh_methodn_t)1|KNH_FLAG_MN_MOVTEXT)
#define METHODN_get__fast               ((knh_methodn_t)1|KNH_FLAG_MN_GETTER)
#define METHODN_set__fast               ((knh_methodn_t)1|KNH_FLAG_MN_SETTER)
#define FIELDN_abs                      ((knh_fieldn_t)2)
#define METHODN_abs                     ((knh_methodn_t)2)
#define METHODN__abs                    ((knh_methodn_t)2|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAbs                  ((knh_methodn_t)2|KNH_FLAG_MN_GETTER)
#define METHODN_setAbs                  ((knh_methodn_t)2|KNH_FLAG_MN_SETTER)
#define FIELDN_add                      ((knh_fieldn_t)3)
#define METHODN_add                     ((knh_methodn_t)3)
#define METHODN__add                    ((knh_methodn_t)3|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAdd                  ((knh_methodn_t)3|KNH_FLAG_MN_GETTER)
#define METHODN_setAdd                  ((knh_methodn_t)3|KNH_FLAG_MN_SETTER)
#define FIELDN_add__fast                ((knh_fieldn_t)4)
#define METHODN_add__fast               ((knh_methodn_t)4)
#define METHODN__add__fast              ((knh_methodn_t)4|KNH_FLAG_MN_MOVTEXT)
#define FIELDN_addr                     ((knh_fieldn_t)5)
#define METHODN_addr                    ((knh_methodn_t)5)
#define METHODN__addr                   ((knh_methodn_t)5|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAddr                 ((knh_methodn_t)5|KNH_FLAG_MN_GETTER)
#define METHODN_setAddr                 ((knh_methodn_t)5|KNH_FLAG_MN_SETTER)
#define FIELDN_another                  ((knh_fieldn_t)6)
#define METHODN_another                 ((knh_methodn_t)6)
#define METHODN__another                ((knh_methodn_t)6|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAnother              ((knh_methodn_t)6|KNH_FLAG_MN_GETTER)
#define METHODN_setAnother              ((knh_methodn_t)6|KNH_FLAG_MN_SETTER)
#define FIELDN_append                   ((knh_fieldn_t)7)
#define METHODN_append                  ((knh_methodn_t)7)
#define METHODN__append                 ((knh_methodn_t)7|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAppend               ((knh_methodn_t)7|KNH_FLAG_MN_GETTER)
#define METHODN_setAppend               ((knh_methodn_t)7|KNH_FLAG_MN_SETTER)
#define FIELDN_autoFlush                ((knh_fieldn_t)8)
#define METHODN_autoFlush               ((knh_methodn_t)8)
#define METHODN__autoFlush              ((knh_methodn_t)8|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getAutoFlush            ((knh_methodn_t)8|KNH_FLAG_MN_GETTER)
#define METHODN_setAutoFlush            ((knh_methodn_t)8|KNH_FLAG_MN_SETTER)
#define FIELDN_b                        ((knh_fieldn_t)9)
#define METHODN_b                       ((knh_methodn_t)9)
#define METHODN__b                      ((knh_methodn_t)9|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getB                    ((knh_methodn_t)9|KNH_FLAG_MN_GETTER)
#define METHODN_setB                    ((knh_methodn_t)9|KNH_FLAG_MN_SETTER)
#define FIELDN_bits                     ((knh_fieldn_t)10)
#define METHODN_bits                    ((knh_methodn_t)10)
#define METHODN__bits                   ((knh_methodn_t)10|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getBits                 ((knh_methodn_t)10|KNH_FLAG_MN_GETTER)
#define METHODN_setBits                 ((knh_methodn_t)10|KNH_FLAG_MN_SETTER)
#define FIELDN_buf                      ((knh_fieldn_t)11)
#define METHODN_buf                     ((knh_methodn_t)11)
#define METHODN__buf                    ((knh_methodn_t)11|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getBuf                  ((knh_methodn_t)11|KNH_FLAG_MN_GETTER)
#define METHODN_setBuf                  ((knh_methodn_t)11|KNH_FLAG_MN_SETTER)
#define FIELDN_c                        ((knh_fieldn_t)12)
#define METHODN_c                       ((knh_methodn_t)12)
#define METHODN__c                      ((knh_methodn_t)12|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getC                    ((knh_methodn_t)12|KNH_FLAG_MN_GETTER)
#define METHODN_setC                    ((knh_methodn_t)12|KNH_FLAG_MN_SETTER)
#define FIELDN_class                    ((knh_fieldn_t)13)
#define METHODN_class                   ((knh_methodn_t)13)
#define METHODN__class                  ((knh_methodn_t)13|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getClass                ((knh_methodn_t)13|KNH_FLAG_MN_GETTER)
#define METHODN_setClass                ((knh_methodn_t)13|KNH_FLAG_MN_SETTER)
#define FIELDN_clear                    ((knh_fieldn_t)14)
#define METHODN_clear                   ((knh_methodn_t)14)
#define METHODN__clear                  ((knh_methodn_t)14|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getClear                ((knh_methodn_t)14|KNH_FLAG_MN_GETTER)
#define METHODN_setClear                ((knh_methodn_t)14|KNH_FLAG_MN_SETTER)
#define FIELDN_close                    ((knh_fieldn_t)15)
#define METHODN_close                   ((knh_methodn_t)15)
#define METHODN__close                  ((knh_methodn_t)15|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getClose                ((knh_methodn_t)15|KNH_FLAG_MN_GETTER)
#define METHODN_setClose                ((knh_methodn_t)15|KNH_FLAG_MN_SETTER)
#define FIELDN_compareTo                ((knh_fieldn_t)16)
#define METHODN_compareTo               ((knh_methodn_t)16)
#define METHODN__compareTo              ((knh_methodn_t)16|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getCompareTo            ((knh_methodn_t)16|KNH_FLAG_MN_GETTER)
#define METHODN_setCompareTo            ((knh_methodn_t)16|KNH_FLAG_MN_SETTER)
#define FIELDN_default                  ((knh_fieldn_t)17)
#define METHODN_default                 ((knh_methodn_t)17)
#define METHODN__default                ((knh_methodn_t)17|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getDefault              ((knh_methodn_t)17|KNH_FLAG_MN_GETTER)
#define METHODN_setDefault              ((knh_methodn_t)17|KNH_FLAG_MN_SETTER)
#define FIELDN_dump                     ((knh_fieldn_t)18)
#define METHODN_dump                    ((knh_methodn_t)18)
#define METHODN__dump                   ((knh_methodn_t)18|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getDump                 ((knh_methodn_t)18|KNH_FLAG_MN_GETTER)
#define METHODN_setDump                 ((knh_methodn_t)18|KNH_FLAG_MN_SETTER)
#define FIELDN_e                        ((knh_fieldn_t)19)
#define METHODN_e                       ((knh_methodn_t)19)
#define METHODN__e                      ((knh_methodn_t)19|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getE                    ((knh_methodn_t)19|KNH_FLAG_MN_GETTER)
#define METHODN_setE                    ((knh_methodn_t)19|KNH_FLAG_MN_SETTER)
#define FIELDN_empty                    ((knh_fieldn_t)20)
#define METHODN_empty                   ((knh_methodn_t)20)
#define METHODN__empty                  ((knh_methodn_t)20|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getEmpty                ((knh_methodn_t)20|KNH_FLAG_MN_GETTER)
#define METHODN_setEmpty                ((knh_methodn_t)20|KNH_FLAG_MN_SETTER)
#define FIELDN_enc                      ((knh_fieldn_t)21)
#define METHODN_enc                     ((knh_methodn_t)21)
#define METHODN__enc                    ((knh_methodn_t)21|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getEnc                  ((knh_methodn_t)21|KNH_FLAG_MN_GETTER)
#define METHODN_setEnc                  ((knh_methodn_t)21|KNH_FLAG_MN_SETTER)
#define FIELDN_encoding                 ((knh_fieldn_t)22)
#define METHODN_encoding                ((knh_methodn_t)22)
#define METHODN__encoding               ((knh_methodn_t)22|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getEncoding             ((knh_methodn_t)22|KNH_FLAG_MN_GETTER)
#define METHODN_setEncoding             ((knh_methodn_t)22|KNH_FLAG_MN_SETTER)
#define FIELDN_endsWith                 ((knh_fieldn_t)23)
#define METHODN_endsWith                ((knh_methodn_t)23)
#define METHODN__endsWith               ((knh_methodn_t)23|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getEndsWith             ((knh_methodn_t)23|KNH_FLAG_MN_GETTER)
#define METHODN_setEndsWith             ((knh_methodn_t)23|KNH_FLAG_MN_SETTER)
#define FIELDN_equals                   ((knh_fieldn_t)24)
#define METHODN_equals                  ((knh_methodn_t)24)
#define METHODN__equals                 ((knh_methodn_t)24|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getEquals               ((knh_methodn_t)24|KNH_FLAG_MN_GETTER)
#define METHODN_setEquals               ((knh_methodn_t)24|KNH_FLAG_MN_SETTER)
#define FIELDN_err                      ((knh_fieldn_t)25)
#define METHODN_err                     ((knh_methodn_t)25)
#define METHODN__err                    ((knh_methodn_t)25|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getErr                  ((knh_methodn_t)25|KNH_FLAG_MN_GETTER)
#define METHODN_setErr                  ((knh_methodn_t)25|KNH_FLAG_MN_SETTER)
#define FIELDN_first                    ((knh_fieldn_t)26)
#define METHODN_first                   ((knh_methodn_t)26)
#define METHODN__first                  ((knh_methodn_t)26|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getFirst                ((knh_methodn_t)26|KNH_FLAG_MN_GETTER)
#define METHODN_setFirst                ((knh_methodn_t)26|KNH_FLAG_MN_SETTER)
#define FIELDN_flush                    ((knh_fieldn_t)27)
#define METHODN_flush                   ((knh_methodn_t)27)
#define METHODN__flush                  ((knh_methodn_t)27|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getFlush                ((knh_methodn_t)27|KNH_FLAG_MN_GETTER)
#define METHODN_setFlush                ((knh_methodn_t)27|KNH_FLAG_MN_SETTER)
#define FIELDN_formatted                ((knh_fieldn_t)28)
#define METHODN_formatted               ((knh_methodn_t)28)
#define METHODN__formatted              ((knh_methodn_t)28|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getFormatted            ((knh_methodn_t)28|KNH_FLAG_MN_GETTER)
#define METHODN_setFormatted            ((knh_methodn_t)28|KNH_FLAG_MN_SETTER)
#define FIELDN_gCMarked                 ((knh_fieldn_t)29)
#define METHODN_gCMarked                ((knh_methodn_t)29)
#define METHODN__gCMarked               ((knh_methodn_t)29|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getGCMarked             ((knh_methodn_t)29|KNH_FLAG_MN_GETTER)
#define METHODN_setGCMarked             ((knh_methodn_t)29|KNH_FLAG_MN_SETTER)
#define FIELDN_hasMetaData              ((knh_fieldn_t)30)
#define METHODN_hasMetaData             ((knh_methodn_t)30)
#define METHODN__hasMetaData            ((knh_methodn_t)30|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getHasMetaData          ((knh_methodn_t)30|KNH_FLAG_MN_GETTER)
#define METHODN_setHasMetaData          ((knh_methodn_t)30|KNH_FLAG_MN_SETTER)
#define FIELDN_in                       ((knh_fieldn_t)31)
#define METHODN_in                      ((knh_methodn_t)31)
#define METHODN__in                     ((knh_methodn_t)31|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIn                   ((knh_methodn_t)31|KNH_FLAG_MN_GETTER)
#define METHODN_setIn                   ((knh_methodn_t)31|KNH_FLAG_MN_SETTER)
#define FIELDN_index                    ((knh_fieldn_t)32)
#define METHODN_index                   ((knh_methodn_t)32)
#define METHODN__index                  ((knh_methodn_t)32|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIndex                ((knh_methodn_t)32|KNH_FLAG_MN_GETTER)
#define METHODN_setIndex                ((knh_methodn_t)32|KNH_FLAG_MN_SETTER)
#define FIELDN_indexOf                  ((knh_fieldn_t)33)
#define METHODN_indexOf                 ((knh_methodn_t)33)
#define METHODN__indexOf                ((knh_methodn_t)33|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIndexOf              ((knh_methodn_t)33|KNH_FLAG_MN_GETTER)
#define METHODN_setIndexOf              ((knh_methodn_t)33|KNH_FLAG_MN_SETTER)
#define FIELDN_init                     ((knh_fieldn_t)34)
#define METHODN_init                    ((knh_methodn_t)34)
#define METHODN__init                   ((knh_methodn_t)34|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getInit                 ((knh_methodn_t)34|KNH_FLAG_MN_GETTER)
#define METHODN_setInit                 ((knh_methodn_t)34|KNH_FLAG_MN_SETTER)
#define FIELDN_initialCapacity          ((knh_fieldn_t)35)
#define METHODN_initialCapacity         ((knh_methodn_t)35)
#define METHODN__initialCapacity        ((knh_methodn_t)35|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getInitialCapacity      ((knh_methodn_t)35|KNH_FLAG_MN_GETTER)
#define METHODN_setInitialCapacity      ((knh_methodn_t)35|KNH_FLAG_MN_SETTER)
#define FIELDN_input                    ((knh_fieldn_t)36)
#define METHODN_input                   ((knh_methodn_t)36)
#define METHODN__input                  ((knh_methodn_t)36|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getInput                ((knh_methodn_t)36|KNH_FLAG_MN_GETTER)
#define METHODN_setInput                ((knh_methodn_t)36|KNH_FLAG_MN_SETTER)
#define FIELDN_insert                   ((knh_fieldn_t)37)
#define METHODN_insert                  ((knh_methodn_t)37)
#define METHODN__insert                 ((knh_methodn_t)37|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getInsert               ((knh_methodn_t)37|KNH_FLAG_MN_GETTER)
#define METHODN_setInsert               ((knh_methodn_t)37|KNH_FLAG_MN_SETTER)
#define FIELDN_isAbstract               ((knh_fieldn_t)38)
#define METHODN_isAbstract              ((knh_methodn_t)38)
#define METHODN__isAbstract             ((knh_methodn_t)38|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsAbstract           ((knh_methodn_t)38|KNH_FLAG_MN_GETTER)
#define METHODN_setIsAbstract           ((knh_methodn_t)38|KNH_FLAG_MN_SETTER)
#define FIELDN_isAspect                 ((knh_fieldn_t)39)
#define METHODN_isAspect                ((knh_methodn_t)39)
#define METHODN__isAspect               ((knh_methodn_t)39|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsAspect             ((knh_methodn_t)39|KNH_FLAG_MN_GETTER)
#define METHODN_setIsAspect             ((knh_methodn_t)39|KNH_FLAG_MN_SETTER)
#define FIELDN_isAutoFlush              ((knh_fieldn_t)40)
#define METHODN_isAutoFlush             ((knh_methodn_t)40)
#define METHODN__isAutoFlush            ((knh_methodn_t)40|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsAutoFlush          ((knh_methodn_t)40|KNH_FLAG_MN_GETTER)
#define METHODN_setIsAutoFlush          ((knh_methodn_t)40|KNH_FLAG_MN_SETTER)
#define FIELDN_isClass                  ((knh_fieldn_t)41)
#define METHODN_isClass                 ((knh_methodn_t)41)
#define METHODN__isClass                ((knh_methodn_t)41|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsClass              ((knh_methodn_t)41|KNH_FLAG_MN_GETTER)
#define METHODN_setIsClass              ((knh_methodn_t)41|KNH_FLAG_MN_SETTER)
#define FIELDN_isDebug                  ((knh_fieldn_t)42)
#define METHODN_isDebug                 ((knh_methodn_t)42)
#define METHODN__isDebug                ((knh_methodn_t)42|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsDebug              ((knh_methodn_t)42|KNH_FLAG_MN_GETTER)
#define METHODN_setIsDebug              ((knh_methodn_t)42|KNH_FLAG_MN_SETTER)
#define FIELDN_isDerived                ((knh_fieldn_t)43)
#define METHODN_isDerived               ((knh_methodn_t)43)
#define METHODN__isDerived              ((knh_methodn_t)43|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsDerived            ((knh_methodn_t)43|KNH_FLAG_MN_GETTER)
#define METHODN_setIsDerived            ((knh_methodn_t)43|KNH_FLAG_MN_SETTER)
#define FIELDN_isFatal                  ((knh_fieldn_t)44)
#define METHODN_isFatal                 ((knh_methodn_t)44)
#define METHODN__isFatal                ((knh_methodn_t)44|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsFatal              ((knh_methodn_t)44|KNH_FLAG_MN_GETTER)
#define METHODN_setIsFatal              ((knh_methodn_t)44|KNH_FLAG_MN_SETTER)
#define FIELDN_isFinal                  ((knh_fieldn_t)45)
#define METHODN_isFinal                 ((knh_methodn_t)45)
#define METHODN__isFinal                ((knh_methodn_t)45|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsFinal              ((knh_methodn_t)45|KNH_FLAG_MN_GETTER)
#define METHODN_setIsFinal              ((knh_methodn_t)45|KNH_FLAG_MN_SETTER)
#define FIELDN_isFormatted              ((knh_fieldn_t)46)
#define METHODN_isFormatted             ((knh_methodn_t)46)
#define METHODN__isFormatted            ((knh_methodn_t)46|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsFormatted          ((knh_methodn_t)46|KNH_FLAG_MN_GETTER)
#define METHODN_setIsFormatted          ((knh_methodn_t)46|KNH_FLAG_MN_SETTER)
#define FIELDN_isGCMarked               ((knh_fieldn_t)47)
#define METHODN_isGCMarked              ((knh_methodn_t)47)
#define METHODN__isGCMarked             ((knh_methodn_t)47|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsGCMarked           ((knh_methodn_t)47|KNH_FLAG_MN_GETTER)
#define METHODN_setIsGCMarked           ((knh_methodn_t)47|KNH_FLAG_MN_SETTER)
#define FIELDN_isGenerated              ((knh_fieldn_t)48)
#define METHODN_isGenerated             ((knh_methodn_t)48)
#define METHODN__isGenerated            ((knh_methodn_t)48|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsGenerated          ((knh_methodn_t)48|KNH_FLAG_MN_GETTER)
#define METHODN_setIsGenerated          ((knh_methodn_t)48|KNH_FLAG_MN_SETTER)
#define FIELDN_isImmutable              ((knh_fieldn_t)49)
#define METHODN_isImmutable             ((knh_methodn_t)49)
#define METHODN__isImmutable            ((knh_methodn_t)49|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsImmutable          ((knh_methodn_t)49|KNH_FLAG_MN_GETTER)
#define METHODN_setIsImmutable          ((knh_methodn_t)49|KNH_FLAG_MN_SETTER)
#define FIELDN_isInterface              ((knh_fieldn_t)50)
#define METHODN_isInterface             ((knh_methodn_t)50)
#define METHODN__isInterface            ((knh_methodn_t)50|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsInterface          ((knh_methodn_t)50|KNH_FLAG_MN_GETTER)
#define METHODN_setIsInterface          ((knh_methodn_t)50|KNH_FLAG_MN_SETTER)
#define FIELDN_isLocal                  ((knh_fieldn_t)51)
#define METHODN_isLocal                 ((knh_methodn_t)51)
#define METHODN__isLocal                ((knh_methodn_t)51|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsLocal              ((knh_methodn_t)51|KNH_FLAG_MN_GETTER)
#define METHODN_setIsLocal              ((knh_methodn_t)51|KNH_FLAG_MN_SETTER)
#define FIELDN_isLogging                ((knh_fieldn_t)52)
#define METHODN_isLogging               ((knh_methodn_t)52)
#define METHODN__isLogging              ((knh_methodn_t)52|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsLogging            ((knh_methodn_t)52|KNH_FLAG_MN_GETTER)
#define METHODN_setIsLogging            ((knh_methodn_t)52|KNH_FLAG_MN_SETTER)
#define FIELDN_isLossLess               ((knh_fieldn_t)53)
#define METHODN_isLossLess              ((knh_methodn_t)53)
#define METHODN__isLossLess             ((knh_methodn_t)53|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsLossLess           ((knh_methodn_t)53|KNH_FLAG_MN_GETTER)
#define METHODN_setIsLossLess           ((knh_methodn_t)53|KNH_FLAG_MN_SETTER)
#define FIELDN_isMetaExtensible         ((knh_fieldn_t)54)
#define METHODN_isMetaExtensible        ((knh_methodn_t)54)
#define METHODN__isMetaExtensible       ((knh_methodn_t)54|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsMetaExtensible     ((knh_methodn_t)54|KNH_FLAG_MN_GETTER)
#define METHODN_setIsMetaExtensible     ((knh_methodn_t)54|KNH_FLAG_MN_SETTER)
#define FIELDN_isModified               ((knh_fieldn_t)55)
#define METHODN_isModified              ((knh_methodn_t)55)
#define METHODN__isModified             ((knh_methodn_t)55|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsModified           ((knh_methodn_t)55|KNH_FLAG_MN_GETTER)
#define METHODN_setIsModified           ((knh_methodn_t)55|KNH_FLAG_MN_SETTER)
#define FIELDN_isNullBase               ((knh_fieldn_t)56)
#define METHODN_isNullBase              ((knh_methodn_t)56)
#define METHODN__isNullBase             ((knh_methodn_t)56|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsNullBase           ((knh_methodn_t)56|KNH_FLAG_MN_GETTER)
#define METHODN_setIsNullBase           ((knh_methodn_t)56|KNH_FLAG_MN_SETTER)
#define FIELDN_isPartial                ((knh_fieldn_t)57)
#define METHODN_isPartial               ((knh_methodn_t)57)
#define METHODN__isPartial              ((knh_methodn_t)57|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsPartial            ((knh_methodn_t)57|KNH_FLAG_MN_GETTER)
#define METHODN_setIsPartial            ((knh_methodn_t)57|KNH_FLAG_MN_SETTER)
#define FIELDN_isPrivate                ((knh_fieldn_t)58)
#define METHODN_isPrivate               ((knh_methodn_t)58)
#define METHODN__isPrivate              ((knh_methodn_t)58|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsPrivate            ((knh_methodn_t)58|KNH_FLAG_MN_GETTER)
#define METHODN_setIsPrivate            ((knh_methodn_t)58|KNH_FLAG_MN_SETTER)
#define FIELDN_isPublic                 ((knh_fieldn_t)59)
#define METHODN_isPublic                ((knh_methodn_t)59)
#define METHODN__isPublic               ((knh_methodn_t)59|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsPublic             ((knh_methodn_t)59|KNH_FLAG_MN_GETTER)
#define METHODN_setIsPublic             ((knh_methodn_t)59|KNH_FLAG_MN_SETTER)
#define FIELDN_isRelease                ((knh_fieldn_t)60)
#define METHODN_isRelease               ((knh_methodn_t)60)
#define METHODN__isRelease              ((knh_methodn_t)60|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsRelease            ((knh_methodn_t)60|KNH_FLAG_MN_GETTER)
#define METHODN_setIsRelease            ((knh_methodn_t)60|KNH_FLAG_MN_SETTER)
#define FIELDN_isSignificant            ((knh_fieldn_t)61)
#define METHODN_isSignificant           ((knh_methodn_t)61)
#define METHODN__isSignificant          ((knh_methodn_t)61|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsSignificant        ((knh_methodn_t)61|KNH_FLAG_MN_GETTER)
#define METHODN_setIsSignificant        ((knh_methodn_t)61|KNH_FLAG_MN_SETTER)
#define FIELDN_isStatic                 ((knh_fieldn_t)62)
#define METHODN_isStatic                ((knh_methodn_t)62)
#define METHODN__isStatic               ((knh_methodn_t)62|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsStatic             ((knh_methodn_t)62|KNH_FLAG_MN_GETTER)
#define METHODN_setIsStatic             ((knh_methodn_t)62|KNH_FLAG_MN_SETTER)
#define FIELDN_isSynchronized           ((knh_fieldn_t)63)
#define METHODN_isSynchronized          ((knh_methodn_t)63)
#define METHODN__isSynchronized         ((knh_methodn_t)63|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsSynchronized       ((knh_methodn_t)63|KNH_FLAG_MN_GETTER)
#define METHODN_setIsSynchronized       ((knh_methodn_t)63|KNH_FLAG_MN_SETTER)
#define FIELDN_isSynonym                ((knh_fieldn_t)64)
#define METHODN_isSynonym               ((knh_methodn_t)64)
#define METHODN__isSynonym              ((knh_methodn_t)64|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsSynonym            ((knh_methodn_t)64|KNH_FLAG_MN_GETTER)
#define METHODN_setIsSynonym            ((knh_methodn_t)64|KNH_FLAG_MN_SETTER)
#define FIELDN_isSystem                 ((knh_fieldn_t)65)
#define METHODN_isSystem                ((knh_methodn_t)65)
#define METHODN__isSystem               ((knh_methodn_t)65|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsSystem             ((knh_methodn_t)65|KNH_FLAG_MN_GETTER)
#define METHODN_setIsSystem             ((knh_methodn_t)65|KNH_FLAG_MN_SETTER)
#define FIELDN_isTemporal               ((knh_fieldn_t)66)
#define METHODN_isTemporal              ((knh_methodn_t)66)
#define METHODN__isTemporal             ((knh_methodn_t)66|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsTemporal           ((knh_methodn_t)66|KNH_FLAG_MN_GETTER)
#define METHODN_setIsTemporal           ((knh_methodn_t)66|KNH_FLAG_MN_SETTER)
#define FIELDN_isTotal                  ((knh_fieldn_t)67)
#define METHODN_isTotal                 ((knh_methodn_t)67)
#define METHODN__isTotal                ((knh_methodn_t)67|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsTotal              ((knh_methodn_t)67|KNH_FLAG_MN_GETTER)
#define METHODN_setIsTotal              ((knh_methodn_t)67|KNH_FLAG_MN_SETTER)
#define FIELDN_isUnsigned               ((knh_fieldn_t)68)
#define METHODN_isUnsigned              ((knh_methodn_t)68)
#define METHODN__isUnsigned             ((knh_methodn_t)68|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsUnsigned           ((knh_methodn_t)68|KNH_FLAG_MN_GETTER)
#define METHODN_setIsUnsigned           ((knh_methodn_t)68|KNH_FLAG_MN_SETTER)
#define FIELDN_isVarArgs                ((knh_fieldn_t)69)
#define METHODN_isVarArgs               ((knh_methodn_t)69)
#define METHODN__isVarArgs              ((knh_methodn_t)69|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsVarArgs            ((knh_methodn_t)69|KNH_FLAG_MN_GETTER)
#define METHODN_setIsVarArgs            ((knh_methodn_t)69|KNH_FLAG_MN_SETTER)
#define FIELDN_isVirtual                ((knh_fieldn_t)70)
#define METHODN_isVirtual               ((knh_methodn_t)70)
#define METHODN__isVirtual              ((knh_methodn_t)70|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getIsVirtual            ((knh_methodn_t)70|KNH_FLAG_MN_GETTER)
#define METHODN_setIsVirtual            ((knh_methodn_t)70|KNH_FLAG_MN_SETTER)
#define FIELDN_key                      ((knh_fieldn_t)71)
#define METHODN_key                     ((knh_methodn_t)71)
#define METHODN__key                    ((knh_methodn_t)71|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getKey                  ((knh_methodn_t)71|KNH_FLAG_MN_GETTER)
#define METHODN_setKey                  ((knh_methodn_t)71|KNH_FLAG_MN_SETTER)
#define FIELDN_keys                     ((knh_fieldn_t)72)
#define METHODN_keys                    ((knh_methodn_t)72)
#define METHODN__keys                   ((knh_methodn_t)72|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getKeys                 ((knh_methodn_t)72|KNH_FLAG_MN_GETTER)
#define METHODN_setKeys                 ((knh_methodn_t)72|KNH_FLAG_MN_SETTER)
#define FIELDN_lambda                   ((knh_fieldn_t)73)
#define METHODN_lambda                  ((knh_methodn_t)73)
#define METHODN__lambda                 ((knh_methodn_t)73|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getLambda               ((knh_methodn_t)73|KNH_FLAG_MN_GETTER)
#define METHODN_setLambda               ((knh_methodn_t)73|KNH_FLAG_MN_SETTER)
#define FIELDN_len                      ((knh_fieldn_t)74)
#define METHODN_len                     ((knh_methodn_t)74)
#define METHODN__len                    ((knh_methodn_t)74|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getLen                  ((knh_methodn_t)74|KNH_FLAG_MN_GETTER)
#define METHODN_setLen                  ((knh_methodn_t)74|KNH_FLAG_MN_SETTER)
#define FIELDN_m                        ((knh_fieldn_t)75)
#define METHODN_m                       ((knh_methodn_t)75)
#define METHODN__m                      ((knh_methodn_t)75|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getM                    ((knh_methodn_t)75|KNH_FLAG_MN_GETTER)
#define METHODN_setM                    ((knh_methodn_t)75|KNH_FLAG_MN_SETTER)
#define FIELDN_modified                 ((knh_fieldn_t)76)
#define METHODN_modified                ((knh_methodn_t)76)
#define METHODN__modified               ((knh_methodn_t)76|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getModified             ((knh_methodn_t)76|KNH_FLAG_MN_GETTER)
#define METHODN_setModified             ((knh_methodn_t)76|KNH_FLAG_MN_SETTER)
#define FIELDN_n                        ((knh_fieldn_t)77)
#define METHODN_n                       ((knh_methodn_t)77)
#define METHODN__n                      ((knh_methodn_t)77|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getN                    ((knh_methodn_t)77|KNH_FLAG_MN_GETTER)
#define METHODN_setN                    ((knh_methodn_t)77|KNH_FLAG_MN_SETTER)
#define FIELDN_name                     ((knh_fieldn_t)78)
#define METHODN_name                    ((knh_methodn_t)78)
#define METHODN__name                   ((knh_methodn_t)78|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getName                 ((knh_methodn_t)78|KNH_FLAG_MN_GETTER)
#define METHODN_setName                 ((knh_methodn_t)78|KNH_FLAG_MN_SETTER)
#define FIELDN_new                      ((knh_fieldn_t)79)
#define METHODN_new                     ((knh_methodn_t)79)
#define METHODN__new                    ((knh_methodn_t)79|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getNew                  ((knh_methodn_t)79|KNH_FLAG_MN_GETTER)
#define METHODN_setNew                  ((knh_methodn_t)79|KNH_FLAG_MN_SETTER)
#define FIELDN_new__array               ((knh_fieldn_t)80)
#define METHODN_new__array              ((knh_methodn_t)80)
#define METHODN__new__array             ((knh_methodn_t)80|KNH_FLAG_MN_MOVTEXT)
#define FIELDN_new__init                ((knh_fieldn_t)81)
#define METHODN_new__init               ((knh_methodn_t)81)
#define METHODN__new__init              ((knh_methodn_t)81|KNH_FLAG_MN_MOVTEXT)
#define FIELDN_new__offset              ((knh_fieldn_t)82)
#define METHODN_new__offset             ((knh_methodn_t)82)
#define METHODN__new__offset            ((knh_methodn_t)82|KNH_FLAG_MN_MOVTEXT)
#define FIELDN_new__slice               ((knh_fieldn_t)83)
#define METHODN_new__slice              ((knh_methodn_t)83)
#define METHODN__new__slice             ((knh_methodn_t)83|KNH_FLAG_MN_MOVTEXT)
#define FIELDN_next                     ((knh_fieldn_t)84)
#define METHODN_next                    ((knh_methodn_t)84)
#define METHODN__next                   ((knh_methodn_t)84|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getNext                 ((knh_methodn_t)84|KNH_FLAG_MN_GETTER)
#define METHODN_setNext                 ((knh_methodn_t)84|KNH_FLAG_MN_SETTER)
#define FIELDN_o                        ((knh_fieldn_t)85)
#define METHODN_o                       ((knh_methodn_t)85)
#define METHODN__o                      ((knh_methodn_t)85|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getO                    ((knh_methodn_t)85|KNH_FLAG_MN_GETTER)
#define METHODN_setO                    ((knh_methodn_t)85|KNH_FLAG_MN_SETTER)
#define FIELDN_offset                   ((knh_fieldn_t)86)
#define METHODN_offset                  ((knh_methodn_t)86)
#define METHODN__offset                 ((knh_methodn_t)86|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOffset               ((knh_methodn_t)86|KNH_FLAG_MN_GETTER)
#define METHODN_setOffset               ((knh_methodn_t)86|KNH_FLAG_MN_SETTER)
#define FIELDN_old                      ((knh_fieldn_t)87)
#define METHODN_old                     ((knh_methodn_t)87)
#define METHODN__old                    ((knh_methodn_t)87|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOld                  ((knh_methodn_t)87|KNH_FLAG_MN_GETTER)
#define METHODN_setOld                  ((knh_methodn_t)87|KNH_FLAG_MN_SETTER)
#define FIELDN_opAdd                    ((knh_fieldn_t)88)
#define METHODN_opAdd                   ((knh_methodn_t)88)
#define METHODN__opAdd                  ((knh_methodn_t)88|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpAdd                ((knh_methodn_t)88|KNH_FLAG_MN_GETTER)
#define METHODN_setOpAdd                ((knh_methodn_t)88|KNH_FLAG_MN_SETTER)
#define FIELDN_opAdd__2                 ((knh_fieldn_t)89)
#define METHODN_opAdd__2                ((knh_methodn_t)89)
#define METHODN__opAdd__2               ((knh_methodn_t)89|KNH_FLAG_MN_MOVTEXT)
#define FIELDN_opDiv                    ((knh_fieldn_t)90)
#define METHODN_opDiv                   ((knh_methodn_t)90)
#define METHODN__opDiv                  ((knh_methodn_t)90|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpDiv                ((knh_methodn_t)90|KNH_FLAG_MN_GETTER)
#define METHODN_setOpDiv                ((knh_methodn_t)90|KNH_FLAG_MN_SETTER)
#define FIELDN_opDiv__2                 ((knh_fieldn_t)91)
#define METHODN_opDiv__2                ((knh_methodn_t)91)
#define METHODN__opDiv__2               ((knh_methodn_t)91|KNH_FLAG_MN_MOVTEXT)
#define FIELDN_opEq                     ((knh_fieldn_t)92)
#define METHODN_opEq                    ((knh_methodn_t)92)
#define METHODN__opEq                   ((knh_methodn_t)92|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpEq                 ((knh_methodn_t)92|KNH_FLAG_MN_GETTER)
#define METHODN_setOpEq                 ((knh_methodn_t)92|KNH_FLAG_MN_SETTER)
#define FIELDN_opGt                     ((knh_fieldn_t)93)
#define METHODN_opGt                    ((knh_methodn_t)93)
#define METHODN__opGt                   ((knh_methodn_t)93|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpGt                 ((knh_methodn_t)93|KNH_FLAG_MN_GETTER)
#define METHODN_setOpGt                 ((knh_methodn_t)93|KNH_FLAG_MN_SETTER)
#define FIELDN_opGte                    ((knh_fieldn_t)94)
#define METHODN_opGte                   ((knh_methodn_t)94)
#define METHODN__opGte                  ((knh_methodn_t)94|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpGte                ((knh_methodn_t)94|KNH_FLAG_MN_GETTER)
#define METHODN_setOpGte                ((knh_methodn_t)94|KNH_FLAG_MN_SETTER)
#define FIELDN_opIn                     ((knh_fieldn_t)95)
#define METHODN_opIn                    ((knh_methodn_t)95)
#define METHODN__opIn                   ((knh_methodn_t)95|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpIn                 ((knh_methodn_t)95|KNH_FLAG_MN_GETTER)
#define METHODN_setOpIn                 ((knh_methodn_t)95|KNH_FLAG_MN_SETTER)
#define FIELDN_opInstanceof             ((knh_fieldn_t)96)
#define METHODN_opInstanceof            ((knh_methodn_t)96)
#define METHODN__opInstanceof           ((knh_methodn_t)96|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpInstanceof         ((knh_methodn_t)96|KNH_FLAG_MN_GETTER)
#define METHODN_setOpInstanceof         ((knh_methodn_t)96|KNH_FLAG_MN_SETTER)
#define FIELDN_opIsMapTo                ((knh_fieldn_t)97)
#define METHODN_opIsMapTo               ((knh_methodn_t)97)
#define METHODN__opIsMapTo              ((knh_methodn_t)97|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpIsMapTo            ((knh_methodn_t)97|KNH_FLAG_MN_GETTER)
#define METHODN_setOpIsMapTo            ((knh_methodn_t)97|KNH_FLAG_MN_SETTER)
#define FIELDN_opLShift                 ((knh_fieldn_t)98)
#define METHODN_opLShift                ((knh_methodn_t)98)
#define METHODN__opLShift               ((knh_methodn_t)98|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLShift             ((knh_methodn_t)98|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLShift             ((knh_methodn_t)98|KNH_FLAG_MN_SETTER)
#define FIELDN_opLogicalAnd             ((knh_fieldn_t)99)
#define METHODN_opLogicalAnd            ((knh_methodn_t)99)
#define METHODN__opLogicalAnd           ((knh_methodn_t)99|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLogicalAnd         ((knh_methodn_t)99|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLogicalAnd         ((knh_methodn_t)99|KNH_FLAG_MN_SETTER)
#define FIELDN_opLogicalNot             ((knh_fieldn_t)100)
#define METHODN_opLogicalNot            ((knh_methodn_t)100)
#define METHODN__opLogicalNot           ((knh_methodn_t)100|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLogicalNot         ((knh_methodn_t)100|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLogicalNot         ((knh_methodn_t)100|KNH_FLAG_MN_SETTER)
#define FIELDN_opLogicalOr              ((knh_fieldn_t)101)
#define METHODN_opLogicalOr             ((knh_methodn_t)101)
#define METHODN__opLogicalOr            ((knh_methodn_t)101|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLogicalOr          ((knh_methodn_t)101|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLogicalOr          ((knh_methodn_t)101|KNH_FLAG_MN_SETTER)
#define FIELDN_opLogicalXor             ((knh_fieldn_t)102)
#define METHODN_opLogicalXor            ((knh_methodn_t)102)
#define METHODN__opLogicalXor           ((knh_methodn_t)102|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLogicalXor         ((knh_methodn_t)102|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLogicalXor         ((knh_methodn_t)102|KNH_FLAG_MN_SETTER)
#define FIELDN_opLt                     ((knh_fieldn_t)103)
#define METHODN_opLt                    ((knh_methodn_t)103)
#define METHODN__opLt                   ((knh_methodn_t)103|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLt                 ((knh_methodn_t)103|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLt                 ((knh_methodn_t)103|KNH_FLAG_MN_SETTER)
#define FIELDN_opLte                    ((knh_fieldn_t)104)
#define METHODN_opLte                   ((knh_methodn_t)104)
#define METHODN__opLte                  ((knh_methodn_t)104|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpLte                ((knh_methodn_t)104|KNH_FLAG_MN_GETTER)
#define METHODN_setOpLte                ((knh_methodn_t)104|KNH_FLAG_MN_SETTER)
#define FIELDN_opMod                    ((knh_fieldn_t)105)
#define METHODN_opMod                   ((knh_methodn_t)105)
#define METHODN__opMod                  ((knh_methodn_t)105|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpMod                ((knh_methodn_t)105|KNH_FLAG_MN_GETTER)
#define METHODN_setOpMod                ((knh_methodn_t)105|KNH_FLAG_MN_SETTER)
#define FIELDN_opMul                    ((knh_fieldn_t)106)
#define METHODN_opMul                   ((knh_methodn_t)106)
#define METHODN__opMul                  ((knh_methodn_t)106|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpMul                ((knh_methodn_t)106|KNH_FLAG_MN_GETTER)
#define METHODN_setOpMul                ((knh_methodn_t)106|KNH_FLAG_MN_SETTER)
#define FIELDN_opMul__2                 ((knh_fieldn_t)107)
#define METHODN_opMul__2                ((knh_methodn_t)107)
#define METHODN__opMul__2               ((knh_methodn_t)107|KNH_FLAG_MN_MOVTEXT)
#define FIELDN_opNeg                    ((knh_fieldn_t)108)
#define METHODN_opNeg                   ((knh_methodn_t)108)
#define METHODN__opNeg                  ((knh_methodn_t)108|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpNeg                ((knh_methodn_t)108|KNH_FLAG_MN_GETTER)
#define METHODN_setOpNeg                ((knh_methodn_t)108|KNH_FLAG_MN_SETTER)
#define FIELDN_opNeq                    ((knh_fieldn_t)109)
#define METHODN_opNeq                   ((knh_methodn_t)109)
#define METHODN__opNeq                  ((knh_methodn_t)109|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpNeq                ((knh_methodn_t)109|KNH_FLAG_MN_GETTER)
#define METHODN_setOpNeq                ((knh_methodn_t)109|KNH_FLAG_MN_SETTER)
#define FIELDN_opNext                   ((knh_fieldn_t)110)
#define METHODN_opNext                  ((knh_methodn_t)110)
#define METHODN__opNext                 ((knh_methodn_t)110|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpNext               ((knh_methodn_t)110|KNH_FLAG_MN_GETTER)
#define METHODN_setOpNext               ((knh_methodn_t)110|KNH_FLAG_MN_SETTER)
#define FIELDN_opNot                    ((knh_fieldn_t)111)
#define METHODN_opNot                   ((knh_methodn_t)111)
#define METHODN__opNot                  ((knh_methodn_t)111|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpNot                ((knh_methodn_t)111|KNH_FLAG_MN_GETTER)
#define METHODN_setOpNot                ((knh_methodn_t)111|KNH_FLAG_MN_SETTER)
#define FIELDN_opOffset                 ((knh_fieldn_t)112)
#define METHODN_opOffset                ((knh_methodn_t)112)
#define METHODN__opOffset               ((knh_methodn_t)112|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpOffset             ((knh_methodn_t)112|KNH_FLAG_MN_GETTER)
#define METHODN_setOpOffset             ((knh_methodn_t)112|KNH_FLAG_MN_SETTER)
#define FIELDN_opPrev                   ((knh_fieldn_t)113)
#define METHODN_opPrev                  ((knh_methodn_t)113)
#define METHODN__opPrev                 ((knh_methodn_t)113|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpPrev               ((knh_methodn_t)113|KNH_FLAG_MN_GETTER)
#define METHODN_setOpPrev               ((knh_methodn_t)113|KNH_FLAG_MN_SETTER)
#define FIELDN_opRShift                 ((knh_fieldn_t)114)
#define METHODN_opRShift                ((knh_methodn_t)114)
#define METHODN__opRShift               ((knh_methodn_t)114|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpRShift             ((knh_methodn_t)114|KNH_FLAG_MN_GETTER)
#define METHODN_setOpRShift             ((knh_methodn_t)114|KNH_FLAG_MN_SETTER)
#define FIELDN_opSeq                    ((knh_fieldn_t)115)
#define METHODN_opSeq                   ((knh_methodn_t)115)
#define METHODN__opSeq                  ((knh_methodn_t)115|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpSeq                ((knh_methodn_t)115|KNH_FLAG_MN_GETTER)
#define METHODN_setOpSeq                ((knh_methodn_t)115|KNH_FLAG_MN_SETTER)
#define FIELDN_opSlice                  ((knh_fieldn_t)116)
#define METHODN_opSlice                 ((knh_methodn_t)116)
#define METHODN__opSlice                ((knh_methodn_t)116|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpSlice              ((knh_methodn_t)116|KNH_FLAG_MN_GETTER)
#define METHODN_setOpSlice              ((knh_methodn_t)116|KNH_FLAG_MN_SETTER)
#define FIELDN_opSub                    ((knh_fieldn_t)117)
#define METHODN_opSub                   ((knh_methodn_t)117)
#define METHODN__opSub                  ((knh_methodn_t)117|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpSub                ((knh_methodn_t)117|KNH_FLAG_MN_GETTER)
#define METHODN_setOpSub                ((knh_methodn_t)117|KNH_FLAG_MN_SETTER)
#define FIELDN_opSub__2                 ((knh_fieldn_t)118)
#define METHODN_opSub__2                ((knh_methodn_t)118)
#define METHODN__opSub__2               ((knh_methodn_t)118|KNH_FLAG_MN_MOVTEXT)
#define FIELDN_opSubset                 ((knh_fieldn_t)119)
#define METHODN_opSubset                ((knh_methodn_t)119)
#define METHODN__opSubset               ((knh_methodn_t)119|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOpSubset             ((knh_methodn_t)119|KNH_FLAG_MN_GETTER)
#define METHODN_setOpSubset             ((knh_methodn_t)119|KNH_FLAG_MN_SETTER)
#define FIELDN_out                      ((knh_fieldn_t)120)
#define METHODN_out                     ((knh_methodn_t)120)
#define METHODN__out                    ((knh_methodn_t)120|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getOut                  ((knh_methodn_t)120|KNH_FLAG_MN_GETTER)
#define METHODN_setOut                  ((knh_methodn_t)120|KNH_FLAG_MN_SETTER)
#define FIELDN_pop                      ((knh_fieldn_t)121)
#define METHODN_pop                     ((knh_methodn_t)121)
#define METHODN__pop                    ((knh_methodn_t)121|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getPop                  ((knh_methodn_t)121|KNH_FLAG_MN_GETTER)
#define METHODN_setPop                  ((knh_methodn_t)121|KNH_FLAG_MN_SETTER)
#define FIELDN_print                    ((knh_fieldn_t)122)
#define METHODN_print                   ((knh_methodn_t)122)
#define METHODN__print                  ((knh_methodn_t)122|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getPrint                ((knh_methodn_t)122|KNH_FLAG_MN_GETTER)
#define METHODN_setPrint                ((knh_methodn_t)122|KNH_FLAG_MN_SETTER)
#define FIELDN_println                  ((knh_fieldn_t)123)
#define METHODN_println                 ((knh_methodn_t)123)
#define METHODN__println                ((knh_methodn_t)123|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getPrintln              ((knh_methodn_t)123|KNH_FLAG_MN_GETTER)
#define METHODN_setPrintln              ((knh_methodn_t)123|KNH_FLAG_MN_SETTER)
#define FIELDN_property                 ((knh_fieldn_t)124)
#define METHODN_property                ((knh_methodn_t)124)
#define METHODN__property               ((knh_methodn_t)124|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getProperty             ((knh_methodn_t)124|KNH_FLAG_MN_GETTER)
#define METHODN_setProperty             ((knh_methodn_t)124|KNH_FLAG_MN_SETTER)
#define FIELDN_query                    ((knh_fieldn_t)125)
#define METHODN_query                   ((knh_methodn_t)125)
#define METHODN__query                  ((knh_methodn_t)125|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getQuery                ((knh_methodn_t)125|KNH_FLAG_MN_GETTER)
#define METHODN_setQuery                ((knh_methodn_t)125|KNH_FLAG_MN_SETTER)
#define FIELDN_random                   ((knh_fieldn_t)126)
#define METHODN_random                  ((knh_methodn_t)126)
#define METHODN__random                 ((knh_methodn_t)126|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getRandom               ((knh_methodn_t)126|KNH_FLAG_MN_GETTER)
#define METHODN_setRandom               ((knh_methodn_t)126|KNH_FLAG_MN_SETTER)
#define FIELDN_readLine                 ((knh_fieldn_t)127)
#define METHODN_readLine                ((knh_methodn_t)127)
#define METHODN__readLine               ((knh_methodn_t)127|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getReadLine             ((knh_methodn_t)127|KNH_FLAG_MN_GETTER)
#define METHODN_setReadLine             ((knh_methodn_t)127|KNH_FLAG_MN_SETTER)
#define FIELDN_refc                     ((knh_fieldn_t)128)
#define METHODN_refc                    ((knh_methodn_t)128)
#define METHODN__refc                   ((knh_methodn_t)128|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getRefc                 ((knh_methodn_t)128|KNH_FLAG_MN_GETTER)
#define METHODN_setRefc                 ((knh_methodn_t)128|KNH_FLAG_MN_SETTER)
#define FIELDN_remove                   ((knh_fieldn_t)129)
#define METHODN_remove                  ((knh_methodn_t)129)
#define METHODN__remove                 ((knh_methodn_t)129|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getRemove               ((knh_methodn_t)129|KNH_FLAG_MN_GETTER)
#define METHODN_setRemove               ((knh_methodn_t)129|KNH_FLAG_MN_SETTER)
#define FIELDN_replace                  ((knh_fieldn_t)130)
#define METHODN_replace                 ((knh_methodn_t)130)
#define METHODN__replace                ((knh_methodn_t)130|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getReplace              ((knh_methodn_t)130|KNH_FLAG_MN_GETTER)
#define METHODN_setReplace              ((knh_methodn_t)130|KNH_FLAG_MN_SETTER)
#define FIELDN_repr                     ((knh_fieldn_t)131)
#define METHODN_repr                    ((knh_methodn_t)131)
#define METHODN__repr                   ((knh_methodn_t)131|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getRepr                 ((knh_methodn_t)131|KNH_FLAG_MN_GETTER)
#define METHODN_setRepr                 ((knh_methodn_t)131|KNH_FLAG_MN_SETTER)
#define FIELDN_s                        ((knh_fieldn_t)132)
#define METHODN_s                       ((knh_methodn_t)132)
#define METHODN__s                      ((knh_methodn_t)132|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getS                    ((knh_methodn_t)132|KNH_FLAG_MN_GETTER)
#define METHODN_setS                    ((knh_methodn_t)132|KNH_FLAG_MN_SETTER)
#define FIELDN_second                   ((knh_fieldn_t)133)
#define METHODN_second                  ((knh_methodn_t)133)
#define METHODN__second                 ((knh_methodn_t)133|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getSecond               ((knh_methodn_t)133|KNH_FLAG_MN_GETTER)
#define METHODN_setSecond               ((knh_methodn_t)133|KNH_FLAG_MN_SETTER)
#define FIELDN_size                     ((knh_fieldn_t)134)
#define METHODN_size                    ((knh_methodn_t)134)
#define METHODN__size                   ((knh_methodn_t)134|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getSize                 ((knh_methodn_t)134|KNH_FLAG_MN_GETTER)
#define METHODN_setSize                 ((knh_methodn_t)134|KNH_FLAG_MN_SETTER)
#define FIELDN_startsWith               ((knh_fieldn_t)135)
#define METHODN_startsWith              ((knh_methodn_t)135)
#define METHODN__startsWith             ((knh_methodn_t)135|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getStartsWith           ((knh_methodn_t)135|KNH_FLAG_MN_GETTER)
#define METHODN_setStartsWith           ((knh_methodn_t)135|KNH_FLAG_MN_SETTER)
#define FIELDN_t                        ((knh_fieldn_t)136)
#define METHODN_t                       ((knh_methodn_t)136)
#define METHODN__t                      ((knh_methodn_t)136|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getT                    ((knh_methodn_t)136|KNH_FLAG_MN_GETTER)
#define METHODN_setT                    ((knh_methodn_t)136|KNH_FLAG_MN_SETTER)
#define FIELDN_term                     ((knh_fieldn_t)137)
#define METHODN_term                    ((knh_methodn_t)137)
#define METHODN__term                   ((knh_methodn_t)137|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getTerm                 ((knh_methodn_t)137|KNH_FLAG_MN_GETTER)
#define METHODN_setTerm                 ((knh_methodn_t)137|KNH_FLAG_MN_SETTER)
#define FIELDN_this                     ((knh_fieldn_t)138)
#define METHODN_this                    ((knh_methodn_t)138)
#define METHODN__this                   ((knh_methodn_t)138|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getThis                 ((knh_methodn_t)138|KNH_FLAG_MN_GETTER)
#define METHODN_setThis                 ((knh_methodn_t)138|KNH_FLAG_MN_SETTER)
#define FIELDN_toLower                  ((knh_fieldn_t)139)
#define METHODN_toLower                 ((knh_methodn_t)139)
#define METHODN__toLower                ((knh_methodn_t)139|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getToLower              ((knh_methodn_t)139|KNH_FLAG_MN_GETTER)
#define METHODN_setToLower              ((knh_methodn_t)139|KNH_FLAG_MN_SETTER)
#define FIELDN_toUpper                  ((knh_fieldn_t)140)
#define METHODN_toUpper                 ((knh_methodn_t)140)
#define METHODN__toUpper                ((knh_methodn_t)140|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getToUpper              ((knh_methodn_t)140|KNH_FLAG_MN_GETTER)
#define METHODN_setToUpper              ((knh_methodn_t)140|KNH_FLAG_MN_SETTER)
#define FIELDN_trim                     ((knh_fieldn_t)141)
#define METHODN_trim                    ((knh_methodn_t)141)
#define METHODN__trim                   ((knh_methodn_t)141|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getTrim                 ((knh_methodn_t)141|KNH_FLAG_MN_GETTER)
#define METHODN_setTrim                 ((knh_methodn_t)141|KNH_FLAG_MN_SETTER)
#define FIELDN_uRN                      ((knh_fieldn_t)142)
#define METHODN_uRN                     ((knh_methodn_t)142)
#define METHODN__uRN                    ((knh_methodn_t)142|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getURN                  ((knh_methodn_t)142|KNH_FLAG_MN_GETTER)
#define METHODN_setURN                  ((knh_methodn_t)142|KNH_FLAG_MN_SETTER)
#define FIELDN_urn                      ((knh_fieldn_t)143)
#define METHODN_urn                     ((knh_methodn_t)143)
#define METHODN__urn                    ((knh_methodn_t)143|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getUrn                  ((knh_methodn_t)143|KNH_FLAG_MN_GETTER)
#define METHODN_setUrn                  ((knh_methodn_t)143|KNH_FLAG_MN_SETTER)
#define FIELDN_v                        ((knh_fieldn_t)144)
#define METHODN_v                       ((knh_methodn_t)144)
#define METHODN__v                      ((knh_methodn_t)144|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getV                    ((knh_methodn_t)144|KNH_FLAG_MN_GETTER)
#define METHODN_setV                    ((knh_methodn_t)144|KNH_FLAG_MN_SETTER)
#define FIELDN_value                    ((knh_fieldn_t)145)
#define METHODN_value                   ((knh_methodn_t)145)
#define METHODN__value                  ((knh_methodn_t)145|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getValue                ((knh_methodn_t)145|KNH_FLAG_MN_GETTER)
#define METHODN_setValue                ((knh_methodn_t)145|KNH_FLAG_MN_SETTER)
#define FIELDN_vargs                    ((knh_fieldn_t)146)
#define METHODN_vargs                   ((knh_methodn_t)146)
#define METHODN__vargs                  ((knh_methodn_t)146|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getVargs                ((knh_methodn_t)146|KNH_FLAG_MN_GETTER)
#define METHODN_setVargs                ((knh_methodn_t)146|KNH_FLAG_MN_SETTER)
#define FIELDN_w                        ((knh_fieldn_t)147)
#define METHODN_w                       ((knh_methodn_t)147)
#define METHODN__w                      ((knh_methodn_t)147|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getW                    ((knh_methodn_t)147|KNH_FLAG_MN_GETTER)
#define METHODN_setW                    ((knh_methodn_t)147|KNH_FLAG_MN_SETTER)
#define FIELDN_write                    ((knh_fieldn_t)148)
#define METHODN_write                   ((knh_methodn_t)148)
#define METHODN__write                  ((knh_methodn_t)148|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getWrite                ((knh_methodn_t)148|KNH_FLAG_MN_GETTER)
#define METHODN_setWrite                ((knh_methodn_t)148|KNH_FLAG_MN_SETTER)
#define FIELDN_x                        ((knh_fieldn_t)149)
#define METHODN_x                       ((knh_methodn_t)149)
#define METHODN__x                      ((knh_methodn_t)149|KNH_FLAG_MN_MOVTEXT)
#define METHODN_getX                    ((knh_methodn_t)149|KNH_FLAG_MN_GETTER)
#define METHODN_setX                    ((knh_methodn_t)149|KNH_FLAG_MN_SETTER)
#define KNH_TFIELDN_SIZE                300

/* ======================================================================== */
/* [MFN] */
#define MFN_Any_Any_            0
#define MF_Any_Any_                     knh_tMethodField[MFN_Any_Any_]
#define MFN_void_OutputStream_Any 1
#define MF_void_OutputStream_Any        knh_tMethodField[MFN_void_OutputStream_Any]
#define MFN_Any                 2
#define MF_Any                          knh_tMethodField[MFN_Any]
#define MFN_nThis_Int           3
#define MF_nThis_Int                    knh_tMethodField[MFN_nThis_Int]
#define MFN_nThis_Int_Any1      4
#define MF_nThis_Int_Any1               knh_tMethodField[MFN_nThis_Int_Any1]
#define MFN_nThis_Any1_         5
#define MF_nThis_Any1_                  knh_tMethodField[MFN_nThis_Any1_]
#define MFN_void_Any1           6
#define MF_void_Any1                    knh_tMethodField[MFN_void_Any1]
#define MFN_void_Any1_          7
#define MF_void_Any1_                   knh_tMethodField[MFN_void_Any1_]
#define MFN_nInt                8
#define MF_nInt                         knh_tMethodField[MFN_nInt]
#define MFN_Any1_nInt           9
#define MF_Any1_nInt                    knh_tMethodField[MFN_Any1_nInt]
#define MFN_void_nInt_Any1      10
#define MF_void_nInt_Any1               knh_tMethodField[MFN_void_nInt_Any1]
#define MFN_Any1                11
#define MF_Any1                         knh_tMethodField[MFN_Any1]
#define MFN_void_nInt           12
#define MF_void_nInt                    knh_tMethodField[MFN_void_nInt]
#define MFN_void                13
#define MF_void                         knh_tMethodField[MFN_void]
#define MFN_nThis_Int_Int       14
#define MF_nThis_Int_Int                knh_tMethodField[MFN_nThis_Int_Int]
#define MFN_nBoolean_Any        15
#define MF_nBoolean_Any                 knh_tMethodField[MFN_nBoolean_Any]
#define MFN_nBytes_Int          16
#define MF_nBytes_Int                   knh_tMethodField[MFN_nBytes_Int]
#define MFN_nConnection_nString 17
#define MF_nConnection_nString          knh_tMethodField[MFN_nConnection_nString]
#define MFN_ResultSet_nString   18
#define MF_ResultSet_nString            knh_tMethodField[MFN_ResultSet_nString]
#define MFN_Any_nString         19
#define MF_Any_nString                  knh_tMethodField[MFN_Any_nString]
#define MFN_void_nString_Any    20
#define MF_void_nString_Any             knh_tMethodField[MFN_void_nString_Any]
#define MFN_void_String         21
#define MF_void_String                  knh_tMethodField[MFN_void_String]
#define MFN_nInt_nString        22
#define MF_nInt_nString                 knh_tMethodField[MFN_nInt_nString]
#define MFN_String_nInt         23
#define MF_String_nInt                  knh_tMethodField[MFN_String_nInt]
#define MFN_nDictMap_Int        24
#define MF_nDictMap_Int                 knh_tMethodField[MFN_nDictMap_Int]
#define MFN_void_nString_nAny   25
#define MF_void_nString_nAny            knh_tMethodField[MFN_void_nString_nAny]
#define MFN_void_nString        26
#define MF_void_nString                 knh_tMethodField[MFN_void_nString]
#define MFN_nDictSet_Int        27
#define MF_nDictSet_Int                 knh_tMethodField[MFN_nDictSet_Int]
#define MFN_Boolean_Any         28
#define MF_Boolean_Any                  knh_tMethodField[MFN_Boolean_Any]
#define MFN_void_nString_nInt   29
#define MF_void_nString_nInt            knh_tMethodField[MFN_void_nString_nInt]
#define MFN_nFloat_nFloat       30
#define MF_nFloat_nFloat                knh_tMethodField[MFN_nFloat_nFloat]
#define MFN_nFloat              31
#define MF_nFloat                       knh_tMethodField[MFN_nFloat]
#define MFN_nFloat_nFloat_      32
#define MF_nFloat_nFloat_               knh_tMethodField[MFN_nFloat_nFloat_]
#define MFN_nBoolean_nFloat     33
#define MF_nBoolean_nFloat              knh_tMethodField[MFN_nBoolean_nFloat]
#define MFN_Float               34
#define MF_Float                        knh_tMethodField[MFN_Float]
#define MFN_Any2_Any1           35
#define MF_Any2_Any1                    knh_tMethodField[MFN_Any2_Any1]
#define MFN_void_Any1_Any2      36
#define MF_void_Any1_Any2               knh_tMethodField[MFN_void_Any1_Any2]
#define MFN_nHashMap_Int        37
#define MF_nHashMap_Int                 knh_tMethodField[MFN_nHashMap_Int]
#define MFN_nHashMap_Any_       38
#define MF_nHashMap_Any_                knh_tMethodField[MFN_nHashMap_Any_]
#define MFN_Boolean_Any1        39
#define MF_Boolean_Any1                 knh_tMethodField[MFN_Boolean_Any1]
#define MFN_nIterator           40
#define MF_nIterator                    knh_tMethodField[MFN_nIterator]
#define MFN_nInt_Any1           41
#define MF_nInt_Any1                    knh_tMethodField[MFN_nInt_Any1]
#define MFN_void_Any1_nInt      42
#define MF_void_Any1_nInt               knh_tMethodField[MFN_void_Any1_nInt]
#define MFN_nHashSet_Int        43
#define MF_nHashSet_Int                 knh_tMethodField[MFN_nHashSet_Int]
#define MFN_String              44
#define MF_String                       knh_tMethodField[MFN_String]
#define MFN_nInt_nInt           45
#define MF_nInt_nInt                    knh_tMethodField[MFN_nInt_nInt]
#define MFN_nInt_nInt_          46
#define MF_nInt_nInt_                   knh_tMethodField[MFN_nInt_nInt_]
#define MFN_nBoolean_nInt       47
#define MF_nBoolean_nInt                knh_tMethodField[MFN_nBoolean_nInt]
#define MFN_nInt_Int            48
#define MF_nInt_Int                     knh_tMethodField[MFN_nInt_Int]
#define MFN_nInt_nInt_Class     49
#define MF_nInt_nInt_Class              knh_tMethodField[MFN_nInt_nInt_Class]
#define MFN_Boolean_nInt        50
#define MF_Boolean_nInt                 knh_tMethodField[MFN_Boolean_nInt]
#define MFN_Boolean             51
#define MF_Boolean                      knh_tMethodField[MFN_Boolean]
#define MFN_nString             52
#define MF_nString                      knh_tMethodField[MFN_nString]
#define MFN_nFloat_nNumber      53
#define MF_nFloat_nNumber               knh_tMethodField[MFN_nFloat_nNumber]
#define MFN_nFloat_nNumber_     54
#define MF_nFloat_nNumber_              knh_tMethodField[MFN_nFloat_nNumber_]
#define MFN_nBoolean_nNumber    55
#define MF_nBoolean_nNumber             knh_tMethodField[MFN_nBoolean_nNumber]
#define MFN_nThis               56
#define MF_nThis                        knh_tMethodField[MFN_nThis]
#define MFN_nInt_Any            57
#define MF_nInt_Any                     knh_tMethodField[MFN_nInt_Any]
#define MFN_Class               58
#define MF_Class                        knh_tMethodField[MFN_Class]
#define MFN_void_nBytes_Int_Int 59
#define MF_void_nBytes_Int_Int          knh_tMethodField[MFN_void_nBytes_Int_Int]
#define MFN_void_Any            60
#define MF_void_Any                     knh_tMethodField[MFN_void_Any]
#define MFN_nRange_Any1_Any1    61
#define MF_nRange_Any1_Any1             knh_tMethodField[MFN_nRange_Any1_Any1]
#define MFN_nRange_Any1_Int     62
#define MF_nRange_Any1_Int              knh_tMethodField[MFN_nRange_Any1_Int]
#define MFN_ResultSet           63
#define MF_ResultSet                    knh_tMethodField[MFN_ResultSet]
#define MFN_nBoolean_nString    64
#define MF_nBoolean_nString             knh_tMethodField[MFN_nBoolean_nString]
#define MFN_nString_Any         65
#define MF_nString_Any                  knh_tMethodField[MFN_nString_Any]
#define MFN_nString_Any_        66
#define MF_nString_Any_                 knh_tMethodField[MFN_nString_Any_]
#define MFN_nString_nString     67
#define MF_nString_nString              knh_tMethodField[MFN_nString_nString]
#define MFN_nString_nString_nString 68
#define MF_nString_nString_nString      knh_tMethodField[MFN_nString_nString_nString]
#define MFN_nString_String      69
#define MF_nString_String               knh_tMethodField[MFN_nString_String]
#define MFN_nString_nInt        70
#define MF_nString_nInt                 knh_tMethodField[MFN_nString_nInt]
#define MFN_nString_Int_Int     71
#define MF_nString_Int_Int              knh_tMethodField[MFN_nString_Int_Int]
#define MFN_nInputStream        72
#define MF_nInputStream                 knh_tMethodField[MFN_nInputStream]
#define MFN_void_InputStream    73
#define MF_void_InputStream             knh_tMethodField[MFN_void_InputStream]
#define MFN_nOutputStream       74
#define MF_nOutputStream                knh_tMethodField[MFN_nOutputStream]
#define MFN_void_OutputStream   75
#define MF_void_OutputStream            knh_tMethodField[MFN_void_OutputStream]
#define MFN_nTuple2_Any1_Any2   76
#define MF_nTuple2_Any1_Any2            knh_tMethodField[MFN_nTuple2_Any1_Any2]
#define MFN_Any_nInt            77
#define MF_Any_nInt                     knh_tMethodField[MFN_Any_nInt]
#define MFN_Boolean_Class       78
#define MF_Boolean_Class                knh_tMethodField[MFN_Boolean_Class]
#define MFN_nBoolean            79
#define MF_nBoolean                     knh_tMethodField[MFN_nBoolean]
#define MFN_void_Boolean        80
#define MF_void_Boolean                 knh_tMethodField[MFN_void_Boolean]
#define KNH_TMETHODFIELD_SIZE   81

/* ======================================================================== */
/* [macros] */
#define knh_AffineConv_struct_copy      NULL
#define knh_AffineConv_struct_compare   NULL
#define knh_AffineConv_struct_traverse  NULL
#define KNH_FLAG_MMF_AFFINE (KNH_FLAG_MMF_SIGNIFICANT|KNH_FLAG_MMF_SYNONYM|KNH_FLAG_MMF_TOTAL|KNH_FLAG_MMF_STATIC)
#define knh_Array_n(a,n)      (a)->list[(n)]
#define knh_Array_size(a)     (a)->size
#define IS_TRUE(o)             (o != KNH_FALSE && IS_NOTNULL(o))
#define IS_FALSE(o)            (o == KNH_FALSE || IS_NULL(o))
#define BOOL_ISTRUE(o)         (o == KNH_TRUE)
#define BOOL_ISFALSE(o)        (o == KNH_FALSE)
#define new_Boolean(ctx,b)     ((b) ? KNH_TRUE : KNH_FALSE)
#define knh_Bytes_size(o)      (o)->size
#define knh_Bytes_value(o)     (o)->buf
#define knh_Bytes_last(o)      ((o)->buf + (o)->size)
#define knh_Bytes_tochar(b)  (char*)knh_Bytes_value(b)
#define KNH_SIZE(v)         knh_size(v)
#define B(c)     new_bytes(c)
#define B2(c,n)   new_bytes__2(c,n)
#define STEXT(c)  new_bytes__2(c,sizeof(c)-1)
#define ISB(t,c) (t.len == (sizeof(c)-1) && knh_strncmp((char*)t.buf,c,t.len) == 0)
#define knh_BytesConv_struct_copy NULL
#define knh_BytesConv_struct_compare NULL
#define CLASS_newid          ((knh_class_t)-1)
#define CLASS_unknown        ((knh_class_t)-2)
#define knh_Class_cid(c)     (knh_class_t)(c)->cid
#define IS_SPEC(o)   (CLASS_IntUnit <= knh_Object_cid(o)  && knh_Object_cid(o) <= CLASS_Vocabulary)
#define KNH_FLAG_TF_NN                KNH_FLAG_T0
#define TYPE_ISNULLABLE(t)            ((t & KNH_FLAG_TF_NN)==0)   
#define TYPE_ISNOTNULL(t)             ((t & KNH_FLAG_TF_NN)==KNH_FLAG_TF_NN)
#define CLASS_TONNTYPE(c)             (c|KNH_FLAG_TF_NN)
#define TYPE_TONNTYPE(t)              (t|KNH_FLAG_TF_NN)
#define TYPE_UNMASK(t)                (t&(~(KNH_FLAG_TF_NN|KNH_FLAG_TF_PMZ)))
#define TYPE_UNMASK_NN(t)             (t&(~KNH_FLAG_TF_NN))
#define TYPEQN(t)                     TYPEN(t), TYPEQ(t)
#define TYPE_void                     CLASS_TONNTYPE(CLASS_Nue)
#define NNTYPE_void                   CLASS_TONNTYPE(CLASS_Nue)
#define TYPE_any                      CLASS_Any
#define NNTYPE_any                    CLASS_any
#define KNH_FLAG_TF_PMZ               KNH_FLAG_T1
#define TYPE_ISPMZ(t)                 ((t & KNH_FLAG_TF_PMZ)==KNH_FLAG_TF_PMZ)   
#define CLASS_PMZ(t)                  (t) /*((t | KNH_FLAG_TF_PMZ))*/
#define TYPE_PMZ(t)                   ((t | KNH_FLAG_TF_PMZ))   
#define TYPE_UNMASK_PMZ(t)            (t&(~KNH_FLAG_TF_PMZ))
#define TYPEN(type)  knh_TYPEN(ctx,type)
#define knh_ClassMap_struct_copy    NULL
#define knh_ClassMap_struct_compare  NULL
#define knh_tstruct_isNative(sid)   (sid < KONOHA_TSTRUCT_SIZE)
#define knh_ClassStruct_struct_copy    NULL
#define knh_Class_getMethod(ctx, c, mn)    knh_Class_getMethod__(ctx, c, mn, 0)
#define knh_Class_findMethod(ctx, c, mn)   knh_Class_getMethod__(ctx, c, mn, 1)
#define knh_Connection_struct_copy    NULL
#define knh_Connection_struct_compare  NULL
#define KNH_STDIN          (((Context*)ctx)->in)
#define KNH_STDOUT         (((Context*)ctx)->out)
#define KNH_STDERR         (((Context*)ctx)->err)
#define knh_DictIdx_struct_copy   NULL
#define knh_DictMap_put(ctx,b,k,v) knh_DictMap_set(ctx,b,k,v)
#define knh_DictMap_put(ctx,b,k,v) knh_DictMap_set(ctx,b,k,v)
#define knh_DictMap_String__   knh_DictMap_Iterator
#define knh_DictSet_put(ctx,b,k,v) knh_DictSet_set(ctx,b,k,v)
#define EXPT_newid            ((knh_expt_t)0)
#define EXPT_Exception        ((knh_expt_t)1)
#define EXPT_NoSuchException  ((knh_expt_t)2)
#define knh_Exception_eid(o)   (o)->eid
#define knh_Exception_struct_copy   NULL
#define knh_Exception_struct_compare  NULL
#define new_Exception__s(ctx, s)     new_Exception__b(ctx, B(s))
#define KNH_SETJUMP(hdlr)   setjmp(DP((ExceptionHandler*)hdlr)->jmpbuf)
#define knh_ExceptionHandler_struct_copy   NULL
#define knh_ExceptionHandler_struct_compare  NULL
#define knh_Float_value(o)    (o)->value
#define knh_FloatUnit_struct_copy    NULL
#define knh_FloatUnit_struct_compare NULL
#define LRUMap                          HashMap
#define knh_LRUMap                      knh_HashMap
#define new_LRUMap(ctx,n)               new_HashMap(ctx,n)
#define knh_LRUMap_get(ctx,b,kh,ko)     knh_HashMap_get(ctx,b,kh,ko)
#define knh_LRUMap_set(ctx,b,kh,ko,v)   knh_HashMap_set(ctx,b,kh,ko,v)
#define knh_HashMap_struct_compare NULL
#define knh_HashMap_put(ctx,b,h,k,v) knh_HashMap_set(ctx,b,h,k,v)
#define knh_HashSet_struct_compare NULL
#define knh_HashSet_put(ctx,b,h,k,v) knh_HashSet_set(ctx,b,h,k,v)
#define knh_InputStream_struct_copy   NULL
#define knh_InputStream_struct_compare  NULL
#define knh_Int_value(o)      (o)->value
#define knh_IntUnit_isBuffered(u,n)   (DP(u)->bfarray != NULL && DP(u)->bfoffset <= n && n < DP(u)->bfoffset + DP(u)->bfsize)
#define knh_IntUnit_struct_copy    NULL
#define knh_IntUnit_struct_compare NULL
#define KNH_SMARTcid(o, alt)   (IS_Class(o)) ? (o)->cid : (alt)
#define knh_Iterator_cid(it)           DP(it)->cid
#define knh_Iterator_source(it)        DP(it)->source
#define knh_Iterator_pos(it)           DP(it)->pos
#define knh_Iterator_setpos(it, p)     DP(it)->pos = p
#define knh_Iterator_ref(it)           DP(it)->ref
#define knh_Method_mn(mtd)    DP(mtd)->mn
#define knh_Method_mf(mtd)    DP(mtd)->mf
#define knh_Method_rtype(mtd)          knh_MethodField_rtype(knh_Method_mf(mtd))
#define knh_Method_psize(mtd)      knh_MethodField_psize(knh_Method_mf(mtd))
#define knh_Method_ptype(mtd,n)          knh_MethodField_ptype(knh_Method_mf(mtd),n)
#define knh_Method_pfields(mtd,n)   knh_MethodField_pfields(knh_Method_mf(mtd),n)
#define knh_Method_lastfield(mtd)   knh_MethodField_lastfield(knh_Method_mf(mtd))
#define CTXCLASSN(cid)     knh_Context_CLASSN(ctx,cid)
#define CTXTYPEQN(cid)     knh_Context_CLASSN(ctx,TYPE_UNMASK_NN(cid)), TYPEQ(cid)
#define IS_NULL(o)          (((Object*)o)->h.cid == CLASS_Nue)
#define IS_NOTNULL(o)       (((Object*)o)->h.cid != CLASS_Nue)
#define new_Nue__b(ctx, txt)   new_Nue(ctx, new_String(ctx, txt, NULL));
#define new_Nue__s(ctx, txt)   new_Nue(ctx, new_String(ctx, B(txt), NULL));
#define knh_Object_cid(o)           (o)->h.cid
#define knh_Object_bcid(o)          (o)->h.bcid
#define knh_OutputStream_struct_copy      NULL
#define knh_OutputStream_struct_compare   NULL
#define knh_write_delim(ctx, w)    knh_write(ctx, w, STEXT(", "))
#define knh_write_dots(ctx, w)     knh_write(ctx, w, STEXT("..."))
#define knh_write__i(ctx, w, n)   knh_write__ifmt(ctx, w, KNH_INT_FMT, n)
#define knh_write__u(ctx, w, n)   knh_write__ifmt(ctx, w, KNH_UINT_FMT, n)
#define knh_write__x(ctx, w, n)   knh_write__ifmt(ctx, w, KNH_INT_FMTX, n)
#define knh_write__f(ctx, w, f)  knh_write__ffmt(ctx, w, KNH_FLOAT_FMT, f)
#define knh_write__e(ctx, w, f)  knh_write__ffmt(ctx, w, KNH_FLOAT_FMTE, f)
#define knh_write__fn(ctx, w, fn)   knh_write__s(ctx, w, FIELDN(fn))
#define knh_write__O(ctx, w, o)    knh_format(ctx, w, METHODN__repr, o, KNH_NULL)
#define knh_Object_toString(ctx, b)   knh_Object_movableText(ctx, b, METHODN__s, KNH_NULL)
#define knh_ResultSet_struct_copy NULL
#define knh_ResultSet_struct_compare NULL
#define knh_Runtime_struct_copy  NULL
#define knh_Runtime_struct_compare NULL
#define knh_String_value(o)   ((o)->str)
#define knh_String_tochar(o)  (char*)((o)->str)
#define knh_String_strlen(o)  (o)->size
#define knh_bytes_hcode(t)     knh_string_hash((t).buf, (t).len)
#define knh_StringUnit_struct_copy   NULL
#define knh_StringUnit_struct_compare  NULL
#define NSN_main           0
#define FILEN_unknown      0
#define knh_Compiler_struct_copy   NULL
#define knh_Compiler_struct_compare  NULL
#define KNH_PERRATA_(ctx, f, l, msgo, msgn)    knh_perrata(ctx, f, l, msgo, msgn)
#define KNH_PERRATA(ctx, tk, msg)  knh_perrata(ctx, (tk)->fileid, (tk)->line, knh_Token_tochar(tk), msg)
#define knh_Stmt_struct_copy  NULL
#define knh_Stmt_struct_compare  NULL
#define knh_Stmt_terms_cmpl(ctx, stmt, n, cpr, ns, reqt, level)      knh_Stmt_terms_cmpl_(ctx, stmt, n, cpr, ns, reqt, level, 0)
#define knh_Stmt_terms_cmplpush(ctx, stmt, n, cpr, ns, reqt, level)  knh_Stmt_terms_cmpl_(ctx, stmt, n, cpr, ns, reqt, level, 1)
#define knh_Token_struct_copy  NULL
#define knh_Token_struct_compare  NULL
#define knh_VirtualMachineCode_struct_compare  NULL
#define knh_Amazon_struct_copy      NULL
#define knh_Amazon_struct_compare   NULL
#define knh_Amazon_struct_traverse  NULL
#define knh_Counter_struct_compare  NULL
#define KNH_FLAG_CF2OF(f)        (f)
#define DEBUG_ASSERT_cid(cid)    KNH_ASSERT(IS_cid(cid))
#define CLASSN(cid)   knh_String_tochar(knh_tClass[cid].lname)
#define CLASSNo(o)    knh_String_tochar(knh_tClass[(o)->h.cid].lname)
#define FIELDN_NONAME    ((knh_fieldn_t)-1)
#define FIELDN_NEWID     ((knh_fieldn_t)-2)
#define FIELDN_return    FIELDN_
#define METHODN_NONAME   ((knh_methodn_t)-1)
#define METHODN_NEWID    ((knh_methodn_t)-2)
#define KNH_FLAG_FN_SUPER   KNH_FLAG_T0
#define KNH_FLAG_FN_U1      KNH_FLAG_T1
#define KNH_FLAG_FN_U2      KNH_FLAG_T2
#define FIELDN_IS_SUPER(fnq)       ((fnq & KNH_FLAG_FN_SUPER) == KNH_FLAG_FN_SUPER)
#define FIELDN_IS_U1(fnq)          ((fnq & KNH_FLAG_FN_U1) == KNH_FLAG_FN_U1)
#define FIELDN_IS_U2(fnq)          ((fnq & KNH_FLAG_FN_U2) == KNH_FLAG_FN_U2)
#define FIELDN_IS_PROTECTED(fnq)   (FIELDN_IS_U1(fnq)||FIELDN_IS_U2(fnq))
#define FIELDN_UNMASK(fnq)         (fnq & (~(KNH_FLAG_FN_SUPER|KNH_FLAG_FN_U1|KNH_FLAG_FN_U2)))
#define KNH_FLAG_MN_SUPER        KNH_FLAG_T0
#define KNH_FLAG_MN_GETTER       KNH_FLAG_T1
#define KNH_FLAG_MN_SETTER       KNH_FLAG_T2
#define KNH_FLAG_MN_MOVTEXT      (KNH_FLAG_T1|KNH_FLAG_T2)
#define KNH_FLAG_MN_FIELDN       (~(KNH_FLAG_T0|KNH_FLAG_T1|KNH_FLAG_T2))
#define METHODN_IS_GETTER(mn)   ((mn & KNH_FLAG_MN_MOVTEXT) == KNH_FLAG_MN_GETTER)
#define METHODN_TO_GETTER(mn)   (mn | KNH_FLAG_MN_GETTER)
#define METHODN_IS_SETTER(mn)   ((mn & KNH_FLAG_MN_MOVTEXT) == KNH_FLAG_MN_SETTER)
#define METHODN_TO_SETTER(mn)   (mn | KNH_FLAG_MN_SETTER)
#define METHODN_IS_MOVTEXT(mn)  ((mn & KNH_FLAG_MN_MOVTEXT) == KNH_FLAG_MN_MOVTEXT)
#define METHODN_TO_MOVTEXT(mn)  (mn | KNH_FLAG_MN_MOVTEXT)
#define METHODN_TOFIELDN(mn)     (mn & KNH_FLAG_MN_FIELDN)
#define FIELDN(fn) knh_String_tochar(knh_tfieldn_name(fn))
#define FILEIDN(fileid) knh_String_tochar(knh_tfileid_name(fileid))
#define new_Object__RAW(ctx, flag, cid, size)   new_Object__bRAW(ctx, flag, cid, cid, size)
#define IS_SWEEP(f)   (f == knh_Object_RCsweep)
#define knh_rootNameSpace    DP(knh_rootSystem)->ns
#define knh_constEncoding    DP(knh_rootSystem)->enc
#define knh_constStdIn       DP(knh_rootSystem)->in
#define knh_constStdOut      DP(knh_rootSystem)->out
#define knh_constStdErr      DP(knh_rootSystem)->err
#define new_String__T(ctx, text)    new_StringX__T(ctx, CLASS_String, text)
#define KNH_FLAG_SF_TUPLE          KNH_FLAG_T1
#define STRUCT_ISTUPLE(sid)        ((sid & KNH_FLAG_SF_TUPLE) == KNH_FLAG_SF_TUPLE)
#define BSIZE_TOSID(bsize)         (((knh_struct_t)bsize)|KNH_FLAG_SF_TUPLE)
#define STRUCT_TUPLE(bsize)        (((knh_struct_t)bsize)|KNH_FLAG_SF_TUPLE)
#define STRUCT_TUPLESIZE(sid)      (sid & (~KNH_FLAG_SF_TUPLE))
#define STRUCT_UNMASK(sid)         (sid & (~KNH_FLAG_SF_TUPLE))
#define DEBUG_ASSERT_sid(sid)   KNH_ASSERT(IS_sid(sid))
#define STRUCTN(sid)   knh_tstruct_name(sid)
#define KNH_LOPEN(ctx, n) \
	knh_sfp_t *lbp_ = ((Context*)ctx)->ebp + 1; \
	knh_stackf_locals(ctx, n) \


#define KNH_LOCALn(n)                 (lbp_[n].o)
#define KNH_LSETv(ctx, n, v)          KNH_SETv(ctx, lbp_[n].o, v) 
#define KNH_LCLOSE(ctx)               ((Context*)ctx)->ebp = lbp_ - 1 
#define KNH_LPUSH(ctx,v) \
	((Context*)ctx)->ebp++; \
	KNH_SETv(ctx, ((Context*)ctx)->ebp[0].o, v); \


#define KNH_PUSHv(ctx,v) \
	((Context*)ctx)->ebp++; \
	KNH_SETv(ctx, ((Context*)ctx)->ebp[0].o, v); \
*/

#define knh_rootDir                DP(knh_rootSystem)->rootDir
#define knh_pkgmgrDictSet          DP(knh_rootSystem)->pkgmgrDictSet
#define knh_dylibDictSet           DP(knh_rootSystem)->dylibDictSet
#define knh_funcDictSet            DP(knh_rootSystem)->funcDictSet
#define KNH_FLAG_PF_STDERR      KNH_FLAG_T0
#define KNH_FLAG_PF_EOL         KNH_FLAG_T1
#define KNH_FLAG_PF_TIME        KNH_FLAG_T2
#define KNH_FLAG_PF_FUNC        KNH_FLAG_T3
#define KNH_FLAG_PF_NAME        KNH_FLAG_T4
#define KNH_FLAG_PF_NOCOMMA     KNH_FLAG_T5
#define KNH_FLAG_PF_EMPTY       KNH_FLAG_T6
#define KNH_FLAG_PF_BOL         KNH_FLAG_T7
#define KNH_THROW(ctx, e) \
	if(IS_NULL(e)) { \
		knh_konohavm_throwException(ctx, new_Exception__Nue(ctx, (Nue*)e)); \
	}else if(IS_Exception(e)) { \
		knh_konohavm_throwException(ctx, (Exception*)e); \
	}else if(IS_bString(e)) { \
		knh_konohavm_throwException(ctx, new_Exception(ctx, (String*)e)); \
	}else { \
		DBG2_P("Cannot throw %s", CLASSN(knh_Object_cid(e))); \
	} \


#define KNH_THROWs(ctx, s) \
	knh_konohavm_throwException(ctx, new_Exception__b(ctx, B(s))); \


#define KNH_THROWf(ctx, fmt, ...) \
	char throwbuf_[256]; \
	knh_snprintf(throwbuf_, sizeof(throwbuf_), fmt, ## __VA_ARGS__); \
	knh_konohavm_throwException(ctx, new_Exception__b(ctx, B(throwbuf_))); \


#define TODO_THROW(ctx) \
	char throwbuf_[256]; \
	knh_snprintf(throwbuf_, sizeof(throwbuf_), "Nakata!!: please call him to check %s", __func__); \
	knh_konohavm_throwException(ctx, new_Exception__b(ctx, B(throwbuf_))); \
	

#define KNH_TMAPMAP  KNH_TMAPPER

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHA_NAME__H*/
