/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHAC_STMT__H
#define KONOHAC_STMT__H

#include<konoha/konoha_t.h>
#include<konoha/class/konohac.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* TT_MACRO knh_token_t */
#define TT_NAMESPACE                    ((knh_token_t)0)
#define TT_IMPORT                       ((knh_token_t)1)
#define TT_USING                        ((knh_token_t)2)
#define TT_WITH                         ((knh_token_t)3)
#define TT_CLASS                        ((knh_token_t)4)
#define TT_EXTENDS                      ((knh_token_t)5)
#define TT_IMPLEMENTS                   ((knh_token_t)6)
#define TT_METHOD                       ((knh_token_t)7)
#define TT_FORMAT                       ((knh_token_t)8)
#define TT_RETURN                       ((knh_token_t)9)
#define TT_MAPMAP                       ((knh_token_t)10)
#define TT_WEAVE                        ((knh_token_t)11)
#define TT_ASPECT                       ((knh_token_t)12)
#define TT_IF                           ((knh_token_t)13)
#define TT_ELSE                         ((knh_token_t)14)
#define TT_WHILE                        ((knh_token_t)15)
#define TT_DO                           ((knh_token_t)16)
#define TT_FOR                          ((knh_token_t)17)
#define TT_FOREACH                      ((knh_token_t)18)
#define TT_WHERE                        ((knh_token_t)19)
#define TT_BREAK                        ((knh_token_t)20)
#define TT_CONTINUE                     ((knh_token_t)21)
#define TT_GOTO                         ((knh_token_t)22)
#define TT_TRY                          ((knh_token_t)23)
#define TT_CATCH                        ((knh_token_t)24)
#define TT_FINALLY                      ((knh_token_t)25)
#define TT_THROW                        ((knh_token_t)26)
#define TT_PRINT                        ((knh_token_t)27)
#define TT_ASSERT                       ((knh_token_t)28)
#define TT_BRACE                        ((knh_token_t)29)
#define TT_PARENTHESIS                  ((knh_token_t)30)
#define TT_BRANCET                      ((knh_token_t)31)
#define TT_DOTS                         ((knh_token_t)32)
#define TT_SEMICOLON                    ((knh_token_t)33)
#define TT_COMMA                        ((knh_token_t)34)
#define TT_LET                          ((knh_token_t)35)
#define TT_LSHIFTE                      ((knh_token_t)36)
#define TT_RSHIFTE                      ((knh_token_t)37)
#define TT_ADDE                         ((knh_token_t)38)
#define TT_SUBE                         ((knh_token_t)39)
#define TT_MULE                         ((knh_token_t)40)
#define TT_DIVE                         ((knh_token_t)41)
#define TT_MODE                         ((knh_token_t)42)
#define TT_BITORE                       ((knh_token_t)43)
#define TT_BITANDE                      ((knh_token_t)44)
#define TT_ALTLET                       ((knh_token_t)45)
#define TT_QUESTION                     ((knh_token_t)46)
#define TT_SUBSET                       ((knh_token_t)47)
#define TT_SLICE                        ((knh_token_t)48)
#define TT_OFFSET                       ((knh_token_t)49)
#define TT_COLON                        ((knh_token_t)50)
#define TT_OR                           ((knh_token_t)51)
#define TT_AND                          ((knh_token_t)52)
#define TT_NOT                          ((knh_token_t)53)
#define TT_INSTANCEOF                   ((knh_token_t)54)
#define TT_ISA                          ((knh_token_t)55)
#define TT_AS                           ((knh_token_t)56)
#define TT_EQUIV                        ((knh_token_t)57)
#define TT_MAPSTO                       ((knh_token_t)58)
#define TT_EQ                           ((knh_token_t)59)
#define TT_NEQ                          ((knh_token_t)60)
#define TT_LT                           ((knh_token_t)61)
#define TT_LTE                          ((knh_token_t)62)
#define TT_GT                           ((knh_token_t)63)
#define TT_GTE                          ((knh_token_t)64)
#define TT_LSHIFT                       ((knh_token_t)65)
#define TT_RSHIFT                       ((knh_token_t)66)
#define TT_ADD                          ((knh_token_t)67)
#define TT_SUB                          ((knh_token_t)68)
#define TT_MOD                          ((knh_token_t)69)
#define TT_DIV                          ((knh_token_t)70)
#define TT_MUL                          ((knh_token_t)71)
#define TT_LOGICALOR                    ((knh_token_t)72)
#define TT_LOGICALAND                   ((knh_token_t)73)
#define TT_ALT                          ((knh_token_t)74)
#define TT_LOGICALNOT                   ((knh_token_t)75)
#define TT_LOGICALXOR                   ((knh_token_t)76)
#define TT_NEXT                         ((knh_token_t)77)
#define TT_PREV                         ((knh_token_t)78)
#define TT_NUM                          ((knh_token_t)79)
#define knh_Token_isNUM(tk_)            (DP(tk_)->tt == TT_NUM)
#define TT_STR                          ((knh_token_t)80)
#define knh_Token_isSTR(tk_)            (DP(tk_)->tt == TT_STR)
#define TT_TSTR                         ((knh_token_t)81)
#define knh_Token_isTSTR(tk_)           (DP(tk_)->tt == TT_TSTR)
#define TT_FMTSTR                       ((knh_token_t)82)
#define knh_Token_isFMTSTR(tk_)         (DP(tk_)->tt == TT_FMTSTR)
#define TT_LABEL                        ((knh_token_t)83)
#define knh_Token_isLABEL(tk_)          (DP(tk_)->tt == TT_LABEL)
#define TT_METAN                        ((knh_token_t)84)
#define knh_Token_isMETAN(tk_)          (DP(tk_)->tt == TT_METAN)
#define TT_PROPN                        ((knh_token_t)85)
#define knh_Token_isPROPN(tk_)          (DP(tk_)->tt == TT_PROPN)
#define TT_URN                          ((knh_token_t)86)
#define knh_Token_isURN(tk_)            (DP(tk_)->tt == TT_URN)
#define TT_MT                           ((knh_token_t)87)
#define knh_Token_isMT(tk_)             (DP(tk_)->tt == TT_MT)
#define TT_CONSTN                       ((knh_token_t)88)
#define knh_Token_isCONSTN(tk_)         (DP(tk_)->tt == TT_CONSTN)
#define TT_TYPEN                        ((knh_token_t)89)
#define knh_Token_isTYPEN(tk_)          (DP(tk_)->tt == TT_TYPEN)
#define TT_CMETHODN                     ((knh_token_t)90)
#define knh_Token_isCMETHODN(tk_)       (DP(tk_)->tt == TT_CMETHODN)
#define TT_NAME                         ((knh_token_t)91)
#define knh_Token_isNAME(tk_)           (DP(tk_)->tt == TT_NAME)
#define TT_MN                           ((knh_token_t)92)
#define knh_Token_isMN(tk_)             (DP(tk_)->tt == TT_MN)
#define TT_FN                           ((knh_token_t)93)
#define knh_Token_isFN(tk_)             (DP(tk_)->tt == TT_FN)
#define TT_CID                          ((knh_token_t)94)
#define knh_Token_isCID(tk_)            (DP(tk_)->tt == TT_CID)
#define TT_CONST                        ((knh_token_t)95)
#define knh_Token_isCONST(tk_)          (DP(tk_)->tt == TT_CONST)
#define TT_MTDMPR                       ((knh_token_t)96)
#define knh_Token_isMTDMPR(tk_)         (DP(tk_)->tt == TT_MTDMPR)
#define TT_EBPIDX                       ((knh_token_t)97)
#define knh_Token_isEBPIDX(tk_)         (DP(tk_)->tt == TT_EBPIDX)
#define TT_SFPIDX                       ((knh_token_t)98)
#define knh_Token_isSFPIDX(tk_)         (DP(tk_)->tt == TT_SFPIDX)
#define TT_FLDIDX                       ((knh_token_t)99)
#define knh_Token_isFLDIDX(tk_)         (DP(tk_)->tt == TT_FLDIDX)
#define TT_OBJIDX                       ((knh_token_t)100)
#define knh_Token_isOBJIDX(tk_)         (DP(tk_)->tt == TT_OBJIDX)
#define TT_SYSCONST                     ((knh_token_t)101)
#define knh_Token_isSYSCONST(tk_)       (DP(tk_)->tt == TT_SYSCONST)
#define TT_ASIS                         ((knh_token_t)102)
#define TT_ERR                          ((knh_token_t)103)
#define knh_Token_isERR(tk_)            (DP(tk_)->tt == TT_ERR)
#define TT_EOT                          ((knh_token_t)104)
#define knh_Token_isEOT(tk_)            (DP(tk_)->tt == TT_EOT)
#define KNH_TOKEN_MAXSIZ                ((knh_token_t)105)

/* ------------------------------------------------------------------------ */
#ifndef METHODN_opNot
#define METHODN_opNot                   METHODN_NONAME
#endif
#ifndef METHODN_opInstanceof
#define METHODN_opInstanceof            METHODN_NONAME
#endif
#ifndef METHODN_opIsa
#define METHODN_opIsa                   METHODN_NONAME
#endif
#ifndef METHODN_opAs
#define METHODN_opAs                    METHODN_NONAME
#endif
#ifndef METHODN_opEquiv
#define METHODN_opEquiv                 METHODN_NONAME
#endif
#ifndef METHODN_opMapsTo
#define METHODN_opMapsTo                METHODN_NONAME
#endif
#ifndef METHODN_opEq
#define METHODN_opEq                    METHODN_NONAME
#endif
#ifndef METHODN_opNeq
#define METHODN_opNeq                   METHODN_NONAME
#endif
#ifndef METHODN_opLt
#define METHODN_opLt                    METHODN_NONAME
#endif
#ifndef METHODN_opLte
#define METHODN_opLte                   METHODN_NONAME
#endif
#ifndef METHODN_opGt
#define METHODN_opGt                    METHODN_NONAME
#endif
#ifndef METHODN_opGte
#define METHODN_opGte                   METHODN_NONAME
#endif
#ifndef METHODN_opLShift
#define METHODN_opLShift                METHODN_NONAME
#endif
#ifndef METHODN_opRShift
#define METHODN_opRShift                METHODN_NONAME
#endif
#ifndef METHODN_opAdd
#define METHODN_opAdd                   METHODN_NONAME
#endif
#ifndef METHODN_opSub
#define METHODN_opSub                   METHODN_NONAME
#endif
#ifndef METHODN_opMod
#define METHODN_opMod                   METHODN_NONAME
#endif
#ifndef METHODN_opDiv
#define METHODN_opDiv                   METHODN_NONAME
#endif
#ifndef METHODN_opMul
#define METHODN_opMul                   METHODN_NONAME
#endif
#ifndef METHODN_opLogicalOr
#define METHODN_opLogicalOr             METHODN_NONAME
#endif
#ifndef METHODN_opLogicalAnd
#define METHODN_opLogicalAnd            METHODN_NONAME
#endif
#ifndef METHODN_opALT
#define METHODN_opALT                   METHODN_NONAME
#endif
#ifndef METHODN_opLogicalNot
#define METHODN_opLogicalNot            METHODN_NONAME
#endif
#ifndef METHODN_opLogicalXor
#define METHODN_opLogicalXor            METHODN_NONAME
#endif
#ifndef METHODN_opNext
#define METHODN_opNext                  METHODN_NONAME
#endif
#ifndef METHODN_opPrev
#define METHODN_opPrev                  METHODN_NONAME
#endif

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
/* STT_MACRO knh_stmt_t */
#define STT_DONE                        ((knh_stmt_t)0)
#define STT_NAMESPACE                   ((knh_stmt_t)1)
#define STT_IMPORT                      ((knh_stmt_t)2)
#define STT_USING                       ((knh_stmt_t)3)
#define STT_UIMPORT                     ((knh_stmt_t)4)
#define STT_UALIAS                      ((knh_stmt_t)5)
#define STT_UUNIT                       ((knh_stmt_t)6)
#define STT_UENUM                       ((knh_stmt_t)7)
#define STT_UVOCAB                      ((knh_stmt_t)8)
#define STT_WITH                        ((knh_stmt_t)9)
#define STT_UFUNC                       ((knh_stmt_t)10)
#define STT_UMAPMAP                     ((knh_stmt_t)11)
#define STT_CLASS                       ((knh_stmt_t)12)
#define STT_EXTENDS                     ((knh_stmt_t)13)
#define STT_IMPLEMENTS                  ((knh_stmt_t)14)
#define STT_METHOD                      ((knh_stmt_t)15)
#define STT_CLOSURE                     ((knh_stmt_t)16)
#define STT_FORMAT                      ((knh_stmt_t)17)
#define STT_DECL                        ((knh_stmt_t)18)
#define STT_RETURN                      ((knh_stmt_t)19)
#define STT_MAPMAP                      ((knh_stmt_t)20)
#define STT_WEAVE                       ((knh_stmt_t)21)
#define STT_ASPECT                      ((knh_stmt_t)22)
#define STT_IF                          ((knh_stmt_t)23)
#define STT_ELSE                        ((knh_stmt_t)24)
#define STT_WHILE                       ((knh_stmt_t)25)
#define STT_DO                          ((knh_stmt_t)26)
#define STT_FOR                         ((knh_stmt_t)27)
#define STT_FOREACH                     ((knh_stmt_t)28)
#define STT_WHERE                       ((knh_stmt_t)29)
#define STT_BREAK                       ((knh_stmt_t)30)
#define STT_CONTINUE                    ((knh_stmt_t)31)
#define STT_GOTO                        ((knh_stmt_t)32)
#define STT_TRY                         ((knh_stmt_t)33)
#define STT_CATCH                       ((knh_stmt_t)34)
#define STT_FINALLY                     ((knh_stmt_t)35)
#define STT_THROW                       ((knh_stmt_t)36)
#define STT_ERR                         ((knh_stmt_t)37)
#define STT_LET                         ((knh_stmt_t)38)
#define STT_LETMULTI                    ((knh_stmt_t)39)
#define STT_NEW                         ((knh_stmt_t)40)
#define STT_MAPCAST                     ((knh_stmt_t)41)
#define STT_CALL                        ((knh_stmt_t)42)
#define STT_CALL1                       ((knh_stmt_t)43)
#define STT_PCALL                       ((knh_stmt_t)44)
#define STT_MT                          ((knh_stmt_t)45)
#define STT_OP                          ((knh_stmt_t)46)
#define STT_TRINARY                     ((knh_stmt_t)47)
#define STT_ALT                         ((knh_stmt_t)48)
#define STT_AND                         ((knh_stmt_t)49)
#define STT_OR                          ((knh_stmt_t)50)
#define STT_PRINT                       ((knh_stmt_t)51)
#define STT_ASSERT                      ((knh_stmt_t)52)
#define STT_MAN                         ((knh_stmt_t)53)
#define KNH_STMT_MAXSIZ                 ((knh_stmt_t)54)

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
/* [done] */

/* ======================================================================== */
/* [namespace] */
#define StmtNAMESPACE_ns(stmt)          DP(stmt)->tokens[0]

/* ======================================================================== */
/* [import] */
#define StmtIMPORT_file(stmt)           DP(stmt)->tokens[0]

/* ======================================================================== */
/* [using] */

/* ======================================================================== */
/* [using import] */
#define StmtUIMPORT_ns(stmt)            DP(stmt)->tokens[0]

/* ======================================================================== */
/* [using alias] */
#define StmtUALIAS_class(stmt)          DP(stmt)->tokens[0]
#define StmtUALIAS_urn(stmt)            DP(stmt)->tokens[1]

/* ======================================================================== */
/* [using unit] */
#define StmtUUNIT_class(stmt)           DP(stmt)->tokens[0]
#define StmtUUNIT_urn(stmt)             DP(stmt)->tokens[1]

/* ======================================================================== */
/* [using enum] */
#define StmtUENUM_class(stmt)           DP(stmt)->tokens[0]
#define StmtUENUM_urn(stmt)             DP(stmt)->tokens[1]

/* ======================================================================== */
/* [using vocab] */
#define StmtUVOCAB_class(stmt)          DP(stmt)->tokens[0]
#define StmtUVOCAB_urn(stmt)            DP(stmt)->tokens[1]

/* ======================================================================== */
/* [with] */

/* ======================================================================== */
/* [using func] */
#define StmtUFUNC_func(stmt)            DP(stmt)->tokens[0]

/* ======================================================================== */
/* [using mapmap] */
#define StmtUMAPMAP_target(stmt)        DP(stmt)->tokens[0]
#define StmtUMAPMAP_source(stmt)        DP(stmt)->tokens[1]
#define StmtUMAPMAP_urn(stmt)           DP(stmt)->tokens[2]

/* ======================================================================== */
/* [class] */
#define StmtCLASS_class(stmt)           DP(stmt)->tokens[0]
#define StmtCLASS_superclass(stmt)      DP(stmt)->tokens[1]
#define StmtCLASS_interface(stmt)       DP(stmt)->stmts[2]
#define StmtCLASS_instmt(stmt)          DP(stmt)->stmts[3]

/* ======================================================================== */
/* [extends] */

/* ======================================================================== */
/* [implements] */
#define StmtIMPLEMENTS_class_size(stmt) (DP(stmt)->size - 0)
#define StmtIMPLEMENTS_class(stmt,n)    DP(stmt)->tokens[n-0]

/* ======================================================================== */
/* [method] */
#define StmtMETHOD_rtype(stmt)          DP(stmt)->tokens[0]
#define StmtMETHOD_class(stmt)          DP(stmt)->tokens[1]
#define StmtMETHOD_method(stmt)         DP(stmt)->tokens[2]
#define StmtMETHOD_params(stmt)         DP(stmt)->stmts[3]
#define StmtMETHOD_instmt(stmt)         DP(stmt)->stmts[4]

/* ======================================================================== */
/* [closure] */
#define StmtCLOSURE_rtype(stmt)         DP(stmt)->tokens[0]
#define StmtCLOSURE_params(stmt)        DP(stmt)->stmts[1]
#define StmtCLOSURE_instmt(stmt)        DP(stmt)->stmts[2]

/* ======================================================================== */
/* [format] */
#define StmtFORMAT_name(stmt)           DP(stmt)->tokens[0]
#define StmtFORMAT_params(stmt)         DP(stmt)->tokens[1]
#define StmtFORMAT_format(stmt)         DP(stmt)->tokens[2]

/* ======================================================================== */
/* [decl] */
#define StmtDECL_type(stmt)             DP(stmt)->tokens[0]
#define StmtDECL_name(stmt)             DP(stmt)->tokens[1]
#define StmtDECL_value(stmt)            DP(stmt)->terms[2]

/* ======================================================================== */
/* [return] */
#define StmtRETURN_values(stmt)         DP(stmt)->tokens[0]

/* ======================================================================== */
/* [mapmap] */
#define StmtMAPMAP_paths_size(stmt)     (DP(stmt)->size - 0)
#define StmtMAPMAP_paths(stmt,n)        DP(stmt)->tokens[n-0]

/* ======================================================================== */
/* [weave] */
#define StmtWEAVE_aspect(stmt)          DP(stmt)->tokens[0]
#define StmtWEAVE_method(stmt)          DP(stmt)->tokens[1]

/* ======================================================================== */
/* [aspect] */
#define StmtASPECT_type(stmt)           DP(stmt)->tokens[0]
#define StmtASPECT_class(stmt)          DP(stmt)->tokens[1]
#define StmtASPECT_method(stmt)         DP(stmt)->tokens[2]
#define StmtASPECT_params(stmt)         DP(stmt)->stmts[3]
#define StmtASPECT_instmt(stmt)         DP(stmt)->stmts[4]

/* ======================================================================== */
/* [if] */
#define StmtIF_bool(stmt)               DP(stmt)->terms[0]
#define StmtIF_truecase(stmt)           DP(stmt)->stmts[1]
#define StmtIF_falsecase(stmt)          DP(stmt)->stmts[2]

/* ======================================================================== */
/* [else] */

/* ======================================================================== */
/* [while] */
#define StmtWHILE_bool(stmt)            DP(stmt)->terms[0]
#define StmtWHILE_loop(stmt)            DP(stmt)->stmts[1]

/* ======================================================================== */
/* [do] */
#define StmtDO_loop(stmt)               DP(stmt)->stmts[0]
#define StmtDO_bool(stmt)               DP(stmt)->terms[1]

/* ======================================================================== */
/* [for] */
#define StmtFOR_init(stmt)              DP(stmt)->terms[0]
#define StmtFOR_bool(stmt)              DP(stmt)->terms[1]
#define StmtFOR_redo(stmt)              DP(stmt)->terms[2]
#define StmtFOR_loop(stmt)              DP(stmt)->stmts[3]

/* ======================================================================== */
/* [foreach] */
#define StmtFOREACH_decl(stmt)          DP(stmt)->terms[0]
#define StmtFOREACH_name(stmt)          DP(stmt)->tokens[1]
#define StmtFOREACH_iter(stmt)          DP(stmt)->terms[2]
#define StmtFOREACH_start(stmt)         DP(stmt)->terms[3]
#define StmtFOREACH_len(stmt)           DP(stmt)->terms[4]
#define StmtFOREACH_end(stmt)           DP(stmt)->terms[5]
#define StmtFOREACH_where(stmt)         DP(stmt)->terms[6]
#define StmtFOREACH_loop(stmt)          DP(stmt)->stmts[7]

/* ======================================================================== */
/* [where] */

/* ======================================================================== */
/* [break] */
#define StmtBREAK_label(stmt)           DP(stmt)->terms[0]

/* ======================================================================== */
/* [continue] */
#define StmtCONTINUE_label(stmt)        DP(stmt)->terms[0]

/* ======================================================================== */
/* [goto] */
#define StmtGOTO_label(stmt)            DP(stmt)->tokens[0]

/* ======================================================================== */
/* [try] */
#define StmtTRY_trycase(stmt)           DP(stmt)->stmts[0]
#define StmtTRY_catch(stmt)             DP(stmt)->stmts[1]
#define StmtTRY_finally(stmt)           DP(stmt)->stmts[2]

/* ======================================================================== */
/* [catch] */
#define StmtCATCH_type(stmt)            DP(stmt)->tokens[0]
#define StmtCATCH_name(stmt)            DP(stmt)->tokens[1]
#define StmtCATCH_catch(stmt)           DP(stmt)->stmts[2]

/* ======================================================================== */
/* [finally] */

/* ======================================================================== */
/* [throw] */
#define StmtTHROW_expt(stmt)            DP(stmt)->terms[0]

/* ======================================================================== */
/* [err] */
#define StmtERR_msg(stmt)               DP(stmt)->tokens[0]

/* ======================================================================== */
/* [let] */
#define StmtLET_lvalue(stmt)            DP(stmt)->tokens[0]
#define StmtLET_rvalue(stmt)            DP(stmt)->terms[1]

/* ======================================================================== */
/* [letmulti] */
#define StmtLETMULTI_names_size(stmt)   (DP(stmt)->size - 0)
#define StmtLETMULTI_names(stmt,n)      DP(stmt)->tokens[n-0]

/* ======================================================================== */
/* [new] */
#define StmtNEW_new(stmt)               DP(stmt)->tokens[0]
#define StmtNEW_class(stmt)             DP(stmt)->tokens[1]
#define StmtNEW_args_size(stmt)         (DP(stmt)->size - 2)
#define StmtNEW_args(stmt,n)            DP(stmt)->terms[n-2]

/* ======================================================================== */
/* [mapcast] */
#define StmtMAPCAST_class(stmt)         DP(stmt)->tokens[0]
#define StmtMAPCAST_source(stmt)        DP(stmt)->terms[1]
#define StmtMAPCAST_option(stmt)        DP(stmt)->terms[2]

/* ======================================================================== */
/* [call] */
#define StmtCALL_method(stmt)           DP(stmt)->tokens[0]
#define StmtCALL_base(stmt)             DP(stmt)->terms[1]
#define StmtCALL_args_size(stmt)        (DP(stmt)->size - 2)
#define StmtCALL_args(stmt,n)           DP(stmt)->terms[n-2]

/* ======================================================================== */
/* [call1] */
#define StmtCALL1_value(stmt)           DP(stmt)->terms[0]

/* ======================================================================== */
/* [pcall] */
#define StmtPCALL_method(stmt)          DP(stmt)->tokens[0]
#define StmtPCALL_base(stmt)            DP(stmt)->terms[1]
#define StmtPCALL_args_size(stmt)       (DP(stmt)->size - 2)
#define StmtPCALL_args(stmt,n)          DP(stmt)->terms[n-2]

/* ======================================================================== */
/* [mt] */
#define StmtMT_mt(stmt)                 DP(stmt)->tokens[0]
#define StmtMT_target(stmt)             DP(stmt)->terms[1]
#define StmtMT_option(stmt)             DP(stmt)->terms[2]

/* ======================================================================== */
/* [op] */
#define StmtOP_first(stmt)              DP(stmt)->terms[0]
#define StmtOP_second(stmt)             DP(stmt)->terms[1]
#define StmtOP_args_size(stmt)          (DP(stmt)->size - 2)
#define StmtOP_args(stmt,n)             DP(stmt)->terms[n-2]

/* ======================================================================== */
/* [trinary] */
#define StmtTRINARY_bool(stmt)          DP(stmt)->terms[0]
#define StmtTRINARY_tvalue(stmt)        DP(stmt)->terms[1]
#define StmtTRINARY_fvalue(stmt)        DP(stmt)->terms[2]

/* ======================================================================== */
/* [alt] */
#define StmtALT_bools_size(stmt)        (DP(stmt)->size - 0)
#define StmtALT_bools(stmt,n)           DP(stmt)->terms[n-0]

/* ======================================================================== */
/* [and] */
#define StmtAND_bools_size(stmt)        (DP(stmt)->size - 0)
#define StmtAND_bools(stmt,n)           DP(stmt)->terms[n-0]

/* ======================================================================== */
/* [or] */
#define StmtOR_bools_size(stmt)         (DP(stmt)->size - 0)
#define StmtOR_bools(stmt,n)            DP(stmt)->terms[n-0]

/* ======================================================================== */
/* [print] */
#define StmtPRINT_values_size(stmt)     (DP(stmt)->size - 0)
#define StmtPRINT_values(stmt,n)        DP(stmt)->terms[n-0]

/* ======================================================================== */
/* [assert] */
#define StmtASSERT_bool(stmt)           DP(stmt)->terms[0]

/* ======================================================================== */
/* [man] */
#define StmtMAN_keyword(stmt)           DP(stmt)->tokens[0]

/* ======================================================================== */
char* knh_token_tochar(knh_token_t t);
knh_methodn_t knh_token_tomethodn(knh_token_t t);
knh_bool_t knh_token_isEndOfStmt(knh_token_t t);
Token *new_Token__parse(Ctx *ctx, knh_flag_t flag, knh_fileid_t fileid, knh_line_t line, knh_bytes_t token, BytesConv *bconv);
char* knh_stmt_tochar(knh_stmt_t t);
size_t knh_stmt_size(knh_stmt_t t);
void knh_Stmt_add_EXPTN(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_NSNAME(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_CURN(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_NSCLASSN(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_TYPEN(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_METHODN(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_CLASSTN(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_STR(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_VARN(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_CLASSN(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_CMETHODN(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_MT(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
void knh_Stmt_add_ANY(Ctx *ctx, Stmt *o, knh_tokens_t *tc);
Stmt *new_StmtSTMT1(Ctx *ctx, knh_tokens_t *tc);
int knh_stmt_isExpr(knh_stmt_t t);
f_visitdecl knh_stmt_decl(knh_stmt_t t);
f_visitname knh_stmt_name(knh_stmt_t t);
f_visitcmpl knh_stmt_cmpl(knh_stmt_t t);

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHAC_STMT__H*/
