#ifndef KONOHA_DEPS_H_
#define KONOHA_DEPS_H_
#include"konoha_t.h"
#include<stdlib.h>
#include<string.h>

/* ======================================================================== */
/* [switch] */

#ifdef KONOHA_OS__LINUX
#include"deps/konoha_linux.h"
#endif

#ifdef KONOHA_OS__MACOSX
#include"deps/konoha_macosx.h"
#endif

#ifdef KONOHA_OS__FREEBSD
#include"deps/konoha_freebsd.h"
#endif

#ifdef KONOHA_OS__MINGW
#include"deps/konoha_mingw.h"
#endif

#ifdef KONOHA_OS__WINDOWS
#include"deps/konoha_windows.h"
#endif

#ifdef KONOHA_OS__CYGWIN
#include"deps/konoha_cygwin.h"
#endif

#ifdef KONOHA_OS__TK
#include"deps/konoha_tk.h"
#endif


/* ======================================================================== */
/* [stdlib] */

#ifdef ALT_SNPRINTF
#define knh_snprintf(b,n,fmt, ...)     ALT_snprintf(b,n,fmt, ## __VA_ARGS__)
#else
#define knh_snprintf(b,n,fmt, ...)     snprintf(b,n,fmt, ## __VA_ARGS__)
#endif

/* ------------------------------------------------------------------------ */

#define knh_strlen(c)                  strlen(c)
#define knh_memcpy(d, s, n)            memcpy(d,s,n)
#define knh_bzero(s, n)                memset(s,0,n)
#define knh_strcmp(s1, s2)             strcmp(s1,s2)
#define knh_strncmp(s1, s2, n)         strncmp(s1,s2,n)

/* ------------------------------------------------------------------------ */

#ifdef ALT_SORT
#define  knh_sort(b,s,w,f)     ALT_sort(b,s,w,f)
#define  knh_qsort(b,s,w,f)    ALT_qsort(b,s,w,f)
#else
#define  knh_sort(b,s,w,f)     qsort(b,s,w,f)
#define  knh_qsort(b,s,w,f)    qsort(b,s,w,f)
#endif

/* ======================================================================== */

#ifdef KNH_USING_POSIX
	#include<dlfcn.h>              /* @using dl -ldl */
	#define knh_dlopen(p,m)         dlopen(p,m)
	#define knh_dlsym(hdr,name)     dlsym(hdr,name)
	#define knh_dlerror()           dlerror()
	#define knh_dlclose(hdr)        dlclose(hdr)
#define KNH_RTLD_LAZY               RTLD_LAZY
#else
	#define knh_dlopen(p,m)         ALT_dlopen(p,m)
	#define knh_dlsym(hdr,name)     ALT_dlsym(hdr,name)
	#define knh_dlerror()           ALT_dlerror()
	#define knh_dlclose(hdr)        ALT_dlclose(hdr)
#ifndef KNH_RTLD_LAZY
#define KNH_RTLD_LAZY               0
#endif
#endif

/* ------------------------------------------------------------------------ */

#ifdef ALT_GETENV
	#define knh_getenv(n)           ALT_getenv(n)
#else
	#define knh_getenv(n)           getenv(n)
#endif

/* ======================================================================== */


#endif /*KONOHA_MISC_H_*/
