/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* [prototype] */

void knh_package_konoha_ginit(Ctx *ctx);
void knh_package_konohac_ginit(Ctx *ctx);
void knh_package_naruto_ginit(Ctx *ctx);
void knh_package_math_ginit(Ctx *ctx);
void knh_package_mysql_ginit(Ctx *ctx);
/* ======================================================================== */
/* [init] */

void knh_tString_init0(void)
{
	DEBUG_ASSERT(knh_tString != NULL);

	KNH_INITv(knh_tString[TSN_EMPTY], new_String__T(NULL, ""));
	KNH_INITv(knh_tString[TSN_TAB], new_String__T(NULL, "\t"));
	KNH_INITv(knh_tString[TSN_LF], new_String__T(NULL, "\n"));
	KNH_INITv(knh_tString[TSN_SPC], new_String__T(NULL, " "));
	KNH_INITv(knh_tString[TSN_EOL], new_String__T(NULL, "EOL"));
	KNH_INITv(knh_tString[TSN_BEGIN], new_String__T(NULL, "BEGIN"));
	KNH_INITv(knh_tString[TSN_END], new_String__T(NULL, "END"));
	KNH_INITv(knh_tString[TSN_void], new_String__T(NULL, "void"));
	KNH_INITv(knh_tString[TSN_true], new_String__T(NULL, "true"));
	KNH_INITv(knh_tString[TSN_false], new_String__T(NULL, "false"));
	KNH_INITv(knh_tString[TSN_null], new_String__T(NULL, "null"));
	KNH_INITv(knh_tString[TSN_main], new_String__T(NULL, "main"));
	KNH_INITv(knh_tString[TSN_ENCODING], new_String__T(NULL, ""KONOHA_ENCODING""));
	KNH_INITv(knh_tString[TSN_DEVNULL], new_String__T(NULL, "/dev/null"));
	KNH_INITv(knh_tString[TSN_DEVSTDIN], new_String__T(NULL, "/dev/stdin"));
	KNH_INITv(knh_tString[TSN_DEVSTDERR], new_String__T(NULL, "/dev/stderr"));
	KNH_INITv(knh_tString[TSN_DEVSTDOUT], new_String__T(NULL, "/dev/stdout"));
	KNH_INITv(knh_tString[TSN_ATlabel], new_String__T(NULL, "@label"));
	KNH_INITv(knh_tString[TSN_TYPEERR], new_String__T(NULL, "Type!!"));
	KNH_INITv(knh_tString[TSN_NULLERR], new_String__T(NULL, "Null!!"));
	KNH_INITv(knh_tString[TSN_SYNTAXERR], new_String__T(NULL, "Syntax!!"));
}

void konoha_load_builtins(Ctx *ctx)
{
	KNH_TFIELDN(ctx, FIELDN_, new_String__T(ctx, ""));
	KNH_TFIELDN(ctx, FIELDN___fast, new_String__T(ctx, ":fast"));
	KNH_TFIELDN(ctx, FIELDN_abs, new_String__T(ctx, "abs"));
	KNH_TFIELDN(ctx, FIELDN_add, new_String__T(ctx, "add"));
	KNH_TFIELDN(ctx, FIELDN_add__fast, new_String__T(ctx, "add:fast"));
	KNH_TFIELDN(ctx, FIELDN_addr, new_String__T(ctx, "addr"));
	KNH_TFIELDN(ctx, FIELDN_another, new_String__T(ctx, "another"));
	KNH_TFIELDN(ctx, FIELDN_append, new_String__T(ctx, "append"));
	KNH_TFIELDN(ctx, FIELDN_autoFlush, new_String__T(ctx, "autoFlush"));
	KNH_TFIELDN(ctx, FIELDN_b, new_String__T(ctx, "b"));
	KNH_TFIELDN(ctx, FIELDN_bits, new_String__T(ctx, "bits"));
	KNH_TFIELDN(ctx, FIELDN_buf, new_String__T(ctx, "buf"));
	KNH_TFIELDN(ctx, FIELDN_c, new_String__T(ctx, "c"));
	KNH_TFIELDN(ctx, FIELDN_class, new_String__T(ctx, "class"));
	KNH_TFIELDN(ctx, FIELDN_clear, new_String__T(ctx, "clear"));
	KNH_TFIELDN(ctx, FIELDN_close, new_String__T(ctx, "close"));
	KNH_TFIELDN(ctx, FIELDN_compareTo, new_String__T(ctx, "compareTo"));
	KNH_TFIELDN(ctx, FIELDN_default, new_String__T(ctx, "default"));
	KNH_TFIELDN(ctx, FIELDN_dump, new_String__T(ctx, "dump"));
	KNH_TFIELDN(ctx, FIELDN_e, new_String__T(ctx, "e"));
	KNH_TFIELDN(ctx, FIELDN_empty, new_String__T(ctx, "empty"));
	KNH_TFIELDN(ctx, FIELDN_enc, new_String__T(ctx, "enc"));
	KNH_TFIELDN(ctx, FIELDN_encoding, new_String__T(ctx, "encoding"));
	KNH_TFIELDN(ctx, FIELDN_endsWith, new_String__T(ctx, "endsWith"));
	KNH_TFIELDN(ctx, FIELDN_equals, new_String__T(ctx, "equals"));
	KNH_TFIELDN(ctx, FIELDN_err, new_String__T(ctx, "err"));
	KNH_TFIELDN(ctx, FIELDN_first, new_String__T(ctx, "first"));
	KNH_TFIELDN(ctx, FIELDN_flush, new_String__T(ctx, "flush"));
	KNH_TFIELDN(ctx, FIELDN_formatted, new_String__T(ctx, "formatted"));
	KNH_TFIELDN(ctx, FIELDN_gCMarked, new_String__T(ctx, "gCMarked"));
	KNH_TFIELDN(ctx, FIELDN_hasMetaData, new_String__T(ctx, "hasMetaData"));
	KNH_TFIELDN(ctx, FIELDN_in, new_String__T(ctx, "in"));
	KNH_TFIELDN(ctx, FIELDN_index, new_String__T(ctx, "index"));
	KNH_TFIELDN(ctx, FIELDN_indexOf, new_String__T(ctx, "indexOf"));
	KNH_TFIELDN(ctx, FIELDN_init, new_String__T(ctx, "init"));
	KNH_TFIELDN(ctx, FIELDN_initialCapacity, new_String__T(ctx, "initialCapacity"));
	KNH_TFIELDN(ctx, FIELDN_input, new_String__T(ctx, "input"));
	KNH_TFIELDN(ctx, FIELDN_insert, new_String__T(ctx, "insert"));
	KNH_TFIELDN(ctx, FIELDN_isAbstract, new_String__T(ctx, "isAbstract"));
	KNH_TFIELDN(ctx, FIELDN_isAspect, new_String__T(ctx, "isAspect"));
	KNH_TFIELDN(ctx, FIELDN_isAutoFlush, new_String__T(ctx, "isAutoFlush"));
	KNH_TFIELDN(ctx, FIELDN_isClass, new_String__T(ctx, "isClass"));
	KNH_TFIELDN(ctx, FIELDN_isDebug, new_String__T(ctx, "isDebug"));
	KNH_TFIELDN(ctx, FIELDN_isDerived, new_String__T(ctx, "isDerived"));
	KNH_TFIELDN(ctx, FIELDN_isFatal, new_String__T(ctx, "isFatal"));
	KNH_TFIELDN(ctx, FIELDN_isFinal, new_String__T(ctx, "isFinal"));
	KNH_TFIELDN(ctx, FIELDN_isFormatted, new_String__T(ctx, "isFormatted"));
	KNH_TFIELDN(ctx, FIELDN_isGCMarked, new_String__T(ctx, "isGCMarked"));
	KNH_TFIELDN(ctx, FIELDN_isGenerated, new_String__T(ctx, "isGenerated"));
	KNH_TFIELDN(ctx, FIELDN_isImmutable, new_String__T(ctx, "isImmutable"));
	KNH_TFIELDN(ctx, FIELDN_isInterface, new_String__T(ctx, "isInterface"));
	KNH_TFIELDN(ctx, FIELDN_isLocal, new_String__T(ctx, "isLocal"));
	KNH_TFIELDN(ctx, FIELDN_isLogging, new_String__T(ctx, "isLogging"));
	KNH_TFIELDN(ctx, FIELDN_isLossLess, new_String__T(ctx, "isLossLess"));
	KNH_TFIELDN(ctx, FIELDN_isMetaExtensible, new_String__T(ctx, "isMetaExtensible"));
	KNH_TFIELDN(ctx, FIELDN_isModified, new_String__T(ctx, "isModified"));
	KNH_TFIELDN(ctx, FIELDN_isNullBase, new_String__T(ctx, "isNullBase"));
	KNH_TFIELDN(ctx, FIELDN_isPartial, new_String__T(ctx, "isPartial"));
	KNH_TFIELDN(ctx, FIELDN_isPrivate, new_String__T(ctx, "isPrivate"));
	KNH_TFIELDN(ctx, FIELDN_isPublic, new_String__T(ctx, "isPublic"));
	KNH_TFIELDN(ctx, FIELDN_isRelease, new_String__T(ctx, "isRelease"));
	KNH_TFIELDN(ctx, FIELDN_isSignificant, new_String__T(ctx, "isSignificant"));
	KNH_TFIELDN(ctx, FIELDN_isStatic, new_String__T(ctx, "isStatic"));
	KNH_TFIELDN(ctx, FIELDN_isSynchronized, new_String__T(ctx, "isSynchronized"));
	KNH_TFIELDN(ctx, FIELDN_isSynonym, new_String__T(ctx, "isSynonym"));
	KNH_TFIELDN(ctx, FIELDN_isSystem, new_String__T(ctx, "isSystem"));
	KNH_TFIELDN(ctx, FIELDN_isTemporal, new_String__T(ctx, "isTemporal"));
	KNH_TFIELDN(ctx, FIELDN_isTotal, new_String__T(ctx, "isTotal"));
	KNH_TFIELDN(ctx, FIELDN_isUnsigned, new_String__T(ctx, "isUnsigned"));
	KNH_TFIELDN(ctx, FIELDN_isVarArgs, new_String__T(ctx, "isVarArgs"));
	KNH_TFIELDN(ctx, FIELDN_isVirtual, new_String__T(ctx, "isVirtual"));
	KNH_TFIELDN(ctx, FIELDN_key, new_String__T(ctx, "key"));
	KNH_TFIELDN(ctx, FIELDN_keys, new_String__T(ctx, "keys"));
	KNH_TFIELDN(ctx, FIELDN_lambda, new_String__T(ctx, "lambda"));
	KNH_TFIELDN(ctx, FIELDN_len, new_String__T(ctx, "len"));
	KNH_TFIELDN(ctx, FIELDN_m, new_String__T(ctx, "m"));
	KNH_TFIELDN(ctx, FIELDN_modified, new_String__T(ctx, "modified"));
	KNH_TFIELDN(ctx, FIELDN_n, new_String__T(ctx, "n"));
	KNH_TFIELDN(ctx, FIELDN_name, new_String__T(ctx, "name"));
	KNH_TFIELDN(ctx, FIELDN_new, new_String__T(ctx, "new"));
	KNH_TFIELDN(ctx, FIELDN_new__array, new_String__T(ctx, "new:array"));
	KNH_TFIELDN(ctx, FIELDN_new__init, new_String__T(ctx, "new:init"));
	KNH_TFIELDN(ctx, FIELDN_new__offset, new_String__T(ctx, "new:offset"));
	KNH_TFIELDN(ctx, FIELDN_new__slice, new_String__T(ctx, "new:slice"));
	KNH_TFIELDN(ctx, FIELDN_next, new_String__T(ctx, "next"));
	KNH_TFIELDN(ctx, FIELDN_o, new_String__T(ctx, "o"));
	KNH_TFIELDN(ctx, FIELDN_offset, new_String__T(ctx, "offset"));
	KNH_TFIELDN(ctx, FIELDN_old, new_String__T(ctx, "old"));
	KNH_TFIELDN(ctx, FIELDN_opAdd, new_String__T(ctx, "opAdd"));
	KNH_TFIELDN(ctx, FIELDN_opAdd__2, new_String__T(ctx, "opAdd:2"));
	KNH_TFIELDN(ctx, FIELDN_opDiv, new_String__T(ctx, "opDiv"));
	KNH_TFIELDN(ctx, FIELDN_opDiv__2, new_String__T(ctx, "opDiv:2"));
	KNH_TFIELDN(ctx, FIELDN_opEq, new_String__T(ctx, "opEq"));
	KNH_TFIELDN(ctx, FIELDN_opGt, new_String__T(ctx, "opGt"));
	KNH_TFIELDN(ctx, FIELDN_opGte, new_String__T(ctx, "opGte"));
	KNH_TFIELDN(ctx, FIELDN_opIn, new_String__T(ctx, "opIn"));
	KNH_TFIELDN(ctx, FIELDN_opInstanceof, new_String__T(ctx, "opInstanceof"));
	KNH_TFIELDN(ctx, FIELDN_opIsMapTo, new_String__T(ctx, "opIsMapTo"));
	KNH_TFIELDN(ctx, FIELDN_opLShift, new_String__T(ctx, "opLShift"));
	KNH_TFIELDN(ctx, FIELDN_opLogicalAnd, new_String__T(ctx, "opLogicalAnd"));
	KNH_TFIELDN(ctx, FIELDN_opLogicalNot, new_String__T(ctx, "opLogicalNot"));
	KNH_TFIELDN(ctx, FIELDN_opLogicalOr, new_String__T(ctx, "opLogicalOr"));
	KNH_TFIELDN(ctx, FIELDN_opLogicalXor, new_String__T(ctx, "opLogicalXor"));
	KNH_TFIELDN(ctx, FIELDN_opLt, new_String__T(ctx, "opLt"));
	KNH_TFIELDN(ctx, FIELDN_opLte, new_String__T(ctx, "opLte"));
	KNH_TFIELDN(ctx, FIELDN_opMod, new_String__T(ctx, "opMod"));
	KNH_TFIELDN(ctx, FIELDN_opMul, new_String__T(ctx, "opMul"));
	KNH_TFIELDN(ctx, FIELDN_opMul__2, new_String__T(ctx, "opMul:2"));
	KNH_TFIELDN(ctx, FIELDN_opNeg, new_String__T(ctx, "opNeg"));
	KNH_TFIELDN(ctx, FIELDN_opNeq, new_String__T(ctx, "opNeq"));
	KNH_TFIELDN(ctx, FIELDN_opNext, new_String__T(ctx, "opNext"));
	KNH_TFIELDN(ctx, FIELDN_opNot, new_String__T(ctx, "opNot"));
	KNH_TFIELDN(ctx, FIELDN_opOffset, new_String__T(ctx, "opOffset"));
	KNH_TFIELDN(ctx, FIELDN_opPrev, new_String__T(ctx, "opPrev"));
	KNH_TFIELDN(ctx, FIELDN_opRShift, new_String__T(ctx, "opRShift"));
	KNH_TFIELDN(ctx, FIELDN_opSeq, new_String__T(ctx, "opSeq"));
	KNH_TFIELDN(ctx, FIELDN_opSlice, new_String__T(ctx, "opSlice"));
	KNH_TFIELDN(ctx, FIELDN_opSub, new_String__T(ctx, "opSub"));
	KNH_TFIELDN(ctx, FIELDN_opSub__2, new_String__T(ctx, "opSub:2"));
	KNH_TFIELDN(ctx, FIELDN_opSubset, new_String__T(ctx, "opSubset"));
	KNH_TFIELDN(ctx, FIELDN_out, new_String__T(ctx, "out"));
	KNH_TFIELDN(ctx, FIELDN_pop, new_String__T(ctx, "pop"));
	KNH_TFIELDN(ctx, FIELDN_print, new_String__T(ctx, "print"));
	KNH_TFIELDN(ctx, FIELDN_println, new_String__T(ctx, "println"));
	KNH_TFIELDN(ctx, FIELDN_property, new_String__T(ctx, "property"));
	KNH_TFIELDN(ctx, FIELDN_query, new_String__T(ctx, "query"));
	KNH_TFIELDN(ctx, FIELDN_random, new_String__T(ctx, "random"));
	KNH_TFIELDN(ctx, FIELDN_readLine, new_String__T(ctx, "readLine"));
	KNH_TFIELDN(ctx, FIELDN_refc, new_String__T(ctx, "refc"));
	KNH_TFIELDN(ctx, FIELDN_remove, new_String__T(ctx, "remove"));
	KNH_TFIELDN(ctx, FIELDN_replace, new_String__T(ctx, "replace"));
	KNH_TFIELDN(ctx, FIELDN_repr, new_String__T(ctx, "repr"));
	KNH_TFIELDN(ctx, FIELDN_s, new_String__T(ctx, "s"));
	KNH_TFIELDN(ctx, FIELDN_second, new_String__T(ctx, "second"));
	KNH_TFIELDN(ctx, FIELDN_size, new_String__T(ctx, "size"));
	KNH_TFIELDN(ctx, FIELDN_startsWith, new_String__T(ctx, "startsWith"));
	KNH_TFIELDN(ctx, FIELDN_t, new_String__T(ctx, "t"));
	KNH_TFIELDN(ctx, FIELDN_term, new_String__T(ctx, "term"));
	KNH_TFIELDN(ctx, FIELDN_this, new_String__T(ctx, "this"));
	KNH_TFIELDN(ctx, FIELDN_toLower, new_String__T(ctx, "toLower"));
	KNH_TFIELDN(ctx, FIELDN_toUpper, new_String__T(ctx, "toUpper"));
	KNH_TFIELDN(ctx, FIELDN_trim, new_String__T(ctx, "trim"));
	KNH_TFIELDN(ctx, FIELDN_uRN, new_String__T(ctx, "uRN"));
	KNH_TFIELDN(ctx, FIELDN_urn, new_String__T(ctx, "urn"));
	KNH_TFIELDN(ctx, FIELDN_v, new_String__T(ctx, "v"));
	KNH_TFIELDN(ctx, FIELDN_value, new_String__T(ctx, "value"));
	KNH_TFIELDN(ctx, FIELDN_vargs, new_String__T(ctx, "vargs"));
	KNH_TFIELDN(ctx, FIELDN_w, new_String__T(ctx, "w"));
	KNH_TFIELDN(ctx, FIELDN_write, new_String__T(ctx, "write"));
	KNH_TFIELDN(ctx, FIELDN_x, new_String__T(ctx, "x"));
/* ------------------------------------------------------------------------ */

	KNH_INITv(knh_tMethodField[MFN_Any_Any_], new_MethodField__1(ctx, KNH_FLAG_MF_VARARGS, TYPE_Any, TYPE_Any, FIELDN_o));
	KNH_INITv(knh_tMethodField[MFN_void_OutputStream_Any], new_MethodField__2(ctx, 0, TYPE_void, TYPE_OutputStream, FIELDN_w, TYPE_Any, FIELDN_o));
	KNH_INITv(knh_tMethodField[MFN_Any], new_MethodField__0(ctx, 0, TYPE_Any));
	KNH_INITv(knh_tMethodField[MFN_nThis_Int], new_MethodField__1(NULL, 0, NNTYPE_This, TYPE_Int, FIELDN_init));
	KNH_INITv(knh_tMethodField[MFN_nThis_Int_Any1], new_MethodField__2(NULL, 0, NNTYPE_This, TYPE_Int, FIELDN_init, TYPE_Any1, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_nThis_Any1_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_This, TYPE_Any1, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_void_Any1], new_MethodField__1(NULL, 0, TYPE_void, TYPE_Any1, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_void_Any1_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, TYPE_void, TYPE_Any1, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nInt], new_MethodField__0(NULL, 0, NNTYPE_Int));
	KNH_INITv(knh_tMethodField[MFN_Any1_nInt], new_MethodField__1(NULL, 0, TYPE_Any1, NNTYPE_Int, FIELDN_index));
	KNH_INITv(knh_tMethodField[MFN_void_nInt_Any1], new_MethodField__2(NULL, 0, TYPE_void, NNTYPE_Int, FIELDN_index, TYPE_Any1, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_Any1], new_MethodField__0(NULL, 0, TYPE_Any1));
	KNH_INITv(knh_tMethodField[MFN_void_nInt], new_MethodField__1(NULL, 0, TYPE_void, NNTYPE_Int, FIELDN_n));
	KNH_INITv(knh_tMethodField[MFN_void], new_MethodField__0(NULL, 0, TYPE_void));
	KNH_INITv(knh_tMethodField[MFN_nThis_Int_Int], new_MethodField__2(NULL, 0, NNTYPE_This, TYPE_Int, FIELDN_s, TYPE_Int, FIELDN_e));
	KNH_INITv(knh_tMethodField[MFN_nBoolean_Any], new_MethodField__1(NULL, 0, NNTYPE_Boolean, TYPE_Any, FIELDN_another));
	KNH_INITv(knh_tMethodField[MFN_nBytes_Int], new_MethodField__1(NULL, 0, NNTYPE_Bytes, TYPE_Int, FIELDN_init));
	KNH_INITv(knh_tMethodField[MFN_nConnection_nString], new_MethodField__1(NULL, 0, NNTYPE_Connection, NNTYPE_String, FIELDN_urn));
	KNH_INITv(knh_tMethodField[MFN_ResultSet_nString], new_MethodField__1(NULL, 0, TYPE_ResultSet, NNTYPE_String, FIELDN_query));
	KNH_INITv(knh_tMethodField[MFN_Any_nString], new_MethodField__1(NULL, 0, TYPE_Any, NNTYPE_String, FIELDN_key));
	KNH_INITv(knh_tMethodField[MFN_void_nString_Any], new_MethodField__2(NULL, 0, TYPE_void, NNTYPE_String, FIELDN_key, TYPE_Any, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_void_String], new_MethodField__1(NULL, 0, TYPE_void, TYPE_String, FIELDN_enc));
	KNH_INITv(knh_tMethodField[MFN_nInt_nString], new_MethodField__1(NULL, 0, NNTYPE_Int, NNTYPE_String, FIELDN_term));
	KNH_INITv(knh_tMethodField[MFN_String_nInt], new_MethodField__1(NULL, 0, TYPE_String, NNTYPE_Int, FIELDN_index));
	KNH_INITv(knh_tMethodField[MFN_nDictMap_Int], new_MethodField__1(NULL, 0, NNTYPE_DictMap, TYPE_Int, FIELDN_initialCapacity));
	KNH_INITv(knh_tMethodField[MFN_void_nString_nAny], new_MethodField__2(NULL, 0, TYPE_void, NNTYPE_String, FIELDN_key, NNTYPE_Any, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_void_nString], new_MethodField__1(NULL, 0, TYPE_void, NNTYPE_String, FIELDN_key));
	KNH_INITv(knh_tMethodField[MFN_nDictSet_Int], new_MethodField__1(NULL, 0, NNTYPE_DictSet, TYPE_Int, FIELDN_initialCapacity));
	KNH_INITv(knh_tMethodField[MFN_Boolean_Any], new_MethodField__1(NULL, 0, TYPE_Boolean, TYPE_Any, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_void_nString_nInt], new_MethodField__2(NULL, 0, TYPE_void, NNTYPE_String, FIELDN_key, NNTYPE_Int, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_nFloat_nFloat], new_MethodField__1(NULL, 0, NNTYPE_Float, NNTYPE_Float, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nFloat], new_MethodField__0(NULL, 0, NNTYPE_Float));
	KNH_INITv(knh_tMethodField[MFN_nFloat_nFloat_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_Float, NNTYPE_Float, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nBoolean_nFloat], new_MethodField__1(NULL, 0, NNTYPE_Boolean, NNTYPE_Float, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_Float], new_MethodField__0(NULL, 0, TYPE_Float));
	KNH_INITv(knh_tMethodField[MFN_Any2_Any1], new_MethodField__1(NULL, 0, TYPE_Any2, TYPE_Any1, FIELDN_key));
	KNH_INITv(knh_tMethodField[MFN_void_Any1_Any2], new_MethodField__2(NULL, 0, TYPE_void, TYPE_Any1, FIELDN_key, TYPE_Any2, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_nHashMap_Int], new_MethodField__1(NULL, 0, NNTYPE_HashMap, TYPE_Int, FIELDN_initialCapacity));
	KNH_INITv(knh_tMethodField[MFN_nHashMap_Any_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_HashMap, TYPE_Any, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_Boolean_Any1], new_MethodField__1(NULL, 0, TYPE_Boolean, TYPE_Any1, FIELDN_key));
	KNH_INITv(knh_tMethodField[MFN_nIterator], new_MethodField__0(NULL, 0, NNTYPE_Iterator));
	KNH_INITv(knh_tMethodField[MFN_nInt_Any1], new_MethodField__1(NULL, 0, NNTYPE_Int, TYPE_Any1, FIELDN_key));
	KNH_INITv(knh_tMethodField[MFN_void_Any1_nInt], new_MethodField__2(NULL, 0, TYPE_void, TYPE_Any1, FIELDN_key, NNTYPE_Int, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_nHashSet_Int], new_MethodField__1(NULL, 0, NNTYPE_HashSet, TYPE_Int, FIELDN_initialCapacity));
	KNH_INITv(knh_tMethodField[MFN_String], new_MethodField__0(NULL, 0, TYPE_String));
	KNH_INITv(knh_tMethodField[MFN_nInt_nInt], new_MethodField__1(NULL, 0, NNTYPE_Int, NNTYPE_Int, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nInt_nInt_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_Int, NNTYPE_Int, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nBoolean_nInt], new_MethodField__1(NULL, 0, NNTYPE_Boolean, NNTYPE_Int, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_nInt_Int], new_MethodField__1(NULL, 0, NNTYPE_Int, TYPE_Int, FIELDN_n));
	KNH_INITv(knh_tMethodField[MFN_nInt_nInt_Class], new_MethodField__2(NULL, 0, NNTYPE_Int, NNTYPE_Int, FIELDN_n, TYPE_Class, FIELDN_c));
	KNH_INITv(knh_tMethodField[MFN_Boolean_nInt], new_MethodField__1(NULL, 0, TYPE_Boolean, NNTYPE_Int, FIELDN_value));
	KNH_INITv(knh_tMethodField[MFN_Boolean], new_MethodField__0(NULL, 0, TYPE_Boolean));
	KNH_INITv(knh_tMethodField[MFN_nString], new_MethodField__0(NULL, 0, NNTYPE_String));
	KNH_INITv(knh_tMethodField[MFN_nFloat_nNumber], new_MethodField__1(NULL, 0, NNTYPE_Float, NNTYPE_Number, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nFloat_nNumber_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_Float, NNTYPE_Number, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nBoolean_nNumber], new_MethodField__1(NULL, 0, NNTYPE_Boolean, NNTYPE_Number, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nThis], new_MethodField__0(NULL, 0, NNTYPE_This));
	KNH_INITv(knh_tMethodField[MFN_nInt_Any], new_MethodField__1(NULL, 0, NNTYPE_Int, TYPE_Any, FIELDN_o));
	KNH_INITv(knh_tMethodField[MFN_Class], new_MethodField__0(NULL, 0, TYPE_Class));
	KNH_INITv(knh_tMethodField[MFN_void_nBytes_Int_Int], new_MethodField__3(NULL, 0, TYPE_void, NNTYPE_Bytes, FIELDN_buf, TYPE_Int, FIELDN_offset, TYPE_Int, FIELDN_len));
	KNH_INITv(knh_tMethodField[MFN_void_Any], new_MethodField__1(NULL, 0, TYPE_void, TYPE_Any, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nRange_Any1_Any1], new_MethodField__2(NULL, 0, NNTYPE_Range, TYPE_Any1, FIELDN_s, TYPE_Any1, FIELDN_e));
	KNH_INITv(knh_tMethodField[MFN_nRange_Any1_Int], new_MethodField__2(NULL, 0, NNTYPE_Range, TYPE_Any1, FIELDN_s, TYPE_Int, FIELDN_offset));
	KNH_INITv(knh_tMethodField[MFN_ResultSet], new_MethodField__0(NULL, 0, TYPE_ResultSet));
	KNH_INITv(knh_tMethodField[MFN_nBoolean_nString], new_MethodField__1(NULL, 0, NNTYPE_Boolean, NNTYPE_String, FIELDN_s));
	KNH_INITv(knh_tMethodField[MFN_nString_Any], new_MethodField__1(NULL, 0, NNTYPE_String, TYPE_Any, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nString_Any_], new_MethodField__1(NULL, KNH_FLAG_MF_VARARGS, NNTYPE_String, TYPE_Any, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nString_nString], new_MethodField__1(NULL, 0, NNTYPE_String, NNTYPE_String, FIELDN_t));
	KNH_INITv(knh_tMethodField[MFN_nString_nString_nString], new_MethodField__2(NULL, 0, NNTYPE_String, NNTYPE_String, FIELDN_old, NNTYPE_String, FIELDN_new));
	KNH_INITv(knh_tMethodField[MFN_nString_String], new_MethodField__1(NULL, 0, NNTYPE_String, TYPE_String, FIELDN_v));
	KNH_INITv(knh_tMethodField[MFN_nString_nInt], new_MethodField__1(NULL, 0, NNTYPE_String, NNTYPE_Int, FIELDN_n));
	KNH_INITv(knh_tMethodField[MFN_nString_Int_Int], new_MethodField__2(NULL, 0, NNTYPE_String, TYPE_Int, FIELDN_offset, TYPE_Int, FIELDN_len));
	KNH_INITv(knh_tMethodField[MFN_nInputStream], new_MethodField__0(NULL, 0, NNTYPE_InputStream));
	KNH_INITv(knh_tMethodField[MFN_void_InputStream], new_MethodField__1(NULL, 0, TYPE_void, TYPE_InputStream, FIELDN_input));
	KNH_INITv(knh_tMethodField[MFN_nOutputStream], new_MethodField__0(NULL, 0, NNTYPE_OutputStream));
	KNH_INITv(knh_tMethodField[MFN_void_OutputStream], new_MethodField__1(NULL, 0, TYPE_void, TYPE_OutputStream, FIELDN_out));
	KNH_INITv(knh_tMethodField[MFN_nTuple2_Any1_Any2], new_MethodField__2(NULL, 0, NNTYPE_Tuple2, TYPE_Any1, FIELDN_first, TYPE_Any2, FIELDN_second));
	KNH_INITv(knh_tMethodField[MFN_Any_nInt], new_MethodField__1(NULL, 0, TYPE_Any, NNTYPE_Int, FIELDN_index));
	KNH_INITv(knh_tMethodField[MFN_Boolean_Class], new_MethodField__1(NULL, 0, TYPE_Boolean, TYPE_Class, FIELDN_c));
	KNH_INITv(knh_tMethodField[MFN_nBoolean], new_MethodField__0(NULL, 0, NNTYPE_Boolean));
	KNH_INITv(knh_tMethodField[MFN_void_Boolean], new_MethodField__1(NULL, 0, TYPE_void, TYPE_Boolean, FIELDN_b));
	knh_package_konoha_ginit(ctx);
	knh_package_konohac_ginit(ctx);
	knh_package_naruto_ginit(ctx);
#ifdef KONOHA_MONOLITHIC
	knh_package_math_ginit(ctx);
#endif
#ifdef KONOHA_MONOLITHIC
	knh_package_mysql_ginit(ctx);
#endif
}

#ifdef __cplusplus
}
#endif
