/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* [flag] */

/* ======================================================================== */
/* [method] */

/* ======================================================================== */
/* [TABLE] */

static INLINE
knh_struct_t
KNH_TSTRUCT_Token(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Token*, int, Object*),
	void (*fcopy)(Ctx*, knh_Token*, knh_Token*),
	void (*fgc)(Ctx*, knh_Token*, f_traverse),
	knh_hcode_t (*fhashCode)(Token*),
	int (*fcompareTo)(Token*, Token*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Stmt(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Stmt*, int, Object*),
	void (*fcopy)(Ctx*, knh_Stmt*, knh_Stmt*),
	void (*fgc)(Ctx*, knh_Stmt*, f_traverse),
	knh_hcode_t (*fhashCode)(Stmt*),
	int (*fcompareTo)(Stmt*, Stmt*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Compiler(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Compiler*, int, Object*),
	void (*fcopy)(Ctx*, knh_Compiler*, knh_Compiler*),
	void (*fgc)(Ctx*, knh_Compiler*, f_traverse),
	knh_hcode_t (*fhashCode)(Compiler*),
	int (*fcompareTo)(Compiler*, Compiler*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_VirtualMachineCode(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_VirtualMachineCode*, int, Object*),
	void (*fcopy)(Ctx*, knh_VirtualMachineCode*, knh_VirtualMachineCode*),
	void (*fgc)(Ctx*, knh_VirtualMachineCode*, f_traverse),
	knh_hcode_t (*fhashCode)(VirtualMachineCode*),
	int (*fcompareTo)(VirtualMachineCode*, VirtualMachineCode*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

/* ======================================================================== */
/* [package] */

void knh_package_konohac_ginit(Ctx *ctx)
{

	KNH_TSTRUCT_Token(ctx, STRUCT_Token, sizeof(knh_Token),
		"Token",
		knh_Token_struct_init,
		knh_Token_struct_copy, 
//		knh_Token_struct_compare, 
		knh_Token_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Stmt(ctx, STRUCT_Stmt, sizeof(knh_Stmt),
		"Stmt",
		knh_Stmt_struct_init,
		knh_Stmt_struct_copy, 
//		knh_Stmt_struct_compare, 
		knh_Stmt_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Compiler(ctx, STRUCT_Compiler, sizeof(knh_Compiler),
		"Compiler",
		knh_Compiler_struct_init,
		knh_Compiler_struct_copy, 
//		knh_Compiler_struct_compare, 
		knh_Compiler_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_VirtualMachineCode(ctx, STRUCT_VirtualMachineCode, sizeof(knh_VirtualMachineCode),
		"VirtualMachineCode",
		knh_VirtualMachineCode_struct_init,
		knh_VirtualMachineCode_struct_copy, 
//		knh_VirtualMachineCode_struct_compare, 
		knh_VirtualMachineCode_struct_traverse,
		NULL,
		NULL);
	KNH_TCLASS(ctx, CFLAG_Token,
		new_String__T(ctx, "konohac.Token"),
		CLASS_Token, STRUCT_Token, CLASS_Object,
		KNH_NULL, NULL, 0); 
	KNH_TCLASS(ctx, CFLAG_Stmt,
		new_String__T(ctx, "konohac.Stmt"),
		CLASS_Stmt, STRUCT_Stmt, CLASS_Object,
		KNH_NULL, NULL, 0); 
	KNH_TCLASS(ctx, CFLAG_Compiler,
		new_String__T(ctx, "konohac.Compiler"),
		CLASS_Compiler, STRUCT_Compiler, CLASS_Object,
		KNH_NULL, NULL, 0); 
	KNH_TCLASS(ctx, CFLAG_VirtualMachineCode,
		new_String__T(ctx, "konohac.VirtualMachineCode"),
		CLASS_VirtualMachineCode, STRUCT_VirtualMachineCode, CLASS_Object,
		KNH_NULL, NULL, 0); 
	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Stmt__s, /*delta*/0, 
		CLASS_Stmt, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Stmt__dump, /*delta*/0, 
		CLASS_Stmt, METHODN__dump,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Token__s, /*delta*/0, 
		CLASS_Token, METHODN__s,
		MF_void_OutputStream_Any
	);

	KNH_TMETHOD(ctx, 
		0, 
		knh_fmethod_movableText, knh_Token__dump, /*delta*/0, 
		CLASS_Token, METHODN__dump,
		MF_void_OutputStream_Any
	);

}

#ifdef __cplusplus
}
#endif
