/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* [flag] */

/* ======================================================================== */
/* [method] */

/* ======================================================================== */
/* [TABLE] */

static INLINE
knh_struct_t
KNH_TSTRUCT_Counter(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Counter*, int, Object*),
	void (*fcopy)(Ctx*, knh_Counter*, knh_Counter*),
	void (*fgc)(Ctx*, knh_Counter*, f_traverse),
	knh_hcode_t (*fhashCode)(Counter*),
	int (*fcompareTo)(Counter*, Counter*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

static INLINE
knh_struct_t
KNH_TSTRUCT_Amazon(Ctx *ctx,
	knh_struct_t sid,
	size_t size,
	char *name,
	void (*finit)(Ctx*, knh_Amazon*, int, Object*),
	void (*fcopy)(Ctx*, knh_Amazon*, knh_Amazon*),
	void (*fgc)(Ctx*, knh_Amazon*, f_traverse),
	knh_hcode_t (*fhashCode)(Amazon*),
	int (*fcompareTo)(Amazon*, Amazon*)) {
	return KNH_TSTRUCT(ctx, sid, size, name, 
		(f_tStruct_init)finit, (f_tStruct_copy)fcopy, (f_tStruct_traverse)fgc,
		(f_hashCode)fhashCode, (f_compareTo)fcompareTo);
}

/* ======================================================================== */
/* [package] */

void knh_package_naruto_ginit(Ctx *ctx)
{

	KNH_TSTRUCT_Counter(ctx, STRUCT_Counter, sizeof(knh_Counter),
		"Counter",
		knh_Counter_struct_init,
		knh_Counter_struct_copy, 
//		knh_Counter_struct_compare, 
		knh_Counter_struct_traverse,
		NULL,
		NULL);
	KNH_TSTRUCT_Amazon(ctx, STRUCT_Amazon, sizeof(knh_Amazon),
		"Amazon",
		knh_Amazon_struct_init,
		knh_Amazon_struct_copy, 
//		knh_Amazon_struct_compare, 
		knh_Amazon_struct_traverse,
		NULL,
		NULL);
	KNH_TCLASS(ctx, CFLAG_Counter,
		new_String__T(ctx, "naruto.Counter"),
		CLASS_Counter, STRUCT_Counter, CLASS_Object,
		KNH_NULL, NULL, 0); 
	KNH_TCLASS(ctx, CFLAG_Amazon,
		new_String__T(ctx, "naruto.Amazon"),
		CLASS_Amazon, STRUCT_Amazon, CLASS_Object,
		KNH_NULL, NULL, 0); 
}

#ifdef __cplusplus
}
#endif
