/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
/* [konoha] */

/* ------------------------------------------------------------------------ */

static int knh_systemIsInitialized = 0;
static knh_uint_t knh_runtimeId = 0;

void konoha_load_builtins(Ctx *ctx);

/* ------------------------------------------------------------------------ */

static
void konoha_init0()
{
	knh_tObject_init0();
	knh_tContext_init0();
	knh_tStruct_init0();
	knh_tClass_init0();
	konoha_load_builtins(NULL);
}

/* ------------------------------------------------------------------------ */

konoha_t konoha_open(void)
{
	if(knh_systemIsInitialized == 0) {
		konoha_init0();
		knh_systemIsInitialized = 1;
	}
	{
		Runtime *runtime = new_Runtime0(knh_runtimeId++);
		konoha_t k = {KONOHA_MAGIC, runtime};
		knh_Object_RCinc((Object*)runtime);
		return k;
	}
}

/* ------------------------------------------------------------------------ */

void konoha_traverse(Ctx *ctx, f_traverse f)
{
	knh_tContext_traverse(ctx, f);
	knh_tObject_traverse(ctx, f);
	knh_tStruct_traverse(ctx, f);
}

/* ------------------------------------------------------------------------ */

void konoha_close(konoha_t konoha)
{
	if(konoha.magic == KONOHA_MAGIC) {
		if(!IS_Runtime(konoha.runtime)) {
			KNH_SAYS("Maybe already closed");
			return;
		}
		knh_Object_RCsweep(NULL, konoha.runtime);
		if(knh_Runtime_isAllClosed()) {
			konoha_traverse(NULL, knh_Object_RCsweep);
#ifdef KNH_DBGMODE
			if(knh_stat_usedMemorySize() != 0) {
				KNH_SAYS("MEMORY LEAK: %d bytes", (int)knh_stat_usedMemorySize());
			}
#endif
		}
	}
	else{
		KNH_SAYS("This is not a Konoha Scripting Engine");
	}
}

/* ======================================================================== */
/* [context] */

Ctx *konoha_open_context(konoha_t konoha)
{
	if(konoha.magic == KONOHA_MAGIC && IS_Runtime(konoha.runtime)) {
		return new_Context0(konoha.runtime, KNH_STACKSIZE);
	}
	else {
		KNH_SAYS("This is not a Konoha Scripting Engine");
	}
	return NULL;
}

/* ------------------------------------------------------------------------ */

void konoha_close_context(konoha_t konoha, Ctx *ctx)
{
	knh_Object_t *o = (knh_Object_t*)ctx;
	if(konoha.magic == KONOHA_MAGIC && IS_Context(o)) {
		knh_Object_RCsweep(ctx, o);
	}
	else {
		KNH_SAYS("This is not a Konoha Scripting Engine");
	}
}

/* ======================================================================== */
/* [konoha] */

//void konoha_eval(Ctx *ctx, char *script)
//{
//	if(ctx == NULL) {
//		return;
//	}
//	else {
//		TODO();
////		knh_wbuf_t cb = knh_Context_wbuf(ctx);
////		knh_Bytes_write(ctx, cb.ba, B(script));
////		InputStream *in = new_InputStream__Bytes(ctx, cb.ba, cb.pos, knh_Bytes_size(cb.ba));
////		in->filen = knh_tfilen_forname(ctx, STEXT("(eval)"));
////		knh_konohac_eval(ctx, NSN_main, in);
////		knh_wbuf_clear(cb);
//	}
//}
//

/* ------------------------------------------------------------------------ */

void konoha_read(Ctx *ctx, char *fpath)
{
	if(ctx == NULL) return;
	FILE *fp = fopen(fpath, "r");
	if(fp == NULL) {
		fprintf(stderr, "konoha: Cannot open: %s\n", fpath);
		return;
	}
	
	InputStream *in = new_InputStream__FILE(ctx, fp);
	DP(in)->fileid = knh_tName_getFileId(ctx, B(fpath));
	knh_konohac_eval(ctx, KNH_NULL, in);
}

/* ------------------------------------------------------------------------ */


#ifdef __cplusplus
}
#endif
