/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */
#define KONOHA_WITH_LOCALE 1

#include"commons.h"

#ifdef KONOHA_WITH_LOCALE
#include<locale.h>
#endif

#ifdef KNH_USING_ICONV
#include<localcharset.h>
#endif

#ifdef KNH_USING_POSIX
#include<langinfo.h>
#endif

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [time] */

char *konoha_encoding()
{
	char *enc = knh_getenv("LC_CTYPE");
	if(enc != NULL) {
		return (char*)enc;
	}
#ifdef KNH_USING_ICONV
	return (char*)locale_charset();
#endif
#ifdef KNH_USING_POSIX
	return nl_langinfo(CODESET);
#endif
#ifdef KONOHA_WITH_LOCALE
	char *locale = setlocale(LC_ALL, "");
	DBG2_P("LC_ALL locale='%s'", locale);
	locale = setlocale(LC_CTYPE, "");
	DBG2_P("LC_CTYPE locale='%s'", locale);
	return locale;
#endif
	return KONOHA_ENCODING;
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
