/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
/* [global] */

#define mprHashMap(ctx) ((Context*)ctx)->tmapperHashMap

#ifdef KNH_STATMODE1
static size_t cache_hit  = 0;
static size_t cache_miss = 0;
#endif

/* ------------------------------------------------------------------------ */

//#ifdef KNH_STATMODE1
//void konoha_stat_tmapmap_cache()
//{
//	DBG2_P("hit=%d, miss=%d", (int)cache_hit, (int)cache_miss);
//}
//#endif

/* ======================================================================== */
/* [tmapmap] */

void KNH_TMAPPER(Ctx *ctx, knh_flag_t flag, knh_type_t stype, knh_type_t ttype, f_mapper fmap, Object *mapdata)
{
	knh_class_t cid = TYPE_UNMASK(stype);
	DEBUG_ASSERT_cid(cid);
	knh_ClassMap_add(ctx, knh_tClass[cid].cmap, 
		new_Mapper(ctx, flag, TYPE_UNMASK(stype), TYPE_UNMASK(ttype), fmap, mapdata));
}

#define _KNH_TMAPMAP  KNH_TMAPPER

/* ======================================================================== */
/* [tcache] */

static
Mapper *knh_tmapper_getcache(Ctx *ctx, knh_class_t scid, knh_class_t tcid)
{
	knh_uint_t hcode = (scid << (sizeof(knh_class_t) * 8)) + tcid;
#ifdef KNH_STATMODE1
	Mapper *mar = knh_HashMap_get(ctx, mprHashMap(ctx), hcode, NULL);
	if(IS_NOTNULL(mar)) {
		cache_hit++;
		KNH_ASSERT(scid == DP(mpr)->scid && tcid == DP(mpr)->tcid);
	}
	else {
		cache_miss++;
	}
	return mar;
#else
	return (Mapper*)knh_HashMap_get(ctx, mprHashMap(ctx), hcode, NULL);
#endif
}

/* ------------------------------------------------------------------------ */

static
Mapper *knh_tmapper_setcache(Ctx *ctx, Mapper *mpr)
{
	knh_uint_t hcode = (DP(mpr)->scid << (sizeof(knh_class_t) * 8)) + DP(mpr)->tcid;
	knh_HashMap_set(ctx, mprHashMap(ctx), hcode, NULL, mpr);
	return mpr;
}

/* ------------------------------------------------------------------------ */

static
Mapper *knh_tmapper_setcache2(Ctx *ctx, Mapper *mpr, Mapper *mpr2)
{
	TODO();
	return NULL; /* knh_tmapper_setcache(ctx, new_Mapper__2(ctx, mpr, mpr2)); */
}


/* ------------------------------------------------------------------------ */
/* [Mapper] */

static Object* knh_Mapper_fInterface(Ctx *ctx, Object *o, Mapper *mpr)
{
	return o;
}

/* ------------------------------------------------------------------------ */

static
Mapper* new_Mapper__asis(Ctx *ctx, knh_class_t scid, knh_class_t tcid)
{
	return new_Mapper(ctx, 0, scid, tcid, knh_Mapper_fInterface, KNH_NULL);
}

/* ------------------------------------------------------------------------ */

static
Object* knh_Mapper_fNull(Ctx *ctx, Object *o, Mapper *mpr)
{
	char buf[CLASSNAME_BUFSIZ*2];
	knh_snprintf(buf, sizeof(buf), "NoSuchMapping!!: %s ==> %s", CLASSN(DP(mpr)->scid), CLASSN(DP(mpr)->tcid));
	return (Object*)new_Nue__s(ctx, buf);
}

/* ------------------------------------------------------------------------ */

static
Mapper* new_Mapper__NoSuchMapping(Ctx *ctx, knh_class_t scid, knh_class_t tcid)
{
	return new_Mapper(ctx, 0, scid, tcid, knh_Mapper_fNull, KNH_NULL);
}

/* ------------------------------------------------------------------------ */

INLINE
knh_bool_t knh_Mapper_isNoSuchMapping(Mapper *o)
{
	return (DP(o)->fmap == knh_Mapper_fNull);
}

/* ------------------------------------------------------------------------ */

Mapper *knh_tmapper_find(Ctx *ctx, knh_class_t scid, knh_class_t tcid)
{
	DBG2_P("finding.. %s ==> %s", CLASSN(scid), CLASSN(tcid));
	DEBUG_ASSERT_cid(scid);
	DEBUG_ASSERT_cid(tcid);
	{
		Mapper *mpr = knh_tmapper_getcache(ctx, scid, tcid);
		if(IS_NOTNULL(mpr)) { return mpr; }
	
		if(scid == tcid) {  /* default */
			return knh_tmapper_setcache(ctx, new_Mapper__asis(ctx, scid, tcid));
		}
		else {
			ClassMap *cmap = knh_tClass[scid].cmap;
			int i;
			DBG2_(knh_ClassMap__dump(ctx, cmap, KNH_STDOUT, KNH_NULL));
			for(i = 0; i < DP(cmap)->size; i++) {
				mpr = DP(cmap)->maplist[i];
				if(DP(mpr)->tcid == tcid) return knh_tmapper_setcache(ctx, mpr);
			}
			for(i = 0; i < DP(cmap)->size; i++) {
				mpr = DP(cmap)->maplist[i];
				if(knh_class_instanceof(DP(mpr)->tcid, tcid)) return knh_tmapper_setcache(ctx, mpr);
			}
			for(i = 0; i < DP(cmap)->size; i++) {
				ClassMap *cmap2 = knh_tClass[DP(DP(cmap)->maplist[i])->tcid].cmap;
				int j;
				DEBUG_ASSERT_cid(DP(DP(cmap)->maplist[i])->tcid);
				for(j = 0; j < DP(cmap2)->size; j++) {
					mpr = DP(cmap2)->maplist[j];
					if(DP(mpr)->tcid == tcid) {
						return knh_tmapper_setcache2(ctx, DP(cmap)->maplist[i], mpr);
					}
				}
				for(j = 0; j < DP(cmap2)->size; j++) {
					mpr = DP(cmap2)->maplist[j];
					if(knh_class_instanceof(DP(mpr)->tcid, tcid)) {
						return knh_tmapper_setcache2(ctx, DP(cmap)->maplist[i], mpr);
					}
				}
			}
		}
		
		/* Mapping Generation Part */
	
		/* C ==> Iterator, C ==> C.. */
		if(tcid == CLASS_Iterator || (knh_tClass[tcid].bcid == CLASS_Iterator && knh_tClass[tcid].p1 == scid)) {
			return knh_tmapper_setcache(ctx, new_Mapper(ctx, 0, scid, tcid, knh_Object_Iterator, KNH_NULL));
		}
		
		/* ResultSet ==> C */
//		if(scid == CLASS_ResultSet) {
//			TODO();
//			return knh_tmapper_setcache(ctx, new_Mapper__ResultSet(ctx, tcid));
//		}
		return knh_tmapper_setcache(ctx, new_Mapper__NoSuchMapping(ctx, scid, tcid));
	}
}

/* ======================================================================== */
/* [mapmap] */

///* ------------------------------------------------------------------------ */
//
//Object* knh_Mapper_f2(Ctx *ctx, Object *self, Mapper *map)
//{
//	Mapper *mpr = (Mapper*)KNH_FIELDn(DP(mpr)->data, 0);
//	Object *target = knh_Mapper_exec(ctx, mpr, self);
//	if(target)
//	KNH_ASSERT(IS_Method(DP(mpr)->mapdata));
//	KNH_PUSHv(ctx, DP(mpr)->mapdata);    /* ebp[-1] */
//	KNH_PUSHv(ctx, self);           /* ebp[0] */
//	KNH_SCALL(ctx, -1);
//	VM_SHIFT(ctx, -1);
//	return VM_EBP(ctx, 1);
//}

/* ======================================================================== */
/* [func] */

/* ------------------------------------------------------------------------ */

static
Object* knh_Mapper_fMethod(Ctx *ctx, Object *o, Mapper *mpr)
{
	KNH_ASSERT(IS_Method(DP(mpr)->mapdata));
	KNH_LPUSH(ctx, DP(mpr)->mapdata);    /* ebp[-1] */
	KNH_LPUSH(ctx, o);                   /* ebp[0] */
	KNH_SCALL(ctx, -1);
	VM_SHIFT(ctx, -1);
	return VM_EBP(ctx, 1);
}

/* ------------------------------------------------------------------------ */

f_mapper knh_tmapper_findfunc(Ctx *ctx, Object *mapdata, knh_class_t scid, knh_class_t tcid)
{
	if(IS_Method(mapdata)) return knh_Mapper_fMethod;
	return knh_Mapper_fNull;
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
