<?php
/*
  checkout_shipping_address_short.php
  2004/12/2
ǽ2005/6/1

ԡͭ²ҥɥ֥졼
δʿ
ryuhei@secondbrain.co.jp

  Released under the GNU General Public License
*/

  require('includes/application_top.php');

// if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

// if the order contains only virtual products, forward the customer to the billing page as
// a shipping address is not needed
  if ($order->content_type == 'virtual') {
    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');
    $shipping = false;
    if (!tep_session_is_registered('sendto')) tep_session_register('sendto');
    $sendto = false;
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
  }

  $error = false;
  $process = false;
  if (isset($HTTP_POST_VARS['action']) && ($HTTP_POST_VARS['action'] == 'submit')) {
// process a new shipping address
    if (tep_not_null($HTTP_POST_VARS['firstname']) && tep_not_null($HTTP_POST_VARS['lastname']) && tep_not_null($HTTP_POST_VARS['street_address'])) {
      $process = true;

      $gender = tep_db_prepare_input($HTTP_POST_VARS['gender']);
      $company = tep_db_prepare_input($HTTP_POST_VARS['company']);
      $firstname = tep_db_prepare_input($HTTP_POST_VARS['firstname']);
      $lastname = tep_db_prepare_input($HTTP_POST_VARS['lastname']);
      $street_address = tep_db_prepare_input($HTTP_POST_VARS['street_address']);
      $suburb = tep_db_prepare_input($HTTP_POST_VARS['suburb']);
      $postcode = tep_db_prepare_input($HTTP_POST_VARS['postcode']);
      $city = tep_db_prepare_input($HTTP_POST_VARS['city']);
      $country = tep_db_prepare_input($HTTP_POST_VARS['country']);
      $zone_id = tep_db_prepare_input($HTTP_POST_VARS['zone_id']);
      $state = tep_db_prepare_input($HTTP_POST_VARS['state']);
// 2003-06-06 add_telephone
      $telephone = tep_db_prepare_input($HTTP_POST_VARS['telephone']);

      if (ACCOUNT_GENDER == 'true') {
        if (($gender == 'm') || ($gender == 'f')) {
          $gender_error = false;
        } else {
          $gender_error = true;
          $error = true;
        }
      }

      if (ACCOUNT_COMPANY == 'true') {
        if (strlen($company) < ENTRY_COMPANY_MIN_LENGTH) {
          $company_error = true;
          $error = true;
        } else {
          $company_error = false;
        }
      }

      if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
        $firstname_error = true;
        $error = true;
      } else {
        $firstname_error = false;
      }

      if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
        $lastname_error = true;
        $error = true;
      } else {
        $lasttname_error = false;
      }

      if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
        $street_address_error = true;
        $error = true;
      } else {
        $street_address_error = false;
      }

      if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
        $postcode_error = true;
        $error = true;
      } else {
        $postcode_error = false;
      }

      if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {
        $city_error = true;
        $error = true;
      } else {
        $city_error = false;
      }

      if (strlen($country) < 1) {
        $country_error = true;
        $error = true;
      } else {
        $country_error = false;
      }

      if (ACCOUNT_STATE == 'true') {
        if ($entry_country_error == true) {
          $entry_state_error = true;
        } else {
          $zone_id = 0;
          $entry_state_error = false;
          $check_query = tep_db_query("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . tep_db_input($country) . "'");
          $check_value = tep_db_fetch_array($check_query);
          $entry_state_has_zones = ($check_value['total'] > 0);
          if ($entry_state_has_zones == true) {
            $zone_query = tep_db_query("select zone_id from " . TABLE_ZONES . " where zone_country_id = '" . tep_db_input($country) . "' and zone_name = '" . tep_db_input($state) . "'");
            if (tep_db_num_rows($zone_query) == 1) {
              $zone_values = tep_db_fetch_array($zone_query);
              $zone_id = $zone_values['zone_id'];
            } else {
              $error = true;
              $entry_state_error = true;
            }
          } else {
            if (strlen($state) < ENTRY_STATE_MIN_LENGTH) {
              $error = true;
              $entry_state_error = true;
            }
          }
        }
      }

// 2003-06-06 add_telephone
      if (strlen($telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
        $telephone_error = true;
        $error = true;
      } else {
        $telephone_error = false;
      }

      if ($error == false) {
        $next_id_query = tep_db_query("select max(address_book_id) as address_book_id from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . $customer_id . "'");
        if (tep_db_num_rows($next_id_query)) {
          $next_id = tep_db_fetch_array($next_id_query);
          $entry_id = $next_id['address_book_id']+1;
        } else {
          $entry_id = 1;
        }

// 2003-06-06 add_telephone
        $sql_data_array = array('customers_id' => $customer_id,
                                'address_book_id' => $entry_id,
                                'entry_firstname' => $firstname,
                                'entry_lastname' => $lastname,
                                'entry_street_address' => $street_address,
                                'entry_postcode' => $postcode,
                                'entry_city' => $city,
                                'entry_country_id' => $country,
                                'entry_telephone' => $telephone);

        if (ACCOUNT_GENDER == 'true') $sql_data_array['entry_gender'] = $gender;
        if (ACCOUNT_COMPANY == 'true') $sql_data_array['entry_company'] = $company;
        if (ACCOUNT_SUBURB == 'true') $sql_data_array['entry_suburb'] = $suburb;
        if (ACCOUNT_STATE == 'true') {
          if ($zone_id > 0) {
            $sql_data_array['entry_zone_id'] = $zone_id;
            $sql_data_array['entry_state'] = '';
          } else {
            $sql_data_array['entry_zone_id'] = '0';
            $sql_data_array['entry_state'] = $state;
          }
        }

        if (!tep_session_is_registered('sendto')) tep_session_register('sendto');
        
        tep_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);

        $sendto = $entry_id;

        if (tep_session_is_registered('shipping')) tep_session_unregister('shipping');

        tep_redirect(tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
      }
// process the selected shipping destination
    } elseif (isset($HTTP_POST_VARS['address'])) {
      $reset_shipping = false;
      if (tep_session_is_registered('sendto')) {
        if ($sendto != $HTTP_POST_VARS['address']) {
          if (tep_session_is_registered('shipping')) {
            $reset_shipping = true;
          }
        }
      } else {
        tep_session_register('sendto');
      }

      $sendto = $HTTP_POST_VARS['address'];

      $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . $customer_id . "' and address_book_id = '" . $sendto . "'");
      $check_address = tep_db_fetch_array($check_address_query);

      if ($check_address['total'] == '1') {
        if ($reset_shipping == true) tep_session_unregister('shipping');
        tep_redirect(tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
      } else {
        tep_session_unregister('sendto');
      }
    } else {
      if (!tep_session_is_registered('sendto')) tep_session_register('sendto');
      $sendto = $customer_default_address_id;

      tep_redirect(tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
    }
  }

// if no shipping destination address was selected, use their own address as default
  if (!tep_session_is_registered('sendto')) {
    $sendto = $customer_default_address_id;
  }

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_SHIPPING_ADDRESS_SHORT);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS_SHORT, '', 'SSL'));
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>">
<link rel="stylesheet" type="text/css" href="general.css">
<link rel="stylesheet" type="text/css" href="<?php echo substr(FILENAME_CHECKOUT_SHIPPING_ADDRESS_SHORT, 0, strrpos(FILENAME_CHECKOUT_SHIPPING_ADDRESS_SHORT, '.'));?>.css">
<script language="javascript"><!--
var selected;

function selectRowEffect(object, buttonSelect) {
  if (!selected) {
    if (document.getElementById) {
      selected = document.getElementById('defaultSelected');
    } else {
      selected = document.all['defaultSelected'];
    }
  }

  if (selected) selected.className = 'checkoutModuleRow';
  object.className = 'checkoutModuleRowSelected';
  selected = object;

// one button is not an array
  if (document.checkout_address.address[0]) {
    document.checkout_address.address[buttonSelect].checked=true;
  } else {
    document.checkout_address.address.checked=true;
  }
}

function rowOverEffect(object) {
  if (object.className == 'checkoutModuleRow') object.className = 'checkoutModuleRowOver';
}

function rowOutEffect(object) {
  if (object.className == 'checkoutModuleRowOver') object.className = 'checkoutModuleRow';
}

function check_form() {
  var error = 0;
  var error_message = "<?php echo JS_ERROR; ?>";

  var firstname = document.checkout_address.firstname.value;
  var lastname = document.checkout_address.lastname.value;
  var street_address = document.checkout_address.street_address.value;
  var postcode = document.checkout_address.postcode.value;
  var city = document.checkout_address.city.value;
<?php // 2003-06-06 add_telephone ?>
  var telephone = document.checkout_address.telephone.value;

  if (firstname == '' && lastname == '' && street_address == '') {
    return true;
  }

<?php
  if (ACCOUNT_GENDER == 'true') {
?>
  if (document.checkout_address.elements['gender'].type != "hidden") {
    if (document.checkout_address.gender[0].checked || document.checkout_address.gender[1].checked) {
    } else {
      error_message = error_message + "<?php echo JS_GENDER; ?>";
      error = 1;
    }
  }
<?php
  }
?>
  if (firstname == "" || firstname.length < <?php echo ENTRY_FIRST_NAME_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_FIRST_NAME; ?>";
    error = 1;
  }

  if (lastname == "" || lastname.length < <?php echo ENTRY_LAST_NAME_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_LAST_NAME; ?>";
    error = 1;
  }

  if (street_address == "" || street_address.length < <?php echo ENTRY_STREET_ADDRESS_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_ADDRESS; ?>";
    error = 1;
  }

  if (postcode == "" || postcode.length < <?php echo ENTRY_POSTCODE_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_POST_CODE; ?>";
    error = 1;
  }

  if (city == "" || city.length < <?php echo ENTRY_CITY_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_CITY; ?>";
    error = 1;
  }
<?php
  if (ACCOUNT_STATE == 'true') {
?>
  if (document.checkout_address.state.value == "" || document.checkout_address.state.length < <?php echo ENTRY_STATE_MIN_LENGTH; ?> ) {
     error_message = error_message + "<?php echo JS_STATE; ?>";
     error = 1;
  }
<?php
  }
?>

  if (document.checkout_address.country.value == 0) {
    error_message = error_message + "<?php echo JS_COUNTRY; ?>";
    error = 1;
  }

<?php // 2003-06-06 add_telephone ?>
  if (telephone == '' || telephone.length < <?php echo ENTRY_TELEPHONE_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_TELEPHONE; ?>";
    error = 1;
  }

  if (error == 1) {
    alert(error_message);
    return false;
  } else {
    return true;
  }
}
//--></script>
</head>
<body>
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table id="contents">
  <tr>
<!-- left_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- left_navigation_eof //-->
<!-- body_text //-->
    <td id="mainContents"><?php echo tep_draw_form('checkout_address', tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS_SHORT, '', 'SSL'), 'post', 'onSubmit="return check_form();"'); ?>
      <h1 class="pageHeading"><?php echo HEADING_TITLE; ?></h1>
<?php
  if ($process == true) {
?>
      <div class="checkoutErrorHeader"><?php echo TABLE_HEADING_NEW_SHIPPING_ADDRESS_PROBLEM; ?></div>
      <div class="checkoutErrorContents">
        <div class="checkoutErrorMessage"><?php echo TEXT_NEW_SHIPPING_ADDRESS_PROBLEM; ?></div>
      </div>
<?php
  }

  if ($process == false) {
?>
      <div class="checkoutAddressHeader"><?php echo TABLE_HEADING_SHIPPING_ADDRESS; ?></div>
      <div class="checkoutAddressConfirmation">
        <div class="checkoutChooseDestination"><?php echo TEXT_SELECTED_SHIPPING_DESTINATION; ?></div>
        <div class="checkoutAddressLabel"><?php echo tep_address_label($customer_id, $sendto, true, ' ', '<br>'); ?></div>
      </div>
<?php
    $addresses_count_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . $customer_id . "' and address_book_id != '" . $sendto . "'");
    $addresses_count = tep_db_fetch_array($addresses_count_query);

    if ($addresses_count['total'] > 0) {
?>
      <div class="checkoutChooseModuleHeader"><?php echo TABLE_HEADING_ADDRESS_BOOK_ENTRIES; ?></div>
      <table class="checkoutModuleTable">
      <thead>
        <tr>
          <th colspan="2"><?php echo TEXT_SELECT_OTHER_SHIPPING_DESTINATION; ?></th>
        </tr>
      </thead>
      <tbody>
<?php
      $radio_buttons = 0;

// 2003-06-06 add_telephone
      $addresses_query = tep_db_query("select address_book_id, entry_firstname as firstname, entry_lastname as lastname, entry_company as company, entry_street_address as street_address, entry_suburb as suburb, entry_city as city, entry_postcode as postcode, entry_state as state, entry_zone_id as zone_id, entry_country_id as country_id, entry_telephone as telephone from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . $customer_id . "'");
      while ($addresses = tep_db_fetch_array($addresses_query)) {
        $format_id = tep_get_address_format_id($addresses['country_id']);
       if ($addresses['address_book_id'] == $sendto) {
          echo '        <tr id="defaultSelected" class="checkoutModuleRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
        } else {
          echo '        <tr class="checkoutModuleRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
        }
?>
          <td class="checkoutModuleTitle"><?php echo tep_output_string_protected(tep_get_fullname($addresses['firstname'],$addresses['lastname'])); ?></td>
          <td class="checkoutModuleSelect"><?php echo tep_draw_radio_field('address', $addresses['address_book_id'], ($addresses['address_book_id'] == $sendto)); ?></td>
        </tr>
        <tr>
           <td class="checkoutModuleMethod"><?php echo tep_address_format($format_id, $addresses, true, ' ', ', '); ?></td>
          <td class="checkoutModuleSelect"></td>
        </tr>
<?php
        $radio_buttons++;
      }
?>
      </tbody>
      </table>
<?php
    }
  }
  if ($addresses_count['total'] < MAX_ADDRESS_BOOK_ENTRIES) {
?>
      <div class="checkoutNewAddressHeader"><?php echo TABLE_HEADING_NEW_SHIPPING_ADDRESS; ?></div>
      <div class="checkoutNewAddress">
        <div class="checkoutNewAddressText"><?php echo TEXT_CREATE_NEW_SHIPPING_ADDRESS; ?></div>
<?php require(DIR_WS_MODULES . 'checkout_new_address.php'); ?>
      </div>
<?php
  }

  if ($process == true) {
?>
      <table>
        <tr class="buttonLine">
          <td class="buttonLeft"><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS_SHORT, '', 'SSL') . '">' . tep_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>'; ?></td>
          <td class="buttonRight"><?php echo tep_draw_hidden_field('action', 'submit') . tep_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE); ?></td>
        </tr>
      </table>
<?php
  } else {
?>
      <table>
        <tr class="buttonLine">
          <td class="buttonRight"><?php echo tep_draw_hidden_field('action', 'submit') . tep_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE); ?></td>
        </tr>
      </table>
<?php
  }
?>
    </form></td>
<!-- body_text_eof //-->
<!-- right_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- right_navigation_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
