<?php
/*
  $Id: order_details.php,v 1.1.1.1 2003/02/20 01:03:54 ptosh Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/
?>
<!-- order_details -->
<?php
  echo '<table id="orderDetails">' . "\n";
  echo '<thead>' . "\n";
  echo '  <tr>' . "\n";

  if (strstr($PHP_SELF, FILENAME_SHOPPING_CART)) {
    echo '    <th class="orderDetailRemoveCol">' . TABLE_HEADING_REMOVE . '</th>' . "\n";
  }

  echo '    <th class="orderDetailQuantityCol">' . TABLE_HEADING_QUANTITY . '</th>' . "\n";

  if ((KN_CFG_PRODUCT_LIST_MODEL > 0) && strstr($PHP_SELF, FILENAME_SHOPPING_CART)) {
    echo '    <th class="orderDetailModelCol">' . TABLE_HEADING_MODEL . '</th>' . "\n";
  }

  echo '    <th class="orderDetailProductCol">' . TABLE_HEADING_PRODUCTS . '</th>' . "\n";

  if (!strstr($PHP_SELF, FILENAME_SHOPPING_CART)) {
    echo '    <th class="orderDetailTaxCol">' . TABLE_HEADING_TAX . '</th>' . "\n";
  }

  echo '    <th class="orderDetailPriceCol">' . TABLE_HEADING_TOTAL . '</th>' . "\n";
  echo '  </tr>' . "\n";
  echo '</thead>' . "\n";
  echo '<tbody>' . "\n";

  for ($i=0, $n=sizeof($products); $i<$n; $i++) {
    echo '  <tr>' . "\n";

// Delete box only for shopping cart
    if (strstr($PHP_SELF, FILENAME_SHOPPING_CART)) {
      echo '    <td class="orderDetailRemoveCol">' . tep_draw_checkbox_field('cart_delete[]', $products[$i]['id']) . '</td>' . "\n";
    }

// Quantity box or information as an input box or text
    if (strstr($PHP_SELF, FILENAME_SHOPPING_CART)) {
      echo '    <td class="orderDetailQuantityCol">' . tep_draw_input_field('cart_quantity[]', $products[$i]['quantity'], 'size="4"') . tep_draw_hidden_field('products_id[]', $products[$i]['id']) . '</td>' . "\n";
    } else {
      echo '    <td class="orderDetailQuantityCol">' . $products[$i]['quantity'] . '</td>' . "\n";
    }

// Model
    if ((KN_CFG_PRODUCT_LIST_MODEL > 0) && strstr($PHP_SELF, FILENAME_SHOPPING_CART)) {
      echo '    <td class="orderDetailModelCol"><a href="' . tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $products[$i]['id']) . '">' . $products[$i]['model'] . '</a></td>' . "\n";
    }
  
// Product name, with or without link
    if (strstr($PHP_SELF, FILENAME_SHOPPING_CART)) {
      echo '    <td class="orderDetailProductCol"><a href="' . tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $products[$i]['id']) . '"><span class="pName">' . $products[$i]['name'] . '</span></a>';
    } else {
      echo '    <td class="orderDetailProductCol"><span class="pName">' . $products[$i]['name'] . '</span>';
    }

// Display marker if stock quantity insufficient
    if (!strstr($PHP_SELF, FILENAME_ACCOUNT_HISTORY_INFO)) {
      if (STOCK_CHECK == 'true') {
        echo $stock_check = tep_check_stock($products[$i]['id'], $products[$i]['quantity']);
        if ($stock_check) $any_out_of_stock = 1;
      }
    }

// Product options names
    $attributes_exist = ((isset($products[$i]['attributes'])) ? 1 : 0);

    if ($attributes_exist == 1) {
      reset($products[$i]['attributes']);
      while (list($option, $value) = each($products[$i]['attributes'])) {
        echo '<br><span class="productOptions"> - ' . $products[$i][$option]['products_options_name'] . ' ' . $products[$i][$option]['products_options_values_name'] . '</span>';
      }
    }

    echo '</td>' . "\n";

// Tax (not in shopping cart, tax rate may be unknown)
    if (!strstr($PHP_SELF, FILENAME_SHOPPING_CART)) {
      echo '    <td class="orderDetailTaxCol">' . number_format($products[$i]['tax'], TAX_DECIMAL_PLACES) . '%</td>' . "\n";
    }

// Product price  
    if (!strstr($PHP_SELF, FILENAME_ACCOUNT_HISTORY_INFO)) {
      echo '    <td class="orderDetailPriceCol">' . $currencies->display_price($products[$i]['price'], tep_get_tax_rate($products[$i]['tax_class_id']), $products[$i]['quantity']);
    } else {
      echo '    <td class="orderDetailPriceCol">' . $currencies->display_price($products[$i]['price'], $products[$i]['tax'], $products[$i]['quantity']);
    }

// Product options prices
    if ($attributes_exist == 1) {
      reset($products[$i]['attributes']);
      while (list($option, $value) = each($products[$i]['attributes'])) {
        if ($products[$i][$option]['options_values_price'] != 0) {
          if (!strstr($PHP_SELF, FILENAME_ACCOUNT_HISTORY_INFO)) {
            echo '<br><span class="productOptions">' . $products[$i][$option]['price_prefix'] . $currencies->display_price($products[$i][$option]['options_values_price'], tep_get_tax_rate($products[$i]['tax_class_id']), $products[$i]['quantity']) . '</span>';
          } else {
            echo '<br><span class="productOptions">' . $products[$i][$option]['price_prefix'] . $currencies->display_price($products[$i][$option]['options_values_price'], $products[$i]['tax'], $products[$i]['quantity']) . '</span>';
          }
        } else {
// Keep price aligned with corresponding option
          echo '<br><span class="productOptions">&nbsp;</span>';
        }
      }
    }

    echo '</td>' . "\n" .
         '  </tr>' . "\n";
  }
  echo '</tbody>' . "\n";
  echo '</table>' . "\n";
?>
<!-- order_details_eof -->
