<?php
/*
  $Id: checkout_shipping.php,v 1.2 2005/08/19 09:48:12 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');
  require('includes/classes/http_client.php');
  
// ʰǤѤ
  if (KN_CFG_SHORT_CHECKOUT == 'true') {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
  }

// if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

// if no shipping destination address was selected, use the customers own address as default
  if (!tep_session_is_registered('sendto')) {
    tep_session_register('sendto');
    $sendto = $customer_default_address_id;
  } else {
// verify the selected shipping address
    $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . $customer_id . "' and address_book_id = '" . $sendto . "'");
    $check_address = tep_db_fetch_array($check_address_query);

    if ($check_address['total'] != '1') {
      $sendto = $customer_default_address_id;
      if (tep_session_is_registered('shipping')) tep_session_unregister('shipping');
    }
  }

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

// register a random ID in the session to check throughout the checkout procedure
// against alterations in the shopping cart contents
  if (!tep_session_is_registered('cartID')) tep_session_register('cartID');
  $cartID = $cart->cartID;

// if the order contains only virtual products, forward the customer to the billing page as
// a shipping address is not needed
  if ($order->content_type == 'virtual') {
    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');
    $shipping = false;
    $sendto = false;
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
  }

  $total_weight = $cart->show_weight();
  $total_count = $cart->count_contents();

// load all enabled shipping modules
// koshoten.netѤ⥸塼Ȥɤ
  if (KN_CFG_USE_KN_MODULES == 'true') {
    require(DIR_WS_CLASSES . 'kn_shipping.php');
  } else {
    require(DIR_WS_CLASSES . 'shipping.php');
  }
  $shipping_modules = new shipping;

  if ( defined('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING') && (MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING == 'true') ) {
    switch (MODULE_ORDER_TOTAL_SHIPPING_DESTINATION) {
      case 'national':
        if ($order->delivery['country_id'] == STORE_COUNTRY) $pass = true; break;
      case 'international':
        if ($order->delivery['country_id'] != STORE_COUNTRY) $pass = true; break;
      case 'both':
        $pass = true; break;
      default:
        $pass = false; break;
    }

    $free_shipping = false;
    if ( ($pass == true) && ($order->info['subtotal'] >= MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER) ) {
      $free_shipping = true;

      include(DIR_WS_LANGUAGES . $language . '/modules/order_total/ot_shipping.php');
    }
  } else {
    $free_shipping = false;
  }

// process the selected shipping method
  if ( isset($HTTP_POST_VARS['action']) && ($HTTP_POST_VARS['action'] == 'process') ) {
    if (!tep_session_is_registered('comments')) tep_session_register('comments');
    if (tep_not_null($HTTP_POST_VARS['comments_added'])) {
      $comments = tep_db_prepare_input($HTTP_POST_VARS['comments']);
    }

    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');

    if ( (tep_count_modules(KN_CFG_MODULE_SHIPPING_INSTALLED) > 0) || ($free_shipping == true) ) {
      if ( (isset($HTTP_POST_VARS['shipping'])) && (strpos($HTTP_POST_VARS['shipping'], '_')) ) {
        $shipping = $HTTP_POST_VARS['shipping'];

        list($module, $method) = explode('_', $shipping);
        if ( is_object($$module) || ($shipping == 'free_free') ) {
          if ($shipping == 'free_free') {
            $quote[0]['methods'][0]['title'] = FREE_SHIPPING_TITLE;
            $quote[0]['methods'][0]['cost'] = '0';
          } else {
            $quote = $shipping_modules->quote($method, $module);
          }
          if (isset($quote['error'])) {
            tep_session_unregister('shipping');
          } else {
            if ( (isset($quote[0]['methods'][0]['title'])) && (isset($quote[0]['methods'][0]['cost'])) ) {
              $shipping = array('id' => $shipping,
                                'title' => (($free_shipping == true) ?  $quote[0]['methods'][0]['title'] : $quote[0]['module'] . ' (' . $quote[0]['methods'][0]['title'] . ')'),
                                'cost' => $quote[0]['methods'][0]['cost'],
                                'timespec' => $quote[0]['methods'][0]['timespec']  // add for Japanese update
                          );

              tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
            }
          }
        } else {
          tep_session_unregister('shipping');
        }
      }
    } else {
      $shipping = false;
                
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
    }    
  }

// get all available shipping quotes
  $quotes = $shipping_modules->quote();

// if no shipping method has been selected, automatically select the cheapest method.
// if the modules status was changed when none were available, to save on implementing
// a javascript force-selection method, also automatically select the cheapest shipping
// method if more than one module is now enabled
  if ( !tep_session_is_registered('shipping') || ( tep_session_is_registered('shipping') && ($shipping == false) && (tep_count_modules(KN_CFG_MODULE_SHIPPING_INSTALLED) > 1) ) ) $shipping = $shipping_modules->cheapest();

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_SHIPPING);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>">
<link rel="stylesheet" type="text/css" href="general.css">
<link rel="stylesheet" type="text/css" href="<?php echo substr(FILENAME_CHECKOUT_SHIPPING, 0, strrpos(FILENAME_CHECKOUT_SHIPPING, '.'));?>.css">
<script language="javascript"><!--
var selected;

function selectRowEffect(object, buttonSelect) {
  if (!selected) {
    if (document.getElementById) {
      selected = document.getElementById('defaultSelected');
    } else {
      selected = document.all['defaultSelected'];
    }
  }

  if (selected) selected.className = 'checkoutModuleRow';
  object.className = 'checkoutModuleRowSelected';
  selected = object;

// one button is not an array
  if (document.checkout_address.shipping[0]) {
    document.checkout_address.shipping[buttonSelect].checked=true;
  } else {
    document.checkout_address.shipping.checked=true;
  }
}

function rowOverEffect(object) {
  if (object.className == 'checkoutModuleRow') object.className = 'checkoutModuleRowOver';
}

function rowOutEffect(object) {
  if (object.className == 'checkoutModuleRowOver') object.className = 'checkoutModuleRow';
}
//--></script>
</head>
<body>
<div id="bodyWrapper">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->

<!-- body //-->
<table id="contents">
  <tr>
<!-- left_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- left_navigation_eof //-->
<!-- body_text //-->
    <td id="mainContents"><?php echo tep_draw_form('checkout_address', tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL')) . tep_draw_hidden_field('action', 'process'); ?>
      <h1 class="pageHeading"><?php echo HEADING_TITLE; ?></h1>
      <div class="checkoutAddressHeader"><?php echo TABLE_HEADING_SHIPPING_ADDRESS; ?></div>
      <div class="checkoutAddressConfirmation">
        <div class="checkoutChooseDestination"><?php echo TEXT_CHOOSE_SHIPPING_DESTINATION; ?></div>
        <div class="checkoutAddressLabel"><?php echo tep_address_label($customer_id, $sendto, true, ' ', '<br>'); ?></div>
        <div class="checkoutChangeAddress"><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL') . '">' . tep_image_button('button_change_address.gif', IMAGE_BUTTON_CHANGE_ADDRESS) . '</a>'; ?></div>
      </div>
<?php
  if (tep_count_modules(KN_CFG_MODULE_SHIPPING_INSTALLED) > 0) {
?>
      <div class="checkoutChooseModuleHeader"><?php echo TABLE_HEADING_SHIPPING_METHOD; ?></div>
      <table class="checkoutModuleTable">
<?php
    if (sizeof($quotes) > 1) {
?>
      <thead>
        <tr>
          <th colspan="3"><?php echo TEXT_CHOOSE_SHIPPING_METHOD; ?></th>
        </tr>
      </thead>
<?php
    } elseif ($free_shipping == false) {
?>
      <thead>
        <tr>
          <th colspan="3"><?php echo TEXT_ENTER_SHIPPING_INFORMATION; ?></th>
        </tr>
      </thead>
<?php
    }

    if ($free_shipping == true) {
?>
      <tbody>
        <tr>
          <td class="checkoutModuleTitle" colspan="3"><?php echo FREE_SHIPPING_TITLE; ?></td>
        </tr>
        <tr id="defaultSelected" class="checkoutModuleRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, 0)">
          <td class="checkoutModuleMethod" colspan="3"><?php echo sprintf(FREE_SHIPPING_DESCRIPTION, $currencies->format(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER)) . tep_draw_hidden_field('shipping', 'free_free'); ?></td>
        </tr>
      </tbody>
<?php
    } else {
?>
      <tbody>
<?php
      $radio_buttons = 0;
      for ($i=0, $n=sizeof($quotes); $i<$n; $i++) {
?>
        <tr>
          <td class="checkoutModuleTitle" colspan="3"><?php echo $quotes[$i]['module']; ?>&nbsp;<?php echo $quotes[$i]['icon']; ?></td>
        </tr>
<?php
        if (isset($quotes[$i]['error'])) {
?>
        <tr>
          <td class="checkoutModuleError" colspan="3"><?php echo $quotes[$i]['error']; ?></td>
        </tr>
<?php
        } else {
          for ($j=0, $n2=sizeof($quotes[$i]['methods']); $j<$n2; $j++) {
// set the radio button to be checked if it is the method chosen
            $checked = (($quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id'] == $shipping['id']) ? true : false);

            if ( ($quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id'] == $shipping['id']) || (tep_count_modules(KN_CFG_MODULE_SHIPPING_INSTALLED) == (int)1) ) {
              echo '        <tr id="defaultSelected" class="checkoutModuleRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
            } else {
              echo '        <tr class="checkoutModuleRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
            }
?>
          <td class="checkoutModuleMethod"><?php echo $quotes[$i]['methods'][$j]['title'].'&nbsp;&nbsp;'.$quotes[$i]['methods'][$j]['option']; ?></td>
<?php
            if ( ($n > 1) || ($n2 > 1) ) {
?>
          <td class="checkoutModuleCost"><?php echo $currencies->format(tep_add_tax($quotes[$i]['methods'][$j]['cost'], $quotes[$i]['tax'])); ?></td>
          <td class="checkoutModuleSelect"><?php echo tep_draw_radio_field('shipping', $quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id'], $checked); ?></td>
<?php
            } else {
?>
          <td class="checkoutModuleCost" colspan="2"><?php echo $currencies->format(tep_add_tax($quotes[$i]['methods'][$j]['cost'], $quotes[$i]['tax'])) . tep_draw_hidden_field('shipping', $quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id']); ?></td>
<?php
            }
?>
        </tr>
<?php
            $radio_buttons++;
          }
        }
      }
?>
      </tbody>
<?php
    }
?>
      </table>
<?php
  }
?>
      <div class="checkoutCommentsHeader"><?php echo TABLE_HEADING_COMMENTS; ?></div>
      <div class="checkoutComments"><?php echo tep_draw_textarea_field('comments', 'soft', '60', '5') . tep_draw_hidden_field('comments_added', 'YES'); ?></div>
      <div class="checkoutContinueCheckout">
        <div class="checkoutContinueCheckoutTitle"><?php echo TITLE_CONTINUE_CHECKOUT_PROCEDURE; ?></div>
        <div class="checkoutContinueCheckoutText"><?php echo TEXT_CONTINUE_CHECKOUT_PROCEDURE; ?></div>
        <div class="checkoutContinueCheckoutButton"><?php echo tep_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE); ?></div>
      </div>
      <table class="checkoutBar">
        <tr class="checkoutBarImage">
          <td class="checkoutBarCurrent"><?php echo tep_image(DIR_WS_IMAGES . 'checkout_bullet.gif'); ?></td>
          <td class="checkoutBarTo"><?php echo tep_draw_separator('pixel_trans.gif', '100%', '1'); ?></td>
          <td class="checkoutBarTo"><?php echo tep_draw_separator('pixel_trans.gif', '100%', '1'); ?></td>
          <td class="checkoutBarTo"><?php echo tep_draw_separator('pixel_trans.gif', '100%', '1'); ?></td>
        </tr>
        <tr class="checkoutBarText">
          <td class="checkoutBarCurrent"><span class="checkoutBarDelivery"><?php echo CHECKOUT_BAR_DELIVERY; ?></span></td>
          <td class="checkoutBarTo"><span class="checkoutBarPayment"><?php echo CHECKOUT_BAR_PAYMENT; ?></span></td>
          <td class="checkoutBarTo"><span class="checkoutBarConfirmation"><?php echo CHECKOUT_BAR_CONFIRMATION; ?></span></td>
          <td class="checkoutBarTo"><span class="checkoutBarFinished"><?php echo CHECKOUT_BAR_FINISHED; ?></span></td>
        </tr>
      </table>
<?php
  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_SHIPPING'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  if (isset($shop_info['shop_info_value']) && tep_not_null($shop_info['shop_info_value'])) {
    echo '      <div class="checkoutOrderNotesHeader">' . HEADING_ORDER_NOTES . '</div>' . "\n";
    echo '      <div id="siShipping">';
    if ($shop_info['allow_tags']) {
      echo $shop_info['shop_info_value'];
    } else {
      echo nl2br(htmlspecialchars($shop_info['shop_info_value']));
    }
    echo '      </div>' . "\n";
  }
 ?>
    </form></td>
<!-- body_text_eof //-->
<!-- right_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- right_navigation_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</div>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
