# $Id: oscommerce.sql,v 1.8 2005/10/25 14:45:38 ryu Exp $
#
# osCommerce, Open Source E-Commerce Solutions
# http://www.oscommerce.com
#
# Copyright (c) 2003 osCommerce
#
# Released under the GNU General Public License
# 
# modified for Koshoten.net2
# http://www.koshoten.net/
#
# NOTE: * Please make any modifications to this file by hand!
#       * DO NOT use a mysqldump created file for new changes!
#       * Please take note of the table structure, and use this
#         structure as a standard for future modifications!
#       * Any tables you add here should be added in admin/backup.php
#         and in catalog/install/includes/functions/database.php
#       * To see the 'diff'erence between MySQL databases, use
#         the mysqldiff perl script located in the extras
#         directory of the 'catalog' module.
#       * Comments should be like these, full line comments.
#         (don`t use inline comments)

#-------------------------------------------------------------------
# ơ֥κ
#-------------------------------------------------------------------

# 2003-06-06 add_telephone
DROP TABLE IF EXISTS address_book;
CREATE TABLE address_book (
   customers_id int DEFAULT '0' NOT NULL,
   address_book_id int DEFAULT '1' NOT NULL,
   entry_gender char(1) NOT NULL,
   entry_company varchar(32),
   entry_firstname varchar(32) NOT NULL,
   entry_lastname varchar(32) NOT NULL,
   entry_street_address varchar(64) NOT NULL,
   entry_suburb varchar(32),
   entry_postcode varchar(10) NOT NULL,
   entry_city varchar(32) NOT NULL,
   entry_state varchar(32),
   entry_country_id int DEFAULT '0' NOT NULL,
   entry_telephone varchar(32) DEFAULT '',
   entry_zone_id int DEFAULT '0' NOT NULL,
   PRIMARY KEY (address_book_id, customers_id)
);

DROP TABLE IF EXISTS address_format;
CREATE TABLE address_format (
  address_format_id int NOT NULL auto_increment,
  address_format varchar(128) NOT NULL,
  address_summary varchar(48) NOT NULL,
  PRIMARY KEY (address_format_id)
);

DROP TABLE IF EXISTS banners;
CREATE TABLE banners (
  banners_id int NOT NULL auto_increment,
  banners_title varchar(64) NOT NULL,
  banners_url varchar(255) NOT NULL,
  banners_image varchar(64) NOT NULL,
  banners_group varchar(10) NOT NULL,
  banners_html_text text,
  expires_impressions int(7) DEFAULT '0',
  expires_date datetime DEFAULT NULL,
  date_scheduled datetime DEFAULT NULL,
  date_added datetime NOT NULL,
  date_status_change datetime DEFAULT NULL,
  status int(1) DEFAULT '1' NOT NULL,
  PRIMARY KEY  (banners_id)
);

DROP TABLE IF EXISTS banners_history;
CREATE TABLE banners_history (
  banners_history_id int NOT NULL auto_increment,
  banners_id int NOT NULL,
  banners_shown int(5) NOT NULL DEFAULT '0',
  banners_clicked int(5) NOT NULL DEFAULT '0',
  banners_history_date datetime NOT NULL,
  PRIMARY KEY  (banners_history_id)
);

DROP TABLE IF EXISTS categories;
CREATE TABLE categories (
   categories_id int NOT NULL auto_increment,
   categories_image varchar(64),
   parent_id int DEFAULT '0' NOT NULL,
   sort_order int(8),
   date_added datetime,
   last_modified datetime,
   PRIMARY KEY (categories_id),
   KEY idx_categories_parent_id (parent_id)
);

DROP TABLE IF EXISTS categories_description;
CREATE TABLE categories_description (
   categories_id int DEFAULT '0' NOT NULL,
   language_id int DEFAULT '1' NOT NULL,
   categories_name varchar(60) NOT NULL,
   categories_description text,
   categories_keywords text,
   PRIMARY KEY (categories_id, language_id),
   KEY idx_categories_name (categories_name)
);

DROP TABLE IF EXISTS configuration;
CREATE TABLE configuration (
  configuration_id int NOT NULL auto_increment,
  configuration_title varchar(64) NOT NULL,
  configuration_key varchar(64) NOT NULL,
  configuration_value varchar(255) NOT NULL,
  configuration_description varchar(255) NOT NULL,
  configuration_group_id int NOT NULL,
  sort_order int(5) NULL,
  last_modified datetime NULL,
  date_added datetime NOT NULL,
  use_function varchar(255) NULL,
  set_function varchar(255) NULL,
  PRIMARY KEY (configuration_id)
);

DROP TABLE IF EXISTS configuration_group;
CREATE TABLE configuration_group (
  configuration_group_id int NOT NULL auto_increment,
  configuration_group_title varchar(64) NOT NULL,
  configuration_group_description varchar(255) NOT NULL,
  sort_order int(5) NULL,
  visible int(1) DEFAULT '1' NULL,
  PRIMARY KEY (configuration_group_id)
);

DROP TABLE IF EXISTS counter;
CREATE TABLE counter (
  startdate char(8),
  counter int(12)
);

DROP TABLE IF EXISTS counter_history;
CREATE TABLE counter_history (
  month char(8),
  counter int(12)
);

DROP TABLE IF EXISTS countries;
CREATE TABLE countries (
  countries_id int NOT NULL auto_increment,
  countries_name varchar(64) NOT NULL,
  countries_iso_code_2 char(2) NOT NULL,
  countries_iso_code_3 char(3) NOT NULL,
  address_format_id int NOT NULL,
  PRIMARY KEY (countries_id),
  KEY IDX_COUNTRIES_NAME (countries_name)
);

DROP TABLE IF EXISTS currencies;
CREATE TABLE currencies (
  currencies_id int NOT NULL auto_increment,
  title varchar(32) NOT NULL,
  code char(3) NOT NULL,
  symbol_left varchar(12),
  symbol_right varchar(12),
  decimal_point char(1),
  thousands_point char(1),
  decimal_places char(1),
  value float(13,8),
  last_updated datetime NULL,
  PRIMARY KEY (currencies_id)
);

DROP TABLE IF EXISTS customers;
CREATE TABLE customers (
   customers_id int NOT NULL auto_increment,
   customers_gender char(1) NOT NULL,
   customers_firstname varchar(32) NOT NULL,
   customers_lastname varchar(32) NOT NULL,
   customers_dob datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   customers_email_address varchar(96) NOT NULL,
   customers_default_address_id int(5) DEFAULT '1' NOT NULL,
   customers_telephone varchar(32) NOT NULL,
   customers_fax varchar(32),
   customers_password varchar(40) NOT NULL,
   customers_newsletter char(1),
   PRIMARY KEY (customers_id)
);

DROP TABLE IF EXISTS customers_basket;
CREATE TABLE customers_basket (
  customers_basket_id int NOT NULL auto_increment,
  customers_id int NOT NULL,
  products_id tinytext NOT NULL,
  customers_basket_quantity int(2) NOT NULL,
  final_price decimal(15,4) NOT NULL,
  customers_basket_date_added char(8),
  PRIMARY KEY (customers_basket_id)
);

DROP TABLE IF EXISTS customers_basket_attributes;
CREATE TABLE customers_basket_attributes (
  customers_basket_attributes_id int NOT NULL auto_increment,
  customers_id int NOT NULL,
  products_id tinytext NOT NULL,
  products_options_id int NOT NULL,
  products_options_value_id int NOT NULL,
  PRIMARY KEY (customers_basket_attributes_id)
);

DROP TABLE IF EXISTS customers_info;
CREATE TABLE customers_info (
  customers_info_id int NOT NULL,
  customers_info_date_of_last_logon datetime,
  customers_info_number_of_logons int(5),
  customers_info_date_account_created datetime,
  customers_info_date_account_last_modified datetime,
  global_product_notifications int(1) DEFAULT '0',
  PRIMARY KEY (customers_info_id)
);

DROP TABLE IF EXISTS languages;
CREATE TABLE languages (
  languages_id int NOT NULL auto_increment,
  name varchar(32)  NOT NULL,
  code char(2) NOT NULL,
  image varchar(64),
  directory varchar(32),
  sort_order int(3),
  PRIMARY KEY (languages_id),
  KEY IDX_LANGUAGES_NAME (name)
);


DROP TABLE IF EXISTS manufacturers;
CREATE TABLE manufacturers (
  manufacturers_id int NOT NULL auto_increment,
  manufacturers_name varchar(32) NOT NULL,
  manufacturers_image varchar(64),
  date_added datetime NULL,
  last_modified datetime NULL,
  sort_order int(5),
  PRIMARY KEY (manufacturers_id),
  KEY IDX_MANUFACTURERS_NAME (manufacturers_name)
);

DROP TABLE IF EXISTS manufacturers_info;
CREATE TABLE manufacturers_info (
  manufacturers_id int NOT NULL,
  languages_id int NOT NULL,
  manufacturers_url varchar(255) NOT NULL,
  manufacturers_keywords text,
  url_clicked int(5) NOT NULL default '0',
  date_last_click datetime NULL,
  PRIMARY KEY (manufacturers_id, languages_id)
);

DROP TABLE IF EXISTS newsletters;
CREATE TABLE newsletters (
  newsletters_id int NOT NULL auto_increment,
  title varchar(255) NOT NULL,
  content text NOT NULL,
  module varchar(255) NOT NULL,
  date_added datetime NOT NULL,
  date_sent datetime,
  status int(1),
  locked int(1) DEFAULT '0',
  PRIMARY KEY (newsletters_id)
);

# 2003-06-06 add_telephone
DROP TABLE IF EXISTS orders;
CREATE TABLE orders (
  orders_id int NOT NULL auto_increment,
  customers_id int NOT NULL,
  customers_name varchar(64) NOT NULL,
  customers_company varchar(32),
  customers_street_address varchar(64) NOT NULL,
  customers_suburb varchar(32),
  customers_city varchar(32) NOT NULL,
  customers_postcode varchar(10) NOT NULL,
  customers_state varchar(32),
  customers_country varchar(32) NOT NULL,
  customers_telephone varchar(32) NOT NULL,
  customers_email_address varchar(96) NOT NULL,
  customers_address_format_id int(5) NOT NULL,
  delivery_name varchar(64) NOT NULL,
  delivery_company varchar(32),
  delivery_street_address varchar(64) NOT NULL,
  delivery_suburb varchar(32),
  delivery_city varchar(32) NOT NULL,
  delivery_postcode varchar(10) NOT NULL,
  delivery_state varchar(32),
  delivery_country varchar(32) NOT NULL,
  delivery_telephone varchar(32) DEFAULT '',
  delivery_address_format_id int(5) NOT NULL,
  billing_name varchar(64) NOT NULL,
  billing_company varchar(32),
  billing_street_address varchar(64) NOT NULL,
  billing_suburb varchar(32),
  billing_city varchar(32) NOT NULL,
  billing_postcode varchar(10) NOT NULL,
  billing_state varchar(32),
  billing_country varchar(32) NOT NULL,
  billing_telephone varchar(32) DEFAULT '',
  billing_address_format_id int(5) NOT NULL,
  payment_method varchar(32) NOT NULL,
  cc_type varchar(20),
  cc_owner varchar(64),
  cc_number varchar(32),
  cc_expires varchar(4),
  last_modified datetime,
  date_purchased datetime,
  orders_status int(5) NOT NULL,
  orders_date_finished datetime,
  currency char(3),
  currency_value decimal(14,6),
  PRIMARY KEY (orders_id)
);

DROP TABLE IF EXISTS orders_products;
CREATE TABLE orders_products (
  orders_products_id int NOT NULL auto_increment,
  orders_id int NOT NULL,
  products_id int NOT NULL,
  products_model varchar(12),
  products_name varchar(255) NOT NULL,
  products_subtitle varchar(255),
  products_series_title varchar(255),
  products_author varchar(255),
  products_description text,
  products_volume varchar(50),
  products_published varchar(100),
  products_publishers varchar(255),
  products_isbn varchar(50),
  manufacturers_id int(11),
  products_price decimal(15,4) NOT NULL,
  final_price decimal(15,4) NOT NULL,
  products_tax decimal(7,4) NOT NULL,
  products_quantity int(2) NOT NULL,
  PRIMARY KEY (orders_products_id)
);

DROP TABLE IF EXISTS orders_status;
CREATE TABLE orders_status (
   orders_status_id int DEFAULT '0' NOT NULL,
   language_id int DEFAULT '1' NOT NULL,
   orders_status_name varchar(32) NOT NULL,
   PRIMARY KEY (orders_status_id, language_id),
   KEY idx_orders_status_name (orders_status_name)
);

DROP TABLE IF EXISTS orders_status_history;
CREATE TABLE orders_status_history (
   orders_status_history_id int NOT NULL auto_increment,
   orders_id int NOT NULL,
   orders_status_id int(5) NOT NULL,
   date_added datetime NOT NULL,
   customer_notified int(1) DEFAULT '0',
   comments text,
   PRIMARY KEY (orders_status_history_id)
);

DROP TABLE IF EXISTS orders_products_attributes;
CREATE TABLE orders_products_attributes (
  orders_products_attributes_id int NOT NULL auto_increment,
  orders_id int NOT NULL,
  orders_products_id int NOT NULL,
  products_options varchar(32) NOT NULL,
  products_options_values varchar(32) NOT NULL,
  options_values_price decimal(15,4) NOT NULL,
  price_prefix char(1) NOT NULL,
  PRIMARY KEY (orders_products_attributes_id)
);

DROP TABLE IF EXISTS orders_products_download;
CREATE TABLE orders_products_download (
  orders_products_download_id int NOT NULL auto_increment,
  orders_id int NOT NULL default '0',
  orders_products_id int NOT NULL default '0',
  orders_products_filename varchar(255) NOT NULL default '',
  download_maxdays int(2) NOT NULL default '0',
  download_count int(2) NOT NULL default '0',
  PRIMARY KEY  (orders_products_download_id)
);

DROP TABLE IF EXISTS orders_total;
CREATE TABLE orders_total (
  orders_total_id int unsigned NOT NULL auto_increment,
  orders_id int NOT NULL,
  title varchar(255) NOT NULL,
  text varchar(255) NOT NULL,
  value decimal(15,4) NOT NULL,
  class varchar(32) NOT NULL,
  sort_order int NOT NULL,
  PRIMARY KEY (orders_total_id),
  KEY idx_orders_total_orders_id (orders_id)
);

DROP TABLE IF EXISTS products;
CREATE TABLE products (
  products_id int NOT NULL auto_increment,
  products_quantity int(4) NOT NULL,
  products_model int(12) default NULL,
  products_image varchar(64),
  products_price decimal(15,4) NOT NULL,
  products_date_added datetime NOT NULL,
  products_last_modified datetime,
  products_date_available datetime,
  products_weight decimal(5,2) NOT NULL,
  products_isbn varchar(50),
  products_status tinyint(1) NOT NULL,
  products_tax_class_id int NOT NULL,
  manufacturers_id int NULL,
  recommendation_order int(3) default NULL,
  sort_order int(12) default '0',
  products_ordered int NOT NULL default '0',
  PRIMARY KEY (products_id),
  KEY idx_products_date_added (products_date_added)
);

DROP TABLE IF EXISTS products_attributes;
CREATE TABLE products_attributes (
  products_attributes_id int NOT NULL auto_increment,
  products_id int NOT NULL,
  options_id int NOT NULL,
  options_values_id int NOT NULL,
  options_values_price decimal(15,4) NOT NULL,
  price_prefix char(1) NOT NULL,
  PRIMARY KEY (products_attributes_id)
);

DROP TABLE IF EXISTS products_attributes_download;
CREATE TABLE products_attributes_download (
  products_attributes_id int NOT NULL,
  products_attributes_filename varchar(255) NOT NULL default '',
  products_attributes_maxdays int(2) default '0',
  products_attributes_maxcount int(2) default '0',
  PRIMARY KEY  (products_attributes_id)
);

DROP TABLE IF EXISTS products_description;
CREATE TABLE products_description (
  products_id int NOT NULL auto_increment,
  language_id int NOT NULL default '1',
  products_name varchar(255) NOT NULL default '',
  products_subtitle varchar(255),
  products_series_title varchar(255),
  products_author varchar(255),
  products_description text,
  products_volume varchar(50),
  products_published varchar(100),
  products_publishers varchar(255),
  products_description2 text,
  products_keywords text,
  products_memo varchar(255),
  products_url varchar(255) default NULL,
  products_viewed int(5) default '0',
  PRIMARY KEY  (products_id,language_id),
  KEY products_name (products_name)
);

DROP TABLE IF EXISTS products_options;
CREATE TABLE products_options (
  products_options_id int NOT NULL default '0',
  language_id int NOT NULL default '1',
  products_options_name varchar(32) NOT NULL default '',
  PRIMARY KEY  (products_options_id,language_id)
);

DROP TABLE IF EXISTS products_options_values;
CREATE TABLE products_options_values (
  products_options_values_id int NOT NULL default '0',
  language_id int NOT NULL default '1',
  products_options_values_name varchar(64) NOT NULL default '',
  PRIMARY KEY  (products_options_values_id,language_id)
);

DROP TABLE IF EXISTS products_options_values_to_products_options;
CREATE TABLE products_options_values_to_products_options (
  products_options_values_to_products_options_id int NOT NULL auto_increment,
  products_options_id int NOT NULL,
  products_options_values_id int NOT NULL,
  PRIMARY KEY (products_options_values_to_products_options_id)
);

DROP TABLE IF EXISTS products_to_categories;
CREATE TABLE products_to_categories (
  products_id int NOT NULL,
  categories_id int NOT NULL,
  PRIMARY KEY (products_id,categories_id)
);

DROP TABLE IF EXISTS reviews;
CREATE TABLE reviews (
  reviews_id int NOT NULL auto_increment,
  products_id int NOT NULL,
  customers_id int,
  customers_name varchar(64) NOT NULL,
  reviews_rating int(1),
  date_added datetime,
  last_modified datetime,
  reviews_read int(5) NOT NULL default '0',
  PRIMARY KEY (reviews_id)
);

DROP TABLE IF EXISTS reviews_description;
CREATE TABLE reviews_description (
  reviews_id int NOT NULL,
  languages_id int NOT NULL,
  reviews_text text NOT NULL,
  PRIMARY KEY (reviews_id, languages_id)
);

DROP TABLE IF EXISTS sessions;
CREATE TABLE sessions (
  sesskey varchar(32) NOT NULL,
  expiry int(11) unsigned NOT NULL,
  value text NOT NULL,
  PRIMARY KEY (sesskey)
);

DROP TABLE IF EXISTS specials;
CREATE TABLE specials (
  specials_id int NOT NULL auto_increment,
  products_id int NOT NULL,
  specials_new_products_price decimal(15,4) NOT NULL,
  specials_date_added datetime,
  specials_last_modified datetime,
  expires_date datetime,
  date_status_change datetime,
  status int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (specials_id)
);

DROP TABLE IF EXISTS tax_class;
CREATE TABLE tax_class (
  tax_class_id int NOT NULL auto_increment,
  tax_class_title varchar(32) NOT NULL,
  tax_class_description varchar(255) NOT NULL,
  last_modified datetime NULL,
  date_added datetime NOT NULL,
  PRIMARY KEY (tax_class_id)
);

DROP TABLE IF EXISTS tax_rates;
CREATE TABLE tax_rates (
  tax_rates_id int NOT NULL auto_increment,
  tax_zone_id int NOT NULL,
  tax_class_id int NOT NULL,
  tax_priority int(5) DEFAULT 1,
  tax_rate decimal(7,4) NOT NULL,
  tax_description varchar(255) NOT NULL,
  last_modified datetime NULL,
  date_added datetime NOT NULL,
  PRIMARY KEY (tax_rates_id)
);

DROP TABLE IF EXISTS geo_zones;
CREATE TABLE geo_zones (
  geo_zone_id int NOT NULL auto_increment,
  geo_zone_name varchar(32) NOT NULL,
  geo_zone_description varchar(255) NOT NULL,
  last_modified datetime NULL,
  date_added datetime NOT NULL,
  PRIMARY KEY (geo_zone_id)
);

DROP TABLE IF EXISTS whos_online;
CREATE TABLE whos_online (
  customer_id int,
  full_name varchar(64) NOT NULL,
  session_id varchar(128) NOT NULL,
  ip_address varchar(15) NOT NULL,
  time_entry varchar(14) NOT NULL,
  time_last_click varchar(14) NOT NULL,
  last_page_url varchar(64) NOT NULL
);

DROP TABLE IF EXISTS zones;
CREATE TABLE zones (
  zone_id int NOT NULL auto_increment,
  zone_country_id int NOT NULL,
  zone_code varchar(32) NOT NULL,
  zone_name varchar(32) NOT NULL,
  PRIMARY KEY (zone_id)
);

DROP TABLE IF EXISTS zones_to_geo_zones;
CREATE TABLE zones_to_geo_zones (
   association_id int NOT NULL auto_increment,
   zone_country_id int NOT NULL,
   zone_id int NULL,
   geo_zone_id int NULL,
   last_modified datetime NULL,
   date_added datetime NOT NULL,
   PRIMARY KEY (association_id)
);

DROP TABLE IF EXISTS shop_info;
CREATE TABLE shop_info (
   shop_info_id int NOT NULL auto_increment,
   shop_info_title varchar(255) NOT NULL,
   shop_info_key varchar(64) NOT NULL,
   shop_info_value text NULL,
   shop_info_value2 text NULL,
   shop_info_note text NULL,
   allow_edit_title int(1) NOT NULL default '0',
   allow_edit_value2 int(1) NOT NULL default '0',
   allow_tags int(1) NOT NULL default '0',
   shop_info_type int(1) NOT NULL default '0',
   last_modified datetime NULL,
   date_added datetime NOT NULL,
   PRIMARY KEY (shop_info_id)
);

DROP TABLE IF EXISTS geta_themes;
CREATE TABLE geta_themes (
   geta_themes_id int NOT NULL auto_increment,
   geta_themes_title varchar(64) NOT NULL,
   geta_themes_description text NULL,
   geta_themes_image1 varchar(64) NULL,
   geta_themes_image2 varchar(64) NULL,
   geta_themes_image3 varchar(64) NULL,
   geta_themes_image4 varchar(64) NULL,
   geta_themes_image5 varchar(64) NULL,
   geta_themes_keywords text NULL,
   last_modified datetime NULL,
   date_added datetime NOT NULL,
   PRIMARY KEY (geta_themes_id)
);

#-------------------------------------------------------------------
# ǡϿ
#-------------------------------------------------------------------

# 1 - Default, 2 - USA, 3 - Spain, 4 - Singapore, 5 - Germany
INSERT INTO address_format VALUES (1, '$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country','$city / $country');
INSERT INTO address_format VALUES (2, '$firstname $lastname$cr$streets$cr$city, $state    $postcode$cr$country','$city, $state / $country');
INSERT INTO address_format VALUES (3, '$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country','$state / $country');
INSERT INTO address_format VALUES (4, '$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country', '$postcode / $country');
INSERT INTO address_format VALUES (5, '$firstname $lastname$cr$streets$cr$postcode $city$cr$country','$city / $country');
INSERT INTO address_format VALUES (6, '$lastname $firstname$cr$postcode$cr$statename$city$cr$streets$cr$country$cr$telephone', '$statename $city');
INSERT INTO address_format VALUES (7, '$lastname $firstname$cr$postcode$cr$statename$city$cr$streets$cr$telephone', '$statename $city');


INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̾', 'STORE_NAME', 'Koshoten.net Web Store', '֥饦ξɽ륿ȥ䡢᡼ʸΥå̾˻Ѥޤ', '1', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('å̾', 'STORE_OWNER', 'Koshoten.net', '쥯ȥ᡼᡼ޥʳΥ᡼ʼϢ᡼ˤκпͤȤƻѤޤ', '1', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('E-Mail ɥ쥹', 'STORE_OWNER_EMAIL_ADDRESS', 'root@localhost', 'åפǻѤ E-Mail ɥ쥹 ꤷޤ', '1', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('E-Mail κп', 'EMAIL_FROM', 'Koshoten.net <root@localhost>', 'ܵҤ E-Mail κп̾ȥɥ쥹ꤷޤեޥå: ̾ &lt;email@address&gt;', '1', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('̾', 'STORE_COUNTRY', '107', 'åפν߹̾ꤷޤ', '1', '6', 'tep_get_country_name', 'tep_cfg_pull_down_country_list(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('åפνϰ', 'STORE_ZONE', '13', 'åפνϰ (̾) ꤷޤ', '1', '7', 'tep_get_zone_name', 'tep_cfg_pull_down_zone_list(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ͽ꾦ʤΥȽ', 'EXPECTED_PRODUCTS_SORT', 'desc', 'ͽ꾦ʤ¤ӽꤷޤ asc () ޤ desc (߽)', '1', '8', 'tep_cfg_select_option(array(\'asc\', \'desc\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ͽ꾦ʤΥȡե', 'EXPECTED_PRODUCTS_FIELD', 'date_expected', 'ͽ꾦ʤ¤ӽ˻Ѥ륫ꤷޤ products_name (̾) ޤ date_expected (ս)', '1', '9', 'tep_cfg_select_option(array(\'products_name\', \'date_expected\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ǥեȸ/̲ߤѹ', 'USE_DEFAULT_LANGUAGE_CURRENCY', 'false', '̲ߤѹϢư뤫ɤꤷޤtrue (Ϣư) false (Ϣư)', '1', '10', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ʸΥ᡼', 'SEND_EXTRA_ORDER_EMAILS_TO', '', 'ʸΥ᡼E-Mailɥ쥹ꤷޤ եޥå: ̾1 &lt;email@address1&gt;, ̾2 &lt;email@address2&gt;', '1', '11', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('󥸥кURL(ȯ)', 'SEARCH_ENGINE_FRIENDLY_URLS', 'false', 'Ȥ󥯤ǥ󥸥кURLλѡԻѤꤷޤ true () false (Ի)', '1', '12', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ʤɲø˥Ȥɽ', 'DISPLAY_CART', 'true', 'ʤܥ򲡤ľ˥ȤƤɽɽꤷޤ true (ɽ) false (ɽ)', '1', '14', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ȤˡͧãΤ餻פ', 'ALLOW_GUEST_TO_TELL_A_FRIEND', 'false', 'ʤͧãΤ餻פȤ򥲥Ȥ˵ġĤꤷޤtrue () false()', '1', '15', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ǥեȤθ黻', 'ADVANCED_SEARCH_DEFAULT_OPERATOR', 'and', 'ǥեȤθ黻Ҥꤷޤ', '1', '17', 'tep_cfg_select_option(array(\'and\', \'or\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('å׽', 'STORE_NAME_ADDRESS', 'å̾\n꣱\nꣲ\nֹ', 'ΰ˻Ѥޤ', '1', '18', 'tep_cfg_textarea(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ƥ꡼ξʿɽ', 'SHOW_COUNTS', 'false', 'ƥ꡼ξʿ򲼰̥ƥ꡼ޤƥɽ롦ʤꤷޤtrue () false (ʤ)', '1', '19', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ǳۤξ', 'TAX_DECIMAL_PLACES', '0', 'ǳۤξʲηꤷޤ', '1', '20', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ǹߤζۤɽ', 'DISPLAY_PRICE_WITH_TAX', 'true', 'true = ǹߤζۤɽޤ false = Ǹǳۤɽޤ', '1', '21', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ǳۤü', 'TAX_ROUND_OPTION', 'drop', 'ǳۤüˡꤷޤ. drop=ڤΤ, round=ͼθ, raise=ڤ夲', '1', '21', 'tep_cfg_select_option(array(\'drop\', \'round\', \'raise\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̾ʺǾ͡', 'ENTRY_FIRST_NAME_MIN_LENGTH', '2', '̾ʸκǾͤꤷޤ', '2', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ʺǾ͡', 'ENTRY_LAST_NAME_MIN_LENGTH', '2', 'ʸκǾͤꤷޤ', '2', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ǯʺǾ͡', 'ENTRY_DOB_MIN_LENGTH', '10', 'ǯʸκǾͤꤷޤ', '2', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('E-Mail ɥ쥹ʺǾ͡', 'ENTRY_EMAIL_ADDRESS_MIN_LENGTH', '6', 'E-Mail ɥ쥹ʸκǾͤꤷޤ', '2', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('1ʺǾ͡', 'ENTRY_STREET_ADDRESS_MIN_LENGTH', '5', '1ʸκǾͤꤷޤ', '2', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ҡʺǾ͡', 'ENTRY_COMPANY_LENGTH', '2', '̾ʸκǾͤꤷޤ', '2', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('͹ֹʺǾ͡', 'ENTRY_POSTCODE_MIN_LENGTH', '4', '͹ֹʸκǾͤꤷޤ', '2', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ԶĮ¼ʺǾ͡', 'ENTRY_CITY_MIN_LENGTH', '3', 'ԶĮ¼ʸκǾͤꤷޤ', '2', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ƻܸʺǾ͡', 'ENTRY_STATE_MIN_LENGTH', '2', 'ƻܸʸκǾͤꤷޤ', '2', '9', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ֹʺǾ͡', 'ENTRY_TELEPHONE_MIN_LENGTH', '3', 'ֹʸκǾͤꤷޤ', '2', '10', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ѥɡʺǾ͡', 'ENTRY_PASSWORD_MIN_LENGTH', '5', 'ѥɤʸκǾͤꤷޤ', '2', '11', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('쥸åȥɽͭ̾ʺǾ͡', 'CC_OWNER_MIN_LENGTH', '3', '쥸åȥɽͭ̾ʸκǾͤꤷޤ', '2', '12', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('쥸åȥֹʺǾ͡', 'CC_NUMBER_MIN_LENGTH', '10', '쥸åȥֹʸκǾͤꤷޤ', '2', '13', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ӥ塼ʸϡʺǾ͡', 'REVIEW_TEXT_MIN_LENGTH', '10', 'ӥ塼ʸϤʸκǾͤꤷޤ', '2', '14', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('٥ȥ顼ʺǾ͡', 'MIN_DISPLAY_BESTSELLERS', '1', '٥ȥ顼Ȥɽ뾦ʿκǾͤꤷޤ', '2', '15', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ƱʺǾ͡', 'MIN_DISPLAY_ALSO_PURCHASED', '1', 'ξʤäͤ...ɽ뾦ʿκǾͤꤷޤ', '2', '16', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɥ쥹ĢκϿ', 'MAX_ADDRESS_BOOK_ENTRIES', '5', 'ܵҤ륢ɥ쥹ĢϿκͤꤷޤ', '3', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɽ', 'MAX_DISPLAY_SEARCH_RESULTS', '20', 'ɽ뾦ʿκͤꤷޤ', '3', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ڡ󥯿', 'MAX_DISPLAY_PAGE_LINKS', '3', 'ʥꥹȤΰɽǥڡβʤɤɽڡֹֹκͤꤷޤ', '3', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('òɽ', 'MAX_DISPLAY_SPECIAL_PRODUCTS', '9', 'òʤȤɽ뾦ʿκͤꤷޤ', '3', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ѡۿ徦ɽ', 'MAX_DISPLAY_NEW_PRODUCTS', '9', 'ƥ꡼ɽ뿷徦ʿκͤꤷޤ', '3', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ͽ꾦ɽ', 'MAX_DISPLAY_UPCOMING_PRODUCTS', '10', 'ɽͽ꾦ʿκͤꤷޤ', '3', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɲùܥꥹɽ', 'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', '0', 'ɲùܥܥåǻȤͤꤷޤ. ɽͤĶȡꥹɽɥåץ󡦥ꥹɽڤؤޤ', '3', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɲù򥵥', 'MAX_MANUFACTURERS_LIST', '1', 'ɲùܥܥåǻȤͤꤷޤ ͤ1ʤɥåץ󡦥ꥹȤɽޤ1ʳξϻꤵ줿ԿΥꥹȥܥåɽޤ', '3', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɲù̾Ĺ', 'MAX_DISPLAY_MANUFACTURER_NAME_LEN', '15', 'ɲùܥܥåǻ/ɽɲù̾ʸκͤꤷޤ', '3', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɾɽ', 'MAX_DISPLAY_NEW_REVIEWS', '6', 'ɾɽɾκͤꤷޤ', '3', '9', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɾΥ', 'MAX_RANDOM_SELECT_REVIEWS', '10', '˽ɾɽ뤿򤵤ɾꤷޤ', '3', '10', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('徦ʤΥ', 'MAX_RANDOM_SELECT_NEW', '10', '˿徦ʤɽ뤿򤵤뾦ʿꤷޤ', '3', '11', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('òʤΥ', 'MAX_RANDOM_SELECT_SPECIALS', '10', 'òʤɽ뤿򤵤뾦ʿꤷޤ', '3', '12', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ѡۣԤɽ륫ƥ꡼', 'MAX_DISPLAY_CATEGORIES_PER_ROW', '3', 'Ԥɽ륫ƥ꡼ꤷޤ', '3', '13', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('徦ʰɽ', 'MAX_DISPLAY_PRODUCTS_NEW', '10', '徦ʥڡɽ뾦ʿκͤꤷޤ', '3', '14', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('٥ȥ顼ʺ͡', 'MAX_DISPLAY_BESTSELLERS', '10', 'ɽ٥ȥ顼ʤκͤꤷޤ', '3', '15', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Ʊʺ͡', 'MAX_DISPLAY_ALSO_PURCHASED', '6', 'ξʤäͤ...ɽ뾦ʿκͤꤷޤ', '3', '16', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ʸBOXʺ͡', 'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', '6', 'ʸBOXɽ뾦ʤκꤷޤ', '3', '17', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ʸɽ', 'MAX_DISPLAY_ORDER_HISTORY', '6', 'ʸڡɽʸκꤷޤ', '3', '18', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('إåβ', 'HEADING_IMAGE_WIDTH', '100', 'ƥ꡼ʤɤΥإåβ(ԥ)ꤷޤ', '4', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('إåι⤵', 'HEADING_IMAGE_HEIGHT', '', 'ƥ꡼ʤɤΥإåι⤵(ԥ)ꤷޤ', '4', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̾ξʲβ', 'SMALL_IMAGE_WIDTH', '100', '̾ξʲβ(ԥ)ꤷޤ', '4', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̾ξʲι⤵', 'SMALL_IMAGE_HEIGHT', '', '̾ξʲι⤵(ԥ)ꤷޤ', '4', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ʳβ', 'SUBCATEGORY_IMAGE_WIDTH', '150', 'ʾܺٲ̤ɽ뾦ʲβ(ԥ)ꤷޤ', '4', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ʳι⤵', 'SUBCATEGORY_IMAGE_HEIGHT', '', 'ʾܺٲ̤ɽ뾦ʲι⤵(ԥ)ꤷޤ', '4', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('׻', 'CONFIG_CALCULATE_IMAGE_SIZE', 'true', 'ޤϹ⤵ˤ碌ƲưŪ˷׻ޤ', '4', '7', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ɬܤȤ', 'IMAGE_REQUIRED', 'false', 'ʤȤɽޤ', '4', '8', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('', 'ACCOUNT_GENDER', 'false', 'ܵҤΥȤ̤ɽɽꤷޤ', '5', '1', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ǯ', 'ACCOUNT_DOB', 'false', 'ܵҤΥȤǯɽɽꤷޤ', '5', '2', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('', 'ACCOUNT_COMPANY', 'true', 'ܵҤΥȤ˲Ҥɽɽꤷޤ', '5', '3', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('2', 'ACCOUNT_SUBURB', 'true', 'ܵҤΥȤ˽2ɽɽꤷޤ', '5', '4', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ƻܸ', 'ACCOUNT_STATE', 'true', 'ܵҤΥȤƻܸɽɽꤷޤ', '5', '5', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Installed Modules', 'MODULE_PAYMENT_INSTALLED', 'cc.php;cod.php', 'List of payment module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: cc.php;cod.php;paypal.php)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Installed Modules', 'MODULE_ORDER_TOTAL_INSTALLED', 'ot_subtotal.php;ot_shipping.php;ot_addition.php;ot_discount.php;ot_total.php', 'List of order_total module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_total.php)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Installed Modules', 'MODULE_SHIPPING_INSTALLED', 'flat.php', 'List of shipping module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ups.php;flat.php;item.php)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Enable Cash On Delivery Module', 'MODULE_PAYMENT_COD_STATUS', 'True', 'Do you want to accept Cash On Delevery payments?', '6', '1', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Payment Zone', 'MODULE_PAYMENT_COD_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Sort order of display.', 'MODULE_PAYMENT_COD_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) VALUES ('Set Order Status', 'MODULE_PAYMENT_COD_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Enable Credit Card Module', 'MODULE_PAYMENT_CC_STATUS', 'True', 'Do you want to accept credit card payments?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Split Credit Card E-Mail Address', 'MODULE_PAYMENT_CC_EMAIL', '', 'If an e-mail address is entered, the middle digits of the credit card number will be sent to the e-mail address (the outside digits are stored in the database with the middle digits censored)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Sort order of display.', 'MODULE_PAYMENT_CC_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '0' , now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Payment Zone', 'MODULE_PAYMENT_CC_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) VALUES ('Set Order Status', 'MODULE_PAYMENT_CC_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Enable Flat Shipping', 'MODULE_SHIPPING_FLAT_STATUS', 'True', 'Do you want to offer flat rate shipping?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Shipping Cost', 'MODULE_SHIPPING_FLAT_COST', '5.00', 'The shipping cost for all orders using this shipping method.', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Tax Class', 'MODULE_SHIPPING_FLAT_TAX_CLASS', '0', 'Use the following tax class on the shipping fee.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Shipping Zone', 'MODULE_SHIPPING_FLAT_ZONE', '0', 'If a zone is selected, only enable this shipping method for that zone.', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Sort Order', 'MODULE_SHIPPING_FLAT_SORT_ORDER', '0', 'Sort order of display.', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Default Currency', 'DEFAULT_CURRENCY', 'JPY', 'Default Currency', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Default Language', 'DEFAULT_LANGUAGE', 'ja', 'Default Language', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Default Order Status For New Orders', 'DEFAULT_ORDERS_STATUS_ID', '1', 'When a new order is created, this order status will be assigned to it.', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Shipping', 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true', 'Do you want to display the order shipping cost?', '6', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '2', 'Sort order of display.', '6', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Allow Free Shipping', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', 'Do you want to allow free shipping?', '6', '3', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, date_added) VALUES ('Free Shipping For Orders Over', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '50', 'Provide free shipping for orders over the set amount.', '6', '4', 'currencies->format', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Provide Free Shipping For Orders Made', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'Provide free shipping for orders sent to the set destination.', '6', '5', 'tep_cfg_select_option(array(\'national\', \'international\', \'both\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Sub-Total', 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', 'Do you want to display the order sub-total cost?', '6', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '1', 'Sort order of display.', '6', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Tax', 'MODULE_ORDER_TOTAL_TAX_STATUS', 'false', 'Do you want to display the order tax value?', '6', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '3', 'Sort order of display.', '6', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Total', 'MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true', 'Do you want to display the total order value?', '6', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '4', 'Sort order of display.', '6', '2', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̾', 'STORE_ORIGIN_COUNTRY', 'JP', 'ѤǻѤ륷åפ &quot; ISO 3166&quot; ̾ɤꤷޤ̾ɤ <A HREF="http://www.din.de/gremien/nas/nabd/iso3166ma/codlstp1/index.html" TARGET="_blank">ISO 3166 Maintenance Agency</A> 򻲾ȤƤ', '7', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ϰ襳', 'STORE_ORIGIN_ZONE', '13', 'ѤǻѤ륷åפJISƻܸ(2)ꤷޤ.', '7', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('͹ֹ', 'STORE_ORIGIN_ZIP', 'NONE', 'åפ͹ֹꤷޤѤ˻Ѥޤ', '7', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ǽʺѥå', 'SHIPPING_MAX_WEIGHT', '50', 'ǽʺѥå̤ꤷޤȼԤˤϣĤΥѥåν¤ޤΤǶ̤ͤǤ', '7', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ѥå', 'SHIPPING_BOX_WEIGHT', '0', 'ѥåŵṲ̄ꤷޤ', '7', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ѥå - Ψ(%)', 'SHIPPING_BOX_PADDING', '10', '10% äξ 10 ϤƤ', '7', '5', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ѡ۾ʥ᡼ɽ', 'PRODUCT_LIST_IMAGE', '0', 'ʰزɽɽꤷޤ', '8', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ѡۥ᡼̾ɽ','PRODUCT_LIST_MANUFACTURER', '0', 'ʰإ᡼̾ɽɽꤷޤ', '8', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ѡ۾ʷ֤ɽ', 'PRODUCT_LIST_MODEL', '0', 'ʰؾʷ֤ɽɽꤷޤ', '8', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ѡ۾̾ɽ', 'PRODUCT_LIST_NAME', '1', 'ʰؾ̾ɽɽꤷޤ', '8', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ѡ۾ʲʤɽ', 'PRODUCT_LIST_PRICE', '2', 'ʰؾʲʤɽɽꤷޤ', '8', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ѡ۾ʿ̤ɽ', 'PRODUCT_LIST_QUANTITY', '0', 'ʰؾʿ̤ɽɽꤷޤ', '8', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ѡ۾ʽ̤ɽ', 'PRODUCT_LIST_WEIGHT', '0', 'ʰؾʽ̤ɽɽꤷޤ', '8', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ѡ[]ɽ', 'PRODUCT_LIST_BUY_NOW', '0', 'ʰ [] ɽɽꤷޤ', '8', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ƥ꡼/᡼ιʹߤɽ', 'PRODUCT_LIST_FILTER', '1', 'ƥ꡼ڡ [ʹ] ɽɽꤷޤ(0=ɽ / 1=ɽ)', '8', '9', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('[ڡ]/[ڡ]ɽ', 'PREV_NEXT_BAR_LOCATION', '2', '[ڡ]/[ڡ]ɽ֤ꤷޤ(1= / 2= / 3=ξ)', '8', '10', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('߸˿Υå', 'STOCK_CHECK', 'true', 'ʬʺ߸ˤ뤫å뤫ɤꤷޤ', '9', '1', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('߸˿', 'STOCK_LIMITED', 'true', 'ǳƺ߸˿ʸ뤫ɤꤷޤ', '9', '2', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('', 'STOCK_ALLOW_CHECKOUT', 'false', '߸ˤ­ƤġĤꤷޤ', '9', '3', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('߸ڤ쾦ʤΥ', 'STOCK_MARK_PRODUCT_OUT_OF_STOCK', '***', 'ʸǾʤ߸ڤξ˸ܵҤɽ륵ꤷޤ', '9', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('߸ˤκʸ', 'STOCK_REORDER_LEVEL', '5', '߸ˤκʸɬפˤʤ뾦ʿꤷޤ', '9', '5', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ڡѡ֤Ͽ', 'STORE_PAGE_PARSE_TIME', 'false', 'ڡΥѡפ֤˵Ͽꤷޤ', '10', '1', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('γǼ', 'STORE_PAGE_PARSE_TIME_LOG', '/var/log/www/tep/page_parse_time.log', 'ڡΥѡ¸ǥ쥯ȥȥե̾ꤷޤ', '10', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('շ', 'STORE_PARSE_DATE_TIME_FORMAT', '%d/%m/%Y %H:%M:%S', '˵Ͽշꤷޤ', '10', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ڡѡ֤ɽ', 'DISPLAY_PAGE_PARSE_TIME', 'true', 'ڡ˥ѡ֤ɽꤷޤ(&quot;ڡѡ֤Ͽ&quot;  true ˤɬפޤ)', '10', '4', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ǡ١䤤碌Ͽ', 'STORE_DB_TRANSACTIONS', 'false', '˥ǡ١䤤碌Ͽ (PHP4Τ) ꤷޤ', '10', '5', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('å', 'USE_CACHE', 'false', 'å嵡ǽλѡԻѤꤷޤ', '11', '1', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('å塦ǥ쥯ȥ', 'DIR_FS_CACHE', '/tmp/', 'å塦ե뤬¸ǥ쥯ȥꤷޤ', '11', '2', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('E-Mail', 'EMAIL_TRANSPORT', 'sendmail', 'E-Mail sendmailؤΥ³Ѥ뤫 TCP/IP ͳ SMTP³ Ѥ뤫ꤷޤ', '12', '1', 'tep_cfg_select_option(array(\'sendmail\', \'smtp\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('E-Mailβ', 'EMAIL_LINEFEED', 'LF', '᡼롦إåڤΤ˻Ѥԥɤꤷޤ', '12', '2', 'tep_cfg_select_option(array(\'LF\', \'CRLF\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('᡼MIME HTML', 'EMAIL_USE_HTML', 'false', 'E-MailHTMLꤷޤ', '12', '3', 'tep_cfg_select_option(array(\'true\', \'false\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('E-Mailɥ쥹DNSǳǧ', 'ENTRY_EMAIL_ADDRESS_CHECK', 'false', 'E-Mailɥ쥹DNSФ䤤碌ǧꤷޤ', '12', '4', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('E-Mail', 'SEND_EMAILS', 'true', 'E-Mailǽˤޤ', '12', '5', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ɤͭ', 'DOWNLOAD_ENABLED', 'false', 'ʤΥ򤹤ꤷޤ', '13', '1', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('쥯Ȥˤ', 'DOWNLOAD_BY_REDIRECT', 'false', '֥饦Υ쥯ȤѤƥɡUnixƥʳǤԲġ', '13', '2', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ͭ()' ,'DOWNLOAD_MAX_DAYS', '7', 'ɡ󥯤δڤޤǤ򥻥åȤޤ0ʤ̵¡', '13', '3', '', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ɺǹ' ,'DOWNLOAD_MAX_COUNT', '5', 'ɤǤǹ򥻥åȤޤ0ʤǧڤ򤷤ʤ', '13', '4', '', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('GZip̤Ѥ', 'GZIP_COMPRESSION', 'false', 'HTTP GZip ѤƥڡФ򰵽̤ꤷޤ', '14', '1', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̥٥', 'GZIP_LEVEL', '5', 'Ѥ밵̥٥ (0 = Ǿ, 9 = )', '14', '2', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('åκ', 'SESSION_RECREATE', 'False', 'ܵҤΥޤϥȺΤȤ,åIDĤ뤿˥åޤ. (PHP >=4.1 needed).', '15', '7', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Installed Modules(koshoten.net)', 'KN_CFG_MODULE_PAYMENT_INSTALLED', 'cod.php', 'List of payment module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: cc.php;cod.php;paypal.php)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Installed Modules(koshoten.net)', 'KN_CFG_MODULE_SHIPPING_INSTALLED', 'flat.php', 'List of shipping module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ups.php;flat.php;item.php)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('λ', 'KN_CFG_USE_SUBTITLE', 'false', 'ܤλѡԻѤꤷޤ', '101', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('꡼̾λ', 'KN_CFG_USE_SERIES_TITLE', 'false', '꡼̾ܤλѡԻѤꤷޤ', '101', '2','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('̾λ', 'KN_CFG_USE_AUTHOR', 'true', '̾ܤλѡԻѤꤷޤ', '101', '3','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ʸλ', 'KN_CFG_USE_DESCRIPTION2', 'true', 'ʸܤλѡԻѤꤷޤ', '101', '4','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ɤλ', 'KN_CFG_USE_KEYWORDS', 'true', 'ɹܤλѡԻѤꤷޤ', '101', '5','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ISBNɤλ', 'KN_CFG_USE_ISBN', 'false', 'ISBNɹܤλѡԻѤꤷޤ', '101', '6','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('λ', 'KN_CFG_USE_VOLUME', 'true', 'ܤλѡԻѤꤷޤ', '101', '7','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Ǹλ', 'KN_CFG_USE_PUBLISHERS', 'true', 'ǸܤλѡԻѤꤷޤ', '101', '8','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ǯλ', 'KN_CFG_USE_PUBLISHED', 'true', 'ǯܤλѡԻѤꤷޤ', '101', '9','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('̤λ', 'KN_CFG_USE_WEIGHT', 'false', '̹ܤλѡԻѤꤷޤ', '101', '10','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ȯλ', 'KN_CFG_USE_DATE_AVAILABLE', 'false', 'ȯܤλѡԻѤꤷޤ', '101', '11','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('URLλ', 'KN_CFG_USE_URL', 'false', 'ʤURLܤλѡԻѤꤷޤ', '101', '12','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɲʬλ', 'KN_CFG_USE_MANUFACTURERS', '', 'ɲʬι̾ꤷޤɲʬѤʤ϶ˤƤ', '101', '13', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ʰǼ̤λ', 'KN_CFG_SHORT_CHECKOUT', 'true', 'ʧˡꤷʤ̤ˤtrueˤޤ', '102', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ᾦʥɽ', 'KN_CFG_RECOMMENDATION_COLUMN_DISPLAY', 'true', 'ᾦʥɽˤtrueˤޤ', '102', '2','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ᾦɽ', 'KN_CFG_MAX_DISPLAY_RECOMMENDATION', '4', 'ᾦʥɽ뤪ᾦʿκͤꤷޤ', '102', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Ԥɽ뤪ᾦʿ', 'KN_CFG_MAX_DISPLAY_RECOMMENDATION_PER_ROW', '2', 'ᾦʥɽ룱ԤΤᾦʿꤷޤ.', '102', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ᾦʸɽ', 'KN_CFG_RECOMMENDATION_DESCRIPTION2_DISPLAY', 'false', 'ᾦʤʸɽˤtrueˤޤ', '102', '5','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('徦ʥɽ', 'KN_CFG_NEW_PRODUCTS_COLUMN_DISPLAY', 'false', '徦ʥɽˤtrueˤޤ', '102', '6','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('徦ɽ', 'KN_CFG_MAX_DISPLAY_NEW_PRODUCTS', '3', '徦ʥɽ뿷徦ʿκͤꤷޤ.', '102', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Ԥɽ뿷徦ʿ', 'KN_CFG_MAX_DISPLAY_NEW_PRODUCTS_PER_ROW', '1', '徦ʥɽ룱Ԥο徦ʿꤷޤ.', '102', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ƥ꡼ɽ', 'KN_CFG_CATEGORIES_DISPLAY', 'true', 'ƥ꡼ɽˤtrueˤޤ', '102', '9','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ƥ꡼', 'KN_CFG_CATEGORIES_DISPLAY_TYPE', 'type2', 'ƥ꡼Υǥѹޤ', '102', '10','tep_cfg_select_option(array(\'type1\', \'type2\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Ԥɽ륫ƥ꡼', 'KN_CFG_MAX_DISPLAY_CATEGORIES_PER_ROW', '3', 'Ԥɽ륫ƥ꡼ꤷޤ.', '102', '11', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ɾλ', 'KN_CFG_USE_REVIEWS', 'false', 'ɾǽѤˤtrueˤޤ', '102', '12','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Ͽɽ', 'KN_CFG_DATE_ADDED_DISPLAY', 'false', 'ʾܺ٥ڡ˾Ͽɽˤtrueˤޤ', '102', '13','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Ʊɽ', 'KN_CFG_ALSO_PURCHASED_DISPLAY', 'false', 'ʾܺ٥ڡˡ֤ξʤäͤϡפɽˤtrueˤޤ', '102', '14','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('᡼θĿ;ɽ', 'KN_CFG_MAIL_PRIVACY_DISPLAY', 'true', '᡼ˤϤ䤴θĿ;ɽˤtrueˤޤ', '102', '15','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('koshoten.netѻʧ', 'KN_CFG_USE_KN_MODULES', 'true', 'osCommerceꥸʥʧ⥸塼Ѥˤfalseˤޤ', '102', '16','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ʸɽ', 'KN_CFG_USE_ORDER_HISTORY', 'true', 'ȾǤͤʸɽʤˤfalseˤޤ', '102', '17','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ʸλ', 'KN_CFG_USE_PRICE_SEARCH', 'false', 'ܺٸǲʸǽѤˤtrueˤޤ', '102', '18','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Ͽλ', 'KN_CFG_USE_DATE_SEARCH', 'false', 'ܺٸϿǽѤˤtrueˤޤ', '102', '19','tep_cfg_select_option(array(\'true\', \'false\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɤɽ', 'KN_CFG_PRODUCT_LIST_MODEL', '1', 'ʰؾʤδɤɽɽꤷޤ.', '103', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̾ɽ', 'KN_CFG_PRODUCT_LIST_NAME', '2', 'ʰؽ̾ɽɽꤷޤ.', '103', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɽ', 'KN_CFG_PRODUCT_LIST_SUBTITLE', '0', 'ʰɽɽꤷޤ.', '103', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('꡼̾ɽ', 'KN_CFG_PRODUCT_LIST_SERIES_TITLE', '0', 'ʰإ꡼̾ɽɽꤷޤ.', '103', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̾ɽ', 'KN_CFG_PRODUCT_LIST_AUTHOR', '3', 'ʰ̾ɽɽꤷޤ.', '103', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ǯɽ', 'KN_CFG_PRODUCT_LIST_PUBLISHED', '4', 'ʰشǯɽɽꤷޤ.', '103', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɽ', 'KN_CFG_PRODUCT_LIST_VOLUME', '5', 'ʰغɽɽꤷޤ.', '103', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ISBNɽ', 'KN_CFG_PRODUCT_LIST_ISBN', '0', 'ʰISBNɽɽꤷޤ.', '103', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ʲʤɽ', 'KN_CFG_PRODUCT_LIST_PRICE', '7', 'ʰؾʲʤɽɽꤷޤ.', '103', '9', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('[]ɽ', 'KN_CFG_PRODUCT_LIST_BUY_NOW', '0', 'ʰ [] ɽɽꤷޤ.', '103', '10', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('᡼ɽ', 'KN_CFG_PRODUCT_LIST_IMAGE', '0', 'ʰزɽɽꤷޤ.', '103', '11', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Ǹɽ','KN_CFG_PRODUCT_LIST_PUBLISHERS', '0', 'ʰؽǸɽɽꤷޤ.', '103', '12', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ɽ', 'KN_CFG_PRODUCT_LIST_QUANTITY', '0', 'ʰؾʿ̤ɽɽꤷޤ.', '103', '13', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̤ɽ', 'KN_CFG_PRODUCT_LIST_WEIGHT', '0', 'ʰؾʽ̤ɽɽꤷޤ.', '103', '14', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ʸɽ', 'KN_CFG_PRODUCT_LIST_DESCRIPTION', '0', 'ʰؾʸɽɽꤷޤ.', '103', '15', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ʸˤޤȤ', 'KN_CFG_PRODUCT_LIST_WITHIN_DESCRIPTION', 'true', 'ξʸ˥֥ȥ롢꡼̾ǯǸޤˤtrueˤޤ', '103', '16','tep_cfg_select_option(array(\'true\', \'false\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ɽ', 'KN_CFG_USE_COLUMN_RIGHT', 'true', 'åײ̱ξBOXɽɽꤷޤ', '104', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ɽ', 'KN_CFG_USE_COLUMN_LEFT', 'false', 'åײ̺ξBOXɽɽꤷޤ', '104', '2','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('BOXɽ', 'KN_CFG_BOX_SEARCH', '1', 'BOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Ϣ۸BOXɽ', 'KN_CFG_BOX_GETA_SEARCH', '1', 'Ϣ۸BOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ƥ꡼BOXɽ', 'KN_CFG_BOX_CATEGORIES', '0', 'ƥ꡼BOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɲʬΰBOXɽ', 'KN_CFG_BOX_MANUFACTURERS', '0', 'ɲʬΰBOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('åԥ󥰥BOXɽ', 'KN_CFG_BOX_SHOPPING_CART', '1', 'åԥ󥰥BOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('GETAơBOXɽ', 'KN_CFG_BOX_GETA_THEMES', '0', 'GETAơBOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('徦BOXɽ', 'KN_CFG_BOX_WHATS_NEW', '0', '徦BOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '9', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ʸBOXɽ', 'KN_CFG_BOX_ORDER_HISTORY', '0', 'ʸBOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '10', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ե᡼BOXɽ', 'KN_CFG_BOX_INFORMATION', '1', 'ե᡼BOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '11', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('٥ȥ顼BOXɽ', 'KN_CFG_BOX_BEST_SELLERS', '0', '٥ȥ顼BOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '12', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ͧΤ餻BOXɽ', 'KN_CFG_BOX_TELL_A_FRIEND', '0', 'ͧΤ餻BOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '13', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('òBOXɽ', 'KN_CFG_BOX_SPECIALS', '0', 'òBOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '14', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ɾBOXɽ', 'KN_CFG_BOX_REVIEWS', '0', 'ɾBOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '15', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('BOXɽ', 'KN_CFG_BOX_LANGUAGES', '0', 'BOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '16', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̲BOXɽ', 'KN_CFG_BOX_CURRENCIES', '0', '̲BOXɽɽꤷޤ1=ɽ / 2=ɽ / 0=ɽ', '104', '17', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('GETAͭ', 'KN_CFG_GETA_ENABLED', 'true', 'GETAѤꤷޤ', '105', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Ϣ۸ͭ', 'KN_CFG_GETA_SEARCH_ENABLED', 'true', 'GETAˤϢ۸Ѥꤷޤ', '105', '2','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Ϣ۸ɽ', 'KN_CFG_GETA_SEARCH_RESULTS_MAX', '20', 'Ϣ۸̰ɽ뾦ʿꤷޤ.', '105', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Ϣۤͭ', 'KN_CFG_GETA_PRODUCTS_ENABLED', 'true', 'GETAˤ뾦ϢۤѤꤷޤ', '105', '4','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Ϣɽ', 'KN_CFG_GETA_PRODUCTS_MAX', '3', 'Ϣۥɽ뾦ʿꤷޤ.', '105', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ơϢۤͭ', 'KN_CFG_GETA_THEMES_ENABLED', 'true', 'GETAˤơϢۤѤꤷޤ', '105', '6','tep_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('GETAơ̾', 'KN_CFG_GETA_THEMES_TITLE', '', 'GETAơޤΥȥꤷޤ.ýåʤʤɡ', '105', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('GETAơɽ', 'KN_CFG_GETA_THEMES_MAX', '6', 'GETAơBOXɽơޥȥꤷޤ.', '105', '8', now());

INSERT INTO configuration_group VALUES ('1', 'å׾', 'åפΰ̾', '1', '1');
INSERT INTO configuration_group VALUES ('2', 'Ǿ', 'ؿ/ǡκǾ', '2', '1');
INSERT INTO configuration_group VALUES ('3', '', 'ؿ/ǡκ', '3', '1');
INSERT INTO configuration_group VALUES ('4', '', 'ƥ꡼ɲùܡʤʤɤβ', '4', '1');
INSERT INTO configuration_group VALUES ('5', 'ɽ', 'ܵҤΥȤ', '5', '1');
INSERT INTO configuration_group VALUES ('6', '⥸塼롦ץ', 'ƥǻѤ', '6', '0');
INSERT INTO configuration_group VALUES ('7', '/ѥå', 'åפǼդץ', '7', '1');
INSERT INTO configuration_group VALUES ('8', 'ʰɽ', 'ʰʤۤȤ̤ѡ', '8', '1');
INSERT INTO configuration_group VALUES ('9', '߸˴', '߸ˤ', '9', '1');
INSERT INTO configuration_group VALUES ('10', 'ɽ/Ͽ', 'ꡣεϿˤϡоǤ꤬ɬפˤʤ뤳Ȥޤ', '10', '1');
INSERT INTO configuration_group VALUES ('11', 'ڡå', 'åꡣåλѤˤϡоǤ꤬ɬפˤʤ뤳Ȥޤ', '11', '1');
INSERT INTO configuration_group VALUES ('12', '᡼ܺ', '᡼δHTML᡼ꡣ', '12', '1');
INSERT INTO configuration_group VALUES ('13', '', '侦ʤꡣKoshoten.net2Ǥ̤', '13', '1');
INSERT INTO configuration_group VALUES ('14', 'GZip ', '̤Υץ', '14', '1');
INSERT INTO configuration_group VALUES ('101', 'KNĥ', 'koshoten.netɲäܤλѡ̤Ѥ', '101', '1');
INSERT INTO configuration_group VALUES ('102', 'KNĥǽ', 'koshoten.net䤽¾ǽλѡ̤Ѥ', '102', '1');
INSERT INTO configuration_group VALUES ('103', 'ʰɽ', 'ʰꡣʰɽܤˡ19ޤǤοϤƤν֤˰ɽޤϢ۸ΰɽоݳ', '103', '1');
INSERT INTO configuration_group VALUES ('104', '쥤', 'ΥξBOXɽɽ', '104', '1');
INSERT INTO configuration_group VALUES ('105', 'GETA', 'GETAϢ۸ˤγƼ', '105', '1');

INSERT INTO countries VALUES (1,'Afghanistan','AF','AFG','1');
INSERT INTO countries VALUES (2,'Albania','AL','ALB','1');
INSERT INTO countries VALUES (3,'Algeria','DZ','DZA','1');
INSERT INTO countries VALUES (4,'American Samoa','AS','ASM','1');
INSERT INTO countries VALUES (5,'Andorra','AD','AND','1');
INSERT INTO countries VALUES (6,'Angola','AO','AGO','1');
INSERT INTO countries VALUES (7,'Anguilla','AI','AIA','1');
INSERT INTO countries VALUES (8,'Antarctica','AQ','ATA','1');
INSERT INTO countries VALUES (9,'Antigua and Barbuda','AG','ATG','1');
INSERT INTO countries VALUES (10,'Argentina','AR','ARG','1');
INSERT INTO countries VALUES (11,'Armenia','AM','ARM','1');
INSERT INTO countries VALUES (12,'Aruba','AW','ABW','1');
INSERT INTO countries VALUES (13,'Australia','AU','AUS','1');
INSERT INTO countries VALUES (14,'Austria','AT','AUT','5');
INSERT INTO countries VALUES (15,'Azerbaijan','AZ','AZE','1');
INSERT INTO countries VALUES (16,'Bahamas','BS','BHS','1');
INSERT INTO countries VALUES (17,'Bahrain','BH','BHR','1');
INSERT INTO countries VALUES (18,'Bangladesh','BD','BGD','1');
INSERT INTO countries VALUES (19,'Barbados','BB','BRB','1');
INSERT INTO countries VALUES (20,'Belarus','BY','BLR','1');
INSERT INTO countries VALUES (21,'Belgium','BE','BEL','1');
INSERT INTO countries VALUES (22,'Belize','BZ','BLZ','1');
INSERT INTO countries VALUES (23,'Benin','BJ','BEN','1');
INSERT INTO countries VALUES (24,'Bermuda','BM','BMU','1');
INSERT INTO countries VALUES (25,'Bhutan','BT','BTN','1');
INSERT INTO countries VALUES (26,'Bolivia','BO','BOL','1');
INSERT INTO countries VALUES (27,'Bosnia and Herzegowina','BA','BIH','1');
INSERT INTO countries VALUES (28,'Botswana','BW','BWA','1');
INSERT INTO countries VALUES (29,'Bouvet Island','BV','BVT','1');
INSERT INTO countries VALUES (30,'Brazil','BR','BRA','1');
INSERT INTO countries VALUES (31,'British Indian Ocean Territory','IO','IOT','1');
INSERT INTO countries VALUES (32,'Brunei Darussalam','BN','BRN','1');
INSERT INTO countries VALUES (33,'Bulgaria','BG','BGR','1');
INSERT INTO countries VALUES (34,'Burkina Faso','BF','BFA','1');
INSERT INTO countries VALUES (35,'Burundi','BI','BDI','1');
INSERT INTO countries VALUES (36,'Cambodia','KH','KHM','1');
INSERT INTO countries VALUES (37,'Cameroon','CM','CMR','1');
INSERT INTO countries VALUES (38,'Canada','CA','CAN','1');
INSERT INTO countries VALUES (39,'Cape Verde','CV','CPV','1');
INSERT INTO countries VALUES (40,'Cayman Islands','KY','CYM','1');
INSERT INTO countries VALUES (41,'Central African Republic','CF','CAF','1');
INSERT INTO countries VALUES (42,'Chad','TD','TCD','1');
INSERT INTO countries VALUES (43,'Chile','CL','CHL','1');
INSERT INTO countries VALUES (44,'China','CN','CHN','1');
INSERT INTO countries VALUES (45,'Christmas Island','CX','CXR','1');
INSERT INTO countries VALUES (46,'Cocos (Keeling) Islands','CC','CCK','1');
INSERT INTO countries VALUES (47,'Colombia','CO','COL','1');
INSERT INTO countries VALUES (48,'Comoros','KM','COM','1');
INSERT INTO countries VALUES (49,'Congo','CG','COG','1');
INSERT INTO countries VALUES (50,'Cook Islands','CK','COK','1');
INSERT INTO countries VALUES (51,'Costa Rica','CR','CRI','1');
INSERT INTO countries VALUES (52,'Cote D\'Ivoire','CI','CIV','1');
INSERT INTO countries VALUES (53,'Croatia','HR','HRV','1');
INSERT INTO countries VALUES (54,'Cuba','CU','CUB','1');
INSERT INTO countries VALUES (55,'Cyprus','CY','CYP','1');
INSERT INTO countries VALUES (56,'Czech Republic','CZ','CZE','1');
INSERT INTO countries VALUES (57,'Denmark','DK','DNK','1');
INSERT INTO countries VALUES (58,'Djibouti','DJ','DJI','1');
INSERT INTO countries VALUES (59,'Dominica','DM','DMA','1');
INSERT INTO countries VALUES (60,'Dominican Republic','DO','DOM','1');
INSERT INTO countries VALUES (61,'East Timor','TP','TMP','1');
INSERT INTO countries VALUES (62,'Ecuador','EC','ECU','1');
INSERT INTO countries VALUES (63,'Egypt','EG','EGY','1');
INSERT INTO countries VALUES (64,'El Salvador','SV','SLV','1');
INSERT INTO countries VALUES (65,'Equatorial Guinea','GQ','GNQ','1');
INSERT INTO countries VALUES (66,'Eritrea','ER','ERI','1');
INSERT INTO countries VALUES (67,'Estonia','EE','EST','1');
INSERT INTO countries VALUES (68,'Ethiopia','ET','ETH','1');
INSERT INTO countries VALUES (69,'Falkland Islands (Malvinas)','FK','FLK','1');
INSERT INTO countries VALUES (70,'Faroe Islands','FO','FRO','1');
INSERT INTO countries VALUES (71,'Fiji','FJ','FJI','1');
INSERT INTO countries VALUES (72,'Finland','FI','FIN','1');
INSERT INTO countries VALUES (73,'France','FR','FRA','1');
INSERT INTO countries VALUES (74,'France, Metropolitan','FX','FXX','1');
INSERT INTO countries VALUES (75,'French Guiana','GF','GUF','1');
INSERT INTO countries VALUES (76,'French Polynesia','PF','PYF','1');
INSERT INTO countries VALUES (77,'French Southern Territories','TF','ATF','1');
INSERT INTO countries VALUES (78,'Gabon','GA','GAB','1');
INSERT INTO countries VALUES (79,'Gambia','GM','GMB','1');
INSERT INTO countries VALUES (80,'Georgia','GE','GEO','1');
INSERT INTO countries VALUES (81,'Germany','DE','DEU','5');
INSERT INTO countries VALUES (82,'Ghana','GH','GHA','1');
INSERT INTO countries VALUES (83,'Gibraltar','GI','GIB','1');
INSERT INTO countries VALUES (84,'Greece','GR','GRC','1');
INSERT INTO countries VALUES (85,'Greenland','GL','GRL','1');
INSERT INTO countries VALUES (86,'Grenada','GD','GRD','1');
INSERT INTO countries VALUES (87,'Guadeloupe','GP','GLP','1');
INSERT INTO countries VALUES (88,'Guam','GU','GUM','1');
INSERT INTO countries VALUES (89,'Guatemala','GT','GTM','1');
INSERT INTO countries VALUES (90,'Guinea','GN','GIN','1');
INSERT INTO countries VALUES (91,'Guinea-bissau','GW','GNB','1');
INSERT INTO countries VALUES (92,'Guyana','GY','GUY','1');
INSERT INTO countries VALUES (93,'Haiti','HT','HTI','1');
INSERT INTO countries VALUES (94,'Heard and Mc Donald Islands','HM','HMD','1');
INSERT INTO countries VALUES (95,'Honduras','HN','HND','1');
INSERT INTO countries VALUES (96,'Hong Kong','HK','HKG','1');
INSERT INTO countries VALUES (97,'Hungary','HU','HUN','1');
INSERT INTO countries VALUES (98,'Iceland','IS','ISL','1');
INSERT INTO countries VALUES (99,'India','IN','IND','1');
INSERT INTO countries VALUES (100,'Indonesia','ID','IDN','1');
INSERT INTO countries VALUES (101,'Iran (Islamic Republic of)','IR','IRN','1');
INSERT INTO countries VALUES (102,'Iraq','IQ','IRQ','1');
INSERT INTO countries VALUES (103,'Ireland','IE','IRL','1');
INSERT INTO countries VALUES (104,'Israel','IL','ISR','1');
INSERT INTO countries VALUES (105,'Italy','IT','ITA','1');
INSERT INTO countries VALUES (106,'Jamaica','JM','JAM','1');
INSERT INTO countries VALUES (107,'Japan','JP','JPN','6');
INSERT INTO countries VALUES (108,'Jordan','JO','JOR','1');
INSERT INTO countries VALUES (109,'Kazakhstan','KZ','KAZ','1');
INSERT INTO countries VALUES (110,'Kenya','KE','KEN','1');
INSERT INTO countries VALUES (111,'Kiribati','KI','KIR','1');
INSERT INTO countries VALUES (112,'Korea, Democratic People\'s Republic of','KP','PRK','1');
INSERT INTO countries VALUES (113,'Korea, Republic of','KR','KOR','1');
INSERT INTO countries VALUES (114,'Kuwait','KW','KWT','1');
INSERT INTO countries VALUES (115,'Kyrgyzstan','KG','KGZ','1');
INSERT INTO countries VALUES (116,'Lao People\'s Democratic Republic','LA','LAO','1');
INSERT INTO countries VALUES (117,'Latvia','LV','LVA','1');
INSERT INTO countries VALUES (118,'Lebanon','LB','LBN','1');
INSERT INTO countries VALUES (119,'Lesotho','LS','LSO','1');
INSERT INTO countries VALUES (120,'Liberia','LR','LBR','1');
INSERT INTO countries VALUES (121,'Libyan Arab Jamahiriya','LY','LBY','1');
INSERT INTO countries VALUES (122,'Liechtenstein','LI','LIE','1');
INSERT INTO countries VALUES (123,'Lithuania','LT','LTU','1');
INSERT INTO countries VALUES (124,'Luxembourg','LU','LUX','1');
INSERT INTO countries VALUES (125,'Macau','MO','MAC','1');
INSERT INTO countries VALUES (126,'Macedonia, The Former Yugoslav Republic of','MK','MKD','1');
INSERT INTO countries VALUES (127,'Madagascar','MG','MDG','1');
INSERT INTO countries VALUES (128,'Malawi','MW','MWI','1');
INSERT INTO countries VALUES (129,'Malaysia','MY','MYS','1');
INSERT INTO countries VALUES (130,'Maldives','MV','MDV','1');
INSERT INTO countries VALUES (131,'Mali','ML','MLI','1');
INSERT INTO countries VALUES (132,'Malta','MT','MLT','1');
INSERT INTO countries VALUES (133,'Marshall Islands','MH','MHL','1');
INSERT INTO countries VALUES (134,'Martinique','MQ','MTQ','1');
INSERT INTO countries VALUES (135,'Mauritania','MR','MRT','1');
INSERT INTO countries VALUES (136,'Mauritius','MU','MUS','1');
INSERT INTO countries VALUES (137,'Mayotte','YT','MYT','1');
INSERT INTO countries VALUES (138,'Mexico','MX','MEX','1');
INSERT INTO countries VALUES (139,'Micronesia, Federated States of','FM','FSM','1');
INSERT INTO countries VALUES (140,'Moldova, Republic of','MD','MDA','1');
INSERT INTO countries VALUES (141,'Monaco','MC','MCO','1');
INSERT INTO countries VALUES (142,'Mongolia','MN','MNG','1');
INSERT INTO countries VALUES (143,'Montserrat','MS','MSR','1');
INSERT INTO countries VALUES (144,'Morocco','MA','MAR','1');
INSERT INTO countries VALUES (145,'Mozambique','MZ','MOZ','1');
INSERT INTO countries VALUES (146,'Myanmar','MM','MMR','1');
INSERT INTO countries VALUES (147,'Namibia','NA','NAM','1');
INSERT INTO countries VALUES (148,'Nauru','NR','NRU','1');
INSERT INTO countries VALUES (149,'Nepal','NP','NPL','1');
INSERT INTO countries VALUES (150,'Netherlands','NL','NLD','1');
INSERT INTO countries VALUES (151,'Netherlands Antilles','AN','ANT','1');
INSERT INTO countries VALUES (152,'New Caledonia','NC','NCL','1');
INSERT INTO countries VALUES (153,'New Zealand','NZ','NZL','1');
INSERT INTO countries VALUES (154,'Nicaragua','NI','NIC','1');
INSERT INTO countries VALUES (155,'Niger','NE','NER','1');
INSERT INTO countries VALUES (156,'Nigeria','NG','NGA','1');
INSERT INTO countries VALUES (157,'Niue','NU','NIU','1');
INSERT INTO countries VALUES (158,'Norfolk Island','NF','NFK','1');
INSERT INTO countries VALUES (159,'Northern Mariana Islands','MP','MNP','1');
INSERT INTO countries VALUES (160,'Norway','NO','NOR','1');
INSERT INTO countries VALUES (161,'Oman','OM','OMN','1');
INSERT INTO countries VALUES (162,'Pakistan','PK','PAK','1');
INSERT INTO countries VALUES (163,'Palau','PW','PLW','1');
INSERT INTO countries VALUES (164,'Panama','PA','PAN','1');
INSERT INTO countries VALUES (165,'Papua New Guinea','PG','PNG','1');
INSERT INTO countries VALUES (166,'Paraguay','PY','PRY','1');
INSERT INTO countries VALUES (167,'Peru','PE','PER','1');
INSERT INTO countries VALUES (168,'Philippines','PH','PHL','1');
INSERT INTO countries VALUES (169,'Pitcairn','PN','PCN','1');
INSERT INTO countries VALUES (170,'Poland','PL','POL','1');
INSERT INTO countries VALUES (171,'Portugal','PT','PRT','1');
INSERT INTO countries VALUES (172,'Puerto Rico','PR','PRI','1');
INSERT INTO countries VALUES (173,'Qatar','QA','QAT','1');
INSERT INTO countries VALUES (174,'Reunion','RE','REU','1');
INSERT INTO countries VALUES (175,'Romania','RO','ROM','1');
INSERT INTO countries VALUES (176,'Russian Federation','RU','RUS','1');
INSERT INTO countries VALUES (177,'Rwanda','RW','RWA','1');
INSERT INTO countries VALUES (178,'Saint Kitts and Nevis','KN','KNA','1');
INSERT INTO countries VALUES (179,'Saint Lucia','LC','LCA','1');
INSERT INTO countries VALUES (180,'Saint Vincent and the Grenadines','VC','VCT','1');
INSERT INTO countries VALUES (181,'Samoa','WS','WSM','1');
INSERT INTO countries VALUES (182,'San Marino','SM','SMR','1');
INSERT INTO countries VALUES (183,'Sao Tome and Principe','ST','STP','1');
INSERT INTO countries VALUES (184,'Saudi Arabia','SA','SAU','1');
INSERT INTO countries VALUES (185,'Senegal','SN','SEN','1');
INSERT INTO countries VALUES (186,'Seychelles','SC','SYC','1');
INSERT INTO countries VALUES (187,'Sierra Leone','SL','SLE','1');
INSERT INTO countries VALUES (188,'Singapore','SG','SGP', '4');
INSERT INTO countries VALUES (189,'Slovakia (Slovak Republic)','SK','SVK','1');
INSERT INTO countries VALUES (190,'Slovenia','SI','SVN','1');
INSERT INTO countries VALUES (191,'Solomon Islands','SB','SLB','1');
INSERT INTO countries VALUES (192,'Somalia','SO','SOM','1');
INSERT INTO countries VALUES (193,'South Africa','ZA','ZAF','1');
INSERT INTO countries VALUES (194,'South Georgia and the South Sandwich Islands','GS','SGS','1');
INSERT INTO countries VALUES (195,'Spain','ES','ESP','3');
INSERT INTO countries VALUES (196,'Sri Lanka','LK','LKA','1');
INSERT INTO countries VALUES (197,'St. Helena','SH','SHN','1');
INSERT INTO countries VALUES (198,'St. Pierre and Miquelon','PM','SPM','1');
INSERT INTO countries VALUES (199,'Sudan','SD','SDN','1');
INSERT INTO countries VALUES (200,'Suriname','SR','SUR','1');
INSERT INTO countries VALUES (201,'Svalbard and Jan Mayen Islands','SJ','SJM','1');
INSERT INTO countries VALUES (202,'Swaziland','SZ','SWZ','1');
INSERT INTO countries VALUES (203,'Sweden','SE','SWE','1');
INSERT INTO countries VALUES (204,'Switzerland','CH','CHE','1');
INSERT INTO countries VALUES (205,'Syrian Arab Republic','SY','SYR','1');
INSERT INTO countries VALUES (206,'Taiwan','TW','TWN','1');
INSERT INTO countries VALUES (207,'Tajikistan','TJ','TJK','1');
INSERT INTO countries VALUES (208,'Tanzania, United Republic of','TZ','TZA','1');
INSERT INTO countries VALUES (209,'Thailand','TH','THA','1');
INSERT INTO countries VALUES (210,'Togo','TG','TGO','1');
INSERT INTO countries VALUES (211,'Tokelau','TK','TKL','1');
INSERT INTO countries VALUES (212,'Tonga','TO','TON','1');
INSERT INTO countries VALUES (213,'Trinidad and Tobago','TT','TTO','1');
INSERT INTO countries VALUES (214,'Tunisia','TN','TUN','1');
INSERT INTO countries VALUES (215,'Turkey','TR','TUR','1');
INSERT INTO countries VALUES (216,'Turkmenistan','TM','TKM','1');
INSERT INTO countries VALUES (217,'Turks and Caicos Islands','TC','TCA','1');
INSERT INTO countries VALUES (218,'Tuvalu','TV','TUV','1');
INSERT INTO countries VALUES (219,'Uganda','UG','UGA','1');
INSERT INTO countries VALUES (220,'Ukraine','UA','UKR','1');
INSERT INTO countries VALUES (221,'United Arab Emirates','AE','ARE','1');
INSERT INTO countries VALUES (222,'United Kingdom','GB','GBR','1');
INSERT INTO countries VALUES (223,'United States','US','USA', '2');
INSERT INTO countries VALUES (224,'United States Minor Outlying Islands','UM','UMI','1');
INSERT INTO countries VALUES (225,'Uruguay','UY','URY','1');
INSERT INTO countries VALUES (226,'Uzbekistan','UZ','UZB','1');
INSERT INTO countries VALUES (227,'Vanuatu','VU','VUT','1');
INSERT INTO countries VALUES (228,'Vatican City State (Holy See)','VA','VAT','1');
INSERT INTO countries VALUES (229,'Venezuela','VE','VEN','1');
INSERT INTO countries VALUES (230,'Viet Nam','VN','VNM','1');
INSERT INTO countries VALUES (231,'Virgin Islands (British)','VG','VGB','1');
INSERT INTO countries VALUES (232,'Virgin Islands (U.S.)','VI','VIR','1');
INSERT INTO countries VALUES (233,'Wallis and Futuna Islands','WF','WLF','1');
INSERT INTO countries VALUES (234,'Western Sahara','EH','ESH','1');
INSERT INTO countries VALUES (235,'Yemen','YE','YEM','1');
INSERT INTO countries VALUES (236,'Yugoslavia','YU','YUG','1');
INSERT INTO countries VALUES (237,'Zaire','ZR','ZAR','1');
INSERT INTO countries VALUES (238,'Zambia','ZM','ZMB','1');
INSERT INTO countries VALUES (239,'Zimbabwe','ZW','ZWE','1');

INSERT INTO currencies VALUES (1,'US Dollar','USD','$','','.',',','2','0.008372', now());
INSERT INTO currencies VALUES (4,'Euro','EUR','','EUR','.',',','2','0.007710', now());
INSERT INTO currencies VALUES (5,'Japanese Yen','JPY','', '', '.',',','0','1.0000', now());

INSERT INTO languages VALUES (4,'Japanese','ja','icon.gif','japanese',4);

INSERT INTO orders_status VALUES ( '1', '1', 'Pending');
INSERT INTO orders_status VALUES ( '1', '2', 'Offen');
INSERT INTO orders_status VALUES ( '1', '3', 'Pendiente');
INSERT INTO orders_status VALUES ( '2', '1', 'Processing');
INSERT INTO orders_status VALUES ( '2', '2', 'In Bearbeitung');
INSERT INTO orders_status VALUES ( '2', '3', 'Proceso');
INSERT INTO orders_status VALUES ( '3', '1', 'Delivered');
INSERT INTO orders_status VALUES ( '3', '2', 'Versendet');
INSERT INTO orders_status VALUES ( '3', '3', 'Entregado');

# JAPAN
INSERT INTO tax_class VALUES (1, '̾', 'ܹˤ̾', now(), now());
INSERT INTO tax_rates VALUES (1, 1, 1, 1, 0.0, 'ǡǡ', now(), now());
INSERT INTO geo_zones (geo_zone_id,geo_zone_name,geo_zone_description,date_added) VALUES (1,"","ܹ",now());
INSERT INTO zones_to_geo_zones (association_id,zone_country_id,zone_id,geo_zone_id,date_added) VALUES (1,107,0,1,now());

# zones : ƻܸ
# Japan
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'01','̳ƻ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'02','Ŀ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'03','긩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'04','ܾ븩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'05','ĸ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'06','');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'07','ʡ縩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'08','븩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'09','ڸ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'10','ϸ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'11','̸');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'12','ո');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'13','');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'14','');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'15','㸩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'16','ٻ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'17','');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'18','ʡ温');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'19','');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'20','Ĺ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'21','츩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'22','Ų');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'23','θ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'24','Ÿ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'25','츩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'26','');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'27','');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'28','ʼ˸');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'29','ɸ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'30','²λ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'31','Ļ踩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'32','纬');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'33','');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'34','縩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'35','');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'36','縩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'37','');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'38','ɲ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'39','θ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'40','ʡ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'41','츩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'42','Ĺ긩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'43','ܸ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'44','ʬ');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'45','ܺ긩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'46','縩');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'47','츩');

# orders_status : ʸơ
INSERT INTO orders_status VALUES ( '1', '4', 'Ԥ');
INSERT INTO orders_status VALUES ( '2', '4', '');
INSERT INTO orders_status VALUES ( '3', '4', 'Ѥ');

INSERT INTO shop_info VALUES (1,'', 'SHOP_INFO_WHATS_NEW', 'ŹϡosCommerceѤŽŹ󥿡ͥåΥȤΥץǤ', '', 'ȥåץڡʸʬǤ<br> ˿ʹˤ䡢٥Ⱦջʤɤ򵭺ܤޤ', '0', '0', '0', '0', '', now());
INSERT INTO shop_info VALUES (2,'ʸˤä', 'SHOP_INFO_SHIPPING', 'ʸή䡢ʤˤĤƤ', '', 'ե᡼ڡȤƷǺܤۤ쥸̤βɽս񤭤ȤƤǺܤޤ<br> ˡʸˤäƤν䡢ʸμ³ˡʤɤ򵭺ܤޤ', '1', '0', '0', '1', '', now());
INSERT INTO shop_info VALUES (3,'ΥȤˤĤ', 'SHOP_INFO_PRIVACY', 'ѾջĿ;ݸ˴ؤ뵬Ƥ', '', 'ե᡼ڡȤƷǺܤޤ<br> ˡΥȤѤˤäƤջ䡢Ŀ;μơŪ갷ˡˤĤƵܤޤ', '1', '0', '0', '1', '', now());
INSERT INTO shop_info VALUES (4,'ĶȤΤ', 'SHOP_INFO_CONDITIONS', '˱ĶȤΤƤ', '', 'ե᡼ڡȤƷǺܤޤ<br> ˡȼԤ̾Ρꡢֹ꾦ˡˤɽ̳դƤƤ䡢ŹޤαĶȰ򵭺ܤޤ', '1', '0', '0', '1', '', now());
INSERT INTO shop_info VALUES (5,'ʸǧ̤ս', 'SHOP_INFO_CHECKOUT_CONFIRMATION', 'ս񤭤Ƥ', '', '쥸κǽǧ̤ξɽޤ<br> ֺ߸ˤʤ⤢ޤΡäդ¥ɬפƤ򵭺ܤޤ', '0', '0', '0', '0', '', now());
INSERT INTO shop_info VALUES (6,'ʸλ̤ս', 'SHOP_INFO_CHECKOUT_SUCCESS', 'ʤ壱¤ΤΤ¿ᡢ<br>ʸʤŹˤƺ߸ˤǧΤ̾ĶǺ߸˲Υ᡼ꤷƤޤ<br>ʸϺ߸˲᡼򤴳ǧȤʤޤ', '', 'ʸλ̤ξɽޤ<br> ˡʸμ³ˡ򵭺ܤޤ', '0', '0', '0', '0', '', now());
INSERT INTO shop_info VALUES (7,'಼', 'SHOP_INFO_COLUMN_LEFT', '', '', 'βʸϤʤɤɲäȤ˻Ȥޤ', '0', '0', '0', '0', '', now());
INSERT INTO shop_info VALUES (8,'಼', 'SHOP_INFO_COLUMN_RIGHT', '', '', 'βʸϤʤɤɲäȤ˻Ȥޤ', '0', '0', '0', '0', '', now());
INSERT INTO shop_info VALUES (10,'᡼ν̾', 'SHOP_INFO_EMAIL_SIGNATURE', '', '', 'ΥȤ᡼ν̾ꤷƤ', '0', '0', '0', '2', '', now());
INSERT INTO shop_info VALUES (11,'СϿ꤬Ȥޤ', 'SHOP_INFO_EMAIL_WELCOME', 'ؤΥСϿˤ꤬Ȥޤ\n---------------------------------------------------------------------------\n\nΥ᡼ˤŹΤѰ⤬ܤƤޤΤǡɬ\nɤ\n\n---------------------------------------------------------------------------\nѰ\n---------------------------------------------------------------------------\nۡڡ˥󤹤뤳ȤǡΥӥѤˤʤޤ\n\nåԥ󥰥\n٥Ȥ줿ʤϡ뤫ʸޤǻĤƤޤ\nɥ쥹Ģ\nʸˤʤäʤ򡢤ʤΤʳˤ뤳ȤǤޤ\nʸ\nʸ줿ʤˤʤ뤳ȤǤޤ\n---------------------------------------------------------------------------', '', 'ͤΥȤزϿ˼ư᡼η̾ʸ̤ꤷƤ<br>᡼쥤Ȥϡ<ol><li>Ź̾</li><li>ʸ̡ʾ</li><li>䤤碌ѹԲġ</li><li>ջѹԲġ</li><li>ʸ̡ʲ</li><li>̾</li></ol>Ȥʤޤ', '1', '1', '0', '2', '', now());
INSERT INTO shop_info VALUES (12,'ʸ꤬Ȥޤʼưۿ᡼', 'SHOP_INFO_EMAIL_AUTO_REPLY', 'ؤʸ򤤤ޤơˤ꤬Ȥޤ\n\nƤˤĤơ߸ˤǧ头ޤ\nʤܥ᡼˵ܤ줿ʸƤθ䡢ޤ顢\nǤޤŹޤǤ䤤碌ޤ褦ꤤ夲ޤ\n', '', 'ͤʤȯ˼ư᡼η̾ʸ̤ꤷƤ<br>᡼쥤Ȥϡ<ol><li>Ź̾</li><li>ʸ̡ʾ</li><li>ʸơѹԲġ</li><li>ʸ̡ʲ</li><li>̾</li></ol>Ȥʤޤ', '1', '1', '0', '2', '', now());
INSERT INTO shop_info VALUES (13,'ʤ֤ΤΤ餻', 'SHOP_INFO_EMAIL_ORDER_RECEIVED_REPLY', '\n\nΤӤϤʸ꤬Ȥޤ\nʸʤϸߡΤȤ߸ˤݤƤޤ\n\nƤ򤴳ǧξ塢Ф⤯\nǧ褴ʤޤ', 'ʸʤϰ콵֤֤ޤ\nޤǤˤΤʤϡ󥻥밷ȤƤޤ\n\nʧ͹ؿؤޤ϶Կ\n͹ؿءxxxxx-x-xxxxx\n\nԿ\nŹ̡xxxxxxx\n\n̾ƥȽŹʶԡ͹ظ¶\n\n嵭ǧ塢Ҿˤȯޤ', 'ʧ˥᡼η̾ʸ̤ꤷƤ<br>᡼쥤Ȥϡ<ol><li>̾</li><li>ʸ̡ʾ</li><li>ơѹԲġ</li><li>ʸ̤Υ</li><li>ʸ̡ʲ</li><li>̾</li></ol>Ȥʤޤ', '1', '1', '0', '2', '', now());
INSERT INTO shop_info VALUES (14,'դΤǧ', 'SHOP_INFO_EMAIL_SEND_PRODUCTS_REPLY', '\n\nΤӤϤʸ꤬Ȥޤ\nʸʤϸߡΤȤ߸ˤݤƤޤ\nǧΤֻ򤤤衢ƱΤꤤޤ', 'ʸʤϰ콵֤֤ޤ\nޤǤˤϢΤʤϡ󥻥밷ȤƤޤ\n\nʧٳǧ˵ܤؤ⤯', 'ʸʧ˥᡼η̾ʸ̤ꤷƤ<br>᡼쥤Ȥϡ<ol><li>̾</li><li>ʸ̡ʾ</li><li>ơѹԲġ</li><li>ʸ̤Υ</li><li>ʸ̡ʲ</li><li>̾</li></ol>Ȥʤޤ', '1', '1', '0', '2', '', now());
INSERT INTO shop_info VALUES (15,'ڤͤӡڤΤΤ餻', 'SHOP_INFO_EMAIL_SOLD_OUT_REPLY', '\n\nΤӤϤʸ꤬Ȥޤ\nʸʤʤϡڤȤʤäƤޤ\nʸʤѿޤ', 'ĨޤȤ⤴ܤꤤޤ', 'ڤ줪ͤӥ᡼η̾ʸ̤ꤷƤ<br>᡼쥤Ȥϡ<ol><li>̾</li><li>ʸ̡ʾ</li><li>ơѹԲġ</li><li>ʸ̤Υ</li><li>ʸ̡ʲ</li><li>̾</li></ol>Ȥʤޤ', '1', '1', '0', '2', '', now());
INSERT INTO shop_info VALUES (16,'߸˳ǧΤΤ餻', 'SHOP_INFO_EMAIL_PENDING_REPLY', '\n\nΤӤϤʸ꤬Ȥޤ\nʸʤʤϡ߸˳ǧǤ\n߸˳ǧ衢٤ֻޤ\n\nλ', '', '߸˳ǧ᡼η̾ʸ̤ꤷƤ<br>᡼쥤Ȥϡ<ol><li>̾</li><li>ʸ̡ʾ</li><li>ơѹԲġ</li><li>ʸ̤Υ</li><li>ʸ̡ʲ</li><li>̾</li></ol>Ȥʤޤ', '1', '1', '0', '2', '', now());
INSERT INTO shop_info VALUES (17,'դΤǧ', 'SHOP_INFO_EMAIL_CODT_PAYMENT_REPLY', '\n\nΤӤϤʸ꤬Ȥޤ\nʸʤʤϡΤȤ߸ˤݤƤޤ\nǧΤֻ򤤤衢ˤƤꤤޤ', 'ʸʤϰ콵֤֤ޤ\nޤǤˤϢΤʤϡ󥻥밷ȤƤޤ', '˥᡼η̾ʸ̤ꤷƤ<br>᡼쥤Ȥϡ<ol><li>̾</li><li>ʸ̡ʾ</li><li>ơѹԲġ</li><li>ʸ̤Υ</li><li>ʸ̡ʲ</li><li>̾</li></ol>Ȥʤޤ', '1', '1', '0', '2', '', now());
INSERT INTO shop_info VALUES (18,'դΤǧʥ쥸åȡ', 'SHOP_INFO_EMAIL_CC_PAYMENT_REPLY', '\n\nΤӤϤʸ꤬Ȥޤ\nʸʤʤϡΤȤ߸ˤݤƤޤ\nǧΤֻ򤤤褪ꤤޤ\nʧϤˤꥯ쥸åȥɤǤƤޤ\nɤѹʤƱˤƤꤤޤΤǤǧ', 'ʸʤϰ콵֤֤ޤ\nޤǤˤϢΤʤϡ󥻥밷ȤƤޤ', 'ʥ쥸åȡ˥᡼η̾ʸ̤ꤷƤ<br>᡼쥤Ȥϡ<ol><li>̾</li><li>ʸ̡ʾ</li><li>ơѹԲġ</li><li>ʸ̤Υ</li><li>ʸ̡ʲ</li><li>̾</li></ol>Ȥʤޤ', '1', '1', '0', '2', '', now());

################################################################################
# admin authentication module for osCommerce 2.2
# Last Update: 2002/06/03
# Author(s): Naomi Suzukawa (suzukawa@bitscope.co.jp)

########################################
# 桼 ơ֥
#
DROP TABLE IF EXISTS users;
create table users (
    userid      char(16) not null,      ## 桼ID
    password    varchar(64) not null,   ## ѥ
    name        varchar(64),            ## ̾
    email       varchar(96),            ## E-mail
    primary key(userid)
);

########################################
# 桼 ơ֥
#
DROP TABLE IF EXISTS permissions;
create table permissions (
    userid      char(16) not null,      ## 桼ID
    permission  int default '0',        ## 
    primary key(userid)
);

########################################
# 󡦥 ơ֥
#
DROP TABLE IF EXISTS login;
create table login (
    sessionid       varchar(32) not null,           # åID
    logintime       datetime not null,              # 
    lastaccesstime  datetime not null,              # Ǹ˥
    account         char(16) default '',            # (桼ID)
    loginstatus     char,                           # 󥹥ơ
        # a:ǧ p:ѥ n: e:DB顼
    logoutstatus    char,                           # ȥơ
        # i: o: t:ॢ
    address         int,                            # IPɥ쥹(4 byte)
    primary key(sessionid),
    index login_logintime_index(logintime),
    index login_lastaccesstime_index(lastaccesstime),
    index login_loginstatus_index(loginstatus),
    index login_logoutstatus_index(logoutstatus)
);
