<?php
/*
  $Id: account_history_info.php,v 1.7 2007/06/12 06:02:03 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

  if (!isset($HTTP_GET_VARS['order_id'])) {
    tep_redirect(tep_href_link(FILENAME_HISTORY, '', 'SSL'));
  }
  
  $customer_number_query = tep_db_query("select customers_id from " . TABLE_ORDERS . " where orders_id = '". tep_db_input(tep_db_prepare_input($HTTP_GET_VARS['order_id'])) . "'");
  $customer_number = tep_db_fetch_array($customer_number_query);
  if ($customer_number['customers_id'] != $customer_id) {
    tep_redirect(tep_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
  }

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_ACCOUNT_HISTORY_INFO);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_3, tep_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $HTTP_GET_VARS['order_id'], 'SSL'));

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order($HTTP_GET_VARS['order_id']);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" /> 
<meta http-equiv="content-style-type" content="text/css" />
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>" />
<link rel="stylesheet" type="text/css" href="general.css" media="screen,print" />
<link rel="stylesheet" type="text/css" href="<?php echo substr(FILENAME_ACCOUNT_HISTORY_INFO, 0, strrpos(FILENAME_ACCOUNT_HISTORY_INFO, '.'));?>.css" media="screen,print" />
</head>
<body>
<div id="container">
<!-- header -->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- /header -->
<hr />
<!-- contents -->
<div id="contents">
<!-- left_contents -->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- /left_contents -->
<hr />
<!-- right_contents -->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- /right_contents -->
<hr />
<!-- main_contents -->
<div id="mainContents">
<p class="hide"><a id="skipped" name="skipped" title="<?php echo TEXT_NAVISKIPPED; ?>"><?php echo TEXT_NAVISKIPPED; ?></a></p> 
<h2 class="pageHeading"><?php echo HEADING_TITLE; ?></h2>
<div id="accountHistory">
<div class="contentBoxHeader">
<p class="leftBox"><?php echo sprintf(HEADING_ORDER_NUMBER, $HTTP_GET_VARS['order_id']); ?></p>
<?php
  if (KN_CFG_USE_ORDER_HISTORY == 'true') {
?>
<p class="rightBox"><?php echo $order->info['orders_status']; ?></p>
<?php
  }
?>
</div>
<div class="contentBoxHeader">
<p class="leftBox"><?php echo HEADING_ORDER_DATE . ' ' . tep_date_long($order->info['date_purchased']); ?></p>
<p class="rightBox"><?php echo HEADING_ORDER_TOTAL . ' ' . $order->info['total']; ?></p>
</div>

<table border="0" class="productsTable">
<?php
  if (sizeof($order->info['tax_groups']) > 1) {
?>
<tr>
<th colspan="3"><?php echo HEADING_PRODUCTS; ?></th>
<th><?php echo HEADING_TAX; ?></th>
<th><?php echo HEADING_TOTAL; ?></th>
</tr>
<?php
  } else {
?>
<tr>
<th colspan="3"><?php echo HEADING_PRODUCTS; ?></th>
<th><?php echo HEADING_TOTAL; ?></th>
</tr>
<?php
  }

  for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
    echo '<tr>' . "\n" .
         '<td class="quantity"><p>' . $order->products[$i]['qty'] . 'x</p></td>' . "\n" .
         '<td class="product"><p>' . $order->products[$i]['name'];
    if ( (isset($order->products[$i]['attributes'])) && (sizeof($order->products[$i]['attributes']) > 0) ) {
      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
        echo '<br /><span class="options"> - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'] . '</span>';
      }
    }

    echo '</p></td>' . "\n";
    echo '<td><p>';
    if ((KN_CFG_USE_SUBTITLE == 'true') && !empty($order->products[$i]['subtitle'])) {
      echo $order->products[$i]['subtitle'] . ' ';
    }
    if ((KN_CFG_USE_SERIES_TITLE == 'true') && !empty($order->products[$i]['series_title'])) {
      echo $order->products[$i]['series_title'] . ' ';
    }
    if ((KN_CFG_USE_AUTHOR == 'true') && !empty($order->products[$i]['author'])) {
      echo $order->products[$i]['author'] . ' ';
    }
    if ((KN_CFG_USE_PUBLISHERS == 'true') && !empty($order->products[$i]['publishers'])) {
      echo $order->products[$i]['publishers'] . ' ';
    }
    if ((KN_CFG_USE_VOLUME == 'true') && !empty($order->products[$i]['volume'])) {
      echo $order->products[$i]['volume'] . ' ';
    }
    if ((KN_CFG_USE_PUBLISHED == 'true') && !empty($order->products[$i]['published'])) {
      echo $order->products[$i]['published'] . ' ';
    }
    echo $order->products[$i]['description'] . '</p></td>' . "\n";

    if (sizeof($order->info['tax_groups']) > 1) echo '<td class="tax"><p>' . tep_display_tax_value($order->products[$i]['tax']) . '%</p></td>' . "\n";

    echo '<td class="price"><p>' . $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']) . '</p></td>' . "\n" .
         '</tr>' . "\n";
  }
  echo "</table>\n";

  if (sizeof($order->totals)) {
    echo '<dl class="ordersTotal">' . "\n";
    for ($i=0, $n=sizeof($order->totals); $i<$n; $i++) {
      if (($order->totals[$i]['class'] == 'ot_addition') && ($order->totals[$i]['value'] == 0)) continue;
      if (($order->totals[$i]['class'] == 'ot_discount') && ($order->totals[$i]['value'] == 0)) continue;
      echo '<dt>' . $order->totals[$i]['title'] . '</dt>' . "\n" .
             '<dd>' . $order->totals[$i]['text'] . '</dd>' . "\n";
    }
    echo "</dl>\n";
  }
?>
<h3><?php echo HEADING_SHIPPING_AND_PAYMENT_INFORMATION; ?></h3>
<div id="customerInfo">
<div id="shipping">
<?php
  if ($order->delivery != false) {
?>
<h4><?php echo HEADING_DELIVERY_ADDRESS; ?></h4>
<p><?php echo tep_address_format($order->delivery['format_id'], $order->delivery, 1, ' ', '<br />'); ?></p>
<?php
  }
  if ($order->info['shipping_method']) {
?>
<h4><?php echo HEADING_SHIPPING_METHOD; ?></h4>
<p><?php echo $order->info['shipping_method']; ?></p>
<?php
  }
?>
</div>
<div id="payment">
<h4><?php echo HEADING_BILLING_ADDRESS; ?></h4>
<p><?php echo tep_address_format($order->billing['format_id'], $order->billing, 1, ' ', '<br />'); ?></p>
<?php
  if ($order->info['payment_method']) {
?>
<h4><?php echo HEADING_PAYMENT_METHOD; ?></h4>
<p><?php echo $order->info['payment_method']; ?></p>
<?php
  }
?>
</div>
</div>

<?php
  if (KN_CFG_USE_ORDER_HISTORY == 'true') {
?>
<h3><?php echo HEADING_ORDER_HISTORY; ?></h3>
<table border="0">
<?php
    $statuses_query = tep_db_query("select os.orders_status_name, osh.date_added, osh.comments from " . TABLE_ORDERS_STATUS . " os, " . TABLE_ORDERS_STATUS_HISTORY . " osh where osh.orders_id = '" . (int)$HTTP_GET_VARS['order_id'] . "' and osh.orders_status_id = os.orders_status_id and os.language_id = '" . (int)$languages_id . "' order by osh.date_added");
    while ($statuses = tep_db_fetch_array($statuses_query)) {
      echo '<tr>' . "\n" .
             '<td>' . tep_date_short($statuses['date_added']) . '</td>' . "\n" .
             '<td>' . $statuses['orders_status_name'] . '</td>' . "\n" .
             '<td>' . (empty($statuses['comments']) ? '&nbsp;' : nl2br(htmlspecialchars($statuses['comments']))) . '</td>' . "\n" .
             '</tr>' . "\n";
    }
?>
</table>
<?php
  }

  if (DOWNLOAD_ENABLED == 'true') include(DIR_WS_MODULES . 'downloads.php');
?>
<div class="buttonLine">
<p class="buttonLeft"><?php echo '<a href="' . tep_href_link(FILENAME_ACCOUNT_HISTORY, tep_get_all_get_params(array('order_id')), 'SSL') . '">' . tep_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>'; ?></p>
</div>
</div>
</div>
<!-- /main_contents -->
</div>
<!-- /contents -->
<hr />
<!-- footer -->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- /footer -->
</div>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
