<?php
/*
  $Id: checkout_confirmation_short.php,v 1.7 2007/06/12 06:02:03 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

// if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot(array('mode' => 'SSL', 'page' => FILENAME_CHECKOUT_SHIPPING));
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

// avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
    if ($cart->cartID != $cartID) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }

// if no shipping destination address was selected, use the customers own address as default
  if (!tep_session_is_registered('sendto')) {
    tep_session_register('sendto');
    $sendto = $customer_default_address_id;
  } else {
// verify the selected shipping address
    $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customer_id . "' and address_book_id = '" . (int)$sendto . "'");
    $check_address = tep_db_fetch_array($check_address_query);

    if ($check_address['total'] != '1') {
      $sendto = $customer_default_address_id;
      if (tep_session_is_registered('shipping')) tep_session_unregister('shipping');
    }
  }

// if no billing destination address was selected, use the customers own address as default
  if (!tep_session_is_registered('billto')) {
    tep_session_register('billto');
    $billto = $customer_default_address_id;
  } else {
// verify the selected billing address
    $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customer_id . "' and address_book_id = '" . (int)$billto . "'");
    $check_address = tep_db_fetch_array($check_address_query);

    if ($check_address['total'] != '1') {
      $billto = $customer_default_address_id;
      if (tep_session_is_registered('payment')) tep_session_unregister('payment');
    }
  }

  if (!tep_session_is_registered('comments')) tep_session_register('comments');

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

  require(DIR_WS_CLASSES . 'order_total.php');
  $order_total_modules = new order_total;

// Stock Check
  $any_out_of_stock = false;
  if (STOCK_CHECK == 'true') {
    for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
      if (tep_check_stock($order->products[$i]['id'], $order->products[$i]['qty'])) {
        $any_out_of_stock = true;
      }
    }
    // Out of Stock
    if ( (STOCK_ALLOW_CHECKOUT != 'true') && ($any_out_of_stock == true) ) {
      tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
    }
  }

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_CONFIRMATION_SHORT);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" /> 
<meta http-equiv="content-style-type" content="text/css" />
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>" />
<link rel="stylesheet" type="text/css" href="general.css" media="screen,print" />
<link rel="stylesheet" type="text/css" href="<?php echo substr(FILENAME_CHECKOUT_CONFIRMATION_SHORT, 0, strrpos(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '.'));?>.css" media="screen,print" />
</head>
<body>
<div id="container">
<!-- header -->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- /header -->
<hr />
<!-- contents -->
<div id="contents">
<!-- left_contents -->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- /left_contents -->
<hr />
<!-- right_contents -->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- /right_contents -->
<hr />
<!-- main_contents -->
<div id="mainContents">
<p class="hide"><a id="skipped" name="skipped" title="<?php echo TEXT_NAVISKIPPED; ?>"><?php echo TEXT_NAVISKIPPED; ?></a></p> 
<h2 class="pageHeading"><?php echo HEADING_TITLE; ?></h2>
<div id="checkout">
<?php
  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_CHECKOUT_CONFIRMATION'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  if (isset($shop_info['shop_info_value']) && tep_not_null($shop_info['shop_info_value'])) {
    echo '<div class="information"><p>';
    if ($shop_info['allow_tags']) {
      echo $shop_info['shop_info_value'];
    } else {
      echo nl2br(htmlspecialchars($shop_info['shop_info_value']));
    }
    echo "</p></div>\n";
  }
?>
<h3><?php echo HEADING_PRODUCTS_INFORMATION; ?></h3>
<p class="orderEdit"><?php echo '<a href="' . tep_href_link(FILENAME_SHOPPING_CART) . '">' . TEXT_EDIT . '</a>'; ?></p>
<table class="productsTable">
<?php
  if (sizeof($order->info['tax_groups']) > 1) {
?>
<tr>
<th colspan="3"><?php echo HEADING_PRODUCTS; ?></th>
<th><?php echo HEADING_TAX; ?></th>
<th><?php echo HEADING_TOTAL; ?></th>
</tr>
<?php
  } else {
?>
<tr>
<th colspan="4"><?php echo HEADING_PRODUCTS; ?></th>
</tr>
<?php
  }

  for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
    echo '<tr>' . "\n" .
         '<td class="quantity"><p>' . $order->products[$i]['qty'] . '&nbsp;x</p></td>' . "\n" .
         '<td class="product"><p>' . $order->products[$i]['name'];

    if (STOCK_CHECK == 'true') {
      echo tep_check_stock($order->products[$i]['id'], $order->products[$i]['qty']);
    }

    if ( (isset($order->products[$i]['attributes'])) && (sizeof($order->products[$i]['attributes']) > 0) ) {
      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
        echo '<br /><span class="options"> - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'] . '</span>';
      }
    }

    echo '</p></td>' . "\n";
    echo '<td><p>';
    if ((KN_CFG_USE_SUBTITLE == 'true') && !empty($order->products[$i]['subtitle'])) {
      echo $order->products[$i]['subtitle'] . '&nbsp;';
    }
    if ((KN_CFG_USE_SERIES_TITLE == 'true') && !empty($order->products[$i]['series_title'])) {
      echo $order->products[$i]['series_title'] . '&nbsp;';
    }
    if ((KN_CFG_USE_AUTHOR == 'true') && !empty($order->products[$i]['author'])) {
      echo $order->products[$i]['author'] . '&nbsp;';
    }
    if ((KN_CFG_USE_PUBLISHERS == 'true') && !empty($order->products[$i]['publishers'])) {
      echo $order->products[$i]['publishers'] . '&nbsp;';
    }
    if ((KN_CFG_USE_VOLUME == 'true') && !empty($order->products[$i]['volume'])) {
      echo $order->products[$i]['volume'] . '&nbsp;';
    }
    if ((KN_CFG_USE_PUBLISHED == 'true') && !empty($order->products[$i]['published'])) {
      echo $order->products[$i]['published'] . '&nbsp;';
    }
    echo $order->products[$i]['description'] . '</p></td>' . "\n";

    if (sizeof($order->info['tax_groups']) > 1) echo '<td class="tax"><p>' . tep_display_tax_value($order->products[$i]['tax']) . '%</p></td>' . "\n";

    echo '<td class="price"><p>' . $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']) . '</p></td>' . "\n";
    echo '</tr>' . "\n";
  }
  
  echo "</table>\n";

  if (MODULE_ORDER_TOTAL_INSTALLED) {
    $order_total_modules->process();
    echo $order_total_modules->output();
  }
?>
<h3><?php echo HEADING_CUSTOMER_INFORMATION; ?></h3>
<div id="contentsBox">
<div id="leftBox">
<h4><?php echo HEADING_DELIVERY_ADDRESS; ?></h4>
<p class="orderEdit"><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS_SHORT, '', 'SSL') . '">' . TEXT_EDIT . '</a>'; ?></p>
<p><?php echo tep_address_format($order->delivery['format_id'], $order->delivery, 1, ' ', '<br />'); ?></p>
</div>
<div id="rightBox">
<h4><?php echo HEADING_BILLING_ADDRESS; ?></h4>
<p class="orderEdit"><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT_ADDRESS_SHORT, '', 'SSL') . '">' . TEXT_EDIT . '</a>'; ?></p>
<p><?php echo tep_address_format($order->billing['format_id'], $order->billing, 1, ' ', '<br />'); ?></p>
</div>
</div>
<?php echo tep_draw_form('checkout_confirmation', tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL'), 'post') . "\n"; ?>
<h3><?php echo HEADING_ORDER_COMMENTS; ?></h3>
<p><?php echo tep_draw_textarea_field('comments', 'soft', '60', '5'); ?></p>
<div class="buttonLine">
<p class="buttonRight"><?php echo tep_image_submit('button_confirm_order.gif', IMAGE_BUTTON_CONFIRM_ORDER);?></p>
</div>
</form>
<?php
  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_SHIPPING'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  if (isset($shop_info['shop_info_value']) && tep_not_null($shop_info['shop_info_value'])) {
    echo '<h3>' . HEADING_ORDER_NOTES . '</h3>' . "\n";
    echo '<p>';
    if ($shop_info['allow_tags']) {
      echo $shop_info['shop_info_value'];
    } else {
      echo nl2br(htmlspecialchars($shop_info['shop_info_value']));
    }
    echo "</p>\n";
  }
 ?>
</div>
</div>
<!-- /main_contents -->
</div>
<!-- /contents -->
<hr />
<!-- footer -->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- /footer -->
</div>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
