<?php
/*
  $Id: visit.php,v 1.1 2006/06/12 09:31:31 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  class visit {
    var $code, $title, $description, $icon, $enabled;

// class constructor
    function visit() {
      global $order;

      $this->code = 'visit';
      $this->title = MODULE_SHIPPING_VISIT_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_VISIT_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_SHIPPING_VISIT_SORT_ORDER;
      $this->icon = '';
      $this->tax_class = MODULE_SHIPPING_VISIT_TAX_CLASS;
      $this->enabled = ((MODULE_SHIPPING_VISIT_STATUS == 'True') ? true : false);

    }

// class methods
    function quote($method = '') {
      global $order, $total_count;

      $this->quotes = array('id' => $this->code,
                            'module' => MODULE_SHIPPING_VISIT_TEXT_TITLE,
                            'methods' => array(array('id' => $this->code,
                                                     'title' => MODULE_SHIPPING_VISIT_TEXT_WAY,
                                                     'cost' => 0)));

      if ($this->tax_class > 0) {
        $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
      }

      if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);

      return $this->quotes;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_VISIT_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ˡ', 'MODULE_SHIPPING_VISIT_TEXT_TITLE', 'Ź', 'ˡ̾', '6', '11', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ӥ', 'MODULE_SHIPPING_VISIT_TEXT_WAY', 'Źˤ뤪', 'ӥ̾', '6', '12', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Źˤ뤪ͭˤ', 'MODULE_SHIPPING_VISIT_STATUS', 'True', 'Ĥˤ󶡤ޤ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ɽ', 'MODULE_SHIPPING_VISIT_SORT_ORDER', '0', 'ɽǤޤۤɾ̤ɽޤ.', '6', '0', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_SHIPPING_VISIT_TEXT_TITLE', 'MODULE_SHIPPING_VISIT_TEXT_WAY', 'MODULE_SHIPPING_VISIT_STATUS', 'MODULE_SHIPPING_VISIT_SORT_ORDER');
    }
  }
?>
