<?php
/*
  $Id: product_info.php,v 1.11 2009/04/14 23:51:23 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_PRODUCT_INFO);

  $please_contact_us = false;
  $meta_discription = '';
  $meta_keywords = '';
  $product_info_query = tep_db_query("select p.products_id, pd.products_name, pd.products_subtitle, pd.products_series_title, pd.products_author, pd.products_published, pd.products_publishers, pd.products_volume, p.products_isbn, pd.products_description, pd.products_description2, pd.products_keywords, p.products_model, p.products_quantity, p.products_image, pd.products_url, p.products_price, p.products_tax_class_id, p.products_date_added, p.products_date_available, p.manufacturers_id from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_status = '1' and p.products_id = '" . (int)$HTTP_GET_VARS['products_id'] . "' and pd.products_id = p.products_id and pd.language_id = '" . (int)$languages_id . "'");
  if (!tep_db_num_rows($product_info_query)) { // product not found in database
    header("HTTP/1.1 404 Not Found");
    $no_product_info = true;
    $product_info_title = TITLE;
  } else {
    $no_product_info = false;
    $product_info = tep_db_fetch_array($product_info_query);
    $product_info_title = TITLE . ' : ' . $product_info['products_name'];
    if ($product_info['products_description2']) {
      if (mb_strlen($product_info['products_description2']) > 200) {
        $meta_description = mb_substr(@strip_tags($product_info['products_description2']), 0, 200);
      } else {
        $meta_description = @strip_tags($product_info['products_description2']);
      }
    }
    if ($product_info['products_keywords']) {
      $meta_keywords = implode(",", explode(" ", $product_info['products_keywords']));
    }
    if ((KN_CFG_CONTACT_PRICE != 0) && ($product_info['products_price'] == KN_CFG_CONTACT_PRICE)) {
      $please_contact_us = true;
      $sjis_p_name = mb_convert_encoding($product_info['products_name'], "SJIS", "EUC-JP");
      $sjis_p_email_subject = mb_convert_encoding(KN_CFG_CONTACT_PRICE_EMAIL_SUBJECT, "SJIS", "EUC-JP");
      $sjis_p_email_body = mb_convert_encoding(KN_CFG_CONTACT_PRICE_EMAIL_BODY, "SJIS", "EUC-JP");
      $email_subject = rawurlencode($sjis_p_email_subject) . rawurlencode($sjis_p_name);
      $email_body = rawurlencode($sjis_p_email_body);
    }
  }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" /> 
<meta http-equiv="content-style-type" content="text/css" />
<title><?php echo $product_info_title; ?></title>
<meta name="description" content="<?php echo $meta_description; ?>" />
<meta name="keywords" content="<?php echo $meta_keywords; ?>" />
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>" />
<link rel="stylesheet" type="text/css" href="general.css" media="screen,print" />
<?php 
  $customCSS = substr(FILENAME_PRODUCT_INFO, 0, strrpos(FILENAME_PRODUCT_INFO, '.')). ".css";
  if (file_exists($customCSS)){
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"$customCSS\" media=\"screen,print\" />";
  }
?>
<script language="javascript"><!--
function popupWindow(url) {
  window.open(url,'popupWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=yes,copyhistory=no,width=100,height=100,screenX=150,screenY=150,top=150,left=150')
}
//--></script>
</head>
<body>
<div id="container">
<!-- header -->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- /header -->
<hr />
<!-- contents -->
<div id="contents">
<!-- left_contents -->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- /left_contents -->
<hr />
<!-- right_contents -->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- /right_contents -->
<hr />
<!-- main_contents -->
<div id="mainContents">
<p class="hide"><a id="skipped" name="skipped" title="<?php echo TEXT_NAVISKIPPED; ?>"><?php echo TEXT_NAVISKIPPED; ?></a></p> 
<?php
  if ($no_product_info) {
    // ʤʤȤ
?>
<div id="productInfo">
<p class="noData"><?php echo TEXT_PRODUCT_NOT_FOUND; ?></p>
<div class="buttonLine">
<p class="buttonRight"><a href="<?php echo tep_href_link(FILENAME_DEFAULT); ?>"><?php echo tep_image_button('button_continue.gif', IMAGE_BUTTON_CONTINUE); ?></a></p>
</div>
</div>
<?php
  } else {
    tep_db_query("update " . TABLE_PRODUCTS_DESCRIPTION . " set products_viewed = products_viewed+1 where products_id = '" . (int)$HTTP_GET_VARS['products_id'] . "' and language_id = '" . (int)$languages_id . "'");
?>
<div id="productInfo">
<h2 class="pageHeading"><?php echo $product_info['products_name']; ?></h2>
<?php
    if ((KN_CFG_USE_SUBTITLE == 'true') && ($product_info['products_subtitle'])) {
    	$products_subtitle = '<span class="pSubtitle">' . TEXT_PRODUCTS_SUBTITLE . $product_info['products_subtitle'] . '</span>';
    } else {
    	$products_subtitle = '';
    }
    if ((KN_CFG_USE_SERIES_TITLE == 'true') && ($product_info['products_series_title'])) {
    	$products_series_title = '<span class="pSeriesTitle">' . TEXT_PRODUCTS_SERIES_TITLE . $product_info['products_series_title'] . '</span>';
    } else {
    	$products_series_title = '';
    }
    if (tep_not_null($products_subtitle) and tep_not_null($products_series_title)) {
      echo '<p>' . $products_subtitle . ' ' . $products_series_title . '</p>' . "\n";
    } elseif (tep_not_null($products_subtitle)) {
      echo '<p>' . $products_subtitle . '</p>' . "\n";
    } elseif (tep_not_null($products_series_title)) {
      echo '<p>' . $products_series_title . '</p>' . "\n";
    }
    echo tep_draw_form('cart_quantity', tep_href_link(FILENAME_PRODUCT_INFO, tep_get_all_get_params(array('action')) . 'action=add_product'));

    if (tep_not_null($product_info['products_image'])) {
?>
<div class="pImage">
<script language="javascript"><!--
document.write('<?php echo '<a href="javascript:popupWindow(\\\'' . tep_href_link(FILENAME_POPUP_IMAGE, 'pID=' . $product_info['products_id']) . '\\\')">' . tep_image(DIR_WS_IMAGES . $product_info['products_image'], addslashes($product_info['products_name']), SUBCATEGORY_IMAGE_WIDTH, SUBCATEGORY_IMAGE_HEIGHT) . '<br />' . TEXT_CLICK_TO_ENLARGE . '</a>'; ?>');
//--></script>
<noscript>
<?php echo '<a href="' . tep_href_link(DIR_WS_IMAGES . $product_info['products_image']) . '">' . tep_image(DIR_WS_IMAGES . $product_info['products_image'], $product_info['products_name'], SUBCATEGORY_IMAGE_WIDTH, SUBCATEGORY_IMAGE_HEIGHT) . '<br />' . TEXT_CLICK_TO_ENLARGE . '</a>'; ?>
</noscript>
</div>
<?php
    }

    echo '<dl class="specification">' . "\n";
    if ((KN_CFG_USE_AUTHOR == 'true') && ($product_info['products_author'])) {
      echo '<dt>' . TEXT_PRODUCTS_AUTHOR . '</dt><dd class="pAuthor">' . $product_info['products_author'] . '</dd>' . "\n";
    }
    if ((KN_CFG_USE_PUBLISHERS == 'true') && ($product_info['products_publishers'])) {
      echo '<dt>' . TEXT_PRODUCTS_PUBLISHERS . '</dt><dd class="pPublishers">' . $product_info['products_publishers'] . '</dd>' . "\n";
    }
    if ((KN_CFG_USE_VOLUME == 'true') && ($product_info['products_volume'])) {
      echo '<dt>' . TEXT_PRODUCTS_VOLUME . '</dt><dd class="pVolume">' . $product_info['products_volume'] . '</dd>' . "\n";
    }
    if ((KN_CFG_USE_PUBLISHED == 'true') && ($product_info['products_published'])) {
      echo '<dt>' . TEXT_PRODUCTS_PUBLISHED . '</dt><dd class="pPublished">' . $product_info['products_published'] . '</dd>' . "\n";
    }
    if ((KN_CFG_USE_ISBN == 'true') && ($product_info['products_isbn'])) {
      echo '<dt>' . TEXT_PRODUCTS_ISBN . '</dt><dd class="pIsbn">' . $product_info['products_isbn'] . '</dd>' . "\n";
    }
    echo '</dl>' . "\n";

    if ($product_info['products_description']) {
      echo '<p class="pDescription">' . TEXT_PRODUCTS_DESCRIPTION . nl2br(stripslashes($product_info['products_description'])) . '</p>' . "\n";
    }
    if ((KN_CFG_USE_DESCRIPTION2 == 'true') && ($product_info['products_description2'])) {
      echo '<p class="pDescription2">' . TEXT_PRODUCTS_DESCRIPTION2 . nl2br(stripslashes($product_info['products_description2'])) . '</p>' . "\n";
    }

    echo '<dl class="specification2">' . "\n";
    $products_attributes_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_ATTRIBUTES . " patrib where patrib.products_id='" . (int)$HTTP_GET_VARS['products_id'] . "' and patrib.options_id = popt.products_options_id and popt.language_id = '" . (int)$languages_id . "'");
    $products_attributes = tep_db_fetch_array($products_attributes_query);
    if ($products_attributes['total'] > 0) {
      echo '<dt>' . TEXT_PRODUCT_OPTIONS . '</dt>' . "\n";
      $products_options_name_query = tep_db_query("select distinct popt.products_options_id, popt.products_options_name from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_ATTRIBUTES . " patrib where patrib.products_id='" . (int)$HTTP_GET_VARS['products_id'] . "' and patrib.options_id = popt.products_options_id and popt.language_id = '" . (int)$languages_id . "'");
      while ($products_options_name = tep_db_fetch_array($products_options_name_query)) {
        $selected = 0;
        $products_options_array = array();
        echo '<dd class="pOptions">' . $products_options_name['products_options_name'];
        $products_options_query = tep_db_query("select pov.products_options_values_id, pov.products_options_values_name, pa.options_values_price, pa.price_prefix from " . TABLE_PRODUCTS_ATTRIBUTES . " pa, " . TABLE_PRODUCTS_OPTIONS_VALUES . " pov where pa.products_id = '" . (int)$HTTP_GET_VARS['products_id'] . "' and pa.options_id = '" . (int)$products_options_name['products_options_id'] . "' and pa.options_values_id = pov.products_options_values_id and pov.language_id = '" . (int)$languages_id . "'");
        while ($products_options = tep_db_fetch_array($products_options_query)) {
          $products_options_array[] = array('id' => $products_options['products_options_values_id'], 'text' => $products_options['products_options_values_name']);
          if ($products_options['options_values_price'] != '0') {
            $products_options_array[sizeof($products_options_array)-1]['text'] .= ' (' . $products_options['price_prefix'] . $currencies->display_price($products_options['options_values_price'], tep_get_tax_rate($product_info['products_tax_class_id'])) .') ';
          }
        }
        echo tep_draw_pull_down_menu('id[' . $products_options_name['products_options_id'] . ']', $products_options_array, $cart->contents[$HTTP_GET_VARS['products_id']]['attributes'][$products_options_name['products_options_id']]);
        echo "</dd>\n";
      }
    }
    if ((KN_CFG_USE_WEIGHT == 'true') && ($product_info['products_weight'])) {
      echo '<dt>' . TEXT_PRODUCTS_WEIGHT . '</dt><dd class="pWeight">' . $product_info['products_weight'] . '</dd>' . "\n";
    }
    if (KN_CFG_USE_REVIEWS == 'true') {
      $reviews = tep_db_query("select count(*) as count from " . TABLE_REVIEWS . " where products_id = '" . (int)$HTTP_GET_VARS['products_id'] . "'");
      $reviews_values = tep_db_fetch_array($reviews);
      if ($reviews_values['count'] > 0) {
        echo '<dt>' . TEXT_CURRENT_REVIEWS . '</dt><dd class="pReviews">' . $reviews_values['count'] . '</dd>' . "\n";
      }
    }
    if ($product_info['products_model']) {
      echo '<dt>' . TEXT_PRODUCTS_MODEL . '</dt><dd class="pModel">' . $product_info['products_model'] . '</dd>' . "\n";
    }
    if ($please_contact_us) {
      if (defined("KN_CFG_CONTACT_BY_EMAIL") && (KN_CFG_CONTACT_BY_EMAIL == 'false')) {
        echo '<dt>' . TEXT_PRODUCTS_PRICE . '</dt><dd class="pPrice">' . KN_CFG_CONTACT_PRICE_TEXT . '</dd>' . "\n";
      } else {
        echo '<dt>' . TEXT_PRODUCTS_PRICE . '</dt><dd class="pPrice"><a href="mailto:' . STORE_OWNER_EMAIL_ADDRESS . '?subject=' . $email_subject . '&body=' . $email_body . '">' . KN_CFG_CONTACT_PRICE_TEXT . '</a></dd>' . "\n";
      }
    } else {
      if ($new_price = tep_get_products_special_price($product_info['products_id'])) {
        echo '<dt>' . TEXT_PRODUCTS_PRICE . '</dt><dd class="pPrice"><del>' . $currencies->display_price($product_info['products_price'], tep_get_tax_rate($product_info['products_tax_class_id'])) . '</del> <span class="specialPrice">' . $currencies->display_price($new_price, tep_get_tax_rate($product_info['products_tax_class_id'])) . '</span></dd>' . "\n";
      } else {
        echo '<dt>' . TEXT_PRODUCTS_PRICE . '</dt><dd class="pPrice">' . $currencies->display_price($product_info['products_price'], tep_get_tax_rate($product_info['products_tax_class_id'])) . '</dd>' . "\n";
      }
    }
    echo '</dl>' . "\n";
?>
<div class="buttonLine">
<?php
    if (KN_CFG_USE_REVIEWS == 'true') {
      $reviews = tep_db_query("select count(*) as count from " . TABLE_REVIEWS . " where products_id = '" . (int)$HTTP_GET_VARS['products_id'] . "'");
      $reviews_values = tep_db_fetch_array($reviews);
      if ($reviews_values['count'] > 0) {
?>
<p class="buttonLeft"><a href="<?php echo tep_href_link(FILENAME_PRODUCT_REVIEWS, substr(tep_get_all_get_params(), 0, -1)); ?>"><?php echo tep_image_button('button_reviews.gif', IMAGE_BUTTON_REVIEWS); ?></a></p>
<?php
      }
    }
    if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
?>
<p class="buttonRight"></p>
<?php
    } else {
      if ($please_contact_us) {
?>
<p class="buttonRight"></p>
<?php
      } else {
?>
<p class="buttonRight"><?php echo tep_draw_hidden_field('products_id', $product_info['products_id']) . tep_image_submit('button_in_cart.gif', IMAGE_BUTTON_IN_CART); ?></p>
<?php
      }
    }
?>
</div>
<?php
    if ((KN_CFG_USE_URL == 'true') && (tep_not_null($product_info['products_url']))) {
      echo '<p>' . sprintf(TEXT_MORE_INFORMATION, tep_href_link(FILENAME_REDIRECT, 'action=url&goto=' . urlencode($product_info['products_url']), 'NONSSL', true, false)) . '</p>' . "\n";
    }

    if ((KN_CFG_USE_DATE_AVAILABLE == 'true') && ($product_info['products_date_available'] > date('Y-m-d H:i:s'))) {
      echo '<p class="caution">' . sprintf(TEXT_DATE_AVAILABLE, tep_date_long($product_info['products_date_available'])) . '</p>' . "\n";
    } else {
      if (KN_CFG_DATE_ADDED_DISPLAY == 'true') {
      echo '<p>' . sprintf(TEXT_DATE_ADDED, tep_date_long($product_info['products_date_added'])) . '</p>' . "\n";
      }
    }

    echo "</form>\n";

    if ((KN_CFG_GETA_ENABLED == 'true') && (KN_CFG_GETA_PRODUCTS_ENABLED == 'true')) {
      //GETAե
      require('../geta_work/geta_cfg.php');
      $g_products_id = (int)$HTTP_GET_VARS['products_id'];
      include(DIR_WS_MODULES . FILENAME_GETA_PRODUCTS);
    }

    if (KN_CFG_ALSO_PURCHASED_DISPLAY == 'true') {
      if ( (USE_CACHE == 'true') && !SID ) {
        echo tep_cache_also_purchased(3600);
      } else {
        include(DIR_WS_MODULES . FILENAME_ALSO_PURCHASED_PRODUCTS);
      }
    }
?>
</div>
<?php
  }
?>
</div>
<!-- /main_contents -->
</div>
<!-- /contents -->
<hr />
<!-- footer -->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- /footer -->
</div>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
