/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKTITEM_H_
#define _KKTITEM_H_

#include <qdom.h>
#include <qpixmap.h>

namespace KKTemplate
{
	class KKTItem
	{
	public:
		KKTItem( QString path );
		virtual ~KKTItem();

		const QString& filename(){ return m_filename; }
		const QPixmap& preview(){ return m_preview; }
		const QString& title(){ return m_title; }
		const QString& author(){ return m_author; }
		const QString& email(){ return m_email; }
		const QString& website(){ return m_website; }
		const QString& comment(){ return m_comment; }

	private:
		QString m_filename;
		QPixmap m_preview;
		QString m_title;
		QString m_author;
		QString m_email;
		QString m_website;
		QString m_comment;

		void readMetaData( const QString& filename );
	};
}
#endif /* _KKTITEM_H_ */
