/***************************************************************************
                          commonWgt.h  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef COMMONWGT_H
#define COMMONWGT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE

// forward declaration
class VarTbl;


/**
  * QButtonGroup Common Class
  */
class CButtonGroup : public QButtonGroup
{
  public:
    /** Constructor */
    CButtonGroup( const QString& s, QWidget* p );
};

/**
  * QGroupBox Common Class
  */
class CGroupBox : public QGroupBox
{
  public:
    /** Constructor */
    CGroupBox( const QString& s, QWidget* p );
};

/**
  * Frame Label
  */
class FrameLabel : public QLabel
{
  public:
    /** Constructor */
    FrameLabel( const QString& str, QWidget* p );
};

/**
  * Icon Push Button
  */
class IconPushButton : public QPushButton
{
  public:
    /** Constructor */
    IconPushButton( const QString& name, QWidget* p );
};

/**
  * User Select Combo Box
  */
class UserComboBox : public QComboBox
{
  public:
    /** Constructor */
    UserComboBox( QWidget *w );

    // User Type Flag
    enum UserSel { All, Current, AllowCron, AllowAt };

    // Set List
    bool setUser( UserSel );
};

#ifndef CRON_DILLON
/**
  * File Select Combo Box
  */
class FileComboBox : public QComboBox
{
  public:
    /** Constructor */
    FileComboBox( QWidget *w );

    // Initialize Combo Box
    void iniFile( const QString& user, CRONTYPE ctype );
    void setCurrent( CRONTYPE ctype );

};
#endif

/**
  * Variable List View Item
  */
class VarListViewItem : public QListViewItem
{
  public:
    /** Constructor */
    VarListViewItem( QListView *p, const QString& n, const QString& v, const QString& c);

    QString name;         // name
    QString value;        // value
    QString cmnt;         // comment
};

/**
  * Variable List View
  */
class VarListView : public QListView
{
  public:
    /** Constructor */
    VarListView( QWidget *w );

    // Set Variable from Varialize Table
    void setVar( QPtrList<VarTbl> *var );
};

#endif // COMMONWGT_H
