/***************************************************************************
                          kronekodoc.cpp  -  description
                             -------------------
    begin                :   2  8 00:43:28 JST 2003
    copyright            : (C) 2003 by kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>
#include <ctype.h>

// include files for Qt
#include <qstring.h>
#include <qdir.h>
#include <qwidget.h>
#include <qdatetime.h>
#include <qlistview.h>
#include <qfile.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qmessagebox.h>
#include <qtabwidget.h>
#include <qprogressbar.h>
#include <qregexp.h>
#include <qfileinfo.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include <ktempfile.h>

// application specific includes
#include "option.h"
#include "system.h"
#include "docTables.h"
#include "kroneconfig.h"
#include "listTabs.h"
#include "timeDlg.h"
#include "clockView.h"
#include "viewTabs.h"
#include "kronekodoc.h"
#include "kroneko.h"
#include "kronekoview.h"
#include "detailDlg.h"


extern Option*    g_Option;
extern QDateTime* g_CurTime;
extern bool       g_ViewMode;
//extern int        g_SecsNext;

QWaitCondition s_waitCond;
/////////////////////////////////////////////////////////////////////////////
// KronekoDoc - Doc Class

//
// Constructor
KronekoDoc::KronekoDoc(QWidget *parent, const char *name)
 : QObject(parent, name)
{

  // Set Auto Delete Tables
  userTbl.setAutoDelete( true );
  cronTbl.setAutoDelete( true );
  anacTbl.setAutoDelete( true );
  atTbl.setAutoDelete( true );

  // Current Select
  curEditCron = NULL;
  curEditAnac = NULL;
  curEditAt   = NULL;
  curStngItem = NULL;
  curExecItem = NULL;
  curLogItem  = NULL;
  newEditCron = new CronTbl();
  newEditAnac = new AnacTbl();
  newEditAt   = new AtTbl();

  curList = LIST_NONE;
  curView = VIEW_NONE;
  bUpdate = false;

  // Statistic Information
  cronUserNum = 0;
  atUserNum = 0;

  // Run Mode
#ifdef CRON_DILLON
  runMode = RUN_INIT;
#else
  runMode = RUN_INIT | RUN_LIST_LOG;
#endif
}

//
// Destructor
KronekoDoc::~KronekoDoc()
{
}

//
// Thread Wake
void KronekoDoc::pStart( int rmode )
{

  int cur = runMode;
  // Set Run Mode
  runMode = runMode | rmode;

  // Wake Thread
//  if( cur == 0 ) s_waitCond.wakeAll();
  if( cur == 0 ) s_waitCond.wakeOne();
  
}

//
// Set Progress Bar
void KronekoDoc::dspProgress( double d )
{
  int p = int( 100.0 * d );
  if ( p < 0 ) p = 0;
  else if ( p > 100 ) p = 100;
  getApp()->slotProgressBar( p );
  qApp->unlock();
  qApp->lock();
}

//
// Set Status Message
void KronekoDoc::dspStatusMsg( const QString& s )
{
  getApp()->slotStatusMsg( s );
  qApp->unlock();
  qApp->lock();
}

//
// Thread Start
void KronekoDoc::run()
{
  qApp->lock();

  while( true ){
    dspProgress( 1.0 );
    getApp()->slotStatusMsgTotal();
    dspStatusMsg(i18n("Ready."));
    
    qApp->unlock();
    if ( runMode == 0 ){
      // All Done.
      // Wati until Wake Actiion
      s_waitCond.wait();
    }
    qApp->lock();

    if ( runMode & RUN_EXIT ) {
      // Exit
      dspStatusMsg(i18n("Exiting..."));
      qApp->unlock();
      QApplication::exit();
      // Exit Thread
      break;
    }
    if ( runMode & RUN_GET ){
      // Get All Table Data
      runMode = runMode & ~RUN_GET;

      // Disable Edit And Select Cancel
      curEditCron = NULL;
      curEditAnac = NULL;
      curEditAt   = NULL;
      curStngItem = NULL;
      curExecItem = NULL;
      view->clockWgt->clrClock();
      if ( ! g_ViewMode ){
        view->cronEditWgt->setEnabled( false );
        if ( System::getAnacStatus() & ANAC_WRITABLE ) view->anacEditWgt->setEnabled( false );
        view->atEditWgt->setEnabled( false );
      }
      
      // Clear All Table Data
      userTbl.clear();
      cronTbl.clear();
      anacTbl.clear();
      atTbl.clear();
      view->stngLvw->clear();
      view->execLvw->clear();
      curStngItem = NULL;
      dspView();
      view->stngLvw->setSorting( -1 );

#ifndef CRON_DILLON
      // Get System 'crontab'
      if ( g_Option->useSyscron && ( System::access( g_Option->cronFileSys ) & CAN_READ ) ){
        dspStatusMsg(i18n("Loading System crontab ..."));
        getCron( "" );
      }
#endif
      if ( System::uid() == 0 ){

        // Get All User's 'crontab'
        dspStatusMsg(i18n("Loading User crontab ..."));
        QStringList sl = System::cronUsers();
        for ( QStringList::Iterator it = sl.begin(); it != sl.end(); ++it ) {
          getCron( *it );
        }
      }else{

        // Get User's 'crontab'
        if ( System::cronEnable() ){
          dspStatusMsg(i18n("Loading User crontab ..."));
          getCron( System::uName() );
        }
      }

      // Get 'anacrontab'
      if ( g_Option->useAnacron && ( System::access( g_Option->anacFileSys ) & CAN_READ ) ){
        dspStatusMsg(i18n("Loading anacrontab ..."));
        getAnac();
      }
      // Get 'at'
      if ( g_Option->useAt && ( System::atEnable() ) ){
        dspStatusMsg(i18n("Loading At Data ..."));
        getAt();
      }
      
      view->stngLvw->setSorting( 1 );
      QListViewItem *i = view->stngLvw->selectedItem();
      if ( i == NULL ){
        view->stngLvw->setSelected( view->stngLvw->firstChild(), true );
      }else{
        view->stngLvw->ensureItemVisible ( i );
      }
    } else if ( runMode & RUN_LIST_EXEC ){

      // Execute List Initialize
      runMode = runMode & ~RUN_LIST_EXEC;
      dspStatusMsg(i18n("Setting Execute List ..."));
      curExecItem = NULL;
      // Clear List
      view->execLvw->clear();
      dspView();

      // Initialize Execute List
      setExecView();
#ifndef CRON_DILLON
    } else if ( runMode & RUN_LIST_LOG ){

      // Log List Initialize
      runMode = runMode & ~RUN_LIST_LOG;
      if ( System::access( g_Option->logFile ) & CAN_READ  ){
        dspStatusMsg(i18n("Setting Log List ..."));
        curLogItem = NULL;
        // Clear List
        view->logLvw->clear();
        dspView();
        // Initialize Log List
        setLogView();
      }
#endif
    } else if ( runMode & RUN_LIST_TIME ){

      // Reset Next Time
      runMode = runMode & ~RUN_LIST_TIME;
      dspStatusMsg(i18n("Resetting Time ..."));
      dspProgress( 0.0 );

      // Reset Setting List
      view->stngLvw->setSorting( -1 );
      {
        for ( QListViewItemIterator it( view->stngLvw ); it.current(); ++it ){
          TabLvi *c = (TabLvi*)it.current();
          if ( c->dType == CRON ){
            c->Next = CronTime(c->cronTbl()).GetNextTime( *g_CurTime );
          }else if ( c->dType == ANACRON ){
            c->Next = CronTime(c->anacTbl()).GetNextTime( *g_CurTime );
          }else if ( c->dType == AT ){
            if ( c->Next <= *g_CurTime ){
              if ( curStngItem == c ){
                view->stngLvw->setSelected( curStngItem, false );
                curStngItem = NULL;
              }  
              view->stngLvw->takeItem( c );
            }
          }
        }
      }
      dspProgress( 0.4 );
      view->stngLvw->setSorting( 1 );

      // Reset Execute List
      {
        for ( QListViewItemIterator it( view->execLvw ); it.current(); ){
          TabLvi *c = (TabLvi*)it.current();
          if ( c->Next <= *g_CurTime ){
            // if Time Passed, Remove from List
            if ( curExecItem == c ) {
              view->execLvw->setSelected( curExecItem, false );
              curExecItem = NULL;
            }
            view->execLvw->takeItem( c );
#ifndef CRON_DILLON
            if ( g_Option->autoModLog ) runMode = runMode | RUN_LIST_LOG;
#endif
          }else{
            ++it;
          }
        }
      }
      dspProgress( 0.8 );
      if ( curExecItem == NULL ){
        // If Removed, Select First Item
        view->execLvw->setSelected( view->execLvw->firstChild(), true );
      }
      dspView();
    }
  }
}

//
// Add "# " to Comment String
QString KronekoDoc::setComment( const QString& c )
{
  QString s = c;
  while( s.find( QRegExp( "\\n$" ) ) != -1 ) s.replace( QRegExp("\\n$"), "" );
  if ( s != "" ){
    s = "# " + s;
    s.replace( QRegExp( "\\n" ), "\n# " );
    s = s + "\n";
  }
  return s;
}

//
// Set Ritch Text for error content
void KronekoDoc::dspErrText( const QString& str, int line )
{
  QString msg = "<pre><code>";
  msg = msg + str.section( "\n", 0, line-2 );
  msg = msg + "\n<font color=\"red\">";
  msg = msg + str.section( "\n", line-1, line-1 );
  msg = msg + "</font>\n";
  msg = msg + str.section( "\n", line );
  msg = msg + "</code></pre>";
  QMessageBox::information( getApp(), i18n("Error Display"), msg );
}

//
// Get 'crontab'
void KronekoDoc::getCron( const QString& usr )
{

  // Create Variable Table List
  QPtrList<VarTbl> *v = new QPtrList<VarTbl>;
  v->setAutoDelete( true );

  // Create User Table
  UserTbl *e = new UserTbl(CRON,usr, "", v);
  userTbl.append( e );
  cronUserNum = 0;

  dspProgress( 0.2 );
  QString cmd;
#ifdef CRON_DILLON
    // Users 'crontab'
    if ( System::uid() == 0 ){
      cmd = System::getCommand( "crontab" ) + " -l " + usr;
    }else{
      cmd = System::getCommand( "crontab" ) + " -l";
    }
#else
  if ( usr == "" ){
    // system 'crontab'
    cmd = "cat " + g_Option->cronFileSys;
  }else{
    // Users 'crontab'
    if ( System::uid() == 0 ){
      cmd = System::getCommand( "crontab" ) + " -u " + usr + " -l" ;
    }else{
      cmd = System::getCommand( "crontab" ) + " -l";
    }
  }
#endif

  // Do Command
  Command command(cmd);
#ifdef CRON_DILLON
  if ( command.exitStatus != 0 || command.errStr != "" ){
    e->Flag |= NO_DATA;
    return;
  }else{
    if ( usr != "" ) cronUserNum++;
  }
#else
  if ( command.exitStatus != 0 ){
    e->Flag |= NO_DATA;
    return;
  }else{
    if ( usr != "" ) cronUserNum++;
  }
#endif

  dspProgress( 0.4 );

  // Text -> String List
  QStringList slist = QStringList::split( '\n', command.outStr, true );

  QStringList::Iterator it=slist.begin();

  int line = 0;

#ifndef CRON_DILLON
#ifndef CRON_DEBIAN
  // if not system 'crontab', skip three line
  if ( usr != "" ) for( ; line<CRON_VERLINES; line++ ) it++;
#endif
#endif
  
  QString cmnt("");
  QString head("");
  int flg = 0;       // 0:read_header 1:read_variable/read_command
  for ( ; it != slist.end(); it++ ){
    line++;
    QString s = *it;
    s.stripWhiteSpace();
    if ( s == "" || s[0] == '#' ){
      // Comment List
      if ( cmnt != "" ) cmnt = cmnt + '\n';
      if ( flg == 0 && s == "" ){
        head = head + cmnt;
        cmnt = "";
      }else{
        if ( s == "" ) {
        if ( cmnt != "" ) cmnt = cmnt + '\n';
        }else{
          if ( s[1] == ' ' ) cmnt = cmnt + s.mid( 2 );
          else               cmnt = cmnt + s.mid( 1 );
        }
      }
    }else{
      // Command | Variable Line
      if ( flg == 0 ){
        if ( head == "" ){
              head = cmnt;
              cmnt = "";
        }
        e->Head = head;
      }
      if ( s.find( QRegExp("^\\S+\\s*=\\s*\\S*$") ) >= 0 ){
        // Variable
        v->append( new VarTbl( s, cmnt ) );
      }else{
        // Command
        CronTbl *cr = new CronTbl( usr, s, cmnt, e );
        QString estr = chkCron( cr );
        if ( estr != "" ){
          QString msg;
          if ( usr == "" )
            msg = i18n("System Crontab Format Error\n");
          else
            msg = "Crontab(" + usr + i18n(") Format Error\n");
          msg = msg +  i18n( "Skip This Data\n\n\"" ) + s + "\"\n\n";
          if ( QMessageBox::warning( getApp(),i18n("'crontab' Data Check"), msg + estr, i18n( "Show File" ) , "OK" ) == 0 ){
            dspErrText( command.outStr, line );
//            QMessageBox::information( getApp(), i18n("Error Display"), setErrText( command.outStr, line ) );
//            ErrDlg dlg( command.outStr, line );
//            dlg.exec();
          }
          delete cr;
        }else{
          cronTbl.append( cr );
          view->stngLvw->addItem(cr, CronTime(cr).GetNextTime( *g_CurTime ) );
        }
      }
      cmnt = "";
      flg = 1;
    }

  }

}

//
// Get 'anacrontab'
void KronekoDoc::getAnac()
{

  // Create Variable Table List
  QPtrList<VarTbl> *v = new QPtrList<VarTbl>;   // Valuables
  v->setAutoDelete( true );
  UserTbl *e = new UserTbl(ANACRON, "", "", v);
  userTbl.append( e );

  Command command("cat " + g_Option->anacFileSys );
  if ( command.exitStatus != 0 ){
    e->Flag |= NO_DATA;
    return;
  }

  dspProgress( 0.5 );

  // Text -> String List
  QStringList slist = QStringList::split( '\n', command.outStr, true );

  QString cmnt("");
  QString head("");
  int line = 0;
  int flg = 0;       // 0:read_header 1:read_variable/read_command
  for ( QStringList::Iterator it= slist.begin(); it != slist.end(); it++ ){
    line++;
    QString s = *it;
    s.stripWhiteSpace();
    if ( s == "" || s[0] == '#' ){
      // Comment
      if ( cmnt != "" ) cmnt = cmnt + '\n';
      if ( flg == 0 && s == "" ){
        head = head + cmnt;
        cmnt = "";
      }else{
        if ( s == "" ) {
          if ( cmnt != "" ) cmnt = cmnt + '\n';
        }else{
          if ( s[1] == ' ' ) cmnt = cmnt + s.mid( 2 );
          else               cmnt = cmnt + s.mid( 1 );
        }
      }
    }else{
      // Variable or Command
      if ( flg == 0 ){
        if ( head == "" ){
          head = cmnt + '\n';
          cmnt = "";
        }
        e->Head = head;
      }
      if ( s.find( QRegExp("^\\S+\\s*=\\s*\\S*$") ) >= 0 ){
        // Variable
        v->append( new VarTbl( s, cmnt ) );
      }else{
        // Command
        AnacTbl *ac = new AnacTbl( s, cmnt, e );
        QString estr = chkAnac( ac, true );
        if ( estr == "" ){
          anacTbl.append( ac );
          if ( g_Option->useAnacron ){
            view->stngLvw->addItem(ac, CronTime(ac).GetNextTime( *g_CurTime ));
          }
        }else{
          QString msg = i18n( "Anacron Format Error\n" ) + i18n( "Skip This Data\n\n\"" ) + s + "\"\n\n";
          if ( QMessageBox::warning( getApp(),i18n("'anacron' Data Check"), msg + estr, i18n( "Show File" ) , "OK" ) == 0 ){
            dspErrText( command.outStr, line );
//            QMessageBox::information( getApp(), i18n("Error Display"), setErrText( command.outStr, line ) );
//            ErrDlg dlg( command.outStr, line );
//            dlg.exec();
          }
          delete ac;
        }
      }
      cmnt = "";
      flg = 1;
    }
  }
}

//
// Get 'at'
void KronekoDoc::getAt( )
{

  dspProgress( 0.0 );
  atUserNum = 0;

  // Get All 'at' Users
  Command cmd_atl( System::getCommand( "at" )  + " -l" );
  if ( cmd_atl.exitStatus ){
    return;
  }

  QStringList slist = QStringList::split( '\n', cmd_atl.outStr, false );
  QStringList ulist;
  dspProgress( 0.4 );
  for ( QStringList::Iterator it=slist.begin(); it != slist.end(); it++ ){

    AtTbl *at = new AtTbl( *it );
    if ( ulist.find( at->User ) == ulist.end() ){
      ulist << at->User;
      atUserNum++;
    }
    
    // Get 'at' Command
    QString cmd;
    cmd.sprintf( "%s -c %d", (const char *)System::getCommand( "at" ), at->Jno );
    Command cmd_atc( cmd );
    QString str = cmd_atc.outStr;
    if ( cmd_atc.exitStatus ){
      QMessageBox::warning( getApp(), i18n("AT Command Read Error"), cmd_atc.errStr );
      continue;
    }
    at->Mail = 0;
    int i = str.find(QRegExp( AT_MAIL_LINE ));
    if ( i > 0 ){
      str = str.mid(i);
      at->Mail = ( str.section( QRegExp( "\\s+" ), 3, 3 ).toInt() );
    }
    at->Cmnd = str.section( QRegExp( AT_COMMAND_DELIM, true, true ), 1, 1 );
    atTbl.append( at );
    if ( System::atEnable() ){
      view->stngLvw->addItem(at);
    }
  }

}

//
// Initialize Expect View
void KronekoDoc::setExecView( )
{
  view->execLvw->setSorting( -1 );
  int tcnt = 0;

  //
  // Init Max Time
  QDateTime maxday;
  if ( g_Option->useExeDay ){
    maxday = g_CurTime->addSecs( g_Option->exeDayMax * 24 * 60 * 60 );
  }else{
    maxday.setDate( QDate(9998, 1, 1) );
  }

  dspProgress( 0.05 );
  QDateTime      tw, tc, tn;
  tc = *g_CurTime;

  // Time Convert List
  QPtrList<CronTime> ctim;
  ctim.setAutoDelete( TRUE );

  // Add 'crontab' to CronTime;
  for( CronTbl *cr=cronTbl.first(); cr; cr=cronTbl.next() ){
    cr->exeCnt = 0;
    cr->userTbl->exeCnt = 0;
    if ( !(cr->Flag & NO_EXEDISP ) ){
      ctim.append( new CronTime(cr) );
    }
  }
  dspProgress( 0.1 );

  // Add 'anacrontab' to CronTime;
  if ( g_Option->useAnacron && g_Option->anacListDisp){
    for( AnacTbl *an=anacTbl.first(); an; an=anacTbl.next() ){
      an->userTbl->exeCnt = 0;
      an->exeCnt = 0;
      if ( !(an->Flag & NO_EXEDISP ) ){
        ctim.append( new CronTime(an) );
      }
    }
  }
  dspProgress( 0.2 );
  //
  // 'at' Data
  if ( System::atEnable() && g_Option->atDispExe ){
    for( AtTbl *at=atTbl.first(); at; at=atTbl.next() ){
      at->exeCnt = 0;
      if ( !(at->Flag & NO_EXEDISP ) ){
        ctim.append( new CronTime(at) );
      }
    }
  }
  dspProgress( 0.3 );

  CronTime  *ct;
  int tf;
  // Add to List View
  while( true ){
    // Get Next Execute
    tf = 0;
    for( ct=ctim.first(); ct; ct=ctim.next() ){
      tw = ct->GetNextTime(tc);
      if ( tf == 0 ) {
        tn = tw;
        tf = 1;
      } else if( tw < tn ) {
        tn = tw;
        tf = 1;
      }
    }
    if ( tf == 0 ) break;
    if ( g_Option->useExeDay && tn > maxday ) break;

    // Add Next Execute
    for( ct=ctim.first(); ct; ct=ctim.next() ){
      tw = ct->GetNextTime(tc);
      if ( tn == tw ){
        if ( ct->dType == CRON ) {
          view->execLvw->addItem(ct->cronTbl(), tn );
          ct->cronTbl()->exeCnt++;
          ct->cronTbl()->userTbl->exeCnt++;
        }else if ( ct->dType == ANACRON ){
          view->execLvw->addItem(ct->anacTbl(), tn );
          ct->anacTbl()->exeCnt++;
          ct->anacTbl()->userTbl->exeCnt++;
        }else {
          view->execLvw->addItem(ct->atTbl());
          ct->atTbl()->exeCnt++;
          ctim.remove( ct );
        }
        tcnt++;
        if ( tcnt >= g_Option->exeListMax ) break;
      }
    }
    if ( tcnt >= g_Option->exeListMax ) break;
    tc = tn;
    if ( ( tcnt % 50 ) == 0 ) dspProgress( 0.3 + 0.8 / (double)g_Option->exeListMax * (double)tcnt );
  }
  endExe = tn;
  view->execLvw->setSorting( 1 );
  // Initialize Select
  QListViewItem *i = view->execLvw->selectedItem();
  if ( i == NULL ){
    view->execLvw->setSelected( view->execLvw->firstChild(), true );
  }else{
    view->execLvw->ensureItemVisible ( i );
  }
}

#ifndef CRON_DILLON
//
// 
// Initialize Log View
// 9460 : 25 sec
void KronekoDoc::setLogView()
{
  view->logLvw->setSorting( -1 );

  QDateTime mt;
  QString fn;

  // Get Log Directry Entry List
  QString dp = QFileInfo( g_Option->logFile ).dirPath();
  QString nm = QFileInfo( g_Option->logFile ).fileName();
  QStringList sl = QDir(dp).entryList( nm + "*" );

  // Create Temparary File ( Reversed Item )
  int i = 0;
  for ( QStringList::Iterator it = sl.begin(); it != sl.end(); it++ ){
    fn = dp + "/" + *it;
    if ( *it == nm ){
      mt = QFileInfo( fn ).lastModified();
      Command command( "tac " + fn + " > /tmp/cronlog" );
    }else{
      Command command( "tac " + fn + " >> /tmp/cronlog" );
    }
    i++;
    dspProgress( ( 0.2 / sl.count() ) * i );
  }

  // Add Log List
  int l = 0;
  QFile f( "/tmp/cronlog" );
  if ( f.open(IO_ReadOnly) ) {
    QTextStream t( &f );        // use a text stream
    QString s;
    QString prog;
    QString w;
    DATATYPE dty;
    bool flg;
    while ( !t.eof() ) {        // until end of file...
      s = t.readLine();
      flg = false;
      w = s.left( s.find( '[' ) );
      prog = w.section( ' ', -1, -1 );
      if ( prog == "crontab" && s.find( ") LIST (" )  == -1 ) {
        flg = true;
        dty = CRON_LOG;
      } else if ( prog == "CROND" || prog == "crond" || prog == "cron" ){
        dty = CRON_LOG;
        flg = true;
      } else if ( prog == "anacron" ){
        dty = ANACRON_LOG;
        flg = true;
      } else if ( prog == "atd" ){
        dty = AT_LOG;
        flg = true;
      }
      if ( flg ){
        view->logLvw->addItem( new LogTbl( s, dty, prog, mt.date() ) );
        l++;
        if ( ( l % 50) == 0 ) {
          dspProgress( 0.2 + ( ( 0.8 / g_Option->logListMax ) * l ) );
        }
        if ( l >= g_Option->logListMax ) break;
      }
    }
    f.close();
  }
  view->logLvw->setSorting( 1, false );
  view->logLvw->setSelected( view->logLvw->firstChild(), true );
  endLog = ((TabLvi *)(view->logLvw->lastItem()))->logTbl()->Time;
  // Remove Temporary File
  Command command ( "rm -f /tmp/cronlog" );
}

#endif

//
// Convert User Variable
QString KronekoDoc::cnvComment( const QString& c )
{

  QString s("");
  if ( c != "" ){
    s = c;
    s.replace( QRegExp( "\\|USER\\|" ), System::uName()  );
    s.replace( QRegExp( "\\|GROUP\\|" ), System::uGroup() );
    s.replace( QRegExp( "\\|HOME\\|" ), System::uHome() );
    s.replace( QRegExp( "\\|SHELL\\|" ), System::uShell() );
    s.replace( QRegExp( "\\|UINF\\|" ), System::uReal() );
    s.replace( QRegExp( "\\|CURRENT\\|" ), g_CurTime->toString( "yy-MM-dd(ddd) hh:mm" ) );
    QDateTime dt = g_CurTime->addSecs( g_Option->atNewTime * 60 );
    s.replace( QRegExp( "\\|EXETIME\\|" ), dt.toString( "yy-MM-dd(ddd) hh:mm" ) );
  }
  return s;
}

//
// Convert User Variable
QString KronekoDoc::cnvCommentU( const QString& c, const QString& u )
{

  QString s("");
  if ( c != "" ){
    s = c;
    passwd *p = getpwnam( u );
    group *g = getgrgid( p->pw_gid );
    s.replace( QRegExp( "\\|USER\\|" ), p->pw_name  );
    s.replace( QRegExp( "\\|GROUP\\|" ), g->gr_name );
    s.replace( QRegExp( "\\|HOME\\|" ), p->pw_dir );
    s.replace( QRegExp( "\\|SHELL\\|" ), p->pw_shell );
    s.replace( QRegExp( "\\|UINF\\|" ), p->pw_gecos );
    s.replace( QRegExp( "\\|CURRENT\\|" ), g_CurTime->toString( "yy-MM-dd(ddd) hh:mm" ) );
    QDateTime dt = g_CurTime->addSecs( g_Option->atNewTime * 60 );
    s.replace( QRegExp( "\\|EXETIME\\|" ), dt.toString( "yy-MM-dd(ddd) hh:mm" ) );
  }
  return s;
}
//
// Remove from Execute List
void KronekoDoc::dispExe( bool flg )
{
  TabLvi* t;
  int *pFlag;
  if ( curList == LIST_STNG ) t = this->curStngItem;
  else                        t = this->curExecItem;
  if ( t->dType == CRON ){
    CronTbl *c = t->cronTbl();
    pFlag = &c->Flag;
  }else if ( t->dType == ANACRON ){
    AnacTbl *n = t->anacTbl();
    pFlag = &n->Flag;
  }else{
    AtTbl *a = t->atTbl();
    pFlag = &a->Flag;
  }
  if ( flg ){
    if ( *pFlag & NO_EXEDISP ){
      *pFlag = *pFlag ^ NO_EXEDISP;
      pStart( RUN_LIST_EXEC );
    }

  }else{
    if ( ! ( *pFlag & NO_EXEDISP ) ){
      *pFlag = *pFlag ^ NO_EXEDISP;
      pStart( RUN_LIST_EXEC );
    }
  }


}


//
// Edit Time
void KronekoDoc::editTime()
{
  TabLvi* t;
  if ( curList == LIST_STNG ) t = this->curStngItem;
  else                        t = this->curExecItem;

  //
  if ( t->dType == CRON ){
    //
    // Cron Time Edit
    CronTbl *c = t->cronTbl();
    CronTimeDlg dlg( c->Time );
    if ( dlg.exec() == QDialog::Accepted && c->Time != dlg.getTime() ){
      // Set Time
      c->Time =dlg.getTime();
      c->Flag |= EDIT_MODIFY;
      if ( curList == LIST_STNG ){
        t->setText( 1, c->Time );
      }else{
        for ( QListViewItemIterator it( view->stngLvw ); it.current(); ++it ){
          TabLvi *f = (TabLvi*)it.current();
          if ( f->TblPtr == (void *)c ){
            f->setText( 1, c->Time );
            break;
          }
        }
      }
      t->Next = CronTime(c).GetNextTime(*g_CurTime);
      // Save Button Enable
      bUpdate = true;      
      // Reset Execute List
      view->stngLvw->resetFlag();
      pStart( RUN_LIST_EXEC );
      view->clockWgt->clockView->iniFrame( true );
      dspView();
    }
  }else{
    //
    // At Time Edit
    AtTbl *a = t->atTbl();
    AtTimeDlg dlg( a->Time );
    if ( dlg.exec() == QDialog::Accepted && dlg.getTime() != a->Time.toString( "yyyy-MM-dd hh:mm" )){
      // Set Time
      a->Time = QDateTime::fromString( dlg.getTime(), Qt::ISODate );
      a->Flag |= EDIT_MODIFY;
      if ( curList == LIST_STNG ){
        t->setText( 1, a->Time.toString( "yy-MM-dd hh:mm" ) );
      }else{
        for ( QListViewItemIterator it( view->stngLvw ); it.current(); ++it ){
          TabLvi *f = (TabLvi*)it.current();
          if ( f->TblPtr == (void *)a ){
            t->setText( 1, a->Time.toString( "yy-MM-dd hh:mm" ) );
            break;
          }
        }
      }
      t->Next = a->Time;
      // Save Button Enable
      bUpdate = true;
      // Reset Execute List
      view->stngLvw->resetFlag();
      pStart( RUN_LIST_EXEC );
      view->clockWgt->clockView->iniFrame( true );
      dspView();
    }
  }

}

//
// Edit Select
void KronekoDoc::editSelect()
{
  TabLvi* c;
  if ( curList == LIST_STNG ){
    c = (TabLvi *)this->curStngItem;
  }else{
    c = (TabLvi *)this->curExecItem;
  }
  if ( c->dType == CRON ){
    // Edit 'crontab' Data
#ifndef CRON_DILLON
    if ( c->cronTbl()->cronType == CRON_ETC && ! System::isCronWritable() ) return;
#endif
    if ( curEditCron ){
      if ( view->cronEditWgt->creBtn->isEnabled() || view->cronEditWgt->modBtn->isEnabled() ){
        if ( QMessageBox::information( getApp(),
          i18n("Edit New Data"), i18n("Cancel Current Editing Data ?"),
          QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Cancel ){
            return;
        }
      }
      curEditCron->Flag &= ~EDIT_CURRENT;
    }
    curEditCron = c->cronTbl();
    curEditCron->Flag |= EDIT_CURRENT;
    view->cronEditWgt->iniEdit(curEditCron);
    view->viewTab->showPage( view->cronEditWgt );
  }else if ( c->dType == ANACRON ){
    // Edit 'anacrontab' Data
     if ( ! ( System::getAnacStatus() & ANAC_WRITABLE ) ) return;
    if ( curEditAnac ) {
      if ( view->anacEditWgt->creBtn->isEnabled() || view->anacEditWgt->modBtn->isEnabled() ){
        if ( QMessageBox::information( getApp(),
          i18n("Edit New Data"), i18n("Cancel Current Editing Data ?"),
          QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Cancel ){
            return;
        }
      }
      curEditAnac->Flag &= ~EDIT_CURRENT;
    }
    curEditAnac = c->anacTbl();
    curEditAnac->Flag |= EDIT_CURRENT;
    view->anacEditWgt->iniEdit(curEditAnac);
    view->viewTab->showPage( view->anacEditWgt );
  }else if ( c->dType == AT ){
    // Edit 'at'
    if ( curEditAt ){
      if ( view->atEditWgt->creBtn->isEnabled() || view->atEditWgt->modBtn->isEnabled() ){
        if ( QMessageBox::information( getApp(),
          i18n("Edit New Data"), i18n("Cancel Current Editing Data ?"),
          QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Cancel ){
            return;
        }
      }
       curEditAt->Flag &= ~EDIT_CURRENT;
    }
    curEditAt = c->atTbl();
    curEditAt->Flag |= EDIT_CURRENT;
    view->atEditWgt->iniEdit(curEditAt);
    view->viewTab->showPage( view->atEditWgt );
  }
  view->stngLvw->resetFlag();
  view->execLvw->resetFlag();
}

//
// Check Update
bool KronekoDoc::checkModify()
{

  bool flg=false;

  // Check 'crontab'
  for( CronTbl* cr=cronTbl.first(); cr; cr=cronTbl.next() ){
    if ( cr->Flag & ( EDIT_CREATE | EDIT_MODIFY | EDIT_DELETE ) ) {
      flg = true;
      break;
    }
    if ( cr->userTbl->Flag & ( EDIT_CREATE | EDIT_MODIFY | EDIT_DELETE ) ){
      flg = true;
      break;
    }
  }

  // Check 'anacrontab'
  if ( !flg ){
    for( AnacTbl* ac=anacTbl.first(); ac; ac=anacTbl.next() ){
      if ( ac->Flag & ( EDIT_CREATE | EDIT_MODIFY | EDIT_DELETE ) ) {
        flg = true;
        break;
      }
      if ( ac->userTbl->Flag & ( EDIT_CREATE | EDIT_MODIFY | EDIT_DELETE ) ){
        flg = true;
        break;
      }
    }
  }

  // Check 'at'
  if ( !flg ){
    for( AtTbl* at=atTbl.first(); at; at=atTbl.next() ){
      if ( at->Flag & ( EDIT_CREATE | EDIT_MODIFY | EDIT_DELETE ) ) {
        flg = true;
        break;
      }
    }
  }

  return flg;
}


//
// Reset All Modify Flag
void KronekoDoc::resetFlag()
{
  if ( curStngItem ){
    if ( curStngItem->dType == CRON && curStngItem->cronTbl()->Flag & EDIT_DELETE ) curStngItem = NULL;
    else if ( curStngItem->dType == ANACRON && curStngItem->anacTbl()->Flag & EDIT_DELETE ) curStngItem = NULL;
    else if ( curStngItem->dType == AT && curStngItem->atTbl()->Flag & EDIT_DELETE ) curStngItem = NULL;
  }
  for( CronTbl* cr=cronTbl.first(); cr; cr=cronTbl.current() ){
    cr->userTbl->Flag &= ~( EDIT_CREATE | EDIT_MODIFY );
    if ( cr->Flag & EDIT_DELETE ){
      view->stngLvw->takeItem( view->stngLvw->getItem( cr ) );
      cronTbl.remove( cr );
    }else{
      cr->Flag &= ~( EDIT_CREATE | EDIT_MODIFY );
      cr=cronTbl.next();
    }
  }
  for( AnacTbl* ac=anacTbl.first(); ac; ac=anacTbl.current() ){
    ac->userTbl->Flag &= ~( EDIT_CREATE | EDIT_MODIFY );
    if ( ac->Flag & EDIT_DELETE ){
      view->stngLvw->takeItem( view->stngLvw->getItem( ac ) );
      anacTbl.remove( ac );
    }else{
      ac->Flag &= ~( EDIT_CREATE | EDIT_MODIFY );
      ac=anacTbl.next();
    }
  }
  for( AtTbl* at=atTbl.first(); at; at=atTbl.current() ){
    if ( at->Flag & EDIT_DELETE ){
      view->stngLvw->takeItem( view->stngLvw->getItem( at ) );
      atTbl.remove(at );
    }else{
      at->Flag &= ~( EDIT_CREATE | EDIT_MODIFY );
      at=atTbl.next();
    }
  }
  view->stngLvw->resetFlag();
}
//
// Update 'crontab'
void KronekoDoc::saveCron()
{

  QString s;
  QPtrList<UserTbl> ulist;

  //
  // Get Modified Users
  for( CronTbl* cr=cronTbl.first(); cr; cr=cronTbl.next() ){
    if ( ( cr->Flag & (EDIT_DELETE|EDIT_MODIFY|EDIT_CREATE) ) ||
         ( cr->userTbl->Flag & (EDIT_DELETE|EDIT_MODIFY|EDIT_CREATE) ) ){
      if ( ulist.find( cr->userTbl ) == -1 ) ulist.append( cr->userTbl );
    }
  }

  for( UserTbl* utbl=ulist.first(); utbl; utbl=ulist.next() ){
    
    KTempFile f;
    f.setAutoDelete( true );

    QTextStream *t = f.textStream();        // use a text stream

    // Header Comment
    *t << setComment( utbl->Head ) + "#\n\n";

    // Variables
    for( VarTbl* vr=utbl->Vars->first(); vr; vr=utbl->Vars->next() ){
      *t << setComment( vr->Cmnt );
      *t << vr->Name + "=" + vr->Val + '\n';
    }
    *t << "\n";

    // 'crontab' Command
    int dcnt = 0;
    for( CronTbl* cr=cronTbl.first(); cr; cr=cronTbl.next() ){
      if ( cr->userTbl == utbl && !( cr->Flag & EDIT_DELETE ) ){

        // Comment
        *t << setComment( cr->Cmnt );

        // Command
#ifdef CRON_DILLON
          s.sprintf( "%-15s %s\n", (const char*)cr->Time, (const char*)cr->Cmnd );
          *t << s;
          dcnt++;
#else
        if ( cr->cronType == CRON_ETC ){
          s.sprintf( "%-15s %s %s\n", (const char*)cr->Time, (const char*)cr->User, (const char*)cr->Cmnd );
          *t << s;
        }else{
          s.sprintf( "%-15s %s\n", (const char*)cr->Time, (const char*)cr->Cmnd );
          *t << s;
          dcnt++;
        }
#endif
      }
      if ( cr->Flag & EDIT_DELETE && cr->Flag & EDIT_CURRENT ){
        view->cronEditWgt->setEnabled( false );
      }
    }
    f.close();

    // Make 'crontab'
    QString cmd;
#ifdef CRON_DILLON
    // User 'crontab'
    if ( System::uid() == 0 ){  // root User
      if ( dcnt ) cmd = System::getCommand("crontab") + " " + f.name() + " -u " + utbl->User;
      else cmd = System::getCommand("crontab") + " -d " + utbl->User;
    }else{
      if ( dcnt ) cmd = System::getCommand("crontab") + " " + f.name();
      else cmd = System::getCommand("crontab") + " -d";
    }
#else
    if ( utbl->User == "" ){
      // System 'crontab'
      cmd = "cp -f " + f.name() + " " + g_Option->cronFileSys;
    }else{
      // User 'crontab'
      if ( System::uid() == 0 ){  // root User
        if ( dcnt ) cmd = System::getCommand("crontab") + " -u " + utbl->User + " " + f.name();
        else cmd = System::getCommand("crontab") + " -u " + utbl->User + " -r";
      }else{
        if ( dcnt ) cmd = System::getCommand("crontab") + " " + f.name();
        else cmd = System::getCommand("crontab") + " -r";
      }
    }
#endif
    // Do Update
    Command command( cmd );
    if ( command.exitStatus != 0 || command.errStr != "" ){
      QMessageBox::warning( getApp(),i18n("'crontab' Update Error"), command.errStr );
    }
//cout << "Save Cron : Status =" << command.exitStatus << " Out = " << command.outStr << " Err = " << command.errStr << endl;
  }

}

//
// Update 'anacrontab'
void KronekoDoc::saveAnac()
{

  QString s;
  UserTbl* ev;
  AnacTbl* ac=anacTbl.first();
  if ( ac ){
    ev=ac->userTbl;

    //
    // Check Update
    if ( ! ( ev->Flag & (EDIT_DELETE|EDIT_MODIFY|EDIT_CREATE) ) ){
      for( ; ac; ac=anacTbl.next() ){
        if ( ac->Flag & (EDIT_DELETE|EDIT_MODIFY|EDIT_CREATE) ) break;
      }
    }
  }

  if ( ac ) {
    // Update
    QFile f( g_Option->anacFileSys );
    if ( ! f.open(IO_WriteOnly) ) {
      // Error
      return;
    }
    QTextStream t( &f );        // use a text stream

    // Header Comment
    t << setComment( ev->Head ) << "#\n\n";

    // Variable
    for( VarTbl* vr=ev->Vars->first(); vr; vr=ev->Vars->next() ){
      t << setComment( vr->Cmnt );
      t << vr->Name << "=" << vr->Val << '\n';
    }
    t << "\n";

    // Command
    for( ac=anacTbl.first(); ac; ac=anacTbl.next() ){
      if ( !( ac->Flag & EDIT_DELETE ) ){
        // Comment
        t << setComment( ac->Cmnt );
        // Command
        s.sprintf( "%-2d %-3d %-15s %s\n", ac->Prod, ac->Dlay, (const char*)ac->Idnt, (const char*)ac->Cmnd );
        t << s;
      }else{
        if ( ac->Flag & EDIT_CURRENT ) view->anacEditWgt->setEnabled( false );
      }
    }
    f.close();
  }
      

}

//
// Update 'at' Jobs
void KronekoDoc::saveAt()
{

  QString s;

  // Remove Job
  for( AtTbl* at=atTbl.first(); at; at=atTbl.next() ){
    if ( at->Jno != (-1) && ( ( at->Flag & EDIT_DELETE ) || ( at->Flag & EDIT_MODIFY ) ) ){
      s = System::getCommand( "at" ) + " -d " + QString().setNum( at->Jno );
      Command command( s );
      if ( command.exitStatus != 0 ){
        QMessageBox::warning( getApp(),i18n("'AT' Delete Error"), command.errStr );
      }
    }
  }

  // Register Job
  for( AtTbl* at=atTbl.first(); at; at=atTbl.next() ){
    if ( ( at->Flag & EDIT_CREATE ) || ( at->Flag & EDIT_MODIFY ) ){

      // Create Command File
      KTempFile f;
      f.setAutoDelete( true );
      QTextStream *t = f.textStream();        // use a text stream
      *t << at->Cmnd;
      f.close();

      // Make 'at' Command
      QDateTime dt = at->Time;
      s = System::getCommand( "at" ) + " -q " + QString(QChar(at->Qno)) + " ";
      if ( at->Mail ) s = s + "-m ";
      s = s + "-f " + f.name() + " " + dt.toString( "hh:mm MM/dd/yy" );

      // Do Command
      Command command( s );
      if ( command.exitStatus != 0 ){
        QMessageBox::warning( getApp(),i18n("'AT' Register Error"), command.errStr );
      }
    }
  }
      

}

//
// Create New 'cron' Command
void KronekoDoc::newCron()
{

  UserTbl* ut;
  QString s;
  QString uname;
  if ( System::cronEnable() ){
    uname = System::uName();
  }else{
    uname = "";
  }

  for ( ut=userTbl.first(); ut; ut=userTbl.next() ){
    if ( ut->dType == CRON && ut->User == uname ) break;
  }
  if ( ut->Flag & NO_DATA ){

    // Get New Header
    QStringList slist = QStringList::split( '\n', cnvComment(g_Option->cronNewHead), true );

    QString cmnt("");
    QString head("");
    int flg = 0;       // 0:read_header 1:read_variable/read_command
    for ( QStringList::Iterator it= slist.begin(); it != slist.end(); it++ ){
      s = *it;       // line of text excluding '\n'
      s.stripWhiteSpace();
      if ( s == "" || s[0] == '#' ){
        if ( cmnt != "" ) cmnt = cmnt + '\n';
        if ( flg == 0 && s == "" ){
          head = head + cmnt;
          cmnt = "";
        }else{
          if ( s == "" ) {
            if ( cmnt != "" ) cmnt = cmnt + '\n';
          }else{
            if ( s[1] == ' ' ) cmnt = cmnt + s.mid( 2 );
            else               cmnt = cmnt + s.mid( 1 );
          }
         }
      }else{
        if ( flg == 0 ){
          if ( head == "" ){
            head = cmnt + '\n';
            cmnt = "";
          }
          ut->Head = head;
        }
        if ( s.find( QRegExp("^\\S+\\s*=\\s*\\S*$") ) >= 0 ){
          ut->Vars->append( new VarTbl( s, cmnt ) );
        }
        cmnt = "";
        flg = 1;
      }
    }
    ut->Flag &= ~NO_DATA;
  }
  // Read Command
  QStringList slist = QStringList::split( '\n', cnvComment(g_Option->cronNewCmnd), true );
  QString cmnt("");
  for ( QStringList::Iterator it= slist.begin(); it != slist.end(); it++ ){
    s = *it;       // line of text excluding '\n'
    s.stripWhiteSpace();
    if ( s == "" || s[0] == '#' ){
      if ( cmnt != "" ) cmnt = cmnt + '\n';
      if ( s != "" ) {
        if ( s[1] == ' ' ) cmnt = cmnt + s.mid( 2 );
        else               cmnt = cmnt + s.mid( 1 );
      }
    }else{
      *newEditCron = CronTbl( System::uName(), s, cmnt, ut );
#ifndef CRON_DILLON
      if ( uname == "" ){
        newEditCron->cronType = CRON_ETC;
      }
#endif
      newEditCron->Flag = EDIT_NEW | EDIT_CURRENT;
      break;
    }
  }

  // Initialize 'crontab' Edit Widget
  if ( curEditCron ) curEditCron->Flag &= ~EDIT_CURRENT;
  curEditCron = newEditCron;
  view->cronEditWgt->iniEdit(curEditCron);
  view->viewTab->showPage( view->cronEditWgt );
  view->stngLvw->resetFlag();
  view->execLvw->resetFlag();


  return;
}

//
// Create New 'cron' Command
void KronekoDoc::newCronUser( UserTbl* ut )
{

  if ( ut->Flag & NO_DATA ){

    // Get New Header
    QStringList slist = QStringList::split( '\n', cnvCommentU(g_Option->cronNewHead, ut->User), true );

    QString s;
    QString cmnt("");
    QString head("");
    int flg = 0;       // 0:read_header 1:read_variable/read_command
    for ( QStringList::Iterator it= slist.begin(); it != slist.end(); it++ ){
      s = *it;       // line of text excluding '\n'
      s.stripWhiteSpace();
      if ( s == "" || s[0] == '#' ){
        if ( cmnt != "" ) cmnt = cmnt + '\n';
        if ( flg == 0 && s == "" ){
          head = head + cmnt;
          cmnt = "";
        }else{
          if ( s == "" ) {
            if ( cmnt != "" ) cmnt = cmnt + '\n';
          }else{
            if ( s[1] == ' ' ) cmnt = cmnt + s.mid( 2 );
            else               cmnt = cmnt + s.mid( 1 );
          }
         }
      }else{
        if ( flg == 0 ){
          if ( head == "" ){
            head = cmnt + '\n';
            cmnt = "";
          }
          ut->Head = head;
        }
        if ( s.find( QRegExp("^\\S+\\s*=\\s*\\S*$") ) >= 0 ){
          ut->Vars->append( new VarTbl( s, cmnt ) );
        }
        cmnt = "";
        flg = 1;
      }
    }
    ut->Flag &= ~NO_DATA;
  }
  return;
}
//
// Create New 'cron' Command
void KronekoDoc::newAnac()
{

  UserTbl* ut;
  QString s;

  for ( ut=userTbl.first(); ut; ut=userTbl.next() ){
    if ( ut->dType == ANACRON ) break;
  }
  if ( ut->Flag & NO_DATA ){

    // Get New Header
    QStringList slist = QStringList::split( '\n', cnvComment(g_Option->anacNewHead), true );
    QString cmnt("");
    QString head("");
    int flg = 0;       // 0:read_header 1:read_variable/read_command
    for ( QStringList::Iterator it= slist.begin(); it != slist.end(); it++ ){
      s = *it;       // line of text excluding '\n'
      s.stripWhiteSpace();
      if ( s == "" || s[0] == '#' ){
        if ( cmnt != "" ) cmnt = cmnt + '\n';
        if ( flg == 0 && s == "" ){
          head = head + cmnt + '\n';
          cmnt = "";
        }else{
          if ( s == "" ) {
            if ( cmnt != "" ) cmnt = cmnt + '\n';
          }else{
            if ( s[1] == ' ' ) cmnt = cmnt + s.mid( 2 );
            else               cmnt = cmnt + s.mid( 1 );
          }
         }
      }else{
        if ( flg == 0 ){
          if ( head == "" ){
            head = cmnt;
            cmnt = "";
          }
          ut->Head = head;
        }
        if ( s.find( QRegExp("^\\S+\\s*=\\s*\\S*$") ) >= 0 ){
          ut->Vars->append( new VarTbl( s, cnvComment(cmnt) ) );
        }
        cmnt = "";
        flg = 1;
      }
    }
    ut->Flag &= ~NO_DATA;
  }
  // Get New Command
  QStringList slist = QStringList::split( '\n', cnvComment(g_Option->anacNewCmnd), true );
  QString cmnt("");
  for ( QStringList::Iterator it= slist.begin(); it != slist.end(); it++ ){
    s = *it;       // line of text excluding '\n'
    s.stripWhiteSpace();
    if ( s == "" || s[0] == '#' ){
      if ( cmnt != "" ) cmnt = cmnt + '\n';
      if ( s != "" ) {
        if ( s[1] == ' ' ) cmnt = cmnt + s.mid( 2 );
        else               cmnt = cmnt + s.mid( 1 );
      }
    }else{
      *newEditAnac = AnacTbl( s, cmnt, ut, true );
      newEditAnac->Flag = EDIT_NEW | EDIT_CURRENT;
      break;
    }
  }

  // Initialize 'anacrontab' Edit Widget
  if ( curEditAnac ) curEditAnac->Flag &= ~EDIT_CURRENT;
  curEditAnac = newEditAnac;
  view->anacEditWgt->iniEdit(curEditAnac);
  view->viewTab->showPage( view->anacEditWgt );
  view->stngLvw->resetFlag();
  view->execLvw->resetFlag();

  return;

}

//
// Create New 'at' Job
void KronekoDoc::newAt()
{

  // Create New Job
  newEditAt->User = System::uName();
  newEditAt->Jno = -1;
  newEditAt->Mail = g_Option->atNewMail;
  newEditAt->Qno = 'a';
  newEditAt->Time = g_CurTime->addSecs( g_Option->atNewTime * 60 );
  newEditAt->Cmnd = cnvComment( g_Option->atNewCmnd );
  newEditAt->Flag = EDIT_NEW | EDIT_CURRENT;

  // Initialize 'at' Edit Widget
  if ( curEditAt ) curEditAt->Flag &= ~EDIT_CURRENT;
  curEditAt = newEditAt;
  view->atEditWgt->iniEdit(curEditAt);
  view->viewTab->showPage( view->atEditWgt );
  view->stngLvw->resetFlag();
  view->execLvw->resetFlag();

}

//
// Check 'cron' Time
bool KronekoDoc::chkCronTime( const QString& str, int mx )
{

  bool ret = true;
  QStringList sl = QStringList::split( QRegExp( "[,-/]" ), str );
  for( QStringList::Iterator it=sl.begin(); it != sl.end(); it++ ){
    QString s = *it;
    if ( s != "*" ){
      if ( s.find( QRegExp( "^\\d+$" ) ) != 0 ){
        ret = false;
        break;
      }else{
        if ( s.toInt() > mx ){
          ret = false;
          break;
        }
      }
    }
  }
  
  return ret;
}

//
// Check 'cron' Time Format
bool KronekoDoc::chkCronForm( const QString& str )
{

  const char *WeekNames[] =
  { "sun", "mon", "tue", "wed", "thu", "fri", "sat", NULL };
  const char *MonthNames[] =  
  { "jan", "feb", "mar", "apr", "may", "jun",
    "jul", "aug", "sep", "oct", "nov", "dec", NULL };

  bool ret = true;
  QString s = str.lower();
  QStringList sl = QStringList::split( QRegExp( "\\s+" ), s );
  if ( sl.count() == 1 ){
    if ( s != "@hourly" && s != "@daily" && s != "@midnight" && s != "@weekly" &&
         s != "@monthly" && s != "@yearly" && s != "@annually" && s != "@reboot" ){
      ret = false;
    }
  }else if ( sl.count() == 5 ){
    QString chk;
    ret = chkCronTime( sl[0], 59 );
    if ( ret ) ret = chkCronTime( sl[1], 23 );
    if ( ret ) ret = chkCronTime( sl[2], 31 );
    if ( ret ){
      chk = sl[3];
      for( int i=0; i<12; i++ ){
        chk = chk.replace( QRegExp( MonthNames[i] ), QString().setNum(i+1) );
      }
      ret = chkCronTime( chk, 12 );
    }
    if ( ret ){
      chk = sl[4];
      for( int i=0; i<7; i++ ){
        chk = chk.replace( QRegExp( WeekNames[i] ), QString().setNum(i+1) );
      }
      ret = chkCronTime( chk, 7 );
    }
  }else{
    ret = false;
  }

  return ret;
}

//
// Check 'Cntab' data
QString KronekoDoc::chkCron( CronTbl* cr )
{
  QString estr = "";
  // Check Time
  if ( cr->Time == "" ){
    estr = i18n("Not Specify Time");
  } else if ( !chkCronForm( cr->Time)  ){
    estr = i18n("Invalid Syntacs in Time Specifier");
  }

  // Check User
  if ( estr == "" ){
    if ( cr->User == "" ){
      estr = i18n("Not Specify User");
    }else{
      QStringList al = System::allUsers();
      if ( al.find( cr->User ) == al.end() ){
        estr = i18n("Bad User");
      }
    }
  }

  // Check Command
  if ( estr == "" && cr->Cmnd == "" ){
    estr = i18n("Not Specify Command");
  }
//  if ( ! ret ){
//    QMessageBox::warning( getApp(), i18n("crontab Data Check"), msg + estr );
//  }
    
  return estr;
}

//
// Check 'anacrontab' data
QString KronekoDoc::chkAnac( AnacTbl* an, bool newdata )
{
  QString estr = "";
  // Check Priod
  if ( an->Prod < 0 ){
    estr = i18n("Period Out of Range");
  }
  
  // Check Delay
  if ( estr == "" && an->Dlay < 0 ){
    estr = i18n("Delay Time Out of Range");
  }

  // Check Identifier
  if ( estr == "" && an->Idnt == "" ){
    estr = i18n("Not Specify Identifier");
  }
  if ( estr == "" && newdata ){
    for( AnacTbl* ac=anacTbl.first(); ac; ac=anacTbl.next() ){
      if ( !( ac->Flag & EDIT_DELETE ) && an->Idnt == ac->Idnt ){
        estr = i18n("Identifier Duplicated");
        break;
      }
    }    
  }

  // Check Command
  if ( estr == "" && an->Cmnd == "" ){
    estr = i18n("Not Specify Command");
  }
//  if ( ! ret ){
//    QMessageBox::warning( getApp(),i18n("'anacron' Data Check"), msg + estr );
//  }

  return estr;
}

//
// Check 'at' data
bool KronekoDoc::chkAt( AtTbl* at )
{
  int ret = true;
  QString estr;
  // Check Time
  if ( ! at->Time.isValid() ){
    estr =  i18n( "Invalid Date Time." );
    ret = false;
  }else if ( at->Time < *g_CurTime ){
    estr = i18n("Specify Time Afer Current Time");
    ret = false;
  }

  // Check Queue Level
  if ( ret && ! ( isalpha( at->Qno ) ) ){
    estr = i18n("Bad Queue No");
    ret = false;
  }
  

  // Check Command
  if ( ret && at->Cmnd == "" ){
    estr = i18n("Not Specify Command");
    ret = false;
  }  
  if ( ! ret ){
    QMessageBox::warning( getApp(),i18n("at Data Check"), estr );
  }

  return ret;
}

//
// Display Statistic Information
void KronekoDoc::dspDetail()
{
    DetailDlg dlg( this );
    dlg.exec();
}

//
// Display View
void KronekoDoc::dspView()
{

  TabLvi* lvi = NULL;
#ifndef CRON_DILLON
  TabLvi* log = NULL;
#endif

  if ( curList == LIST_STNG )      lvi = curStngItem;
  else if ( curList == LIST_EXEC ) lvi = curExecItem;
#ifndef CRON_DILLON
  else                             log = curLogItem;
#endif
  

  if ( curView == VIEW_CLOCK ){
    if ( lvi != NULL ){
      if ( lvi->dType == CRON ){      // 'crontab'
        view->clockWgt->dspClock( lvi->cronTbl(), &lvi->Next );
      }else if ( lvi->dType == ANACRON ){   // 'anacrontab'
        view->clockWgt->dspClock( lvi->anacTbl(), &lvi->Next );
      }else{                                        // 'at'
        view->clockWgt->dspClock( &lvi->Next );
      }
#ifndef CRON_DILLON
    }else if ( log != NULL ){
      view->clockWgt->dspClock( &log->Next );
#endif
    }else{
      view->clockWgt->clrClock();
    }
  }else if ( curView == VIEW_DETAIL ){
    if ( lvi != NULL ){
      if ( lvi->dType == CRON ){      // 'crontab'
        view->detailWgt->dspText( lvi->cronTbl(), lvi->Next );
      }else if ( lvi->dType == ANACRON ){   // 'anacrontab'
        view->detailWgt->dspText( lvi->anacTbl(), lvi->Next );
      }else{                                        // 'at'
        view->detailWgt->dspText( lvi->atTbl() );
      }
#ifndef CRON_DILLON
    }else if ( log != NULL ){
      view->detailWgt->dspText( log->logTbl() );
#endif
    }
  }

  bool eflg = true;
  bool tflg = true;
  bool rflg = true;
  bool remFlag = true;
  if ( lvi != NULL ){
    if ( lvi->dType == CRON ){
#ifndef CRON_DILLON
      if ( lvi->cronTbl()->cronType == CRON_ETC && ( ! System::isCronWritable() )) {
        eflg = false;
        tflg = false;
      }
#endif
      if ( lvi->cronTbl()->Flag & EDIT_DELETE ) tflg = false;
      if ( lvi->cronTbl()->Flag & NO_EXEDISP ) remFlag = false;
    }else if ( lvi->dType == ANACRON ){
      tflg = false;
      if ( ! ( System::getAnacStatus() & ANAC_WRITABLE ) ) eflg = false;
      if ( lvi->anacTbl()->Flag & NO_EXEDISP ) remFlag = false;
    }else{
      if ( lvi->atTbl()->Flag & EDIT_DELETE ) tflg = false;
      if ( lvi->atTbl()->Flag & NO_EXEDISP ) remFlag = false;
    }
  }else{
    eflg = false;
    tflg = false;
    rflg = false;
  }

  // Set Toolbar
  if ( ! g_ViewMode ) getApp()->fileEdit->setEnabled(eflg);
  if ( ! g_ViewMode ) getApp()->fileTime->setEnabled(tflg);
  getApp()->fileRemExe->setEnabled(rflg);
  if ( rflg ){
    getApp()->fileRemExe->setChecked( remFlag );
  }

  if ( lvi != NULL ){
    QString u;
    QString h;
    int u_t=0;
    int e_t=0;
//    int s_t=0;
    if ( lvi->dType == CRON ) {
      u = lvi->cronTbl()->User;
      h = "CRON(" + u + ")";
#ifndef CRON_DILLON
      if ( lvi->cronTbl()->cronType == CRON_ETC ) h = "SYSTEM " + h;
#endif
      e_t = lvi->cronTbl()->exeCnt;
      u_t = lvi->cronTbl()->userTbl->itemCnt;
//      s_t = lvi->cronTbl()->userTbl->exeCnt;
    } else if ( lvi->dType == ANACRON ) {
      u = "-";
      h = "ANACRON";
      e_t = lvi->anacTbl()->exeCnt;
      u_t = lvi->anacTbl()->userTbl->itemCnt;
//      s_t = lvi->anacTbl()->userTbl->exeCnt;
    } else if ( lvi->dType == AT ) {
      u = lvi->atTbl()->User;
      h = "AT(" + u + ")";
      e_t = lvi->atTbl()->exeCnt;
      for ( QListViewItemIterator it( view->stngLvw ); it.current(); ++it ){
        TabLvi *c = (TabLvi*)it.current();
        if ( c->dType == AT && c->atTbl()->User == u ) u_t++;
      }
//      for ( QListViewItemIterator it( view->execLvw ); it.current(); ++it ){
//        TabLvi *c = (TabLvi*)it.current();
//        if ( c->dType == AT && c->atTbl()->User == u ) s_t++;
//      }
    }
    getApp()->slotStatusMsgUser( h, u_t, e_t );
    
#ifndef CRON_DILLON
  }else if ( log != NULL ){
    int u_t=0;
    for ( QListViewItemIterator it( view->logLvw ); it.current(); ++it ){
      TabLvi *c = (TabLvi*)it.current();
      if ( log->dType == CRON_LOG ){
        if ( c->logTbl()->Prog == log->logTbl()->Prog &&
             c->logTbl()->User == log->logTbl()->User ) u_t++;
        
      }else{
        if ( c->dType == log->dType ) u_t++;
      }
    }
    QString h = log->logTbl()->Prog;
    if ( log->dType == CRON_LOG ){
        h = h + "(" + log->logTbl()->User + ")";
    }
    getApp()->slotStatusMsgUser( h, u_t, 0 );
#endif    
  }
  if ( ! g_ViewMode ) getApp()->fileSave->setEnabled( bUpdate );
    
}
