/*
 system call list for ia32
 Copyright (c) 2005,2007 Hitachi,Ltd.,
 Created by Satoru Moriya <satoru.moriya.br@hitachi.com>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __KSTRAX_SYSCALL_LIST_H__
#define __KATRACE_SYSCALL_LIST_H__

#define IPC_MAX 24
#define SOCKETCALL_MAX 17

enum syscall {
	KS_RESTART=0,
	KS_EXIT,
	KS_FORK,
	KS_READ,
	KS_WRITE,
	KS_OPEN,               /* 5 */
	KS_CLOSE,
	KS_WAITPID,
	KS_CREAT,
	KS_LINK,
	KS_UNLINK,             /* 10 */
	KS_EXECVE,
	KS_CHDIR,
	KS_TIME,
	KS_MKNOD,
	KS_CHMOD,              /* 15 */
	KS_LCHOWN16,
	KS_OLD_BREAK,
	KS_STAT,
	KS_LSEEK,
	KS_GETPID,             /* 20 */
	KS_MOUNT,
	KS_OLDUMOUNT,
	KS_SETUID16,
	KS_GETUID16,
	KS_STIME,              /* 25 */
	KS_PTRACE,
	KS_ALARM,
	KS_FSTAT,
	KS_PAUSE,
	KS_UTIME,              /* 30 */
	KS_OLD_STTY,
	KS_OLD_GTTY,
	KS_ACCESS,
	KS_NICE,
	KS_OLD_FTIME,          /* 35 */
	KS_SYNC,
	KS_KILL,
	KS_RENAME,
	KS_MKDIR,
	KS_RMDIR,              /* 40 */
	KS_DUP,
	KS_PIPE,
	KS_TIMES,
	KS_OLD_PROF,
	KS_BRK,                /* 45 */
	KS_SETGID16,
	KS_GETGID16,
	KS_SIGNAL,
	KS_GETEUID16,
	KS_GETEGID16,          /* 50 */
	KS_ACCT,
	KS_UMOUNT,
	KS_OLD_LOCK,
	KS_IOCTL,
	KS_FCNTL,              /* 55 */
	KS_OLD_MPX,
	KS_SETPGID,
	KS_OLD_ULIMIT,
	KS_OLDUNAME,
	KS_UMASK,              /* 60 */
	KS_CHROOT,
	KS_USTAT,
	KS_DUP2,
	KS_GETPPID,
	KS_GETPGRP,            /* 65 */
	KS_SETSID,
	KS_SIGACTION,
	KS_SGETMASK,
	KS_SSETMASK,
	KS_SETREUID16,         /* 70 */
	KS_SETREGID16,
	KS_SIGSUSPEND,
	KS_SIGPENDING,
	KS_SETHOSTNAME,
	KS_SETRLIMIT,          /* 75 */
	KS_OLD_GETRLIMIT,
	KS_GETRUSAGE,
	KS_GETTIMEOFDAY,
	KS_SETTIMEOFDAY,
	KS_GETGROUPS16,        /* 80 */
	KS_SETGROUPS16,
	KS_OLD_SELECT,
	KS_SYMLINK,
	KS_LSTAT,
	KS_READLINK,           /* 85 */
	KS_USELIB,
	KS_SWAPON,
	KS_REBOOT,
	KS_READDIR,
	KS_OLD_MMAP,           /* 90 */
	KS_MUNMAP,
	KS_TRUNCATE,
	KS_FTRUNCATE,
	KS_FCHMOD,
	KS_FCHOWN16,           /* 95 */
	KS_GETPRIORITY,
	KS_SETPRIORITY,
	KS_OLD_PROFIL,
	KS_STATFS,
	KS_FSTATFS,            /* 100 */
	KS_IOPERM,
	KS_SOCKETCALL,
	KS_SYSLOG,
	KS_SETITIMER,
	KS_GETITIMER,          /* 105 */
	KS_NEWSTAT,
	KS_NEWLSTAT,
	KS_NEWFSTAT,
	KS_UNAME,
	KS_IOPL,               /* 110 */
	KS_VHANGUP,
	KS_OLD_IDLE,
	KS_VM86OLD,
	KS_WAIT4,
	KS_SWAPOFF,            /* 115 */
	KS_SYSINFO,
	KS_IPC,
	KS_FSYNC,
	KS_SIGRETURN,
	KS_CLONE,              /* 120 */
	KS_SETDOMAINNAME,
	KS_NEWUNAME,
	KS_MODIFY_LDT,
	KS_ADJTIMEX,
	KS_MPROTECT,           /* 125 */
	KS_SIGPROCMASK,
	KS_OLD_CREATE_MODULE,
	KS_INIT_MODULE,
	KS_DELETE_MODULE,
	KS_GET_KERNEL_SYMS,    /* 130 */
	KS_QUOTACTL,
	KS_GETPGID,
	KS_FCHDIR,
	KS_BDFLUSH,
	KS_SYSFS,              /* 135 */
	KS_PERSONALITY,
	KS_AFS_SYSCALL,
	KS_SETFSUID16,
	KS_SETFSGID16,
	KS_LLSEEK,             /* 140 */
	KS_GETDENTS,
	KS_SELECT,
	KS_FLOCK,
	KS_MSYNC,
	KS_READV,              /* 145 */
	KS_WRITEV,
	KS_GETSID,
	KS_FDATASYNC,
	KS_SYSCTL,
	KS_MLOCK,              /* 150 */
	KS_MUNLOCK,
	KS_MLOCKALL,
	KS_MUNLOCKALL,
	KS_SCHED_SETPARAM,
	KS_SCHED_GETPARAM,     /* 155 */
	KS_SCHED_SETSCHEDULER,
	KS_SCHED_GETSCHEDULER,
	KS_SCHED_YIELD,
	KS_SCHED_GET_PRIORITY_MAX,
	KS_SCHED_GET_PRIORITY_MIN,  /* 160 */
	KS_SCHED_RR_GET_INTERVAL,
	KS_NANOSLEEP,
	KS_MREMAP,
	KS_SETRESUID16,
	KS_GETRESUID16,        /* 165 */
	KS_VM86,
	KS_OLD_SYS_QUERY_MODULE,
	KS_POLL,
	KS_NFSSERVCTL,
	KS_SETRESGID16,        /* 170 */
	KS_GETRESGID16,
	KS_PRCTL,
	KS_RT_SIGRETURN,
	KS_RT_SIGACTION,
	KS_RT_SIGPROCMASK,     /* 175 */
	KS_RT_SIGPENDING,
	KS_RT_SIGTIMEDWAIT,
	KS_RT_SIGQUEUEINFO,
	KS_RT_SIGSUSPEND,
	KS_PREAD64,            /* 180 */
	KS_PWRITE64,
	KS_CHOWN16,
	KS_GETCWD,
	KS_CAPGET,
	KS_CAPSET,             /* 185 */
	KS_SIGALTSTACK,
	KS_SENDFILE,
	KS_STERAMS1,
	KS_STREAMS2,
	KS_VFORK,              /* 190 */
	KS_GETRLIMIT,
	KS_MMAP2,
	KS_TRUNCATE64,
	KS_FTRUNCATE64,
	KS_STAT64,             /* 195 */
	KS_LSTAT64,
	KS_FSTAT64,
	KS_LCHOWN,
	KS_GETUID,
	KS_GETGID,             /* 200 */
	KS_GETEUID,
	KS_GETEGID,
	KS_SETREUID,
	KS_SETREGID,
	KS_GETGROUPS,          /* 205 */
	KS_SETGROUPS,
	KS_FCHOWN,
	KS_SETRESUID,
	KS_GETRESUID,
	KS_SETRESGID,          /* 210 */
	KS_GETRESGID,
	KS_CHOWN,
	KS_SETUID,
	KS_SETGID,
	KS_SETFSUID,           /* 215 */
	KS_SETFSGID,
	KS_PIVOT_ROOT,
	KS_MINCORE,
	KS_MADVISE,
	KS_GETDENTS64,          /* 220 */
	KS_FCNTL64,
	KS_TUX,
	KS_NR_223,
	KS_GETTID,
	KS_READAHEAD,          /* 225 */
	KS_SETXATTR,
	KS_LSETXATTR,
	KS_FSETXATTR,
	KS_GETXATTR,
	KS_LGETXATTR,          /* 230 */
	KS_FGETXATTR,
	KS_LISTXATTR,
	KS_LLISTXATTR,
	KS_FLISTXATTR,
	KS_REMOVEXATTR,        /* 235 */
	KS_LREMOVEXATTR,
	KS_FREMOVEXATTR,
	KS_TKILL,
	KS_SENDFILE64,
	KS_FUTEX,              /* 240 */
	KS_SCHED_SETAFFINITY,
	KS_SCHED_GETAFFINITY,
	KS_SET_THREAD_AREA,
	KS_GET_THREAD_AREA,
	KS_IO_SETUP,           /* 245 */
	KS_IO_DESTROY,
	KS_IO_GETEVENTS,
	KS_IO_SUBMIT,
	KS_IO_CANCEL,
	KS_FADVISE64,          /* 250 */
	KS_NR_251,
	KS_EXIT_GROUP,
	KS_LOOKUP_DCOOKIE,
	KS_EPOLL_CREATE,
	KS_EPOLL_CTL,          /* 255 */
	KS_EPOLL_WAIT,
	KS_REAMAP_FILE_PAGES,
	KS_SET_TID_ADDRESS,
	KS_TIMER_CREATE,
	KS_TIMER_SETTIME,      /* 260 */
	KS_TIMER_GETTIME,
	KS_TIMER_GETOVERRUN,
	KS_TIMER_DELETE,
	KS_CLOCK_SETTIME,
	KS_CLOCK_GETTIME,      /* 265 */
	KS_CLOCK_GETRES,
	KS_CLOCK_NANOSLEEP,
	KS_STATFS64,
	KS_FSTATFS64,
	KS_TGKILL,             /* 270 */
	KS_UTIMES,
	KS_FADVISE64_64,
	KS_SYS_VSERVER,
	KS_MBIND,
	KS_GET_MEMPOLICY,      /* 275 */
	KS_SET_MEMPOLICY,
	KS_MQ_OPEN,
	KS_MQ_UNLINK,
	KS_MQ_TIMEDSEND,
	KS_MQ_TIMEDRECEIVE,    /* 280 */
	KS_MQ_NOTIFY,
	KS_MQ_GETSETATTR,
	KS_KEXEC,
	KS_WAITID,
	KS_NR_285,             /* 285 */
	KS_ADD_KEY,
	KS_REQUEST_KEY,
	KS_KEYCTL,
	KS_IOPRIO_SET,
	KS_IOPRIO_GET,         /* 290 */
	KS_INOTIFY_INIT,
	KS_INOTIFY_ADD_WATCH,
	KS_INOTIFY_RM_WATCH,
	KS_MIGRATE_PAGES,
	KS_OPENAT,             /* 295 */
	KS_MKDIRAT,
	KS_MKNODAT,
	KS_FCHOWNAT,
	KS_FUTIMESAT,
	KS_FSTATAT64,          /* 300 */
	KS_UNLINKAT,
	KS_RENAMEAT,
	KS_LINKAT,
	KS_SYMLINKAT,
	KS_READLINKAT,         /* 305 */
	KS_FCHMODAT,
	KS_FACCESSAT,
	KS_PSELECT6,
	KS_PPOLL,
	KS_UNSHARE,            /* 310 */
	KS_SET_ROBUST_LIST,
	KS_GET_ROBUST_LIST,
	KS_SPLICE,
	KS_SYNC_FILE_RANGE,
	KS_TEE,                /* 315 */
	KS_VMSPLICE,
	KS_MOVE_PAGES,
	KS_GETCPU,
	KS_EPOLL_PWAIT
};

enum socketcall_syscall {
	KS_SOCKET = 1,
	KS_BIND,
	KS_CONNECT,
	KS_LISTEN,
	KS_ACCEPT,
	KS_GETSOCKNAME,
	KS_GETPEERNAME,
	KS_SOCKETPAIR,
	KS_SEND,
	KS_RECV,
	KS_SENDTO,
	KS_RECVFROM,
	KS_SHUTDOWN,
	KS_SETSOCKOPT,
	KS_GETSOCKOPT,
	KS_SENDMSG,
	KS_RECVMSG
};

enum ipc_syscall {
	KS_SEMOP = 1,
	KS_SEMGET,
	KS_SEMCTL,
	KS_SEMTIMEDOP,
	KS_MSGSND = 11,
	KS_MSGRCV,
	KS_MSGGET,
	KS_MSGCTL,
	KS_SHMAT = 21,
	KS_SHMDT,
	KS_SHMGET,
	KS_SHMCTL
};

#endif  /* __KSTRAX_SYSCALL_LIST_H__ */ 
