/*
 mbuffer -- buffer module
 Copyright (c) 2005,2007 Hitachi,Ltd.,
 Created by Satoru Moriya <satoru.moriya.br@hitachi.com>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MBUFFER_ARCH_H__
#define __MBUFFER_ARCH_H__

#include "ctr.h"
#include "kstrax_ioc.h"
#include "kstrax_syscall_list.h"

#define SPECIFIED_FILE (kstrax_status.trace_syscall[KS_OPEN] == 1 && \
		       	kstrax_status.trace_syscall[KS_CREAT] == 1 && \
			kstrax_status.trace_syscall[KS_LINK] == 1 && \
			kstrax_status.trace_syscall[KS_UNLINK] == 1 && \
			kstrax_status.trace_syscall[KS_EXECVE] == 1 && \
			kstrax_status.trace_syscall[KS_CHDIR] == 1 && \
			kstrax_status.trace_syscall[KS_MKNOD] == 1 && \
			kstrax_status.trace_syscall[KS_CHMOD] == 1 && \
			kstrax_status.trace_syscall[KS_LCHOWN16] == 1 && \
			kstrax_status.trace_syscall[KS_STAT] == 1 && \
			kstrax_status.trace_syscall[KS_MOUNT] == 1 && \
			kstrax_status.trace_syscall[KS_OLDUMOUNT] == 1 && \
			kstrax_status.trace_syscall[KS_UTIME] == 1 && \
			kstrax_status.trace_syscall[KS_ACCESS] == 1 && \
			kstrax_status.trace_syscall[KS_RENAME] == 1 && \
			kstrax_status.trace_syscall[KS_MKDIR] == 1 && \
			kstrax_status.trace_syscall[KS_RMDIR] == 1 && \
			kstrax_status.trace_syscall[KS_ACCT] == 1 && \
			kstrax_status.trace_syscall[KS_UMOUNT] == 1 && \
			kstrax_status.trace_syscall[KS_CHROOT] == 1 && \
			kstrax_status.trace_syscall[KS_SYMLINK] == 1 && \
			kstrax_status.trace_syscall[KS_LSTAT] == 1 && \
			kstrax_status.trace_syscall[KS_READLINK] == 1 && \
			kstrax_status.trace_syscall[KS_USELIB] == 1 && \
			kstrax_status.trace_syscall[KS_SWAPON] == 1 && \
			kstrax_status.trace_syscall[KS_TRUNCATE] == 1 && \
			kstrax_status.trace_syscall[KS_STATFS] == 1 && \
			kstrax_status.trace_syscall[KS_NEWSTAT] == 1 && \
			kstrax_status.trace_syscall[KS_NEWLSTAT] == 1 && \
			kstrax_status.trace_syscall[KS_PREAD64] == 1 && \
			kstrax_status.trace_syscall[KS_PWRITE64] == 1 && \
			kstrax_status.trace_syscall[KS_CHOWN16] == 1 && \
			kstrax_status.trace_syscall[KS_GETCWD] == 1 && \
			kstrax_status.trace_syscall[KS_SENDFILE] == 1 && \
			kstrax_status.trace_syscall[KS_TRUNCATE64] == 1 && \
			kstrax_status.trace_syscall[KS_FTRUNCATE64] == 1 && \
			kstrax_status.trace_syscall[KS_STAT64] == 1 && \
			kstrax_status.trace_syscall[KS_LSTAT64] == 1 && \
			kstrax_status.trace_syscall[KS_FSTAT64] == 1 && \
			kstrax_status.trace_syscall[KS_LCHOWN] == 1 && \
			kstrax_status.trace_syscall[KS_CHOWN] == 1 && \
			kstrax_status.trace_syscall[KS_PIVOT_ROOT] == 1 && \
			kstrax_status.trace_syscall[KS_SETXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_LSETXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_GETXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_LGETXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_LISTXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_LLISTXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_REMOVEXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_LREMOVEXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_SENDFILE64] == 1 && \
			kstrax_status.trace_syscall[KS_FADVISE64] == 1 && \
			kstrax_status.trace_syscall[KS_STATFS64] == 1 && \
			kstrax_status.trace_syscall[KS_FSTATFS64] == 1 && \
			kstrax_status.trace_syscall[KS_UTIMES] == 1 && \
			kstrax_status.trace_syscall[KS_FADVISE64_64])

#define SPECIFIED_PROCESS (kstrax_status.trace_syscall[KS_EXIT] == 1 && \
			   kstrax_status.trace_syscall[KS_FORK] == 1 && \
			   kstrax_status.trace_syscall[KS_WAITPID] == 1 && \
			   kstrax_status.trace_syscall[KS_EXECVE] == 1 && \
			   kstrax_status.trace_syscall[KS_WAIT4] == 1 && \
			   kstrax_status.trace_syscall[KS_CLONE] == 1 && \
			   kstrax_status.trace_syscall[KS_VFORK] == 1 && \
			   kstrax_status.trace_syscall[KS_WAITID] == 1)
    
#define SPECIFIED_SIGNAL (kstrax_status.trace_syscall[KS_PAUSE] == 1 && \
			  kstrax_status.trace_syscall[KS_KILL] == 1 && \
			  kstrax_status.trace_syscall[KS_SIGNAL] == 1 && \
			  kstrax_status.trace_syscall[KS_SIGACTION] == 1 && \
			  kstrax_status.trace_syscall[KS_SGETMASK] == 1 && \
			  kstrax_status.trace_syscall[KS_SSETMASK] == 1 && \
			  kstrax_status.trace_syscall[KS_SIGSUSPEND] == 1 && \
			  kstrax_status.trace_syscall[KS_SIGPENDING] == 1 && \
			  kstrax_status.trace_syscall[KS_SIGRETURN] == 1 && \
			  kstrax_status.trace_syscall[KS_SIGPROCMASK] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGRETURN] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGACTION] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGPROCMASK] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGPENDING] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGTIMEDWAIT] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGSUSPEND] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGQUEUEINFO] == 1 && \
			  kstrax_status.trace_syscall[KS_TKILL] == 1 && \
			  kstrax_status.trace_syscall[KS_TGKILL] == 1 && \
			  kstrax_status.trace_syscall[KS_SIGALTSTACK] == 1)

#define SPECIFIED_DEMO (kstrax_status.trace_syscall[KS_READ] == 1 && \
			kstrax_status.trace_syscall[KS_WRITE] == 1 && \
			kstrax_status.trace_syscall[KS_OPEN] == 1 && \
			kstrax_status.trace_syscall[KS_CLOSE] == 1 && \
			kstrax_status.trace_syscall[KS_EXECVE] == 1 && \
			kstrax_status.trace_syscall[KS_TIME] == 1 && \
			kstrax_status.trace_syscall[KS_GETTIMEOFDAY] == 1 && \
			kstrax_status.trace_syscall[KS_CLONE] == 1)

#define IS_FILE_SYSCALL(i) \
if (i == KS_OPEN || i == KS_CREAT || i == KS_LINK || i == KS_UNLINK || \
    i == KS_EXECVE || i == KS_CHDIR || i == KS_MKNOD || i == KS_CHMOD || \
    i == KS_LCHOWN16 || i == KS_STAT || i == KS_MOUNT || i == KS_OLDUMOUNT || \
    i == KS_UTIME || i == KS_ACCESS || i == KS_RENAME || i == KS_MKDIR || \
    i == KS_RMDIR || i == KS_ACCT || i == KS_UMOUNT || i == KS_CHROOT || \
    i == KS_SYMLINK || i == KS_LSTAT || i == KS_READLINK || i == KS_USELIB || \
    i == KS_SWAPON || i == KS_TRUNCATE || i == KS_STATFS || i== KS_NEWSTAT || \
    i == KS_NEWLSTAT || i == KS_PREAD64 || i == KS_PWRITE64 || i == KS_CHOWN16 || \
    i == KS_GETCWD || i == KS_SENDFILE || i == KS_TRUNCATE64 || \
    i == KS_FTRUNCATE64 || i == KS_STAT64 || i == KS_LSTAT64 || \
    i == KS_FSTAT64 || i == KS_LCHOWN || i == KS_CHOWN || i == KS_PIVOT_ROOT || \
    i == KS_SETXATTR || i == KS_LSETXATTR || i == KS_GETXATTR || \
    i == KS_LGETXATTR || i == KS_LISTXATTR || i == KS_LLISTXATTR || \
    i == KS_REMOVEXATTR || i == KS_LREMOVEXATTR || i == KS_SENDFILE64 || \
    i == KS_FADVISE64 || i == KS_STATFS64 || i == KS_FSTATFS64 || \
    i == KS_UTIMES || i == KS_FADVISE64_64)

#define IS_PROCESS_SYSCALL(i) \
if (i == KS_EXIT || i == KS_FORK || i == KS_WAITPID || i == KS_EXECVE || \
    i == KS_WAIT4 || i == KS_CLONE || i == KS_VFORK || i == KS_WAITID)

#define IS_SIGNAL_SYSCALL(i) \
if (i == KS_PAUSE || i == KS_KILL || i == KS_SIGNAL || i == KS_SIGACTION || \
    i == KS_SGETMASK || i == KS_SSETMASK || i == KS_SIGSUSPEND || \
    i == KS_SIGPENDING || i == KS_SIGRETURN || i == KS_SIGPROCMASK ||\
    i == KS_RT_SIGRETURN || i == KS_RT_SIGACTION || i == KS_RT_SIGPROCMASK || \
    i == KS_RT_SIGPENDING || i == KS_RT_SIGTIMEDWAIT || i == KS_RT_SIGSUSPEND || \
    i == KS_RT_SIGQUEUEINFO || i == KS_TKILL || i == KS_TGKILL || \
    i == KS_SIGALTSTACK)

#define IS_DEMO_SYSCALL(i) \
if (i == KS_READ || i == KS_WRITE || i == KS_OPEN || i == KS_CLOSE || \
    i == KS_EXECVE || i == KS_TIME || i == KS_GETTIMEOFDAY || i == KS_CLONE)

#define NOT_TRACE -1

typedef atomic_t kstrax_serial_t;

typedef struct sys_call_info {
	pid_t pid;
	short sys_call_number;
	long time;
	long utime;
	long arg_1;
	union {
		long arg_2;
		long return_value;
	};
	long arg_3;
	long arg_4;
	long arg_5;
	long arg_6;
	int  serial; /* int */
	int  cpu;
} sys_call_t;

typedef struct kbuffer_head {
	sys_call_t *buffer;
	int size;
	int w_index;
	int r_index;
	int limit_index;
	int wakeup_index;
	int wakeup_flag;
	wait_queue_head_t wq_head;
	struct tasklet_struct kst_tasklet;
} buf_head_t;

static void test_flag_spec_syscall(void);
static int kstrax_trace_each_syscall(int);

static inline void __set_basetime(sys_call_t *kst_time)
{	struct timeval tv;
	
	/* get the system time (tsc & gettimeofday) */
	do_gettimeofday(&tv);
	rdtsc(kst_time->utime, kst_time->time);
	kst_time->arg_1 = tv.tv_sec;
	kst_time->arg_2 = tv.tv_usec;	
	kst_time->arg_3 = cpu_khz;
	kst_time->pid = KS_BASETIME;
}

static inline void __kstrax_init_ipc_socketcall(trace_stat_t *kstrax_status)
{
	int i;
	for (i = 0; i < NR_SOCKETCALL; i++) 
		kstrax_status->trace_socketcall[i] = 0;
	for (i = 0; i < NR_IPC; i++)
		kstrax_status->trace_ipc[i] = 0;
}

static inline void __set_each_socketcall(int syscall_num, 
					 trace_stat_t *kstrax_status)
{
	int index;
	if (syscall_num == KS_SOCKETCALL) {
		index = 0;
	} else {
		index = -syscall_num - 7;
	}

	if (kstrax_status->trace_socketcall[index] == 1) {
		kstrax_status->trace_socketcall[index] = 0;
	} else { 
		kstrax_status->trace_socketcall[index] = 1;
	}
}

static inline void __check_trace_socketcall(trace_stat_t *kstrax_status)
{
	int i, trace_count = 0;	
	for (i = 0; i < NR_SOCKETCALL; i++) {
		if (kstrax_status->trace_socketcall[i] == 1)
			trace_count++;
	}
	if (trace_count == 0)
		kstrax_status->trace_syscall[KS_SOCKETCALL] = 0;
	else
		kstrax_status->trace_syscall[KS_SOCKETCALL] = 1;
}

static inline void __kstrax_trace_socketcall(int syscall_num, 
					     trace_stat_t *kstrax_status)
{
	int i;
       
	if (syscall_num == TRACE_NETWORK) {
		int add_count = 0;
		for (i = 1; i < NR_SOCKETCALL; i++) {
			if (kstrax_status->trace_socketcall[i] == 0) {
				add_count++;
				kstrax_status->trace_socketcall[i] = 1;
			}
		}
		if (add_count == 0) {/* off */
			for (i = 1; i < NR_SOCKETCALL; i++)
				kstrax_status->trace_socketcall[i] = 0;
		}
	} else {
		__set_each_socketcall(syscall_num, kstrax_status);
	}
	__check_trace_socketcall(kstrax_status);
	test_flag_spec_syscall();
}

static inline void __set_each_ipc(int syscall_num, trace_stat_t *kstrax_status)
{
	int num;
	int index[13] = {0, 1, 2, 3, 4, 11, 12, 13, 14, 21, 22, 23, 24};

	if (syscall_num == KS_IPC) {
		num = 0;
	} else { 
		num = -syscall_num -24;
	}
	
	if (kstrax_status->trace_ipc[index[num]] == 1) {
		kstrax_status->trace_ipc[index[num]] = 0;
	} else {
		kstrax_status->trace_ipc[index[num]] = 1;
	}
}

static inline void __check_trace_ipc(trace_stat_t *kstrax_status)
{
	int i, trace_count = 0;
	
	for (i = 0; i < NR_IPC; i++) {
		if (kstrax_status->trace_ipc[i] == 1) {
			trace_count++;
		}
	}
	if (trace_count == 0) {
		kstrax_status->trace_syscall[KS_IPC] = 0;
	} else {
		kstrax_status->trace_syscall[KS_IPC] = 1;
	}
}

static inline void __kstrax_trace_ipc(int syscall_num, 
				      trace_stat_t *kstrax_status)
{
	int i;
	
	if (syscall_num == TRACE_IPC) {
		int add_count = 0;
		for (i = 1; i < NR_IPC; i++) {
			if ((4 < i && i < 11) || (14 < i && i < 21))
				continue;
			if (kstrax_status->trace_ipc[i] == 0) {
				add_count++;
				kstrax_status->trace_ipc[i] = 1;
			}
		}
		if (add_count == 0) {
			for (i = 1; i < NR_IPC; i++)
				kstrax_status->trace_ipc[i] = 0;
		}
	} else  {
		__set_each_ipc(syscall_num, kstrax_status);
	}
	__check_trace_ipc(kstrax_status);
	test_flag_spec_syscall();
}

static inline int __kstrax_syscall_spec_default(int syscall_num,
						trace_stat_t *kstrax_status)
{
	int retval = 0;
	
	if (TRACE_SOCKET >= syscall_num &&
	    syscall_num >= TRACE_RECVMSG) {
		__kstrax_trace_socketcall(syscall_num, kstrax_status);
	} else if (TRACE_SEMOP >= syscall_num &&
		   syscall_num >= TRACE_SHMCTL) {
		__kstrax_trace_ipc(syscall_num, kstrax_status);
	} else {
		printk(KERN_ERR "error(syscall_spec):bad argument\n");
		retval = -EINVAL;
	}
	return retval;
}

static inline int __kstrax_syscall_spec_by_syscall_num(int syscall_num,
						       trace_stat_t *kstrax_status)
{
	int retval = 0;
	if (syscall_num == KS_SOCKETCALL) {
		__kstrax_trace_socketcall(syscall_num, kstrax_status);
	} else if (syscall_num == KS_IPC) {
		__kstrax_trace_ipc(syscall_num, kstrax_status);
	} else {
		retval = kstrax_trace_each_syscall(syscall_num);
	}
	return retval;
}

static inline int __check_tracing_socketcall(const ctr_arg_t *args,
					     trace_stat_t *kstrax_status)
{
	int retval = 0;

	if (0 < args->regs.ebx && args->regs.ebx < 18) {
		if (kstrax_status->trace_socketcall[args->regs.ebx] == 0)
			retval = NOT_TRACE;
	} else {
		if (kstrax_status->trace_socketcall[0] == 0)
			retval = NOT_TRACE;
	}
	return retval;
}

static inline int __check_tracing_ipc(const ctr_arg_t * args,
				      trace_stat_t *kstrax_status)
{
	int retval = 0;

	if ((0 < args->regs.ebx && args->regs.ebx < 5) ||
	    (10 < args->regs.ebx && args->regs.ebx < 15) ||
	    (20 < args->regs.ebx && args->regs.ebx < 25)) {
		if (kstrax_status->trace_ipc[args->regs.ebx] == 0)
			retval = NOT_TRACE;
	} else {
		if (kstrax_status->trace_ipc[0] == 0)
			retval = NOT_TRACE;
	}
	return retval;
}

static inline int __check_tracing_syscall(const ctr_arg_t *args,
					  trace_stat_t *kstrax_status)
{
	int retval = 0;

	if (args->regs.orig_eax == -1) {
		/* sigreturn or rt_sigreturn */
		if (kstrax_status->trace_syscall[KS_SIGRETURN] == 0 &&
		    kstrax_status->trace_syscall[KS_RT_SIGRETURN] == 0)
			retval = NOT_TRACE;
	} else if (args->regs.orig_eax == KS_SOCKETCALL) {
		/* socketcall */
		if (kstrax_status->trace_syscall[KS_SOCKETCALL] == 0) {
			retval = NOT_TRACE;
		} else {
			retval = __check_tracing_socketcall(args, kstrax_status);
		}
	} else if (args->regs.orig_eax == KS_IPC) {
		/* ipc */
		if (kstrax_status->trace_syscall[KS_IPC] == 0) {
			retval = NOT_TRACE;
		} else { 
			retval = __check_tracing_ipc(args, kstrax_status);
		}
	} else {
		/* everything else */
		if (kstrax_status->trace_syscall[args->regs.orig_eax] == 0)
			retval = NOT_TRACE;
	} 

	return retval;
}

static inline void __kstrax_get_filename(const ctr_arg_t *args, 
					 buf_head_t *head, 
					 sys_call_t **buf)
{
	int i;
	int division_size, len;
	int nr_add = 0;
	char filename[256] = {'\0'};
	sys_call_t *name = NULL;

	/* copy filename */
	if (args->regs.orig_eax == KS_OPEN || args->regs.orig_eax == KS_CREAT) {
		division_size = sizeof(sys_call_t) - \
			((unsigned long)&(*buf)->time - (unsigned long)(*buf)) -1;
		put_cpu();
		/* might sleep */
		len = strncpy_from_user(filename, (const char *)args->regs.ebx, 
					256);
		get_cpu();

		if (len < 0) {
			printk("Error at strncpy_from_user\n");
			return;
		}
		if (len % division_size)
			nr_add = len / division_size + 1;
		else
			nr_add = len / division_size;

		/* reload buf index*/
		*buf = &head->buffer[head->w_index];
		name = &head->buffer[(head->w_index + 1) % head->size];

		for (i = 0; i < nr_add; i++) {
			memset(name, 0, sizeof(sys_call_t));
			name->pid = KS_FILENAME;
			/* store return value(file descriptor) */
			name->sys_call_number = args->regs.eax;
			strncpy((char *)&name->time,
				(const char *)&filename[i * division_size],
				division_size);

			head->w_index = (head->w_index + 1) % head->size;
			if (head->w_index == head->r_index) {
				head->r_index = (head->r_index + 1) % head->size;
			}
			name = &head->buffer[head->w_index];
		}
	}
}

static inline void __record_sys_call_information_pre(const ctr_arg_t *args,
						     sys_call_t *buf,
						     kstrax_serial_t *serial,
						     __u32 cpu)
{
	buf->pid = current->pid;
	rdtsc(buf->utime, buf->time);
	buf->sys_call_number = args->regs.orig_eax;
	buf->arg_1 = args->regs.ebx;
	buf->arg_2 = args->regs.ecx;
	buf->arg_3 = args->regs.edx;
	buf->arg_4 = args->regs.esi;
	buf->arg_5 = args->regs.edi;
	buf->arg_6 = args->regs.ebp;
	buf->serial = atomic_inc_return((atomic_t *)serial); 
	buf->cpu = cpu;
}

static inline void __record_sys_call_information_post(const ctr_arg_t *args,
						      sys_call_t *buf,
						      kstrax_serial_t *serial,
						      __u32 cpu)
{
	buf->pid = current->pid;
	rdtsc(buf->utime, buf->time);
	
	if (args->regs.orig_eax == -1) /* sigreturn is special */
		buf->sys_call_number = -KS_SIGRETURN;
	else 
		buf->sys_call_number = -args->regs.orig_eax;
	
	buf->return_value = args->regs.eax;
	buf->arg_1 = args->regs.ebx;  /* for ipc & socketcall */
	buf->serial = atomic_inc_return((atomic_t *)serial);
	buf->cpu = cpu;

	if (args->regs.orig_eax == 0) {
		buf->arg_1 = MAGIC_SYSCALL_ZERO;
		buf->arg_3 = MAGIC_SYSCALL_ZERO;
		buf->arg_4 = MAGIC_SYSCALL_ZERO;
		buf->arg_5 = MAGIC_SYSCALL_ZERO;
		buf->arg_6 = MAGIC_SYSCALL_ZERO;
	}
}
#endif /* __MBUFFER_ARCH_H__*/
