/*
 syscall_name - system call information for RedHat Enterprise Linux AS 4
 Copyright (c) 2006,2007 Hitachi,Ltd.,
 Created by Satoru Moriya <satoru.moriya.br@hitachi.com>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "syscall_name.h"

struct syscall_attribute syscall_name[] = {
	[0] = {"restart_syscall" , 0, 0},
	[1] = {"exit" ,   1,  0},
	[2] = {"fork" ,   0,  0},
	[3] = {"read" ,   3,  2},
	[4] = {"write" ,  3,  2},
	[5] = {"open" ,   3,  1},
	[6] = {"close" ,  1,  0},
	[7] = {"waitpid" ,3,  2},
	[8] = {"creat" ,  2,  1},
	[9] = {"link" ,   2,  3},
	[10] = {"unlink" , 1, 1},
	[11] = {"execve" , 3, 7},
	[12] = {"chdir" ,  1, 1},
	[13] = {"time" ,   1, 1},
	[14] = {"mknod" ,  3, 1},
	[15] = {"chmod" ,  2, 1},
	[16] = {"lchown16" , 3, 1},
	[17] = {"break", 0, 0}, /* break not implemented */
	[18] = {"stat" , 2, 3}, /* obsolete */
	[19] = {"lseek" ,  3, 0},
	[20] = {"getpid" , 0, 0},
	[21] = {"mount" ,  5, 23},
	[22] = {"oldumount" , 1, 1}, 
	[23] = {"setuid16" , 1, 0},
	[24] = {"getuid16" , 0, 0},
	[25] = {"stime" ,  1, 1},
	[26] = {"ptrace" , 4, 0},
	[27] = {"alarm" ,  1, 0},
	[28] = {"fstat" ,  2, 2}, /* obsolete */
	[29] = {"pause" ,  0, 0},
	[30] = {"utime" ,  2, 3},
	[31] = {"stty",    2, 3}, /* stty not implemented */
	[32] = {"gtty",    2, 3}, /* gtty not implemented */
	[33] = {"access" , 2, 1},
	[34] = {"nice" ,   1, 0},
	[35] = {"ftime",   0, 0}, /* ftime not implemented */
	[36] = {"sync" ,   0, 0},
	[37] = {"kill" ,   2, 0},
	[38] = {"rename" , 2, 3},
	[39] = {"mkdir" ,  2, 1},
	[40] = {"rmdir" ,  1, 1},
	[41] = {"dup" ,    1, 0},
	[42] = {"pipe" ,   1, 1},
	[43] = {"times" ,  1, 1},
	[44] = {"prof",    0, 0}, /* prof not implemented */
	[45] = {"brk" ,    1, 0},
	[46] = {"setgid16" , 1, 0},
	[47] = {"getgid16" , 0, 0},
	[48] = {"signal" , 2, 0},
	[49] = {"geteuid16" ,0, 0},
	[50] = {"getegid16" ,0, 0},
	[51] = {"acct" ,   1, 1},
	[52] = {"umount" ,2, 1},
	[53] = {"lock",   0, 0}, /* lock not implemented */
	[54] = {"ioctl" ,  3, 0},
	[55] = {"fcntl" ,  3, 0},
	[56] = {"mpx",     0, 0}, /* mpx not implemented */
	[57] = {"setpgid" ,2, 0},
	[58] = {"ulimit",  2, 3}, /* ulimit not implemented */
	[59] = {"olduname" , 1, 1}, /* obsolete */
	[60] = {"umask" ,  1, 0},
	[61] = {"chroot" , 1, 1},
	[62] = {"ustat" ,  2, 2},
	[63] = {"dup2" ,   2, 0},
	[64] = {"getppid" ,0, 0},
	[65] = {"getpgrp" ,0, 0},
	[66] = {"setsid" , 0, 0},
	[67] = {"sigaction" ,  3, 6},
	[68] = {"sgetmask" ,   0, 0}, /* siggetmask */
	[69] = {"ssetmask" ,   1, 0}, /* sigsetmask */
	[70] = {"setreuid16" ,   2, 0},
	[71] = {"setregid16" ,   2, 0},
	[72] = {"sigsuspend" , 3, 0},
	[73] = {"sigpending" , 1, 1},
	[74] = {"sethostname" ,2, 1},
	[75] = {"setrlimit" ,  2, 2},
	[76] = {"old_getrlimit" ,  2, 2},
	[77] = {"getrusage" ,  2, 2},
	[78] = {"gettimeofday" , 2, 3},
	[79] = {"settimeofday" , 2, 3},
	[80] = {"getgroups16" ,  2, 2},
	[81] = {"setgroups16" ,  2, 2},
	[82] = {"old_select" , 1, 1},
	[83] = {"symlink" ,    2, 3},
	[84] = {"lstat" ,   2, 3},
	[85] = {"readlink" ,   3, 3},
	[86] = {"uselib" ,  1, 1},
	[87] = {"swapon" ,  2, 1},
	[88] = {"reboot" ,  4, 8},
	[89] = {"old_readdir" , 3, 2},
	[90] = {"old_mmap" ,    1, 1},
	[91] = {"munmap" ,  2, 0},
	[92] = {"truncate" ,2, 1},
	[93] = {"ftruncate" ,  2, 0},
	[94] = {"fchmod" ,     2, 0},
	[95] = {"fchown16" ,     3, 0},
	[96] = {"getpriority" ,2, 0},
	[97] = {"setpriority" ,3, 0},
	[98] = {"profil",   4, 15}, /* OLD profil is not implemented now  */
	[99] = {"statfs" ,  2, 3},
	[100] = {"fstatfs" ,2, 2},
	[101] = {"ioperm" , 3, 0},
	[102] = {"socketcall" ,2, 2},
	[103] = {"syslog" ,    3, 2},
	[104] = {"setitimer" , 3, 6},
	[105] = {"getitimer" , 2, 2},
	[106] = {"newstat" ,      2, 3},
	[107] = {"newlstat" ,     2, 3},
	[108] = {"newfstat" ,     2, 2},
	[109] = {"uname" ,  1, 1},      /* obsolete */
	[110] = {"iopl" ,      1, 0},
	[111] = {"vhangup" ,   0, 0},
	[112] = {"idle" ,      0, 0},   /* OLD (now not implemented) */
	[113] = {"vm86old" ,   1, 1},
	[114] = {"wait4" ,     4, 10},
	[115] = {"swapoff" ,   1, 1},
	[116] = {"sysinfo" ,   1, 1},
	[117] = {"ipc" ,       6, 48},   /*----------- henko------------ */
	[118] = {"fsync" ,     1, 0},
	[119] = {"sigreturn" , 1, 0},
	[120] = {"clone" ,     5, 30},
	[121] = {"setdomainname" , 2, 1},
	[122] = {"newuname" ,     1, 1},
	[123] = {"modify_ldt" ,3, 2},
	[124] = {"adjtimex" ,  1, 1},
	[125] = {"mprotect" ,  3, 0},
	[126] = {"sigprocmask" ,   3, 6},
	[127] = {"create_module" , 2, 1},    /* OLD (now not implemented) */
	[128] = {"init_module" ,   3, 5},
	[129] = {"delete_module" , 2, 1},
	[130] = {"get_kernel_syms" , 1, 1},  /* OLD (now not implemented) */
	[131] = {"quotactl" ,  4, 10},
	[132] = {"getpgid" ,   1, 0},
	[133] = {"fchdir" ,    1, 0},
	[134] = {"bdflush" ,   2, 0},
	[135] = {"sysfs" ,     3, 0},
	[136] = {"personality" ,   1, 0},
	[137] = {"afs_syscall",5, 63}, /* afs_syscall not implemented */
	[138] = {"setfsuid16" ,  1, 0},
	[139] = {"setfsgid16" ,  1, 0},
	[140] = {"llseek" ,   5, 8},
	[141] = {"getdents" ,  3, 2},
	[142] = {"select" ,5, 30},
	[143] = {"flock" ,     2, 0},
	[144] = {"msync" ,     3, 0},
	[145] = {"readv" ,     3, 2},
	[146] = {"writev" ,    3, 2},
	[147] = {"getsid" ,    1, 0},
	[148] = {"fdatasync" , 1, 0},
	[149] = {"sysctl" ,    1, 1},
	[150] = {"mlock" ,     2, 0},
	[151] = {"munlock" ,   2, 0},
	[152] = {"mlockall" ,  1, 0},
	[153] = {"munlockall" ,0, 0},
	[154] = {"sched_setparam" ,         2, 2},
	[155] = {"sched_getparam" ,         2, 2},
	[156] = {"sched_setscheduler" ,     3, 4},
	[157] = {"sched_getscheduler" ,     1, 0},
	[158] = {"sched_yield" ,            0, 0},
	[159] = {"sched_get_priority_max" , 1, 0},
	[160] = {"sched_get_priority_min" , 1, 0},
	[161] = {"sched_rr_get_interval" ,  2, 2},
	[162] = {"nanosleep" , 2, 3},
	[163] = {"mremap" ,    5, 0},
	[164] = {"setresuid16" , 3, 0},
	[165] = {"getresuid16" , 3, 7},
	[166] = {"vm86" ,      2, 2},
	[167] = {"query_module" ,    5, 21},  /* OLD (now not implimented) */
	[168] = {"poll" ,      3, 1},
	[169] = {"nfsservctl" ,3, 6},
	[170] = {"setresgid16" , 3, 0},
	[171] = {"getresgid16" , 3, 7},
	[172] = {"prctl" ,     5, 0},
	[173] = {"rt_sigreturn" ,    1, 0},
	[174] = {"rt_sigaction" ,    4, 6},
	[175] = {"rt_sigprocmask" ,  4, 6},
	[176] = {"rt_sigpending" ,   2, 1},
	[177] = {"rt_sigtimedwait" , 4, 7},
	[178] = {"rt_sigqueueinfo" , 3, 4},
	[179] = {"rt_sigsuspend" ,   2, 3},
	[180] = {"pread64" ,   4, 2},
	[181] = {"pwrite64" ,  4, 2},
	[182] = {"chown16" ,     3, 1},
	[183] = {"getcwd" ,    2, 1},
	[184] = {"capget" ,    2, 0},
	[185] = {"capset" ,    2, 0},
	[186] = {"sigaltstack" ,     1, 0},
	[187] = {"sendfile" ,  4, 4},
	[188] = {"getpmsg",   5, 63}, /* stream1 not implemented */
	[189] = {"putpmsg",   5, 63}, /* stream2 not implemented */
	[190] = {"vfork" ,     0, 0},
	[191] = {"getrlimit" ,2, 2},
	[192] = {"mmap2" ,     6, 32}, /*----------- henko------------ */
	[193] = {"truncate64", 2, 1},
	[194] = {"ftruncate64" ,     2, 0},
	[195] = {"stat64" ,    2, 3},
	[196] = {"lstat64" ,   2, 3},
	[197] = {"fstat64" ,   2, 2},
	[198] = {"lchown" ,  3, 1},
	[199] = {"getuid" ,  0, 0},
	[200] = {"getgid" ,  0, 0},
	[201] = {"geteuid" , 0, 0},
	[202] = {"getegid" , 0, 0},
	[203] = {"setreuid", 2, 0},
	[204] = {"setregid", 2, 0},
	[205] = {"getgroups" ,     2, 2},
	[206] = {"setgroups" ,     2, 2},
	[207] = {"fchown" ,        3, 0},
	[208] = {"setresuid" ,     3, 0},
	[209] = {"getresuid" ,     3, 7},
	[210] = {"setresgid" ,     3, 0},
	[211] = {"getresgid" ,     3, 7},
	[212] = {"chown" ,   3, 1},
	[213] = {"setuid" ,  1, 0},
	[214] = {"setgid" ,  1, 0},
	[215] = {"setfsuid" ,1, 0},
	[216] = {"setfsgid" ,1, 0},
	[217] = {"pivot_root" ,2, 3},
	[218] = {"mincore" ,   3, 4},
	[219] = {"madvise" ,   3, 0},
	[220] = {"getdents64" ,3, 2},
	[221] = {"fcntl64" ,   3, 0},
	[222] = {"tux",      2, 2},      /* RESERVED (now not implemented) */
	[223] = {"security", 5, 63}, /* security not not implemented*/
	[224] = {"gettid" ,    0, 0},
	[225] = {"readahead" , 3, 0},
	[226] = {"setxattr" ,  5, 7},
	[227] = {"lsetxattr" , 5, 7},
	[228] = {"fsetxattr" , 5, 6},
	[229] = {"getxattr" ,  4, 7},
	[230] = {"lgetxattr" , 4, 7},
	[231] = {"fgetxattr" , 4, 6},
	[232] = {"listxattr" , 3, 3},
	[233] = {"llistxattr" ,3, 3},
	[234] = {"flistxattr" ,3, 2},
	[235] = {"removexattr" ,     2, 3},
	[236] = {"lremovexattr" ,    2, 3},
	[237] = {"fremovexattr" ,    2, 2},
	[238] = {"tkill" ,     2, 0},
	[239] = {"sendfile64" ,4, 4},
	[240] = {"futex" ,     6, 25},
	[241] = {"sched_setaffinity" , 3, 4},
	[242] = {"sched_getaffinity" , 3, 4},
	[243] = {"set_thread_area" ,   1, 1},
	[244] = {"get_thread_area" ,   1, 1},
	[245] = {"io_setup" ,  2, 2},
	[246] = {"io_destroy" ,1, 0},
	[247] = {"io_getevents" ,      5, 24},
	[248] = {"io_submit" , 3, 4},
	[249] = {"io_cancel" , 3, 6},
	[250] = {"fadvise64" , 4, 0},
	[251] = {"(null)", 0, 0},
	[252] = {"exit_group" ,1, 0},
	[253] = {"lookup_dcookie" ,    3, 2},
	[254] = {"epoll_create" ,      1, 0},
	[255] = {"epoll_ctl" , 4, 8},
	[256] = {"epoll_wait" ,4, 2},
	[257] = {"remap_file_pages" ,  5, 0},
	[258] = {"set_tid_address" ,   1, 1},
	[259] = {"timer_create" ,      3, 6},
	[260] = {"timer_settime", 4, 12},
	[261] = {"timer_gettime", 2,  2},
	[262] = {"timer_getoverrun", 1, 0},
	[263] = {"timer_delete",  1,  0},
	[264] = {"clock_settime", 2,  2},
	[265] = {"clock_gettime", 2,  2},
	[266] = {"clock_getres",  2,  2},
	[267] = {"clock_nanosleep", 4, 12},
	[268] = {"statfs64" ,  3, 5},
	[269] = {"fstatfs64" , 3, 4},
	[270] = {"tgkill" ,    3, 0},
	[271] = {"utimes" ,    2, 3},
	[272] = {"fadvise64_64" ,      4, 0},
	[273] = {"vserver",    5, 53}, /* reserved for vserver */
	[274] = {"mbind" ,     6, 8},
	[275] = {"get_mempolicy" ,     5, 3},
	[276] = {"set_mempolicy" ,     3, 2},
	[277] = {"mq_open" ,   4, 9},
	[278] = {"mq_unlink",  1, 1},
	[279] = {"mq_timedsend", 5, 18},
	[280] = {"mq_timedreceive", 5, 26},
	[281] = {"mq_notify", 2, 2},
	[282] = {"mq_getsetattr", 3, 6},
	[283] = {"kexec_load" ,   4, 4}, 
	[284] = {"waitid" ,   5, 20},
	[285] = {"setaltroot", 0, 0},
	[286] = {"add_key",   5, 7},
	[287] = {"request_key",   4, 7},
	[288] = {"keyctl" ,   5, 0},
	[289] = {"ioprio_set",3, 0},
	[290] = {"ioprio_get",2, 0},
	[291] = {"inotify_init",  0, 0},
	[292] = {"inotify_add_watch", 3, 2},
	[293] = {"inotify_rm_watch",  2, 0},
	[294] = {"migrage_pages", 4, 12},
	[295] = {"openat", 4, 2},
	[296] = {"mkdirat", 3, 2},
	[297] = {"mknodat", 4, 2},
	[298] = {"fchownat", 5, 2},
	[299] = {"futimesat", 3, 6},
	[300] = {"fstatat64", 4, 6},
	[301] = {"unlinkat", 3, 2},
	[302] = {"renameat", 4, 10},
	[303] = {"linkat", 5, 10},
	[304] = {"symlinkat", 3, 5},
	[305] = {"readlinkat", 4, 6},
	[306] = {"fchmodat", 3, 2},
	[307] = {"faccessat", 3, 2},
	[308] = {"pselect6", 6, 62},
	[309] = {"ppoll", 5, 13},
	[310] = {"unshare", 1, 0},
	[311] = {"set_robust_list", 2, 1},
	[312] = {"get_robust_list", 3, 6},
	[313] = {"splice", 6, 10},
	[314] = {"sync_file_range", 4, 0},
	[315] = {"tee", 3, 0},
	[316] = {"vmsplice", 4, 2},
	[317] = {"move_pages", 6, 28},
	[318] = {"getcpu", 3, 7},
	[319] = {"epoll_pwait", 6, 18}
};

struct syscall_attribute socketcall_syscall_name[] = {
	[0] = {"socketcall", 2, 2},
	[1] = {"socket", 3, 0},
	[2] = {"bind", 3, 2},
	[3] = {"connect", 3, 2},
	[4] = {"listen", 2, 0},
	[5] = {"accept", 3, 6},
	[6] = {"getsockname", 3, 6},
	[7] = {"getpeername", 3, 6},
	[8] = {"socketpair", 4, 8},
	[9] = {"send", 4, 2},
	[10] = {"recv", 4, 2},
	[11] = {"sendto", 6, 18},
	[12] = {"recvfrom", 6, 50},
	[13] = {"shutdown", 2, 0},
	[14] = {"setsockopt", 5, 8},
	[15] = {"getsockopt", 5, 24},
	[16] = {"sendmsg", 3, 2},
	[17] = {"recvmsg", 3, 2}
};

struct syscall_attribute ipc_syscall_name[] = {
	[0] = {"ipc", 6, 16},
	[1] = {"semop",  3, 2},
	[2] = {"semget", 3, 0},
	[3] = {"semctl", 4, 0},
	[4] = {"semtimedop", 4, 10},
	[11] = {"msgsnd", 4, 2},
	[12] = {"msgrcv", 5, 2},
	[13] = {"msgget", 2, 0},
	[14] = {"msgctl", 3, 4},
	[21] = {"shmat",  5, 16},
	[22] = {"shmdt",  1, 1},
	[23] = {"shmget",3, 0},
	[24] = {"shmctl",3, 4}
};
